/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.server.events;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.GeothermalVentBlock;
import com.github.alexmodguy.alexscaves.server.block.ThornwoodBranchBlock;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MeltedCaramelEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.CandicornEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.CaramelCubeEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GossamerWormEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormSegmentEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumbeeperEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GummyBearEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.HullbreakerEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.LanternfishEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.MineGuardianEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.NucleeperEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.RaycatEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SeaPigEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TripodfishEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.GummyColors;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.compat.ACEnrichedCompat;
import org.crimsoncrips.alexscavesexemplified.compat.AMCompat;
import org.crimsoncrips.alexscavesexemplified.compat.SupplementariesCompat;
import org.crimsoncrips.alexscavesexemplified.datagen.ACExDamageTypes;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExBlockTagGenerator;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExEntityTagGenerator;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.ACExBaseInterface;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.MineGuardianXtra;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.NucleeperXtra;
import org.crimsoncrips.alexscavesexemplified.server.blocks.ACExBlockRegistry;
import org.crimsoncrips.alexscavesexemplified.server.effect.ACExEffects;
import org.crimsoncrips.alexscavesexemplified.server.entity.ACExEntityRegistry;
import vazkii.patchouli.common.item.PatchouliItems;

@Mod.EventBusSubscriber(modid="alexscavesexemplified", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ACExemplifiedEvents {
    @SubscribeEvent
    public void onEntityFinalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        Double chargedChance = (Double)AlexsCavesExemplified.COMMON_CONFIG.CHARGED_CAVE_CREEPER_CHANCE.get();
        if (entity instanceof GumbeeperEntity) {
            GumbeeperEntity gumbeeper = (GumbeeperEntity)entity;
            if (entity.m_217043_().m_188500_() < chargedChance) {
                gumbeeper.setCharged(true);
            }
        }
        if (entity instanceof NucleeperEntity) {
            NucleeperEntity nucleeper = (NucleeperEntity)entity;
            if (entity.m_217043_().m_188500_() < chargedChance) {
                nucleeper.setCharged(true);
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.RABIES_ENABLED.get()).booleanValue() && entity.m_217043_().m_188500_() < 0.05 && (entity instanceof CorrodentEntity || entity instanceof UnderzealotEntity || entity instanceof VesperEntity)) {
            entity.m_7292_(new MobEffectInstance((MobEffect)ACExEffects.RABIAL.get(), 140000, 0));
        }
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState blockState = event.getEntity().m_9236_().m_8055_(event.getPos());
        BlockPos pos = event.getPos();
        Level worldIn = event.getLevel();
        RandomSource random = event.getEntity().m_217043_();
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GLUTTONY_ENABLED.get()).booleanValue() && blockState.m_204336_(ACExBlockTagGenerator.CONSUMABLE_BLOCKS)) {
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
            if (player.m_6047_()) {
                MobEffectInstance hunger = player.m_21124_(MobEffects.f_19612_);
                if (hunger != null) {
                    ((ACExBaseInterface)player).addSweets(1);
                    if (!hunger.m_267577_()) {
                        player.m_21195_(MobEffects.f_19612_);
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, hunger.m_19557_() - 60, hunger.m_19564_()));
                    }
                    worldIn.m_46953_(pos, true, (Entity)player);
                    player.m_36324_().m_38707_(1, 1.0f);
                    player.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    for (int i = 0; i <= 15; ++i) {
                        Vec3 lookAngle = player.m_20154_();
                        worldIn.m_7106_((ParticleOptions)particle, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), lookAngle.f_82479_ * 1.5, lookAngle.f_82480_ * 2.0, lookAngle.f_82481_ * 1.5);
                    }
                    ACExUtils.awardAdvancement((Entity)player, "gluttony", "eat");
                    if (random.m_188500_() < 0.01) {
                        player.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.SUGAR_RUSH.get(), 100, 0));
                    }
                } else if (player.m_36324_().m_38721_()) {
                    ((ACExBaseInterface)player).addSweets(1);
                    player.m_36324_().m_38707_(2, 2.0f);
                    player.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    for (int i = 0; i <= 15; ++i) {
                        Vec3 lookAngle = player.m_20154_();
                        worldIn.m_7106_((ParticleOptions)particle, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), lookAngle.f_82479_ * 1.5, lookAngle.f_82480_ * 2.0, lookAngle.f_82481_ * 1.5);
                    }
                    ACExUtils.awardAdvancement((Entity)player, "gluttony", "eat");
                    if (random.m_188500_() < 0.01) {
                        player.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.SUGAR_RUSH.get(), 100, 0));
                    }
                }
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.LIQUID_REPLICATION_ENABLED.get()).booleanValue() && blockState.m_60713_(Blocks.f_50256_) && (itemStack.m_150930_(((Block)ACBlockRegistry.SCRAP_METAL.get()).m_5456_()) || itemStack.m_150930_(((Block)ACBlockRegistry.SCRAP_METAL_PLATE.get()).m_5456_())) && player.m_6047_()) {
            event.getLevel().m_7731_(pos, ((Block)ACExBlockRegistry.METAL_CAULDRON.get()).m_49966_(), 3);
            player.m_6674_(event.getHand());
            player.m_5496_(SoundEvents.f_12471_, 1.0f, 1.0f);
            ACExUtils.awardAdvancement((Entity)player, "metal_cauldron", "metal");
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        Level level = event.getLevel();
        Entity target = event.getTarget();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GLUTTONY_ENABLED.get()).booleanValue() && player.m_6047_() && player.m_21124_(MobEffects.f_19612_) != null) {
            GummyBearEntity gummyBearEntity;
            CaramelCubeEntity caramelCube;
            Vec3 lookAngle;
            ItemParticleOption particle;
            GingerbreadManEntity gingerbread;
            if (target instanceof GingerbreadManEntity && !(gingerbread = (GingerbreadManEntity)target).isOvenSpawned()) {
                particle = new ItemParticleOption(ParticleTypes.f_123752_, ((Item)ACItemRegistry.GINGERBREAD_CRUMBS.get()).m_5456_().m_7968_());
                lookAngle = player.m_20154_();
                level.m_7106_((ParticleOptions)particle, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), lookAngle.f_82479_ * 0.2, lookAngle.f_82480_ * 0.6, lookAngle.f_82481_ * 0.2);
                for (GingerbreadManEntity entity2 : level.m_45976_(GingerbreadManEntity.class, gingerbread.m_20191_().m_82377_(10.0, 5.0, 10.0))) {
                    if (entity2.isOvenSpawned() || player.m_7500_()) continue;
                    entity2.m_6710_((LivingEntity)player);
                }
                event.getTarget().m_146870_();
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() + 2);
                player.m_5496_(SoundEvents.f_11912_, 1.0f, -2.0f);
            }
            if (target instanceof CaramelCubeEntity && (caramelCube = (CaramelCubeEntity)target).getSlimeSize() <= 0) {
                particle = new ItemParticleOption(ParticleTypes.f_123752_, ((Item)ACItemRegistry.CARAMEL.get()).m_5456_().m_7968_());
                lookAngle = player.m_20154_();
                level.m_7106_((ParticleOptions)particle, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), lookAngle.f_82479_ * 0.2, lookAngle.f_82480_ * 0.6, lookAngle.f_82481_ * 0.2);
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() + 3);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, false, false));
                event.getTarget().m_146870_();
                player.m_5496_(SoundEvents.f_11912_, 1.0f, -2.0f);
            }
            if (target instanceof GummyBearEntity && (gummyBearEntity = (GummyBearEntity)target).m_6162_()) {
                Vec3 lookAngle2 = player.m_20154_();
                ItemStack gelatinColor = switch (gummyBearEntity.getGummyColor()) {
                    case GummyColors.GREEN -> ((Item)ACItemRegistry.GELATIN_GREEN.get()).m_5456_().m_7968_();
                    case GummyColors.BLUE -> ((Item)ACItemRegistry.GELATIN_BLUE.get()).m_5456_().m_7968_();
                    case GummyColors.YELLOW -> ((Item)ACItemRegistry.GELATIN_YELLOW.get()).m_5456_().m_7968_();
                    case GummyColors.PINK -> ((Item)ACItemRegistry.GELATIN_PINK.get()).m_5456_().m_7968_();
                    default -> ((Item)ACItemRegistry.GELATIN_RED.get()).m_5456_().m_7968_();
                };
                ItemParticleOption particle2 = new ItemParticleOption(ParticleTypes.f_123752_, gelatinColor.m_41720_().m_7968_());
                for (int i = 0; i <= 15; ++i) {
                    level.m_7106_((ParticleOptions)particle2, player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_(), lookAngle2.f_82479_ * 0.2, lookAngle2.f_82480_ * 0.6, lookAngle2.f_82481_ * 0.2);
                }
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() + 5);
                for (GummyBearEntity entity3 : level.m_45976_(GummyBearEntity.class, player.m_20191_().m_82377_(10.0, 5.0, 10.0))) {
                    if (player.m_7500_()) continue;
                    entity3.m_6710_((LivingEntity)player);
                }
                target.m_146870_();
                player.m_5496_(SoundEvents.f_11912_, 1.0f, -2.0f);
                player.m_5496_((SoundEvent)ACSoundRegistry.GUMMY_BEAR_DEATH.get(), 0.4f, 2.0f);
            }
        }
        if ((entity = event.getTarget()) instanceof Parrot) {
            Parrot parrot = (Parrot)entity;
            if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.COOKIE_CRUMBLE_ENABLED.get()).booleanValue() && itemStack.m_150930_(((Block)ACBlockRegistry.COOKIE_BLOCK.get()).m_5456_())) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                parrot.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 900));
                parrot.m_6469_(player.m_269291_().m_269075_(player), Float.MAX_VALUE);
                parrot.m_9236_().m_254849_((Entity)player, parrot.m_20185_(), parrot.m_20186_(), parrot.m_20189_(), 3.0f, Level.ExplosionInteraction.MOB);
            }
        }
        if ((entity = event.getTarget()) instanceof CandicornEntity) {
            CandicornEntity candicornEntity = (CandicornEntity)entity;
            if (itemStack.m_150930_((Item)ACItemRegistry.CARAMEL_APPLE.get()) && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.CANDICORN_HEAL_ENABLED.get()).booleanValue()) {
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                candicornEntity.m_5634_(4.0f);
                player.m_6674_(event.getHand());
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent deathEvent) {
        MineGuardianEntity mineGuardianEntity;
        LivingEntity died = deathEvent.getEntity();
        Entity killer = deathEvent.getSource().m_7639_();
        Level level = died.m_9236_();
        if (died instanceof NucleeperEntity) {
            NucleeperEntity nucleeper = (NucleeperEntity)died;
            if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.NUCLEAR_CHAIN_ENABLED.get()).booleanValue() && !((NucleeperXtra)nucleeper).isDefused() && (deathEvent.getSource().m_276093_(DamageTypes.f_268448_) || deathEvent.getSource().m_276093_(DamageTypes.f_268565_) || deathEvent.getSource().m_276093_(ACDamageTypes.NUKE) || deathEvent.getSource().m_276093_(ACDamageTypes.TREMORZILLA_BEAM))) {
                NuclearExplosionEntity explosionMain = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(nucleeper.m_9236_());
                explosionMain.m_20359_((Entity)nucleeper);
                explosionMain.setSize(nucleeper.isCharged() ? 1.75f : 1.0f);
                if (!nucleeper.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                    explosionMain.setNoGriefing(true);
                }
                nucleeper.m_9236_().m_7967_((Entity)explosionMain);
                int amount = 0;
                for (NucleeperEntity nucleepers : level.m_45976_(NucleeperEntity.class, nucleeper.m_20191_().m_82400_(13.0))) {
                    if (!((Boolean)AlexsCavesExemplified.COMMON_CONFIG.NUCLEAR_CHAIN_ENABLED.get()).booleanValue() || ((NucleeperXtra)nucleepers).isDefused()) continue;
                    ++amount;
                    NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(level);
                    explosion.m_20359_((Entity)nucleepers);
                    explosion.setSize(nucleepers.isCharged() ? 1.75f : 1.0f);
                    if (!level.m_46469_().m_46207_(GameRules.f_46132_)) {
                        explosion.setNoGriefing(true);
                    }
                    level.m_7967_((Entity)explosion);
                }
                for (Player players : level.m_45976_(Player.class, nucleeper.m_20191_().m_82400_(50.0))) {
                    if (amount >= 10) {
                        ACExUtils.awardAdvancement((Entity)players, "nucleeper_annhilation", "nuke_chained");
                    }
                    if (amount == 0) continue;
                    ACExUtils.awardAdvancement((Entity)players, "chain_reaction", "chain");
                }
            }
        }
        if (died instanceof MineGuardianEntity && ((MineGuardianXtra)(mineGuardianEntity = (MineGuardianEntity)died)).alexsCavesExemplified$getVariant() >= 1) {
            ACExUtils.awardAdvancement(killer, "nuclear_kill", "killed");
        }
        if (killer instanceof Player) {
            Player player = (Player)killer;
            if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.ECOLOGICAL_REPUTATION_ENABLED.get()).booleanValue()) {
                if (died instanceof SeaPigEntity) {
                    ACExUtils.deepReputation((Entity)player, -1);
                } else if (died instanceof GossamerWormEntity) {
                    ACExUtils.deepReputation((Entity)player, -2);
                } else if (died instanceof LanternfishEntity && player.m_217043_().m_188500_() < 0.3) {
                    ACExUtils.deepReputation((Entity)player, -1);
                } else if (died instanceof TripodfishEntity) {
                    ACExUtils.deepReputation((Entity)player, -1);
                } else if (died instanceof HullbreakerEntity) {
                    ACExUtils.awardAdvancement((Entity)player, "hullbreaker_reputation", "killed");
                    ACExUtils.deepReputation((Entity)player, -20);
                } else if (died instanceof MineGuardianEntity) {
                    ACExUtils.deepReputation((Entity)player, 2);
                }
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.FISH_MUTATION_ENABLED.get()).booleanValue() && died.m_146900_().m_60713_((Block)ACBlockRegistry.ACID.get()) && died.m_6095_().m_204039_(ACExEntityTagGenerator.ACID_TO_FISH) && !died.m_9236_().m_5776_() && died.m_217043_().m_188500_() < 1.0) {
            ((EntityType)ACEntityRegistry.RADGILL.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)died.m_20185_(), (double)died.m_20186_(), (double)died.m_20189_()), MobSpawnType.MOB_SUMMONED);
            for (Player players : level.m_45976_(Player.class, died.m_20191_().m_82400_(8.0))) {
                ACExUtils.awardAdvancement((Entity)players, "convert_fish", "convert");
            }
            died.m_146870_();
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.CAT_MUTATION_ENABLED.get()).booleanValue() && died.m_146900_().m_60713_((Block)ACBlockRegistry.ACID.get()) && died.m_6095_().m_204039_(ACExEntityTagGenerator.ACID_TO_CAT) && !died.m_9236_().m_5776_() && died.m_217043_().m_188500_() < 1.0) {
            ((EntityType)ACEntityRegistry.RAYCAT.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)died.m_20185_(), (double)died.m_20186_(), (double)died.m_20189_()), MobSpawnType.MOB_SUMMONED);
            for (Player players : level.m_45976_(Player.class, died.m_20191_().m_82400_(8.0))) {
                ACExUtils.awardAdvancement((Entity)players, "convert_cat", "convert");
            }
            died.m_146870_();
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent breakEvent) {
        BlockState blockState = breakEvent.getState();
        Level level = (Level)breakEvent.getLevel();
        Player player = breakEvent.getPlayer();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.BURST_OUT_ENABLED.get()).booleanValue()) {
            if (blockState.m_204336_(ACExBlockTagGenerator.BURST_BLOCKS) && breakEvent.getLevel().m_213780_().m_188500_() < 0.02 && level.m_204166_(breakEvent.getPos()).m_203565_(ACBiomeRegistry.FORLORN_HOLLOWS)) {
                if (level.m_213780_().m_188499_()) {
                    ((EntityType)ACEntityRegistry.UNDERZEALOT.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)breakEvent.getPos().m_123341_(), (double)breakEvent.getPos().m_123342_(), (double)breakEvent.getPos().m_123343_()), MobSpawnType.MOB_SUMMONED);
                } else {
                    ((EntityType)ACEntityRegistry.CORRODENT.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)breakEvent.getPos().m_123341_(), (double)breakEvent.getPos().m_123342_(), (double)breakEvent.getPos().m_123343_()), MobSpawnType.MOB_SUMMONED);
                }
                ACExUtils.awardAdvancement((Entity)player, "burst_out", "burst");
            }
            if (blockState.m_60713_((Block)ACBlockRegistry.PEERING_COPROLITH.get()) && breakEvent.getLevel().m_213780_().m_188500_() < 0.4 && level.m_204166_(breakEvent.getPos()).m_203565_(ACBiomeRegistry.FORLORN_HOLLOWS)) {
                ((EntityType)ACEntityRegistry.CORRODENT.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)breakEvent.getPos().m_123341_(), (double)breakEvent.getPos().m_123342_(), (double)breakEvent.getPos().m_123343_()), MobSpawnType.MOB_SUMMONED);
            }
        }
        if (blockState.m_204336_(ACExBlockTagGenerator.ABYSSAL_ECOSYSTEM) && player.m_9236_().m_204166_(player.m_20097_()).m_203565_(ACBiomeRegistry.ABYSSAL_CHASM) && player.m_217043_().m_188500_() > 0.25) {
            ACExUtils.deepReputation((Entity)player, -1);
        }
    }

    @SubscribeEvent
    public void mobTickEvents(LivingEvent.LivingTickEvent livingTickEvent) {
        BlockState blockState;
        MobEffectInstance irradiated;
        int irradiationAmmount;
        Player player;
        LivingEntity livingEntity = livingTickEvent.getEntity();
        Level level = livingEntity.m_9236_();
        if (livingEntity instanceof SeaPigEntity) {
            SeaPigEntity seaPigEntity = (SeaPigEntity)livingEntity;
            if (level.f_46441_.m_188500_() < 0.01 && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.POISONOUS_SKIN_ENABLED.get()).booleanValue()) {
                for (LivingEntity entity : seaPigEntity.m_9236_().m_45976_(LivingEntity.class, seaPigEntity.m_20191_().m_82400_(0.5))) {
                    if (entity == seaPigEntity || !(entity.m_20206_() <= 3.5f) || entity instanceof SeaPigEntity) continue;
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0));
                    ACExUtils.awardAdvancement((Entity)entity, "poisonous_skin", "touched");
                }
            }
        }
        if (livingEntity instanceof Player && level.m_204166_((player = (Player)livingEntity).m_20183_()).m_203565_(ACBiomeRegistry.ABYSSAL_CHASM) && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.ABYSSAL_CRUSH_ENABLED.get()).booleanValue() && !(player.m_20202_() instanceof SubmarineEntity)) {
            int aboveWater = 0;
            BlockPos pos = new BlockPos(player.m_146903_(), player.m_146904_() + 2, player.m_146907_());
            while (level.m_8055_(pos).m_60713_(Blocks.f_49990_)) {
                pos = pos.m_7494_();
                ++aboveWater;
            }
            int diving = ACExUtils.getDivingAmount(livingEntity);
            if (level.f_46441_.m_188500_() < 0.1 - 0.03 * (double)diving && aboveWater > 50 && diving <= 10) {
                player.m_6469_(ACExDamageTypes.getDamageSource(player.m_9236_(), ACExDamageTypes.DEPTH_CRUSH, new EntityType[0]), (float)(0.025 * (double)(aboveWater - 40)));
                player.m_20301_(player.m_20146_() + (int)(0.025 * (double)(aboveWater - 100)));
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.PRESSURED_HOOKS_ENABLED.get()).booleanValue() && livingEntity instanceof Player) {
            player = (Player)livingEntity;
            boolean trueMainhand = livingEntity.m_21205_().m_150930_((Item)ACItemRegistry.CANDY_CANE_HOOK.get());
            boolean trueOffhand = livingEntity.m_21206_().m_150930_((Item)ACItemRegistry.CANDY_CANE_HOOK.get());
            if (livingEntity.m_20202_() instanceof GumWormSegmentEntity && trueMainhand) {
                if (player.m_7500_()) {
                    return;
                }
                if (!(player.m_217043_().m_188500_() < 0.05)) {
                    return;
                }
                player.m_21205_().m_41622_(1, (LivingEntity)player, p_233654_0_ -> {});
            }
            if (livingEntity.m_20202_() instanceof GumWormSegmentEntity && trueOffhand) {
                if (player.m_7500_()) {
                    return;
                }
                if (!(player.m_217043_().m_188500_() < 0.05)) {
                    return;
                }
                player.m_21206_().m_41622_(1, (LivingEntity)player, p_233654_0_ -> {});
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GUASLOWPOKE_ENABLED.get()).booleanValue() && (livingEntity.m_146900_().m_60713_((Block)ACBlockRegistry.GUANO_BLOCK.get()) || livingEntity.m_146900_().m_60713_((Block)ACBlockRegistry.GUANO_LAYER.get()))) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 0));
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SOLIDIFIED_ENABLED.get()).booleanValue() && livingEntity instanceof WatcherEntity) {
            WatcherEntity watcherEntity = (WatcherEntity)livingEntity;
            if (watcherEntity.f_19797_ > 3000 && watcherEntity.m_20202_() == null && !watcherEntity.m_20160_()) {
                BlockPos blockPos = watcherEntity.m_20097_().m_7494_();
                for (int i = 0; i < 3; ++i) {
                    BlockPos blockPlacing = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_() + i, blockPos.m_123343_());
                    if (level.m_8055_(blockPlacing).m_60838_((BlockGetter)level, blockPlacing)) continue;
                    level.m_7731_(blockPlacing, ((Block)ACBlockRegistry.THORNWOOD_WOOD.get()).m_49966_(), 2);
                    if (i == 2) {
                        if (watcherEntity.m_6350_() == Direction.WEST || watcherEntity.m_6350_() == Direction.EAST) {
                            level.m_7731_(blockPlacing.m_122012_(), (BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)Direction.NORTH), 2);
                            level.m_7731_(blockPlacing.m_122019_(), (BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
                        } else {
                            level.m_7731_(blockPlacing.m_122029_(), (BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)Direction.EAST), 2);
                            level.m_7731_(blockPlacing.m_122024_(), (BlockState)((Block)ACBlockRegistry.THORNWOOD_BRANCH.get()).m_49966_().m_61124_((Property)ThornwoodBranchBlock.FACING, (Comparable)Direction.WEST), 2);
                        }
                    }
                    if (!(level.f_46441_.m_188500_() < 0.03)) continue;
                    level.m_7731_(new BlockPos((Vec3i)blockPlacing.m_7494_()), ((Block)ACBlockRegistry.BEHOLDER.get()).m_49966_(), 2);
                }
                for (Player player2 : level.m_45976_(Player.class, watcherEntity.m_20191_().m_82400_(40.0))) {
                    ACExUtils.awardAdvancement((Entity)player2, "solidified", "solid");
                }
                watcherEntity.m_5496_((SoundEvent)ACSoundRegistry.WATCHER_DEATH.get(), 6.0f, -5.0f);
                watcherEntity.m_146870_();
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.STICKY_SODA_ENABLED.get()).booleanValue() && !livingEntity.m_6095_().m_204039_(ACTagRegistry.CANDY_MOBS) && livingEntity.m_146900_().m_60713_((Block)ACBlockRegistry.PURPLE_SODA.get())) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 90, 0));
            ACExUtils.awardAdvancement((Entity)livingEntity, "sticky_soda", "stick");
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.PURPLE_LEATHERED_ENABLED.get()).booleanValue() && livingEntity.isInFluidType((FluidType)ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get())) {
            this.checkLeatherArmor(livingEntity.m_6844_(EquipmentSlot.HEAD), livingEntity);
            this.checkLeatherArmor(livingEntity.m_6844_(EquipmentSlot.FEET), livingEntity);
            this.checkLeatherArmor(livingEntity.m_6844_(EquipmentSlot.CHEST), livingEntity);
            this.checkLeatherArmor(livingEntity.m_6844_(EquipmentSlot.LEGS), livingEntity);
            this.checkLeatherArmor(livingEntity.m_6844_(EquipmentSlot.MAINHAND), livingEntity);
            this.checkLeatherArmor(livingEntity.m_6844_(EquipmentSlot.OFFHAND), livingEntity);
        }
        if (livingEntity.m_217043_().m_188500_() < 0.05 && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.IRRADIATION_WASHOFF_ENABLED.get()).booleanValue() && (livingEntity.m_20069_() || livingEntity.m_20075_().m_60713_(Blocks.f_152476_) || livingEntity.m_20071_())) {
            ACExUtils.irradiationWash(livingEntity, 50);
        }
        if ((irradiationAmmount = ((Integer)AlexsCavesExemplified.COMMON_CONFIG.EXEMPLIFIED_IRRADIATION_AMOUNT.get()).intValue()) > 0 && level.f_46441_.m_188500_() < 0.1 && (irradiated = livingEntity.m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get())) != null && irradiated.m_19564_() >= irradiationAmmount - 1) {
            ACExUtils.awardAdvancement((Entity)livingEntity, "deathly_radiation", "radiate");
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 60, 0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 60, 0));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0));
            if (ModList.get().isLoaded("alexsmobs")) {
                livingEntity.m_7292_(new MobEffectInstance(AMCompat.exsanguination(), 60, 0));
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GEOTHERMAL_EFFECTS_ENABLED.get()).booleanValue() && (blockState = livingEntity.m_20075_()).m_60734_() instanceof GeothermalVentBlock) {
            if ((Integer)blockState.m_61143_((Property)GeothermalVentBlock.SMOKE_TYPE) == 1 && livingEntity.m_217043_().m_188500_() < 0.05) {
                ACExUtils.irradiationWash(livingEntity, 50);
                if (livingEntity.m_6060_()) {
                    livingEntity.m_252836_();
                }
            }
            if ((Integer)blockState.m_61143_((Property)GeothermalVentBlock.SMOKE_TYPE) == 2) {
                livingEntity.m_20254_(5);
            }
            if ((Integer)blockState.m_61143_((Property)GeothermalVentBlock.SMOKE_TYPE) == 3 && !livingEntity.m_21023_((MobEffect)ACEffectRegistry.IRRADIATED.get())) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 400, 0));
            }
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        MobEffectInstance irradiated;
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.IRRADIATION_WASHOFF_ENABLED.get()).booleanValue() && ModList.get().isLoaded("supplementaries") && (irradiated = player.m_21124_((MobEffect)ACEffectRegistry.IRRADIATED.get())) != null && SupplementariesCompat.isSoap(player.m_21120_(hand)) && (player.m_20069_() || player.m_20075_().m_60713_(Blocks.f_152476_))) {
            ACExUtils.irradiationWash((LivingEntity)player, player.m_217043_().m_216339_(200, 500));
            player.m_6674_(hand);
            for (int i = 0; i < 10; ++i) {
                double d1 = player.m_217043_().m_188583_() * 0.02;
                double d2 = player.m_217043_().m_188583_() * 0.02;
                double d3 = player.m_217043_().m_188583_() * 0.02;
                level.m_7106_(SupplementariesCompat.suds(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), d1 * 2.0, d2 * 2.0, d3 * 2.0);
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.KIROV_REPORTING_ENABLED.get()).booleanValue() && player.m_21255_() && (player.m_21120_(hand).m_150930_(Items.f_42409_) || player.m_21120_(hand).m_150930_(Items.f_42613_))) {
            boolean succeeded = true;
            InteractionHand otherHand = hand.equals((Object)InteractionHand.MAIN_HAND) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack otherStack = player.m_21120_(otherHand);
            if (!player.m_36335_().m_41519_(otherStack.m_41720_())) {
                switch (otherStack.m_41720_().toString()) {
                    case "tnt": {
                        System.out.println("test");
                        if (level.m_5776_()) break;
                        EntityType.f_20515_.m_262496_((ServerLevel)level, BlockPos.m_274561_((double)player.m_20185_(), (double)(player.m_20186_() - 2.0), (double)player.m_20189_()), MobSpawnType.MOB_SUMMONED);
                        break;
                    }
                    case "tnt_minecart": {
                        if (level.m_5776_()) break;
                        EntityType.f_20475_.m_262496_((ServerLevel)level, BlockPos.m_274561_((double)player.m_20185_(), (double)(player.m_20186_() - 2.0), (double)player.m_20189_()), MobSpawnType.MOB_SUMMONED);
                        break;
                    }
                    case "nuclear_bomb": {
                        if (level.m_5776_()) break;
                        ((EntityType)ACEntityRegistry.NUCLEAR_BOMB.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)player.m_20185_(), (double)(player.m_20186_() - 2.0), (double)player.m_20189_()), MobSpawnType.MOB_SUMMONED);
                        break;
                    }
                    case "gamma_nuclear_bomb": {
                        if (level.m_5776_()) break;
                        ((EntityType)ACExEntityRegistry.GAMMA_NUCLEAR_BOMB.get()).m_262496_((ServerLevel)level, BlockPos.m_274561_((double)player.m_20185_(), (double)(player.m_20186_() - 2.0), (double)player.m_20189_()), MobSpawnType.MOB_SUMMONED);
                        break;
                    }
                    case "mini_nuke": {
                        ACEnrichedCompat.enrichedBomb((LivingEntity)player, 200, 1);
                        break;
                    }
                    case "neutron_bomb": {
                        ACEnrichedCompat.enrichedBomb((LivingEntity)player, 200, 2);
                        break;
                    }
                    case "black_hole_bomb": {
                        ACEnrichedCompat.enrichedBomb((LivingEntity)player, 400, 3);
                        break;
                    }
                    default: {
                        succeeded = false;
                    }
                }
                if (succeeded) {
                    player.m_9236_().m_142346_((Entity)player, GameEvent.f_157776_, player.m_20183_());
                    player.m_9236_().m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.m_36335_().m_41524_(player.m_21120_(hand).m_41720_(), 60);
                    player.m_6674_(hand);
                    if (!player.m_7500_()) {
                        otherStack.m_41774_(1);
                    }
                    ACExUtils.awardAdvancement((Entity)player, "kirov_reporting", "kirov");
                }
            }
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingDamageEvent livingDamageEvent) {
        CaramelCubeEntity caramelCubeEntity;
        LivingEntity living;
        Entity damager = livingDamageEvent.getSource().m_7639_();
        LivingEntity damaged = livingDamageEvent.getEntity();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.RABIES_ENABLED.get()).booleanValue() && damager instanceof LivingEntity && (living = (LivingEntity)damager).m_21023_((MobEffect)ACExEffects.RABIAL.get()) && damaged.m_6095_().m_204039_(ACExEntityTagGenerator.CAN_RABIES) && !damaged.m_21023_(MobEffects.f_19606_)) {
            damaged.m_7292_(new MobEffectInstance((MobEffect)ACExEffects.RABIAL.get(), 72000, 0));
            ACExUtils.awardAdvancement(damager, "rabial_spread", "spread");
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.STICKY_CARAMEL_ENABLED.get()).booleanValue() && damager instanceof CaramelCubeEntity && (caramelCubeEntity = (CaramelCubeEntity)damager).m_217043_().m_188500_() < 0.5) {
            MeltedCaramelEntity meltedCaramel = (MeltedCaramelEntity)((EntityType)ACEntityRegistry.MELTED_CARAMEL.get()).m_20615_(caramelCubeEntity.m_9236_());
            if (meltedCaramel == null) {
                return;
            }
            meltedCaramel.m_146884_(damaged.m_20318_(1.0f));
            meltedCaramel.setDespawnsIn(40 + (1 + caramelCubeEntity.getSlimeSize() - 1) * 40);
            meltedCaramel.m_20256_(caramelCubeEntity.m_20184_().m_82542_(-1.0, 0.0, -1.0));
            caramelCubeEntity.m_9236_().m_7967_((Entity)meltedCaramel);
        }
    }

    @SubscribeEvent
    public void bonemealEvent(BonemealEvent bonemealEvent) {
        Player entity = bonemealEvent.getEntity();
        Level level = bonemealEvent.getLevel();
        BlockPos blockPos = bonemealEvent.getPos();
        BlockState blockState = level.m_8055_(blockPos);
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.ECOLOGICAL_REPUTATION_ENABLED.get()).booleanValue() && blockState.m_60713_((Block)ACBlockRegistry.PING_PONG_SPONGE.get()) && level.m_204166_(blockPos).m_203565_(ACBiomeRegistry.ABYSSAL_CHASM)) {
            ACExUtils.deepReputation((Entity)entity, 1);
        }
    }

    @SubscribeEvent
    public void talkEvent(ServerChatEvent serverChatEvent) {
        ServerPlayer player = serverChatEvent.getPlayer();
        String message = serverChatEvent.getMessage().getString();
        if (message.contains("pspspsps") && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.CATTASTROPHE_ENABLED.get()).booleanValue()) {
            int delay = 0;
            while (delay < 200) {
                if (++delay < 200) continue;
                for (LivingEntity cats : player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82377_(4.0, 4.0, 4.0))) {
                    if (!(cats instanceof Cat) && !(cats instanceof Ocelot) && !(cats instanceof RaycatEntity) && !AMCompat.tiger(cats)) continue;
                    NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(cats.m_9236_());
                    explosion.m_20359_((Entity)cats);
                    explosion.setSize(1.75f);
                    cats.m_9236_().m_7967_((Entity)explosion);
                    cats.m_146870_();
                }
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.RABIES_ENABLED.get()).booleanValue() && player.m_217043_().m_188500_() < 0.01 && player.m_21023_((MobEffect)ACExEffects.RABIAL.get())) {
            serverChatEvent.setMessage(Component.m_130674_((String)("rrRRRrrrAgh!... " + message)));
        }
    }

    private void checkLeatherArmor(ItemStack item, LivingEntity living) {
        DyeableLeatherItem dyeableLeatherItem;
        Item item2 = item.m_41720_();
        if (item2 instanceof DyeableLeatherItem && !(dyeableLeatherItem = (DyeableLeatherItem)item2).m_41113_(item)) {
            dyeableLeatherItem.m_41115_(item, 12073446);
            ACExUtils.awardAdvancement((Entity)living, "purple_coloring", "colored");
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (ModList.get().isLoaded("patchouli")) {
            Player player = event.getEntity();
            CompoundTag playerData = event.getEntity().getPersistentData();
            CompoundTag data = playerData.m_128469_("PlayerPersisted");
            ItemStack book = new ItemStack((ItemLike)PatchouliItems.BOOK);
            book.m_41784_().m_128359_("patchouli:book", "alexscavesexemplified:acewiki");
            if (!data.m_128471_("ace_book") && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.ACE_WIKI_ENABLED.get()).booleanValue()) {
                player.m_36356_(book);
                data.m_128379_("ace_book", true);
                playerData.m_128365_("PlayerPersisted", (Tag)data);
            }
        }
    }
}

