/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.tremorzilla;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.model.TremorzillaModel;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.TremorzillaRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.Gammafied;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TremorzillaRenderer.class})
public abstract class ACExTremorzillaRenderMixin
extends MobRenderer<TremorzillaEntity, TremorzillaModel>
implements CustomBookEntityRenderer {
    @Shadow
    @Final
    private static HashMap<Integer, Vec3> mouthParticlePositions;
    @Shadow
    @Final
    private static Vec3 MOUTH_TRANSFORM_POS;
    @Shadow
    private boolean sepia;
    private static final ResourceLocation TEXTURE;
    private static final ResourceLocation TEXTURE_BEAM_INNER;
    private static final ResourceLocation TEXTURE_BEAM_OUTER;
    private static final ResourceLocation TEXTURE_BEAM_END_0;
    private static final ResourceLocation TEXTURE_BEAM_END_1;
    private static final ResourceLocation TEXTURE_BEAM_END_2;
    private static final ResourceLocation TEXTURE_RETRO;
    private static final ResourceLocation TEXTURE_RETRO_BEAM_INNER;
    private static final ResourceLocation TEXTURE_RETRO_BEAM_OUTER;
    private static final ResourceLocation TEXTURE_RETRO_BEAM_END_0;
    private static final ResourceLocation TEXTURE_RETRO_BEAM_END_1;
    private static final ResourceLocation TEXTURE_RETRO_BEAM_END_2;
    private static final ResourceLocation TEXTURE_TECTONIC;
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_INNER;
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_OUTER;
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_END_0;
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_END_1;
    private static final ResourceLocation TEXTURE_TECTONIC_BEAM_END_2;
    private static final ResourceLocation TEXTURE_GAMMA;
    private static final ResourceLocation TEXTURE_GAMMA_BEAM_INNER;
    private static final ResourceLocation TEXTURE_GAMMA_BEAM_OUTER;
    private static final ResourceLocation TEXTURE_GAMMA_BEAM_END_0;
    private static final ResourceLocation TEXTURE_GAMMA_BEAM_END_1;
    private static final ResourceLocation TEXTURE_GAMMA_BEAM_END_2;

    @Shadow
    protected abstract void renderBeam(TremorzillaEntity var1, PoseStack var2, MultiBufferSource var3, float var4, float var5, float var6, boolean var7, boolean var8);

    public ACExTremorzillaRenderMixin(EntityRendererProvider.Context pContext, TremorzillaModel pModel, float pShadowRadius) {
        super(pContext, (EntityModel)pModel, pShadowRadius);
    }

    public ResourceLocation getTextureLocation(TremorzillaEntity entity) {
        Gammafied myAccessor = (Gammafied)entity;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA : (entity.getAltSkin() == 2 ? TEXTURE_TECTONIC : (entity.getAltSkin() == 1 ? TEXTURE_RETRO : TEXTURE));
    }

    protected void scale(TremorzillaEntity mob, PoseStack matrixStackIn, float partialTicks) {
        float scale = ((Gammafied)mob).isGamma() ? 1.5f : 1.0f;
        matrixStackIn.m_85841_(scale, scale, scale);
    }

    @Inject(method={"render(Lcom/github/alexmodguy/alexscaves/server/entity/living/TremorzillaEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void alexsCavesExempified$render(TremorzillaEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight, CallbackInfo ci) {
        if (((Gammafied)entity).isGamma()) {
            ci.cancel();
            Vec3 gammaMultiplier = new Vec3(1.5, 1.5, 1.5);
            ((TremorzillaModel)this.f_115290_).straighten = this.sepia;
            this.f_114477_ = 4.0f * entity.m_6134_();
            super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, source, packedLight);
            float bodyYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
            float beamProgress = entity.getBeamProgress(partialTicks);
            Vec3 beamEndVec = entity.getClientBeamEndPosition(partialTicks);
            if (beamProgress > 0.0f && entity.m_6084_() && beamEndVec != null) {
                Vec3 modelOffset = ((TremorzillaModel)this.m_7200_()).getMouthPosition(new Vec3(0.0, (double)0.1f, 0.0)).m_82524_((float)(Math.PI - (double)(bodyYaw * ((float)Math.PI / 180)))).m_82559_(gammaMultiplier);
                float ageInTicks = (float)entity.f_19797_ + partialTicks;
                float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.075f;
                float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.075f;
                float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.075f;
                Vec3 rawBeamPosition = beamEndVec.m_82546_(entity.m_20318_(partialTicks).m_82549_(modelOffset));
                float length = (float)rawBeamPosition.m_82553_();
                Vec3 vec3 = rawBeamPosition.m_82541_();
                float xRot = (float)Math.acos(vec3.f_82480_);
                float yRot = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
                float width = beamProgress * 1.5f;
                poseStack.m_85836_();
                poseStack.m_85837_(modelOffset.f_82479_ + (double)shakeByX, modelOffset.f_82480_ + (double)shakeByY, modelOffset.f_82481_ + (double)shakeByZ);
                poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
                for (float angle = 0.0f; angle < 360.0f; angle += 120.0f) {
                    poseStack.m_85836_();
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(angle + ageInTicks * 4.0f));
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(2.0f));
                    this.renderBeam(entity, poseStack, source, partialTicks, width, length, true, false);
                    if (((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue()) {
                        this.renderBeam(entity, poseStack, source, partialTicks, width, length, true, true);
                    }
                    this.renderBeam(entity, poseStack, source, partialTicks, width, length, false, false);
                    poseStack.m_85849_();
                }
                poseStack.m_85849_();
            }
            mouthParticlePositions.put(entity.m_19879_(), ((TremorzillaModel)this.f_115290_).getMouthPosition(MOUTH_TRANSFORM_POS).m_82559_(gammaMultiplier));
        }
    }

    @ModifyVariable(method={"renderBeam"}, at=@At(value="STORE"), ordinal=0, remap=false)
    private ResourceLocation beam1(ResourceLocation value, @Local TremorzillaEntity tremorzilla) {
        Gammafied myAccessor = (Gammafied)tremorzilla;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA_BEAM_INNER : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_INNER : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_INNER : TEXTURE_BEAM_INNER));
    }

    @ModifyVariable(method={"renderBeam"}, at=@At(value="STORE", ordinal=1), remap=false)
    private ResourceLocation beam2(ResourceLocation original, @Local TremorzillaEntity tremorzilla) {
        Gammafied myAccessor = (Gammafied)tremorzilla;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA_BEAM_OUTER : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_OUTER : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_OUTER : TEXTURE_BEAM_OUTER));
    }

    @ModifyReturnValue(method={"getEndBeamTexture"}, at={@At(value="RETURN")}, remap=false)
    private ResourceLocation beam3(ResourceLocation original, @Local TremorzillaEntity tremorzilla) {
        Gammafied myAccessor = (Gammafied)tremorzilla;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA_BEAM_END_0 : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_0 : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_0 : TEXTURE_BEAM_END_0));
    }

    @ModifyReturnValue(method={"getEndBeamTexture"}, at={@At(value="RETURN")}, remap=false)
    private ResourceLocation beam4(ResourceLocation original, @Local TremorzillaEntity tremorzilla) {
        Gammafied myAccessor = (Gammafied)tremorzilla;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA_BEAM_END_1 : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_1 : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_1 : TEXTURE_BEAM_END_1));
    }

    @ModifyReturnValue(method={"getEndBeamTexture"}, at={@At(value="RETURN")}, remap=false)
    private ResourceLocation beam5(ResourceLocation original, @Local TremorzillaEntity tremorzilla) {
        Gammafied myAccessor = (Gammafied)tremorzilla;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA_BEAM_END_2 : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_2 : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_2 : TEXTURE_BEAM_END_2));
    }

    @ModifyReturnValue(method={"getEndBeamTexture"}, at={@At(value="RETURN")}, remap=false)
    private ResourceLocation beam6(ResourceLocation original, @Local TremorzillaEntity tremorzilla) {
        Gammafied myAccessor = (Gammafied)tremorzilla;
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && myAccessor.isGamma() ? TEXTURE_GAMMA_BEAM_END_0 : (tremorzilla.getAltSkin() == 2 ? TEXTURE_TECTONIC_BEAM_END_0 : (tremorzilla.getAltSkin() == 1 ? TEXTURE_RETRO_BEAM_END_0 : TEXTURE_BEAM_END_0));
    }

    static {
        TEXTURE = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla.png");
        TEXTURE_BEAM_INNER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_inner.png");
        TEXTURE_BEAM_OUTER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_outer.png");
        TEXTURE_BEAM_END_0 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_end_0.png");
        TEXTURE_BEAM_END_1 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_end_1.png");
        TEXTURE_BEAM_END_2 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_beam_end_2.png");
        TEXTURE_RETRO = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro.png");
        TEXTURE_RETRO_BEAM_INNER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_inner.png");
        TEXTURE_RETRO_BEAM_OUTER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_retro_beam_outer.png");
        TEXTURE_RETRO_BEAM_END_0 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_gamma_lbeam_end_0.png");
        TEXTURE_RETRO_BEAM_END_1 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_gamma_lbeam_end_1.png");
        TEXTURE_RETRO_BEAM_END_2 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_gamma_lbeam_end_2.png");
        TEXTURE_TECTONIC = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic.png");
        TEXTURE_TECTONIC_BEAM_INNER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_inner.png");
        TEXTURE_TECTONIC_BEAM_OUTER = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_outer.png");
        TEXTURE_TECTONIC_BEAM_END_0 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_end_0.png");
        TEXTURE_TECTONIC_BEAM_END_1 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_end_1.png");
        TEXTURE_TECTONIC_BEAM_END_2 = new ResourceLocation("alexscaves:textures/entity/tremorzilla/tremorzilla_tectonic_beam_end_2.png");
        TEXTURE_GAMMA = new ResourceLocation("alexscavesexemplified:textures/entity/tremorzilla/tremorzilla_gamma.png");
        TEXTURE_GAMMA_BEAM_INNER = new ResourceLocation("alexscavesexemplified:textures/entity/tremorzilla/tremorzilla_gamma_beam_inner.png");
        TEXTURE_GAMMA_BEAM_OUTER = new ResourceLocation("alexscavesexemplified:textures/entity/tremorzilla/tremorzilla_gamma_beam_outer.png");
        TEXTURE_GAMMA_BEAM_END_0 = new ResourceLocation("alexscavesexemplified:textures/entity/tremorzilla/tremorzilla_gamma_beam_end_0.png");
        TEXTURE_GAMMA_BEAM_END_1 = new ResourceLocation("alexscavesexemplified:textures/entity/tremorzilla/tremorzilla_gamma_beam_end_1.png");
        TEXTURE_GAMMA_BEAM_END_2 = new ResourceLocation("alexscavesexemplified:textures/entity/tremorzilla/tremorzilla_gamma_beam_end_2.png");
    }
}

