/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.tremorzilla;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import com.github.alexmodguy.alexscaves.server.item.HazmatArmorItem;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Iterator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.client.particle.ACExParticleRegistry;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.Gammafied;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TremorzillaEntity.class})
public abstract class ACExTremorzillaMixin
extends DinosaurEntity
implements Gammafied {
    @Shadow
    public Vec3 beamServerTarget;
    @Shadow
    @Final
    public static Animation ANIMATION_ROAR_2;
    @Shadow
    private int beamTime;
    @Shadow
    @Final
    private static EntityDimensions SWIMMING_SIZE;
    boolean sound;
    private static final EntityDataAccessor<Boolean> GAMMA;
    private static final EntityDataAccessor<Boolean> ANIMATION_BEAMING;
    private static final EntityDataAccessor<Boolean> SECOND_PHASE;
    int spitDesire = 0;

    @Shadow
    public abstract void setMaxBeamBreakLength(float var1);

    @Shadow
    public abstract Animation getAnimation();

    @Shadow
    public abstract void setAnimation(Animation var1);

    @Shadow
    public abstract int getAnimationTick();

    @Shadow
    protected abstract Vec3 createInitialBeamVec();

    @Shadow
    public abstract void setCharge(int var1);

    @Shadow
    public abstract void setBeamEndPosition(@Nullable Vec3 var1);

    @Shadow
    public abstract void setFiring(boolean var1);

    @Shadow
    public abstract boolean isTremorzillaSwimming();

    protected ACExTremorzillaMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public boolean isGamma() {
        return (Boolean)this.f_19804_.m_135370_(GAMMA);
    }

    @Override
    public void setGamma(boolean val) {
        this.m_21051_(Attributes.f_22276_).m_22100_(750.0);
        this.m_21051_(Attributes.f_22284_).m_22100_(18.0);
        this.m_21051_(Attributes.f_22281_).m_22100_(50.0);
        this.f_19804_.m_135381_(GAMMA, (Object)val);
    }

    public boolean is2ndPhase() {
        return (Boolean)this.f_19804_.m_135370_(SECOND_PHASE);
    }

    public void set2ndPhase(boolean val) {
        this.f_19804_.m_135381_(SECOND_PHASE, (Object)val);
    }

    @Override
    public boolean isAnimationBeaming() {
        return (Boolean)this.f_19804_.m_135370_(ANIMATION_BEAMING);
    }

    @Override
    public void setAnimationBeaming(boolean variant) {
        this.f_19804_.m_135381_(ANIMATION_BEAMING, (Object)variant);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(GAMMA, (Object)false);
        this.f_19804_.m_135372_(SECOND_PHASE, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_BEAMING, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Gamma", this.isGamma());
        compound.m_128379_("2ndPhase", this.is2ndPhase());
        compound.m_128379_("AnimationBeaming", this.isAnimationBeaming());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setGamma(compound.m_128471_("Gamma"));
        this.set2ndPhase(compound.m_128471_("2ndPhase"));
        this.setAnimationBeaming(compound.m_128471_("AnimationBeaming"));
    }

    public void m_6667_(DamageSource pCause) {
        if (this.isGamma() && !this.m_21824_() && !this.m_6162_() && pCause.m_7639_() instanceof Player) {
            ACExUtils.awardAdvancement(pCause.m_7639_(), "gamma_tremorzilla_kill", "gamma_kill");
        }
        super.m_6667_(pCause);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        float determiner;
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            amount *= 0.35f;
        }
        if (amount > (determiner = this.m_21233_() / 3.0f) && this.m_21223_() > determiner && !this.m_6162_() && !this.is2ndPhase() && this.isGamma() && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get()).booleanValue() && source.m_7639_() != null) {
            this.setAnimationBeaming(true);
            this.beamServerTarget = this.createInitialBeamVec();
            this.setMaxBeamBreakLength(180.0f);
            this.setAnimation(ANIMATION_ROAR_2);
            this.m_6710_(null);
            this.m_6703_(null);
            this.set2ndPhase(true);
            this.m_21051_(Attributes.f_22284_).m_22100_(12.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(75.0);
            return super.m_6469_(source, this.m_21223_() - determiner);
        }
        return super.m_6469_(source, amount);
    }

    @ModifyReturnValue(method={"getScale"}, at={@At(value="RETURN")})
    private float alexsCavesExemplified$getScale(float original) {
        return (this.m_6162_() ? 0.15f : 1.0f) * (this.isGamma() ? 1.4f : 1.0f);
    }

    @ModifyReturnValue(method={"getBeamShootFrom"}, at={@At(value="RETURN")}, remap=false)
    private Vec3 alexsCavesExemplified$getBeamShootFrom(Vec3 original) {
        return original.m_82520_(0.0, this.isGamma() ? 3.0 : 0.0, 0.0);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/living/DinosaurEntity;tick()V")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        this.m_6210_();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get()).booleanValue()) {
            LivingEntity living;
            LivingEntity prevTarget;
            Level level = this.m_9236_();
            if (this.m_21223_() == this.m_21233_()) {
                this.set2ndPhase(false);
                this.m_21051_(Attributes.f_22284_).m_22100_(18.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(50.0);
            }
            if ((prevTarget = null) != (living = this.m_5448_())) {
                prevTarget = living;
            }
            if (this.getAnimation() == ANIMATION_ROAR_2 && this.getAnimationTick() >= 20 && this.getAnimationTick() <= 45 && this.isAnimationBeaming()) {
                this.setFiring(true);
            } else if (this.isAnimationBeaming() && this.getAnimation() == ANIMATION_ROAR_2 && this.getAnimationTick() >= 45) {
                this.sound = false;
                this.setFiring(false);
                this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_BEAM_END.get(), 8.0f, 1.0f);
                if (this.getAnimationTick() >= 55) {
                    this.m_6710_(prevTarget);
                    int rotate = this.f_19796_.m_216339_(0, 361);
                    for (int i = 0; i < 7; ++i) {
                        Vec3 vec3 = new Vec3(this.m_20185_() + Math.cos((rotate += 51) * 10) * 2.0, this.m_20186_(), this.m_20189_() + Math.sin(rotate * 10) * 2.0);
                        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                        if (lightningBolt == null) continue;
                        lightningBolt.m_146884_(vec3);
                        level.m_7967_((Entity)lightningBolt);
                    }
                    this.beamTime = 0;
                    this.beamServerTarget = null;
                    this.setBeamEndPosition(null);
                    this.setAnimationBeaming(false);
                    this.setCharge(0);
                }
            }
            if (!this.sound && this.getAnimation() == ANIMATION_ROAR_2 && this.getAnimationTick() == 15 && this.isAnimationBeaming()) {
                this.m_5496_((SoundEvent)ACSoundRegistry.TREMORZILLA_ROAR.get(), 8.0f, this.m_6162_() ? 2.0f : 1.0f);
                this.sound = true;
            }
            ++this.spitDesire;
        }
        if (!((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get()).booleanValue() && this.isGamma()) {
            this.setGamma(false);
            this.set2ndPhase(false);
        }
    }

    @ModifyArg(method={"tick"}, at=@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/living/TremorzillaEntity;breakBlocksAround(Lnet/minecraft/world/phys/Vec3;FZZF)Z"), index=1)
    private float alexsCavesExemplified$tick1(float radius) {
        return radius * (this.isGamma() ? 1.4f : 1.0f);
    }

    @ModifyArg(method={"positionRider"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity$MoveFunction;accept(Lnet/minecraft/world/entity/Entity;DDD)V"), index=2)
    private double alexsCavesExemplified$positionRider(double pY) {
        return pY + (this.isGamma() ? 3.0 : 0.0);
    }

    @ModifyConstant(method={"tickBreath"}, constant={@Constant(floatValue=5.0f)}, remap=false)
    private float alexsCavesExemplified$tickBreath1(float amount) {
        return this.isGamma() ? 10.0f : amount;
    }

    @ModifyArg(method={"tickBreath"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;ZDDDDDD)V", ordinal=2))
    private ParticleOptions alexsCavesExemplified$tickBreath2(ParticleOptions pParticleData) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && this.isGamma() ? (ParticleOptions)ACExParticleRegistry.TREMORZILLA_GAMMA_PROTON.get() : (this.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_PROTON.get() : (this.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_PROTON.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_PROTON.get()));
    }

    @ModifyArg(method={"tickBreath"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;ZDDDDDD)V", ordinal=0))
    private ParticleOptions alexsCavesExemplified$tickBreath3(ParticleOptions pParticleData) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && this.isGamma() ? (ParticleOptions)ACExParticleRegistry.TREMORZILLA_GAMMA_EXPLOSION.get() : (this.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_EXPLOSION.get() : (this.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_EXPLOSION.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_EXPLOSION.get()));
    }

    @ModifyArg(method={"tickBreath"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addAlwaysVisibleParticle(Lnet/minecraft/core/particles/ParticleOptions;ZDDDDDD)V", ordinal=1))
    private ParticleOptions alexsCavesExemplified$tickBreath4(ParticleOptions pParticleData) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && this.isGamma() ? (ParticleOptions)ACExParticleRegistry.TREMORZILLA_GAMMA_LIGHTNING.get() : (this.getAltSkin() == 2 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_TECTONIC_LIGHTNING.get() : (this.getAltSkin() == 1 ? (ParticleOptions)ACParticleRegistry.TREMORZILLA_RETRO_LIGHTNING.get() : (ParticleOptions)ACParticleRegistry.TREMORZILLA_LIGHTNING.get()));
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=100, ordinal=1)})
    private int alexsCavesExemplified$tick(int amount) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && this.isGamma() ? 250 : amount;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(floatValue=100.0f, ordinal=0)})
    private float alexsCavesExemplified$tick(float constant) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get() != false && this.isGamma() ? 180.0f : constant;
    }

    @ModifyConstant(method={"hurtEntitiesAround"}, constant={@Constant(intValue=2)}, remap=false)
    private int alexsCavesExemplified$hurtEntitiesAround(int amount, @Local LivingEntity living) {
        int hazmatReduction;
        int n = hazmatReduction = (Boolean)AlexsCavesExemplified.COMMON_CONFIG.ARMORED_LIQUIDATORS_ENABLED.get() != false ? HazmatArmorItem.getWornAmount((LivingEntity)living) : 0;
        return ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get()).booleanValue() && this.isGamma() ? (6 - hazmatReduction > 0 ? 6 - hazmatReduction : 1) : (amount - hazmatReduction > 0 ? amount - hazmatReduction : 1);
    }

    @Inject(method={"hurtEntitiesAround"}, at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/living/TremorzillaEntity;knockbackTarget(Lnet/minecraft/world/entity/Entity;DDDZ)V")}, locals=LocalCapture.CAPTURE_FAILSOFT, remap=false)
    private void alexsCavesExemplified$hurtEntitiesAround1(Vec3 center, float radius, float damageAmount, float knockbackAmount, boolean radioactive, boolean hurtsOtherKaiju, boolean stretchY, CallbackInfoReturnable<Boolean> cir, AABB aabb, boolean flag, DamageSource damageSource, Iterator var11, LivingEntity living) {
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.GAMMA_TREMORZILLA_ENABLED.get()).booleanValue() && this.isGamma()) {
            living.m_7311_(1000);
        }
    }

    static {
        GAMMA = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        ANIMATION_BEAMING = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SECOND_PHASE = SynchedEntityData.m_135353_(TremorzillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

