/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.teletor;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MagneticWeaponEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TeletorEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TeletorEntity.class})
public abstract class ACExTeletorMixin
extends Monster {
    @Shadow
    public abstract Entity getWeapon();

    protected ACExTeletorMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        TeletorEntity teletor = (TeletorEntity)this;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.TELETOR_ARMORY_ENABLED.get()).booleanValue() && !teletor.m_21224_()) {
            for (ItemEntity item : teletor.m_9236_().m_45976_(ItemEntity.class, teletor.m_20191_().m_82400_(8.0))) {
                if (!item.m_32055_().m_204117_(ACTagRegistry.TELETOR_SPAWNS_WITH) || teletor.getWeapon() != null) continue;
                ItemStack stolen = item.m_32055_();
                MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get()).m_20615_(this.m_9236_());
                stolen.m_41783_().m_128379_("Stolen", true);
                magneticWeapon.setItemStack(stolen);
                magneticWeapon.setControllerUUID(teletor.m_20148_());
                teletor.setWeaponUUID(magneticWeapon.m_20148_());
                this.m_9236_().m_7967_((Entity)magneticWeapon);
                magneticWeapon.m_146884_(item.m_20182_());
                item.m_146870_();
                ACExUtils.awardAdvancement(item.m_19749_(), "teletor_rearm", "rearm");
            }
        }
    }

    @Inject(method={"dropEquipment"}, at={@At(value="HEAD")})
    private void alexsCavesExemplified$dropEquipment(CallbackInfo ci) {
        Entity weapon = this.getWeapon();
        if (weapon instanceof MagneticWeaponEntity) {
            MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)weapon;
            ItemStack itemstack = magneticWeapon.getItemStack();
            float f1 = this.m_21519_(EquipmentSlot.MAINHAND);
            if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack) && !(this.f_19796_.m_188501_() < f1) && itemstack.m_41783_().m_128471_("Stolen")) {
                ItemEntity stolenItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20188_(), this.m_20189_(), itemstack);
                stolenItem.m_146915_(true);
                this.m_9236_().m_7967_((Entity)stolenItem);
            }
        }
    }
}

