/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.nucleeper;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.NuclearExplosionEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.NucleeperEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.datagen.loottables.ACExLootTables;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.NucleeperXtra;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExNucleeperMelee;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NucleeperEntity.class})
public abstract class ACExNucleeperMixin
extends Monster
implements NucleeperXtra {
    private static final EntityDataAccessor<Boolean> DEFUSED = SynchedEntityData.m_135353_(NucleeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Shadow
    public abstract void setTriggered(boolean var1);

    protected ACExNucleeperMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$registerGoals(CallbackInfo ci) {
        this.f_21345_.m_25352_(2, (Goal)new ACExNucleeperMelee((NucleeperEntity)this));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DEFUSED, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Defused", this.isDefused());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        this.setDefused(compound.m_128471_("Defused"));
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")})
    private void alexsCavesExemplified$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player.m_21120_(hand).m_150930_(Items.f_42574_) && !this.isDefused() && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.DEFUSION_ENABLED.get()).booleanValue()) {
            ACExUtils.awardAdvancement((Entity)player, "defusing", "defuse");
            this.setTriggered(false);
            ACExUtils.spawnLoot(ACExLootTables.NUCLEEPER_DEFUSION, (LivingEntity)this, (Entity)player, 1);
            this.m_216990_((SoundEvent)ACSoundRegistry.NUCLEAR_BOMB_DEFUSE.get());
            this.setDefused(true);
            player.m_6674_(hand);
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p_233654_0_ -> {});
            }
        }
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")}, remap=false)
    private void alexsCavesExemplified$explode(CallbackInfo ci) {
        Level level = this.m_9236_();
        int amount = 0;
        for (NucleeperEntity nucleepers : level.m_45976_(NucleeperEntity.class, this.m_20191_().m_82400_(13.0))) {
            if (!((Boolean)AlexsCavesExemplified.COMMON_CONFIG.NUCLEAR_CHAIN_ENABLED.get()).booleanValue() || ((NucleeperXtra)nucleepers).isDefused()) continue;
            ++amount;
            NuclearExplosionEntity explosion = (NuclearExplosionEntity)((EntityType)ACEntityRegistry.NUCLEAR_EXPLOSION.get()).m_20615_(level);
            explosion.m_20359_((Entity)nucleepers);
            explosion.setSize(nucleepers.isCharged() ? 1.75f : 1.0f);
            if (!level.m_46469_().m_46207_(GameRules.f_46132_)) {
                explosion.setNoGriefing(true);
            }
            level.m_7967_((Entity)explosion);
        }
        for (Player players : level.m_45976_(Player.class, this.m_20191_().m_82400_(50.0))) {
            if (amount >= 10) {
                ACExUtils.awardAdvancement((Entity)players, "nucleeper_annhilation", "nuke_chained");
            }
            if (amount == 0) continue;
            ACExUtils.awardAdvancement((Entity)players, "chain_reaction", "chain");
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        if (!((Boolean)AlexsCavesExemplified.COMMON_CONFIG.DEFUSION_ENABLED.get()).booleanValue() && this.isDefused()) {
            this.setDefused(false);
        }
    }

    @Override
    public void setDefused(boolean val) {
        this.f_19804_.m_135381_(DEFUSED, (Object)val);
    }

    @Override
    public boolean isDefused() {
        return (Boolean)this.f_19804_.m_135370_(DEFUSED);
    }

    @WrapWithCondition(method={"mobInteract"}, at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/living/NucleeperEntity;setTriggered(Z)V")})
    private boolean alexsCavesExemplified$tick(NucleeperEntity instance, boolean triggered) {
        return !this.isDefused();
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=2)})
    private boolean nearestAttack(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.DEFUSION_ENABLED.get() == false;
    }
}

