/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.mine_guardian;

import com.github.alexmodguy.alexscaves.client.model.MineGuardianModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.MineGuardianRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.MineGuardianEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.MineGuardianXtra;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={MineGuardianRenderer.class})
public abstract class ACExMineRendererMixin
extends MobRenderer<MineGuardianEntity, MineGuardianModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/mine_guardian.png");
    private static final ResourceLocation TEXTURE_SLEEPING = new ResourceLocation("alexscaves:textures/entity/mine_guardian_sleeping.png");
    private static final ResourceLocation TEXTURE_NOON = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/noon_guardian.png");
    private static final ResourceLocation TEXTURE_NOON_SLEEPING = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/noon_guardian_sleeping.png");
    private static final ResourceLocation TEXTURE_NOON_ACTIVE = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/noon_guardian_active.png");
    private static final ResourceLocation TEXTURE_AE_NUCLEAR = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/nuclear_ae_guardian.png");
    private static final ResourceLocation TEXTURE_AE_NUCLEAR_SLEEPING = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/nuclear_ae_guardian_sleeping.png");
    private static final ResourceLocation TEXTURE_JESSE_NUCLEAR = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/nuclear_jesse_guardian.png");
    private static final ResourceLocation TEXTURE_JESSE_NUCLEAR_SLEEPING = new ResourceLocation("alexscavesexemplified:textures/entity/mine_guardian/nuclear_jesse_guardian_sleeping.png");

    public ACExMineRendererMixin(EntityRendererProvider.Context pContext, MineGuardianModel pModel, float pShadowRadius) {
        super(pContext, (EntityModel)pModel, pShadowRadius);
    }

    private static void nuclearShineOrigin(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(10, 240, 50, 255).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void nuclearShineLeft(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(15, 250, 59, 0).m_7421_(xOffset, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void nuclearShineRight(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(15, 250, 59, 0).m_7421_(xOffset, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void noonShineOrigin(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(60, 210, 230, 255).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void noonShineLeft(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(64, 233, 255, 0).m_7421_(xOffset, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void noonShineRight(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(64, 233, 255, 0).m_7421_(xOffset, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void ownedShineOrigin(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void ownedShineLeft(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(255, 255, 255, 0).m_7421_(xOffset, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void ownedShineRight(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(255, 255, 255, 0).m_7421_(xOffset, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(MineGuardianEntity entity) {
        return switch (((MineGuardianXtra)entity).alexsCavesExemplified$getVariant()) {
            case -1 -> {
                if (entity.isEyeClosed()) {
                    yield TEXTURE_NOON_SLEEPING;
                }
                if (entity.isScanning()) {
                    yield TEXTURE_NOON;
                }
                yield TEXTURE_NOON_ACTIVE;
            }
            case 1 -> {
                if (entity.isEyeClosed()) {
                    yield TEXTURE_AE_NUCLEAR_SLEEPING;
                }
                yield TEXTURE_AE_NUCLEAR;
            }
            case 2 -> {
                if (entity.isEyeClosed()) {
                    yield TEXTURE_JESSE_NUCLEAR_SLEEPING;
                }
                yield TEXTURE_JESSE_NUCLEAR;
            }
            default -> entity.isEyeClosed() ? TEXTURE_SLEEPING : TEXTURE;
        };
    }

    @Inject(method={"render(Lcom/github/alexmodguy/alexscaves/server/entity/living/MineGuardianEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V", ordinal=2)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void alexsCavesExemplified$render(MineGuardianEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, CallbackInfo ci, float bodyYaw, float scanProgress, float ticks, float length, float width, float extraX) {
        MineGuardianXtra accesor = (MineGuardianXtra)entityIn;
        assert (Minecraft.m_91087_().f_91074_ != null);
        if (!Minecraft.m_91087_().f_91074_.m_20149_().equals(accesor.alexsCavesExemplified$getOwner())) {
            VertexConsumer lightConsumer;
            Matrix3f matrix3f1;
            Matrix4f matrix4f1;
            PoseStack.Pose posestack$pose;
            if (accesor.alexsCavesExemplified$getVariant() == -1) {
                ci.cancel();
                poseStack.m_252880_(0.3f, -0.5f, -0.1f);
                posestack$pose = poseStack.m_85850_();
                matrix4f1 = posestack$pose.m_252922_();
                matrix3f1 = posestack$pose.m_252943_();
                lightConsumer = bufferIn.m_6299_(ACRenderTypes.getSubmarineLights());
                ACExMineRendererMixin.noonShineOrigin(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
                ACExMineRendererMixin.noonShineLeft(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                ACExMineRendererMixin.noonShineRight(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                ACExMineRendererMixin.noonShineLeft(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                poseStack.m_85849_();
                poseStack.m_85849_();
            }
            if (accesor.alexsCavesExemplified$getVariant() > 0) {
                ci.cancel();
                poseStack.m_252880_(0.0f, -0.5f, 0.0f);
                posestack$pose = poseStack.m_85850_();
                matrix4f1 = posestack$pose.m_252922_();
                matrix3f1 = posestack$pose.m_252943_();
                lightConsumer = bufferIn.m_6299_(ACRenderTypes.getSubmarineLights());
                ACExMineRendererMixin.nuclearShineOrigin(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
                ACExMineRendererMixin.nuclearShineLeft(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                ACExMineRendererMixin.nuclearShineRight(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                ACExMineRendererMixin.nuclearShineLeft(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
                poseStack.m_85849_();
                poseStack.m_85849_();
            }
        } else {
            ci.cancel();
            if (accesor.alexsCavesExemplified$getVariant() == -1) {
                poseStack.m_252880_(0.3f, -0.5f, -0.1f);
            } else {
                poseStack.m_252880_(0.0f, -0.5f, 0.0f);
            }
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f1 = posestack$pose.m_252922_();
            Matrix3f matrix3f1 = posestack$pose.m_252943_();
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getSubmarineLights());
            ACExMineRendererMixin.ownedShineOrigin(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
            ACExMineRendererMixin.ownedShineLeft(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            ACExMineRendererMixin.ownedShineRight(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            ACExMineRendererMixin.ownedShineLeft(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
    }
}

