/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs.boundroid;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidWinchEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.ACExBaseInterface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BoundroidEntity.class})
public abstract class ACExBoundroidMixin
extends Monster
implements ACExBaseInterface {
    @Shadow
    public int stopSlammingFor;
    private static final EntityDataAccessor<Boolean> MAGNETIZING = SynchedEntityData.m_135353_(BoundroidEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int activateDelay;

    protected ACExBoundroidMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        BoundroidEntity boundroidEntity = (BoundroidEntity)this;
        if (this.isMagnetizing() && boundroidEntity.m_217043_().m_188500_() < 0.01) {
            for (int i = 0; i < 10; ++i) {
                Vec3 vec3 = new Vec3(((double)boundroidEntity.m_217043_().m_188501_() - 0.5) * (double)0.3f, ((double)boundroidEntity.m_217043_().m_188501_() - 0.5) * (double)0.3f + (double)boundroidEntity.m_217043_().m_216339_(-2, 3), (double)(1.0f + 1.0f * boundroidEntity.m_217043_().m_188501_())).m_82524_((float)((double)((float)i / 10.0f) * Math.PI * 2.0)).m_82549_(boundroidEntity.m_20182_());
                boundroidEntity.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_SHIELD_LIGHTNING.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, boundroidEntity.m_20185_(), boundroidEntity.m_20186_(), boundroidEntity.m_20189_());
            }
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.BOUNDED_MAGNETISM_ENABLED.get()).booleanValue()) {
            LivingEntity target = boundroidEntity.m_5448_();
            BoundroidWinchEntity boundroidWinch = (BoundroidWinchEntity)boundroidEntity.getWinch();
            if (this.isMagnetizing() && target != null && MagnetUtil.isPulledByMagnets((Entity)target) && MagnetUtil.isPulledByMagnets((Entity)target) && boundroidWinch.m_20270_((Entity)target) < 3.0f && boundroidWinch.isLatched()) {
                this.activateDelay = 100;
                this.setMagnetizing(false);
                this.stopSlammingFor = 110;
            }
            if (this.activateDelay > 0 && !this.isMagnetizing()) {
                --this.activateDelay;
            }
            if (this.activateDelay <= 0 && !this.isMagnetizing() && !boundroidEntity.m_9236_().m_5776_()) {
                this.setMagnetizing(true);
            }
            for (Entity entity1 : boundroidEntity.m_9236_().m_45976_(Entity.class, boundroidEntity.m_20191_().m_82400_(2.2))) {
                Vec3 pull = boundroidEntity.m_20182_().m_82492_(0.0, 1.8, 0.0).m_82546_(entity1.m_20182_());
                if (pull.m_82553_() > 1.0) {
                    pull = pull.m_82541_();
                }
                if (!MagnetUtil.isPulledByMagnets((Entity)entity1)) continue;
                float strength = 0.32f;
                if (Math.abs(pull.f_82479_) > Math.abs(pull.f_82480_) && Math.abs(pull.f_82479_) > Math.abs(pull.f_82481_)) {
                    pull = new Vec3(pull.f_82479_, 0.0, 0.0);
                }
                if (Math.abs(pull.f_82480_) > Math.abs(pull.f_82479_) && Math.abs(pull.f_82480_) > Math.abs(pull.f_82481_)) {
                    pull = new Vec3(0.0, pull.f_82480_, 0.0);
                }
                if (Math.abs(pull.f_82481_) > Math.abs(pull.f_82479_) && Math.abs(pull.f_82481_) > Math.abs(pull.f_82480_)) {
                    pull = new Vec3(0.0, 0.0, pull.f_82481_);
                }
                entity1.f_19789_ = 0.0f;
                if (MagnetUtil.isEntityOnMovingMetal((Entity)entity1) || !this.isMagnetizing()) continue;
                if (entity1 == boundroidEntity.m_5448_()) {
                    this.stopSlammingFor = 30 + this.f_19796_.m_188503_(20);
                }
                Vec3 center = entity1.m_20182_();
                entity1.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_MAGNETIC_ORBIT.get(), center.f_82479_, center.f_82480_ + 1.0, center.f_82481_, center.f_82479_, center.f_82480_, center.f_82481_);
                entity1.m_20256_(entity1.m_20184_().m_82520_((double)strength * pull.f_82479_, (double)strength * pull.f_82480_, (double)strength * pull.f_82481_));
            }
        }
    }

    @Override
    public boolean isMagnetizing() {
        return (Boolean)this.f_19804_.m_135370_(MAGNETIZING);
    }

    public void setMagnetizing(boolean val) {
        this.f_19804_.m_135381_(MAGNETIZING, (Object)val);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$define(CallbackInfo ci) {
        this.f_19804_.m_135372_(MAGNETIZING, (Object)true);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$add(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Magnetizing", this.isMagnetizing());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$read(CompoundTag compound, CallbackInfo ci) {
        this.setMagnetizing(compound.m_128471_("Magnetizing"));
    }
}

