/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs;

import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import com.google.common.base.Predicates;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.compat.CuriosCompat;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExEntityTagGenerator;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExVesperTarget;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VesperEntity.class})
public abstract class ACExVesperMixin
extends Monster {
    @Shadow
    public int groundedFor;

    @Shadow
    public abstract void setHanging(boolean var1);

    protected ACExVesperMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        VesperEntity vesper = (VesperEntity)this;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, new ACExVesperTarget<Player>(vesper, 32.0f, Player.class, livingEntity -> !CuriosCompat.hasLight(livingEntity) || vesper.m_271686_() == livingEntity));
            vesper.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)vesper, LivingEntity.class, 4.0f, 1.5, 2.0, livingEntity -> vesper.m_271686_() != livingEntity && CuriosCompat.hasLight(livingEntity)));
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.ANTI_SACRIFICE_ENABLED.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, new ACExVesperTarget<UnderzealotEntity>(vesper, 32.0f, UnderzealotEntity.class, livingEntity -> {
                UnderzealotEntity underzealot;
                return livingEntity instanceof UnderzealotEntity && (underzealot = (UnderzealotEntity)livingEntity).m_146895_() instanceof VesperEntity;
            }));
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.ADD_TARGETS_ENABLED.get()).booleanValue()) {
            this.f_21346_.m_25352_(3, new ACExVesperTarget<LivingEntity>(vesper, 32.0f, LivingEntity.class, ACExVesperMixin.buildPredicateFromTag(ACExEntityTagGenerator.VESPER_HUNT)));
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        LivingEntity target = this.m_5448_();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get()).booleanValue() && target != null && target != this.m_21188_() && CuriosCompat.hasLight(target)) {
            this.m_6710_(null);
            ACExUtils.awardAdvancement((Entity)target, "light_repel", "repelled");
        }
    }

    public boolean m_6573_(Player pPlayer) {
        return super.m_6573_(pPlayer) || (Boolean)AlexsCavesExemplified.COMMON_CONFIG.DARK_OFFERING_ENABLED.get() != false && !this.m_20159_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268739_) && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.VESPER_SHOTDOWN_ENABLED.get()).booleanValue()) {
            this.setHanging(false);
            this.groundedFor = 1000;
            ACExUtils.awardAdvancement(pSource.m_7639_(), "shot_down", "shot");
        }
        return super.m_6469_(pSource, pAmount);
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=7)})
    private boolean alexsCavesExemplified$nearestAttack(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get() == false;
    }

    private static Predicate<LivingEntity> buildPredicateFromTag(TagKey<EntityType<?>> entityTag) {
        return entityTag == null ? Predicates.alwaysFalse() : e -> e.m_6084_() && e.m_6095_().m_204039_(entityTag);
    }
}

