/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorsaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.TargetsDroppedItems;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.TremorConsumption;
import org.crimsoncrips.alexscavesexemplified.server.effect.ACExEffects;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExDinosaurEggAttack;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExTremorDroppedEatBlock;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExTremorEatBlock;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExTremorTempt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TremorsaurusEntity.class})
public abstract class ACExTremorsaurusMixin
extends DinosaurEntity
implements TargetsDroppedItems,
TremorConsumption {
    private static final EntityDataAccessor<Boolean> SNIFFED = SynchedEntityData.m_135353_(TremorsaurusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected ACExTremorsaurusMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"registerGoals"}, at={@At(value="HEAD")})
    private void registerGoals(CallbackInfo ci) {
        TremorsaurusEntity tremorsaurus = (TremorsaurusEntity)this;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.EGG_ANGER_ENABLED.get()).booleanValue()) {
            tremorsaurus.f_21346_.m_25352_(4, new ACExDinosaurEggAttack((Mob)tremorsaurus, LivingEntity.class, true));
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SEETHED_TAMING_ENABLED.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new ACExTremorTempt(tremorsaurus, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACBlockRegistry.COOKED_DINOSAUR_CHOP.get(), (ItemLike)ACBlockRegistry.DINOSAUR_CHOP.get()}), false));
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SCAVENGING_ENABLED.get()).booleanValue()) {
            tremorsaurus.f_21345_.m_25352_(3, (Goal)new ACExTremorEatBlock(tremorsaurus, 1.0, 30, 3));
            tremorsaurus.f_21346_.m_25352_(2, (Goal)new ACExTremorDroppedEatBlock(tremorsaurus, true, true, 200 + tremorsaurus.m_217043_().m_188503_(150), 30));
        }
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/entity/living/TremorsaurusEntity;playSound(Lnet/minecraft/sounds/SoundEvent;FF)V")})
    private void stomp(CallbackInfo ci) {
        TremorsaurusEntity tremorsaurus = (TremorsaurusEntity)this;
        for (LivingEntity entity : tremorsaurus.m_9236_().m_45976_(LivingEntity.class, tremorsaurus.m_20191_().m_82363_(1.0, -2.0, 1.0))) {
            if (entity == tremorsaurus || !(entity.m_20206_() <= 0.8f)) continue;
            entity.m_6469_(tremorsaurus.m_269291_().m_269333_((LivingEntity)tremorsaurus), 3.0f);
        }
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=6)})
    private boolean tempt(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.SEETHED_TAMING_ENABLED.get() == false;
    }

    public boolean canTargetItem(ItemStack itemStack) {
        return itemStack.m_150930_(((Block)ACBlockRegistry.DINOSAUR_CHOP.get()).m_5456_()) || itemStack.m_150930_(((Block)ACBlockRegistry.COOKED_DINOSAUR_CHOP.get()).m_5456_());
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(SNIFFED, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Sniffed", this.isSniffed());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setSniffed(compound.m_128471_("Sniffed"));
    }

    @Override
    public boolean isSniffed() {
        return (Boolean)this.f_19804_.m_135370_(SNIFFED);
    }

    @Override
    public void setSniffed(boolean value) {
        this.f_19804_.m_135381_(SNIFFED, (Object)value);
    }

    public boolean isSeethed(TremorsaurusEntity tremorsaurus) {
        return tremorsaurus.m_21023_((MobEffect)ACExEffects.SERENED.get());
    }
}

