/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs;

import com.github.alexmodguy.alexscaves.server.entity.living.GummyBearEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.GummyColors;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={GummyBearEntity.class})
public abstract class ACExGummybearMixin
extends Animal {
    @Shadow
    private int sleepFor;
    @Shadow
    private int jellybeansToMake;
    private int setVariable;

    @Shadow
    public abstract boolean isDigestiblePotion(ItemStack var1);

    @Shadow
    public abstract boolean isDigesting();

    @Shadow
    public abstract void setDigesting(boolean var1);

    @Shadow
    public abstract boolean digestEffect(Potion var1);

    @Shadow
    public abstract GummyColors getGummyColor();

    @Shadow
    public abstract boolean isBearSleeping();

    protected ACExGummybearMixin(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_6469_(DamageSource damageSource, float pAmount) {
        Entity entity;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.JELLYBEAN_CHANGES_ENABLED.get()).booleanValue() && (entity = damageSource.m_7639_()) != null && this.isBearSleeping()) {
            this.jellybeansToMake = this.setVariable / 4000 - this.sleepFor / 4000;
            this.sleepFor = 0;
            ACExUtils.awardAdvancement(entity, "interrupt", "interrupt");
        }
        return super.m_6469_(damageSource, pAmount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isDigestiblePotion(itemstack) && !this.isDigesting()) {
            if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.JELLYBEAN_CHANGES_ENABLED.get()).booleanValue()) {
                this.jellybeansToMake = 0;
            }
            this.setDigesting(true);
            this.digestEffect(PotionUtils.m_43579_((ItemStack)itemstack));
            this.m_142075_(player, hand, itemstack);
            if (!player.m_150110_().f_35937_) {
                player.m_36356_(new ItemStack((ItemLike)Items.f_42590_));
            }
            this.sleepFor = 24000 * (2 + this.f_19796_.m_188503_(2));
            if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.JELLYBEAN_CHANGES_ENABLED.get()).booleanValue()) {
                this.setVariable = this.sleepFor;
                this.jellybeansToMake = 1 + this.setVariable / 8000;
            } else {
                this.jellybeansToMake = this.f_19796_.m_188503_(2) + 3;
            }
            this.m_5496_((SoundEvent)ACSoundRegistry.GUMMY_BEAR_EAT.get(), this.m_6121_(), this.m_6100_());
            return InteractionResult.SUCCESS;
        }
        if (this.isBearSleeping() && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.SWEETISH_SPEEDUP_ENABLED.get()).booleanValue() && this.sleepFor > 0) {
            return switch (this.getGummyColor().toString()) {
                case "GREEN" -> {
                    if (itemstack.m_150930_((Item)ACItemRegistry.SWEETISH_FISH_GREEN.get())) {
                        this.boost((Entity)player, itemstack);
                    }
                    yield InteractionResult.SUCCESS;
                }
                case "BLUE" -> {
                    if (itemstack.m_150930_((Item)ACItemRegistry.SWEETISH_FISH_BLUE.get())) {
                        this.boost((Entity)player, itemstack);
                    }
                    yield InteractionResult.SUCCESS;
                }
                case "YELLOW" -> {
                    if (itemstack.m_150930_((Item)ACItemRegistry.SWEETISH_FISH_YELLOW.get())) {
                        this.boost((Entity)player, itemstack);
                    }
                    yield InteractionResult.SUCCESS;
                }
                case "PINK" -> {
                    if (itemstack.m_150930_((Item)ACItemRegistry.SWEETISH_FISH_PINK.get())) {
                        this.boost((Entity)player, itemstack);
                    }
                    yield InteractionResult.SUCCESS;
                }
                default -> {
                    if (itemstack.m_150930_((Item)ACItemRegistry.SWEETISH_FISH_RED.get())) {
                        this.boost((Entity)player, itemstack);
                    }
                    yield InteractionResult.SUCCESS;
                }
            };
        }
        return super.m_6071_(player, hand);
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=85)})
    private int modifyAmount(int amount) {
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.JELLYBEAN_CHANGES_ENABLED.get()).booleanValue()) {
            return 100000000;
        }
        return amount;
    }

    public void boost(Entity entity, ItemStack itemStack) {
        itemStack.m_41774_(1);
        ACExUtils.awardAdvancement(entity, "feed_speedup", "feed");
        this.sleepFor = this.sleepFor >= 1000 ? (this.sleepFor -= 1000) : 0;
        this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }
}

