/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.FrostmintSpearEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.FrostmintExplosion;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.compat.BOPCompat;
import org.crimsoncrips.alexscavesexemplified.compat.CreateCompat;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FrostmintSpearEntity.class})
public abstract class ACExFrostmintSpearMixin
extends AbstractArrow {
    @Shadow
    private boolean exploded;

    @Shadow
    @Nullable
    public abstract Entity m_19749_();

    protected ACExFrostmintSpearMixin(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_6128_() {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.RADIANT_WRATH_ENABLED.get() != false && this.getPersistentData().m_128471_("FrostRadiant");
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        Level level = this.m_9236_();
        if (this.isInFluidType() && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.AMPLIFIED_FROSTMINT_ENABLED.get()).booleanValue() && this.isInFluidType((FluidType)ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get()) && !level.f_46443_) {
            FrostmintExplosion explosion = new FrostmintExplosion(level, (Entity)this, this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, 4.0f, Explosion.BlockInteraction.DESTROY_WITH_DECAY, false);
            explosion.explode();
            explosion.finalizeExplosion(true);
            if (this.m_19749_() instanceof Player) {
                ACAdvancementTriggerRegistry.FROSTMINT_EXPLOSION.triggerForEntity(this.m_19749_());
            }
            this.m_146870_();
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.RADIANT_WRATH_ENABLED.get()).booleanValue() && this.getPersistentData().m_128471_("FrostRadiant") && this.f_19797_ > 100) {
            this.m_146870_();
        }
    }

    @Inject(method={"onHit"}, at={@At(value="HEAD")})
    private void hit(HitResult hitResult, CallbackInfo ci) {
        FrostmintSpearEntity frostmintSpear = (FrostmintSpearEntity)this;
        BlockPos blockPos = new BlockPos(frostmintSpear.m_146903_(), frostmintSpear.m_146904_() - 1, frostmintSpear.m_146907_());
        Level level = this.m_9236_();
        if (!this.exploded && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.AMPLIFIED_FROSTMINT_ENABLED.get()).booleanValue()) {
            this.solidifyBlock(Blocks.f_49990_, Blocks.f_50126_, level, blockPos);
            this.solidifyBlock(Blocks.f_49991_, Blocks.f_50137_, level, blockPos);
            this.solidifyBlock((Block)ACBlockRegistry.PURPLE_SODA.get(), (Block)ACBlockRegistry.SUGAR_GLASS.get(), level, blockPos);
            this.solidifyBlock((Block)ACBlockRegistry.ACID.get(), (Block)ACBlockRegistry.RADROCK.get(), level, blockPos);
            if (ModList.get().isLoaded("create")) {
                CreateCompat.solidifyCreateLiquid(frostmintSpear, level, blockPos);
            }
            if (ModList.get().isLoaded("biomesoplenty")) {
                this.solidifyBlock(BOPCompat.getBOPBlock(true), BOPCompat.getBOPBlock(false), level, blockPos);
            }
        }
    }

    @Unique
    public void solidifyBlock(Block block, Block output, Level level, BlockPos blockPos) {
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos icePos = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    BlockState blockState = level.m_8055_(icePos);
                    if (!blockState.m_60713_(block) || !level.m_7731_(icePos, output.m_49966_(), 3)) continue;
                    level.m_186460_(icePos, blockState.m_60734_(), 2);
                    this.m_146870_();
                    ACExUtils.awardAdvancement(this.m_19749_(), "frostmint_freeze", "freeze");
                    this.explode();
                }
            }
        }
    }

    private void explode() {
        FrostmintExplosion explosion = new FrostmintExplosion(this.m_9236_(), this.m_19749_(), this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 2.0f, Explosion.BlockInteraction.KEEP, true);
        explosion.explode();
        explosion.finalizeExplosion(true);
    }
}

