/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.mobs;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.MobTarget3DGoal;
import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.TargetsDroppedItems;
import com.github.alexmodguy.alexscaves.server.entity.util.UnderzealotSacrifice;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.compat.CuriosCompat;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExItemTagGenerator;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.server.goals.ACExKnawingGoal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CorrodentEntity.class})
public abstract class ACExCorrodentMixin
extends Monster
implements UnderzealotSacrifice,
TargetsDroppedItems {
    private int sacrificeTime = 0;
    private boolean isBeingSacrificed = false;

    protected ACExCorrodentMixin(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$registerGoals(CallbackInfo ci) {
        CorrodentEntity corrodent = (CorrodentEntity)this;
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get()).booleanValue()) {
            corrodent.f_21346_.m_25352_(2, (Goal)new MobTarget3DGoal((Mob)corrodent, Player.class, false, 10, livingEntity -> {
                Player player;
                return livingEntity instanceof Player && !CuriosCompat.hasLight((LivingEntity)(player = (Player)livingEntity));
            }));
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.KNAWING_ENABLED.get()).booleanValue()) {
            corrodent.f_21346_.m_25352_(1, (Goal)new ACExKnawingGoal(corrodent, false));
        }
    }

    public void triggerSacrificeIn(int time) {
        this.isBeingSacrificed = true;
        this.sacrificeTime = time;
    }

    public boolean isValidSacrifice(int distanceFromGround) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.CORRODENT_CONVERSION_ENABLED.get() != false && !this.m_21523_();
    }

    public boolean m_6573_(Player pPlayer) {
        return super.m_6573_(pPlayer) || (Boolean)AlexsCavesExemplified.COMMON_CONFIG.DARK_OFFERING_ENABLED.get() != false && !this.m_20159_();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void alexsCavesExemplified$tick(CallbackInfo ci) {
        if (this.isBeingSacrificed && this.m_20159_() && !this.m_9236_().f_46443_ && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.CORRODENT_CONVERSION_ENABLED.get()).booleanValue()) {
            --this.sacrificeTime;
            if (this.sacrificeTime < 10) {
                this.m_9236_().m_7605_((Entity)this, (byte)61);
            }
            if (this.sacrificeTime < 0) {
                Entity entity;
                if (this.m_20159_() && (entity = this.m_20202_()) instanceof UnderzealotEntity) {
                    UnderzealotEntity underzealot = (UnderzealotEntity)entity;
                    underzealot.postSacrifice((UnderzealotSacrifice)this);
                    underzealot.triggerIdleDigging();
                }
                this.m_8127_();
                UnderzealotEntity underzealot1 = (UnderzealotEntity)this.m_21406_((EntityType)ACEntityRegistry.UNDERZEALOT.get(), true);
                if (underzealot1 != null) {
                    this.m_5496_((SoundEvent)ACSoundRegistry.CORRODENT_HURT.get(), 8.0f, 1.0f);
                    ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)underzealot1);
                    underzealot1.triggerIdleDigging();
                    underzealot1.m_8127_();
                }
            }
        }
        LivingEntity target = this.m_5448_();
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get()).booleanValue() && target != null && target != this.m_21188_() && CuriosCompat.hasLight(target)) {
            this.m_6710_(null);
            ACExUtils.awardAdvancement((Entity)target, "light_repel", "repelled");
        }
    }

    @WrapWithCondition(method={"registerGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/world/entity/ai/goal/Goal;)V", ordinal=8)})
    private boolean alexsCavesExemplified$nearestAttack(GoalSelector instance, int pPriority, Goal pGoal) {
        return (Boolean)AlexsCavesExemplified.COMMON_CONFIG.FORLORN_LIGHT_EFFECT_ENABLED.get() == false;
    }

    public boolean canTargetItem(ItemStack itemStack) {
        return itemStack.m_41614_() || itemStack.m_204117_(ACExItemTagGenerator.KNAWING);
    }

    public void onGetItem(ItemEntity itemEntity) {
        Item item = itemEntity.m_32055_().m_41720_();
        if (item.m_41472_()) {
            this.m_5634_(5.0f);
            List test = Objects.requireNonNull(itemEntity.m_32055_().getFoodProperties((LivingEntity)this)).m_38749_();
            if (!test.isEmpty()) {
                for (int i = 0; i < test.size(); ++i) {
                    this.m_7292_(new MobEffectInstance((MobEffectInstance)((Pair)test.get(i)).getFirst()));
                }
            }
            itemEntity.m_32055_().m_41774_(1);
        } else {
            itemEntity.m_32055_().m_41774_(1);
            this.m_5634_(1.0f);
        }
    }
}

