/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.misc;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MagneticWeaponEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.MagnetronPartEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.TeletorEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.GalenaGauntletItem;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.client.particle.ACExParticleRegistry;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.MagnetronMagneticism;
import org.crimsoncrips.alexscavesexemplified.server.enchantment.ACExEnchants;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GalenaGauntletItem.class})
public abstract class ACExGauntletItemMixin
extends Item {
    public ACExGauntletItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @ModifyExpressionValue(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/tags/TagKey;)Z")})
    private boolean alexsCavesExemplified$use(boolean original, @Local Player player, @Local InteractionHand interactionHand) {
        MagneticWeaponEntity magneticWeaponEntity;
        ItemEntity item;
        ItemStack itemstack = player.m_21120_(interactionHand);
        Entity entityLook = ACExUtils.getLookingAtEntity(player);
        return original || (entityLook instanceof ItemEntity && this.grabableItems((item = (ItemEntity)entityLook).m_32055_(), itemstack) || entityLook instanceof MagnetronEntity || entityLook instanceof MagnetronPartEntity || entityLook instanceof MagneticWeaponEntity && (magneticWeaponEntity = (MagneticWeaponEntity)entityLook).getController() instanceof TeletorEntity) && (Boolean)AlexsCavesExemplified.COMMON_CONFIG.MAGNETICISM_ENABLED.get() != false && itemstack.getEnchantmentLevel((Enchantment)ACExEnchants.MAGNETICISM.get()) > 0;
    }

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;)I")})
    private void alexsCavesExemplified$onUseTick(Level level, LivingEntity living, ItemStack stack, int timeUsing, CallbackInfo ci, @Local(ordinal=1) ItemStack otherStack, @Local boolean otherMagneticWeaponsInUse) {
        Object player;
        Entity entityLook = null;
        if (living instanceof Player) {
            player = (Player)living;
            entityLook = ACExUtils.getLookingAtEntity((Player)player);
        }
        for (MagneticWeaponEntity magneticWeapon : level.m_45976_(MagneticWeaponEntity.class, living.m_20191_().m_82400_(16.0))) {
            Entity controller = magneticWeapon.getController();
            if (controller == null || !controller.m_7306_((Entity)living)) continue;
            otherMagneticWeaponsInUse = true;
            break;
        }
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.MAGNETICISM_ENABLED.get()).booleanValue() && living instanceof Player) {
            player = (Player)living;
            if (!otherMagneticWeaponsInUse && stack.getEnchantmentLevel((Enchantment)ACExEnchants.MAGNETICISM.get()) > 0 && !this.grabableItems(otherStack, stack)) {
                ItemEntity item;
                MagneticWeaponEntity magneticWeaponEntity;
                Entity entity;
                if (entityLook instanceof MagneticWeaponEntity && (entity = (magneticWeaponEntity = (MagneticWeaponEntity)entityLook).getController()) instanceof TeletorEntity) {
                    TeletorEntity teletor = (TeletorEntity)entity;
                    magneticWeaponEntity.setControllerUUID(player.m_20148_());
                    teletor.setWeaponUUID(null);
                    ItemStack itemStack = magneticWeaponEntity.getItemStack();
                    if (itemStack.m_41763_()) {
                        itemStack.m_41721_(itemStack.m_41776_() - teletor.m_217043_().m_188503_(1 + teletor.m_217043_().m_188503_(Math.max(itemStack.m_41776_() - 3, 1))));
                    }
                    ACExUtils.awardAdvancement((Entity)player, "galena_steal", "steal");
                } else if (entityLook instanceof ItemEntity && this.grabableItems((item = (ItemEntity)entityLook).m_32055_(), stack)) {
                    ItemStack copy = item.m_32055_().m_41777_();
                    item.m_146870_();
                    MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get()).m_20615_(level);
                    if (magneticWeapon != null) {
                        magneticWeapon.setItemStack(copy);
                        magneticWeapon.m_146884_(item.m_20182_().m_82520_(0.0, 1.0, 0.0));
                        magneticWeapon.setControllerUUID(player.m_20148_());
                        level.m_7967_((Entity)magneticWeapon);
                    }
                } else if (entityLook instanceof MagnetronEntity || entityLook instanceof MagnetronPartEntity) {
                    MagnetronMagneticism accesor;
                    MagnetronEntity magnetronEntity;
                    MagnetronEntity magnetronEntity2 = magnetronEntity = entityLook instanceof MagnetronEntity ? (MagnetronEntity)entityLook : (MagnetronEntity)((MagnetronPartEntity)entityLook).getParent();
                    if (!magnetronEntity.m_6084_()) {
                        return;
                    }
                    Vec3 vec3 = ACExGauntletItemMixin.findTargetPos(player.m_20183_(), (LivingEntity)magnetronEntity);
                    float partialTicks = 1.0f;
                    float yBodyRot = Mth.m_14179_((float)partialTicks, (float)((Player)player).f_20884_, (float)((Player)player).f_20883_);
                    boolean mainHand = player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ACItemRegistry.GALENA_GAUNTLET.get());
                    Vec3 offset = new Vec3((double)(player.m_20205_() * (mainHand ? -0.75f : 0.75f)), (double)(player.m_20206_() * 0.68f), (double)(player.m_20205_() * -0.1f)).m_82524_((float)Math.toRadians(-yBodyRot));
                    Vec3 armViewExtra = player.m_20252_(partialTicks).m_82541_().m_82490_(0.75);
                    Vec3 from = player.m_20318_(partialTicks).m_82549_(offset).m_82549_(armViewExtra);
                    if (!level.f_46443_ && player.m_217043_().m_188500_() < 0.15) {
                        ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ACExParticleRegistry.AZURE_FOCUSED_LIGHTNING.get()), from.f_82479_, from.f_82480_, from.f_82481_, 0, -vec3.f_82479_, -vec3.f_82480_ + 1.0, -vec3.f_82481_, 0.5);
                    }
                    if ((accesor = (MagnetronMagneticism)magnetronEntity).getRippedHeart() <= 100) {
                        accesor.setRippedHeart(accesor.getRippedHeart() + 1);
                        if (!player.m_7500_()) {
                            magnetronEntity.m_6710_((LivingEntity)player);
                        }
                    } else {
                        if (!player.m_7500_()) {
                            stack.m_41622_(80, (LivingEntity)player, livingEntity -> {});
                            player.m_36335_().m_41524_(stack.m_41720_(), 500);
                        }
                        MagneticWeaponEntity magneticWeapon = (MagneticWeaponEntity)((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get()).m_20615_(level);
                        magnetronEntity.captureDrops();
                        magnetronEntity.m_6074_();
                        if (magneticWeapon != null) {
                            magneticWeapon.setItemStack(((Block)ACBlockRegistry.HEART_OF_IRON.get()).m_5456_().m_7968_());
                            magneticWeapon.m_146884_(magnetronEntity.m_20182_().m_82520_(0.0, 1.0, 0.0));
                            magneticWeapon.setControllerUUID(player.m_20148_());
                            level.m_7967_((Entity)magneticWeapon);
                        }
                        player.m_5810_();
                    }
                }
            }
        }
    }

    public boolean grabableItems(ItemStack item, ItemStack gauntlet) {
        boolean crystallization = gauntlet.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.CRYSTALLIZATION.get()) > 0;
        return item.m_204117_(crystallization ? ACTagRegistry.GALENA_GAUNTLET_CRYSTALLIZATION_ITEMS : ACTagRegistry.MAGNETIC_ITEMS);
    }

    @Unique
    private static Vec3 findTargetPos(BlockPos blockPos, LivingEntity livingEntity) {
        Vec3 center = Vec3.m_82512_((Vec3i)blockPos);
        return new Vec3(center.f_82479_ - livingEntity.m_20185_(), center.f_82480_ - livingEntity.m_20186_(), center.f_82481_ - livingEntity.m_20189_());
    }
}

