/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.misc;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.EnigmaticEngineBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.MineGuardianEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.datagen.tags.ACExBlockTagGenerator;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.crimsoncrips.alexscavesexemplified.misc.interfaces.MineGuardianXtra;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EnigmaticEngineBlockEntity.class})
public abstract class ACExEnigmaticEngineMixin
extends BlockEntity {
    public ACExEnigmaticEngineMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lcom/github/alexmodguy/alexscaves/server/block/blockentity/EnigmaticEngineBlockEntity;attemptAssembly()Z")}, remap=false)
    private static void tick(Level level, BlockPos blockPos, BlockState state, EnigmaticEngineBlockEntity entity, CallbackInfo ci) {
        if (((Boolean)AlexsCavesExemplified.COMMON_CONFIG.REMINEDING_ENABLED.get()).booleanValue()) {
            ACExEnigmaticEngineMixin.attemptMineAssembly(entity);
        }
    }

    @Unique
    private static void attemptMineAssembly(EnigmaticEngineBlockEntity entity) {
        Direction assembleIn = null;
        Level level = entity.m_58904_();
        BlockPos blockPos = entity.m_58899_();
        for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
            if (!ACExEnigmaticEngineMixin.assemblingCheck(direction, blockPos, entity)) continue;
            assembleIn = direction;
            break;
        }
        if (assembleIn != null) {
            for (BlockPos pos : BlockPos.m_121976_((int)(blockPos.m_123341_() - 1), (int)(blockPos.m_123342_() - 1), (int)(blockPos.m_123343_() - 1), (int)(blockPos.m_123341_() + 1), (int)(blockPos.m_123342_() + 1), (int)(blockPos.m_123343_() + 1))) {
                if (!level.m_8055_(pos).m_60838_((BlockGetter)level, pos)) continue;
                level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
            Player owner = null;
            Iterator pos = level.m_45976_(Player.class, new AABB(blockPos.m_7918_(-6, -6, -6), blockPos.m_7918_(6, 6, 6))).iterator();
            if (pos.hasNext()) {
                Player player;
                owner = player = (Player)pos.next();
            }
            if (!level.f_46443_) {
                MineGuardianEntity mineGuardian = (MineGuardianEntity)((EntityType)ACEntityRegistry.MINE_GUARDIAN.get()).m_20615_(level);
                Vec3 vec31 = Vec3.m_82512_((Vec3i)blockPos).m_82520_(0.0, -1.0, 0.0);
                mineGuardian.m_146922_(assembleIn.m_122435_());
                mineGuardian.m_6034_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                if (owner != null) {
                    ACExUtils.awardAdvancement((Entity)owner, "mine_ownership", "own");
                    ((MineGuardianXtra)mineGuardian).alexsCavesExemplified$setOwner(owner.m_20148_().toString());
                }
                level.m_7967_((Entity)mineGuardian);
            }
        }
    }

    @Unique
    private static boolean assemblingCheck(Direction direction, BlockPos blockPos, EnigmaticEngineBlockEntity entity) {
        Level level = entity.m_58904_();
        ArrayList<BlockPos> scrap = new ArrayList<BlockPos>();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    BlockPos blockCheck = new BlockPos(blockPos.m_123341_() + x, blockPos.m_123342_() + y, blockPos.m_123343_() + z);
                    if (y == 0) {
                        if (!level.m_8055_(blockCheck).m_204336_(ACExBlockTagGenerator.REMINEDING_MATERIAL)) continue;
                        scrap.add(blockCheck);
                        continue;
                    }
                    if (x == 0 && z == 0 || x + z == 1 || x + z == -1) {
                        if (!level.m_8055_(blockCheck).m_204336_(ACExBlockTagGenerator.REMINEDING_MATERIAL)) continue;
                        scrap.add(blockCheck);
                        continue;
                    }
                    if (!level.m_8055_(blockCheck).m_60838_((BlockGetter)level, blockCheck)) continue;
                    scrap.clear();
                }
            }
        }
        return scrap.size() == 17 && level.m_8055_(blockPos.m_121945_(direction)).m_60713_((Block)ACBlockRegistry.DEPTH_GLASS.get());
    }
}

