/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.mixins.blocks;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.VolcanicCoreBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.TephraEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.AtlatitanEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.ACExReflectionUtil;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;
import org.crimsoncrips.alexscavesexemplified.misc.ACExUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VolcanicCoreBlockEntity.class})
public abstract class ACExVolcanicCoreBlockEntityMixin
extends BlockEntity {
    private static final Predicate<ItemEntity> recharge = item -> item.m_32055_().m_150930_(((Block)ACBlockRegistry.ATLATITAN_EGG.get()).m_5456_());

    public ACExVolcanicCoreBlockEntityMixin(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=false)
    private static void tick(Level level, BlockPos blockPos, BlockState state, VolcanicCoreBlockEntity entity, CallbackInfo ci) {
        int bossCooldown = (Integer)ACExReflectionUtil.getField(entity, "bossSpawnCooldown");
        if (bossCooldown > 0 && ((Boolean)AlexsCavesExemplified.COMMON_CONFIG.VOLCANIC_SACRIFICE_ENABLED.get()).booleanValue()) {
            Vec3 delta;
            Vec3 sub;
            double dist;
            Vec3 vec3 = Vec3.m_82512_((Vec3i)blockPos);
            AABB itemAABB = new AABB(vec3.m_82492_(20.0, 100.0, 20.0), vec3.m_82520_(20.0, 100.0, 20.0));
            double maxDist = 100.0;
            for (ItemEntity item : level.m_6443_(ItemEntity.class, itemAABB, recharge)) {
                dist = Mth.m_14116_((float)((float)item.m_20238_(vec3)));
                if (dist < maxDist) {
                    item.getPersistentData().m_128379_("DraggedProtection", true);
                    item.m_146915_(true);
                    sub = vec3.m_82546_(item.m_20182_()).m_82541_().m_82490_((double)0.2f);
                    delta = item.m_20184_().m_82490_((double)0.8f);
                    item.m_20256_(sub.m_82549_(delta));
                }
                if (!(dist < 1.0)) continue;
                item.m_32055_().m_41774_(1);
                if (!(level.m_213780_().m_188500_() < 1.0)) continue;
                ACExVolcanicCoreBlockEntityMixin.spawnTephra(level, entity);
                ACExReflectionUtil.setField(entity, "bossSpawnCooldown", 0);
                ACExUtils.awardAdvancement(item.m_19749_(), "egg_sacrifice", "egg_sacrifice");
            }
            for (AtlatitanEntity atlatitan : level.m_45976_(AtlatitanEntity.class, new AABB(blockPos.m_7918_(-12, -12, -12), blockPos.m_7918_(12, 32, 12)))) {
                if (!atlatitan.m_6162_()) continue;
                dist = Mth.m_14116_((float)((float)atlatitan.m_20238_(vec3)));
                if (dist < maxDist) {
                    sub = vec3.m_82546_(atlatitan.m_20182_()).m_82541_().m_82490_((double)0.2f);
                    delta = atlatitan.m_20184_().m_82490_(1.0);
                    atlatitan.m_20256_(sub.m_82549_(delta));
                }
                if (!(dist < (double)0.66f)) continue;
                atlatitan.m_6074_();
                if (!(level.m_213780_().m_188500_() < 1.0)) continue;
                ACExVolcanicCoreBlockEntityMixin.spawnTephra(level, entity);
                for (Player player : level.m_45976_(Player.class, atlatitan.m_20191_().m_82400_(40.0))) {
                    ACExUtils.awardAdvancement((Entity)player, "volcanic_sacrifice", "live_sacrifice");
                }
                ACExReflectionUtil.setField(entity, "bossSpawnCooldown", 0);
            }
        }
    }

    private static BlockPos.MutableBlockPos getTopOfVolcano(BlockPos posIn, Level level) {
        BlockPos.MutableBlockPos volcanoTop = new BlockPos.MutableBlockPos();
        volcanoTop.m_122190_((Vec3i)posIn);
        while (level.m_8055_((BlockPos)volcanoTop).m_204336_(ACTagRegistry.VOLCANO_BLOCKS) && volcanoTop.m_123342_() < level.m_151558_()) {
            volcanoTop.m_122184_(0, 1, 0);
        }
        volcanoTop.m_122184_(0, -1, 0);
        return volcanoTop;
    }

    private static void spawnTephra(Level level, VolcanicCoreBlockEntity entity) {
        BlockPos volcanoTop = ACExVolcanicCoreBlockEntityMixin.getTopOfVolcano(entity.m_58899_(), level).m_7949_();
        if (level.m_8055_(volcanoTop).m_60713_((Block)ACBlockRegistry.VOLCANIC_CORE.get()) || level.m_8055_(volcanoTop).m_60713_((Block)ACBlockRegistry.PRIMAL_MAGMA.get()) || level.m_8055_(volcanoTop).m_60713_((Block)ACBlockRegistry.FISSURE_PRIMAL_MAGMA.get()) || level.m_6425_(volcanoTop).m_205070_(FluidTags.f_13132_)) {
            Vec3 targetVec;
            Vec3 volcanoVec = Vec3.m_82514_((Vec3i)volcanoTop, (double)3.0);
            Player nearestPlayer = level.m_45924_(volcanoVec.f_82479_, volcanoVec.f_82480_, volcanoVec.f_82481_, 400.0, true);
            TephraEntity bigTephra = (TephraEntity)((EntityType)ACEntityRegistry.TEPHRA.get()).m_20615_(level);
            bigTephra.m_146884_(volcanoVec);
            bigTephra.setMaxScale(2.0f + level.f_46441_.m_188501_());
            if (nearestPlayer == null) {
                targetVec = new Vec3((double)(level.f_46441_.m_188501_() - 0.5f), 0.0, (double)(level.f_46441_.m_188501_() - 0.5f)).m_82541_().m_82490_((double)(level.f_46441_.m_188503_(50) + 20));
            } else {
                targetVec = nearestPlayer.m_20182_().m_82546_(volcanoVec);
                bigTephra.setArcingTowards(nearestPlayer.m_20148_());
            }
            double d4 = Math.sqrt(targetVec.f_82479_ * targetVec.f_82479_ + targetVec.f_82481_ * targetVec.f_82481_);
            double d5 = nearestPlayer == null ? (double)level.f_46441_.m_188501_() : 0.0;
            bigTephra.m_6686_(targetVec.f_82479_, targetVec.f_82480_ + 0.5 + d4 * 0.75 + d5, targetVec.f_82481_, (float)(d4 * (double)0.1f + d5), 1.0f + level.f_46441_.m_188501_() * 0.5f);
            level.m_7967_((Entity)bigTephra);
            for (int smalls = 0; smalls < 3 + level.f_46441_.m_188503_(3); ++smalls) {
                TephraEntity smallTephra = (TephraEntity)((EntityType)ACEntityRegistry.TEPHRA.get()).m_20615_(level);
                smallTephra.m_146884_(volcanoVec);
                smallTephra.setMaxScale(0.6f + 0.6f * level.f_46441_.m_188501_());
                Vec3 targetVec2 = new Vec3((double)(level.f_46441_.m_188501_() - 0.5f), 0.0, (double)(level.f_46441_.m_188501_() - 0.5f)).m_82541_().m_82490_((double)(level.f_46441_.m_188503_(30) + 30));
                double d42 = Math.sqrt(targetVec2.f_82479_ * targetVec2.f_82479_ + targetVec2.f_82481_ * targetVec2.f_82481_);
                smallTephra.m_6686_(targetVec2.f_82479_, targetVec2.f_82480_ + 0.5 + d42 * 0.75 + (double)level.f_46441_.m_188501_(), targetVec2.f_82481_, (float)(d42 * (double)0.1f + (double)level.f_46441_.m_188501_()), 1.0f);
                level.m_7967_((Entity)smallTephra);
            }
        }
    }
}

