/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.datagen.loottables;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.crimsoncrips.alexscavesexemplified.AlexsCavesExemplified;

public class ACExLootTables {
    private static final Set<ResourceLocation> ACE_LOOT_TABLES = Sets.newHashSet();
    public static final ResourceLocation VESPER_TRADE = ACExLootTables.register("entities/vesper_trade");
    public static final ResourceLocation GLOOMOTH_TRADE = ACExLootTables.register("entities/gloomoth_trade");
    public static final ResourceLocation CORRODENT_TRADE = ACExLootTables.register("entities/corrodent_trade");
    public static final ResourceLocation NUCLEEPER_DEFUSION = ACExLootTables.register("entities/nucleeper_defusion");
    public final ResourceLocation lootTable;

    private ACExLootTables(String path) {
        this.lootTable = AlexsCavesExemplified.prefix(String.format("chests/%s", path));
    }

    private static ResourceLocation register(String id) {
        return ACExLootTables.register(AlexsCavesExemplified.prefix(id));
    }

    private static ResourceLocation register(ResourceLocation id) {
        if (ACE_LOOT_TABLES.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " loot table already registered");
    }

    public static Set<ResourceLocation> allBuiltin() {
        return Collections.unmodifiableSet(ACE_LOOT_TABLES);
    }
}

