/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.client.particle;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.model.MushroomCloudModel;
import com.github.alexmodguy.alexscaves.client.particle.MushroomCloudParticle;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.sound.NuclearExplosionSound;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.crimsoncrips.alexscavesexemplified.client.particle.ACExParticleRegistry;

public class GammaMushroomCloud
extends MushroomCloudParticle {
    private static final ResourceLocation GAMMA = new ResourceLocation("alexscavesexemplified:textures/entity/gamma_mushroom_cloud.png");
    private static final ResourceLocation GAMMA_GLOW = new ResourceLocation("alexscavesexemplified:textures/entity/gamma_mushroom_cloud_glow.png");
    private final float scale;
    private static final MushroomCloudModel MODEL = new MushroomCloudModel();
    private static final int BALL_FOR = 10;
    private static final int FADE_SPEED = 10;
    private boolean playedRinging;
    private boolean playedExplosion;
    private boolean playedRumble;

    protected GammaMushroomCloud(ClientLevel level, double x, double y, double z, float scale, boolean pink) {
        super(level, x, y, z, scale, pink);
        this.scale = scale + 0.2f;
    }

    public void m_5989_() {
        boolean large;
        ClientProxy cfr_ignored_0 = (ClientProxy)AlexsCaves.PROXY;
        ClientProxy.renderNukeSkyDarkFor = 70;
        ClientProxy cfr_ignored_1 = (ClientProxy)AlexsCaves.PROXY;
        ClientProxy.muteNonNukeSoundsFor = 50;
        boolean bl = large = this.scale > 2.0f;
        if (this.f_107224_ > 10 && !this.playedExplosion) {
            this.playedExplosion = true;
            this.playSound(large ? (SoundEvent)ACSoundRegistry.LARGE_NUCLEAR_EXPLOSION.get() : (SoundEvent)ACSoundRegistry.NUCLEAR_EXPLOSION.get(), this.f_107225_ - 20, this.f_107225_, 0.2f, false);
        }
        if (this.f_107224_ < 10) {
            if (!this.playedRinging && ((Boolean)AlexsCaves.CLIENT_CONFIG.nuclearBombFlash.get()).booleanValue()) {
                this.playedRinging = true;
                this.playSound((SoundEvent)ACSoundRegistry.NUCLEAR_EXPLOSION_RINGING.get(), 100, 50, 0.05f, true);
            }
            ClientProxy cfr_ignored_2 = (ClientProxy)AlexsCaves.PROXY;
            ClientProxy.renderNukeFlashFor = 16;
        } else if (this.f_107224_ < this.f_107225_ - 10) {
            float life = (float)Math.log(1.0f + (float)(this.f_107224_ - 10) / (float)(this.f_107225_ - 10)) * 2.0f;
            float explosionSpread = (12.0f * life + 4.0f) * this.scale;
            int i = 0;
            while ((float)i < (float)(1 + this.f_107223_.m_188503_(2)) * this.scale) {
                Vec3 from = new Vec3((double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f)).m_82490_((double)(this.scale * 1.4f)).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                Vec3 away = new Vec3((double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f), (double)(this.f_107208_.f_46441_.m_188501_() - 0.5f)).m_82490_((double)2.34f);
                this.f_107208_.m_7106_((ParticleOptions)ACExParticleRegistry.TREMORZILLA_GAMMA_EXPLOSION.get(), from.f_82479_, from.f_82480_, from.f_82481_, away.f_82479_, away.f_82480_, away.f_82481_);
                ++i;
            }
            int j = 0;
            while ((float)j < this.scale * this.scale) {
                Vec3 explosionBase = new Vec3((double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * explosionSpread), (double)((-0.6f + this.f_107208_.f_46441_.m_188501_() * 0.5f) * explosionSpread * 0.1f), (double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * explosionSpread)).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                this.f_107208_.m_7106_((ParticleOptions)ACExParticleRegistry.TREMORZILLA_GAMMA_EXPLOSION.get(), explosionBase.f_82479_, explosionBase.f_82480_, explosionBase.f_82481_, 0.0, 0.0, 0.0);
                ++j;
            }
            if (this.f_107224_ > 10 && !this.playedRumble) {
                this.playedRumble = true;
                this.playSound((SoundEvent)ACSoundRegistry.NUCLEAR_EXPLOSION_RUMBLE.get(), this.f_107225_ + 100, this.f_107225_, 0.1f, true);
            }
        }
        super.m_5989_();
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_252880_(f, f1 - 0.5f, f2);
        posestack.m_85841_(-this.scale, -this.scale, this.scale);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        MODEL.hideFireball(this.f_107224_ >= 10);
        float life = (float)Math.log(1.0f + ((float)(this.f_107224_ - 10) + partialTick) / (float)(this.f_107225_ - 10)) * 2.0f;
        float glowLife = life < 1.0f ? 1.0f - life : 0.0f;
        int left = this.f_107225_ - this.f_107224_;
        float alpha = left <= 10 ? (float)left / 10.0f : 1.0f;
        MODEL.animateParticle((float)this.f_107224_, ACMath.smin((float)life, (float)1.0f, (float)0.5f), partialTick);
        VertexConsumer baseConsumer = multibuffersource$buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)GAMMA));
        MODEL.m_7695_(posestack, baseConsumer, this.m_6355_(partialTick), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        VertexConsumer glowConsumer1 = multibuffersource$buffersource.m_6299_(ACRenderTypes.getEyesAlphaEnabled((ResourceLocation)GAMMA));
        MODEL.m_7695_(posestack, glowConsumer1, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        VertexConsumer glowConsumer2 = multibuffersource$buffersource.m_6299_(ACRenderTypes.getEyesAlphaEnabled((ResourceLocation)GAMMA_GLOW));
        MODEL.m_7695_(posestack, glowConsumer2, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, glowLife * alpha);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    private void playSound(SoundEvent soundEvent, int duration, int fadesAt, float fadeInBy, boolean looping) {
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new NuclearExplosionSound(soundEvent, this.f_107212_, this.f_107213_, this.f_107214_, duration, fadesAt, fadeInBy, looping));
    }

    public static class GammaNukeFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (xSpeed == 0.0) {
                xSpeed = 1.0;
            }
            return new GammaMushroomCloud(worldIn, x, y, z, (float)Math.max(0.5, xSpeed), ySpeed >= 1.0);
        }
    }
}

