/*
 * Decompiled with CFR 0.152.
 */
package org.crimsoncrips.alexscavesexemplified.client.particle;

import com.github.alexthe666.citadel.client.render.LightningBoltData;
import com.github.alexthe666.citadel.client.render.LightningRender;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

public class FocusedLightningParticle
extends Particle {
    private LightningRender lightningRender = new LightningRender();

    public FocusedLightningParticle(ClientLevel world, double x, double y, double z, double xd, double yd, double zd, boolean blue) {
        super(world, x, y, z);
        this.m_107250_(6.0f, 6.0f);
        this.f_107212_ = x;
        this.f_107213_ = y;
        this.f_107214_ = z;
        Vec3 lightningTo = new Vec3(xd, yd, zd);
        this.f_107225_ = (int)Math.ceil(lightningTo.m_82553_());
        int sections = 4 * this.f_107225_;
        LightningBoltData.BoltRenderInfo boltData = new LightningBoltData.BoltRenderInfo(0.2f, 0.1f, 0.2f, 0.6f, new Vector4f(blue ? 0.1f : 0.8f, 0.1f, blue ? 0.8f : 0.1f, 0.3f), 0.5f);
        LightningBoltData bolt = new LightningBoltData(boltData, Vec3.f_82478_, new Vec3(xd, yd, zd), sections).size(0.3f + this.f_107223_.m_188501_() * 0.2f).fade(LightningBoltData.FadeFunction.fade((float)0.5f)).lifespan(this.f_107225_ + 1).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
        this.lightningRender.update((Object)this, bolt, 1.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    private boolean canSeeBlock(Vec3 from, Vec3 to) {
        BlockHitResult result = this.f_107208_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return Vec3.m_82512_((Vec3i)result.m_82425_()).m_82554_(to) < 3.0;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107216_ -= (double)this.f_107226_;
        }
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTick) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        posestack.m_252880_(x, y, z);
        this.lightningRender.render(partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ScarletFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FocusedLightningParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AzureFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FocusedLightningParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, true);
        }
    }
}

