/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.entity;

import net.mehvahdjukaar.amendments.client.TumblingAnimation;
import net.mehvahdjukaar.amendments.common.ProjectileStats;
import net.mehvahdjukaar.amendments.common.entity.IVisualTransformationProvider;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.entity.ParticleTrailEmitter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class MediumDragonFireball
extends ImprovedProjectileEntity
implements IVisualTransformationProvider {
    private final ParticleTrailEmitter trailEmitter = ProjectileStats.makeDragonTrialEmitter(false);
    private final TumblingAnimation tumblingAnimation = ProjectileStats.makeTumbler();

    public MediumDragonFireball(EntityType<? extends MediumDragonFireball> entityType, Level level) {
        super(entityType, level);
        if (!CommonConfigs.FIRE_CHARGE_GRAVITY.get().booleanValue()) {
            this.m_20242_(true);
        }
    }

    public MediumDragonFireball(Level level, double x, double y, double z) {
        super(ModRegistry.MEDIUM_DRAGON_FIREBALL.get(), x, y, z, level);
        if (!CommonConfigs.FIRE_CHARGE_GRAVITY.get().booleanValue()) {
            this.m_20242_(true);
        }
    }

    public MediumDragonFireball(Level level, LivingEntity shooter) {
        super(ModRegistry.MEDIUM_DRAGON_FIREBALL.get(), shooter, level);
        if (!CommonConfigs.FIRE_CHARGE_GRAVITY.get().booleanValue()) {
            this.m_20242_(true);
        }
    }

    public void spawnTrailParticles() {
        super.spawnTrailParticles();
        this.trailEmitter.tick((Projectile)this, (p, motion) -> {
            if (this.m_20069_()) {
                return;
            }
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, p.f_82479_, p.f_82480_, p.f_82481_, this.f_19796_.m_188583_() * 0.04, this.f_19796_.m_188583_() * 0.04, this.f_19796_.m_188583_() * 0.04);
        });
        if (ClientConfigs.CHARGES_TUMBLE.get().booleanValue()) {
            this.tumblingAnimation.tick(this.f_19796_);
        }
    }

    @Override
    public Matrix4f amendments$getVisualTransformation(float partialTicks) {
        return new Matrix4f().rotate((Quaternionfc)this.tumblingAnimation.getRotation(partialTicks));
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!(result.m_6662_() == HitResult.Type.ENTITY && this.m_150171_(((EntityHitResult)result).m_82443_()) || this.m_9236_().f_46443_)) {
            if (!this.m_20067_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_5496_(SoundEvents.f_11892_, 1.0f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
            }
            this.spawnCloud();
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        entity.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, this.m_19749_()), 2.0f);
    }

    private void spawnCloud() {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            areaEffectCloud.m_19718_((LivingEntity)entity);
        }
        areaEffectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        areaEffectCloud.m_19712_(1.0f);
        areaEffectCloud.m_19734_(40);
        areaEffectCloud.m_19740_(0);
        areaEffectCloud.m_19738_((6.5f - areaEffectCloud.m_19743_()) / (float)areaEffectCloud.m_19748_());
        areaEffectCloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
        this.m_9236_().m_7967_((Entity)areaEffectCloud);
    }

    @Nullable
    public ItemStack m_142340_() {
        return super.m_142340_();
    }

    public boolean m_6087_() {
        return CommonConfigs.DEFLECT_FIRE_CHARGES.get();
    }

    public float m_6143_() {
        return 0.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected Item m_7881_() {
        return ModRegistry.DRAGON_CHARGE.get();
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        Level level = this.m_9236_();
        if (id == 3) {
            for (int x = 0; x < 30; ++x) {
                float f = 0.2f;
                float speed = this.f_19796_.m_188501_() * f;
                float angle = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                double sx = Mth.m_14089_((float)angle) * speed;
                double sy = 0.01 + this.f_19796_.m_188500_() * (double)f * 0.2;
                double sz = Mth.m_14031_((float)angle) * speed;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20185_() + sx * 0.1, this.m_20186_() + 0.3, this.m_20189_() + sz * 0.1, sx, sy, sz);
            }
        }
    }
}

