/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import net.blay09.mods.hardcorerevival.HardcoreRevival;
import net.blay09.mods.hardcorerevival.capability.HardcoreRevivalData;
import net.blay09.mods.hardcorerevival.client.HardcoreRevivalClient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class HardcoreRevivalDataMessage {
    private final int entityId;
    private final boolean knockedOut;
    private final int knockoutTicksPassed;
    private final boolean beingRescued;

    public HardcoreRevivalDataMessage(int entityId, boolean knockedOut, int knockoutTicksPassed, boolean beingRescued) {
        this.entityId = entityId;
        this.knockedOut = knockedOut;
        this.knockoutTicksPassed = knockoutTicksPassed;
        this.beingRescued = beingRescued;
    }

    public static void encode(HardcoreRevivalDataMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.writeBoolean(message.knockedOut);
        buf.writeInt(message.knockoutTicksPassed);
        buf.writeBoolean(message.beingRescued);
    }

    public static HardcoreRevivalDataMessage decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean knockedOut = buf.readBoolean();
        int knockoutTicksPassed = buf.readInt();
        boolean beingRescued = buf.readBoolean();
        return new HardcoreRevivalDataMessage(entityId, knockedOut, knockoutTicksPassed, beingRescued);
    }

    public static void handle(Player player, HardcoreRevivalDataMessage message) {
        Entity entity;
        if (player != null && (entity = player.m_9236_().m_6815_(message.entityId)) != null) {
            HardcoreRevivalData revivalData = entity.m_19879_() == player.m_19879_() ? HardcoreRevival.getClientRevivalData() : HardcoreRevival.getRevivalData(entity);
            revivalData.setKnockedOut(message.knockedOut);
            revivalData.setKnockoutTicksPassed(message.knockoutTicksPassed);
            HardcoreRevivalClient.setBeingRescued(message.beingRescued);
        }
    }
}

