/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.forge.ModBiomeModifiers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public record ConfigurableFeatureModifier(HolderSet<Biome> biomes, Optional<HolderSet<PlacedFeature>> featuresToAdd, Optional<HolderSet<PlacedFeature>> featuresToRemove) implements BiomeModifier
{
    public static final MapCodec<ConfigurableFeatureModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).fieldOf("biomes").forGetter(ConfigurableFeatureModifier::biomes), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256988_).optionalFieldOf("features_to_add").forGetter(ConfigurableFeatureModifier::featuresToAdd), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256988_).optionalFieldOf("features_to_remove").forGetter(ConfigurableFeatureModifier::featuresToRemove)).apply((Applicative)instance, ConfigurableFeatureModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
            this.featuresToAdd.ifPresent(additions -> {
                for (Holder feature : additions) {
                    if (!ModWorldGeneration.shouldFeatureSpawnInBiome((Holder<PlacedFeature>)feature, biome)) continue;
                    builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add(feature);
                }
            });
        }
        if (phase == BiomeModifier.Phase.REMOVE && this.biomes.m_203333_(biome)) {
            this.featuresToRemove.ifPresent(removals -> {
                for (Holder feature : removals) {
                    if (!ModWorldGeneration.shouldFeatureSpawnInBiome((Holder<PlacedFeature>)feature, biome)) continue;
                    builder.getGenerationSettings().getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).remove(feature);
                }
            });
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ModBiomeModifiers.CONFIGURABLE_FEATURE_MODIFIER.get();
    }
}

