/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterStealDiamondGoal
extends Goal {
    private final HamsterEntity hamster;
    private final Level world;
    @Nullable
    private ItemEntity targetItem;
    @Nullable
    private Player owner;
    @Nullable
    private Vec3 pounceStartPos;
    private int bounceSoundDelayTicks;
    private int tauntSettleTicks;
    @Nullable
    private Vec3 repositionTarget;
    private int repositionAttempts;
    private static final int LUNGE_DURATION_TICKS = 5;
    private int lungeTicks;
    private State currentState = State.SCANNING;
    private int stealDurationTimer;

    public HamsterStealDiamondGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        float chance;
        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Evaluating canStart...", (Object)this.hamster.m_19879_());
        if (this.hamster.isStealingDiamond()) {
            if (this.hamster.m_21827_()) {
                return false;
            }
            if (!(this.hamster.m_269323_() instanceof Player)) {
                return false;
            }
            this.owner = (Player)this.hamster.m_269323_();
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart SUCCEEDED: Resuming existing steal.", (Object)this.hamster.m_19879_());
            return true;
        }
        if (!Configs.AHP.enableDiamondStealing) {
            return false;
        }
        if (this.hamster.isStealingDiamond()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster is already in a stealing state.", (Object)this.hamster.m_19879_());
            return false;
        }
        if (this.hamster.m_21827_()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster is sitting.", (Object)this.hamster.m_19879_());
            return false;
        }
        long currentTime = this.world.m_46467_();
        if (this.hamster.stealCooldownEndTick > currentTime) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Steal cooldown is active for another {} ticks.", (Object)this.hamster.m_19879_(), (Object)(this.hamster.stealCooldownEndTick - currentTime));
            return false;
        }
        float randomVal = this.hamster.m_217043_().m_188501_();
        if (randomVal > (chance = ((Float)Configs.AHP.diamondPounceChance.get()).floatValue())) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Pounce chance check failed (Rolled {} > Chance {})", new Object[]{this.hamster.m_19879_(), String.format("%.2f", Float.valueOf(randomVal)), String.format("%.2f", Float.valueOf(chance))});
            return false;
        }
        LivingEntity livingEntity = this.hamster.m_269323_();
        if (!(livingEntity instanceof Player)) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: Hamster has no valid owner.", (Object)this.hamster.m_19879_());
            return false;
        }
        Player playerOwner = (Player)livingEntity;
        this.owner = playerOwner;
        List<Item> stealableItems = Configs.AHP.stealableItems.stream().map(ResourceLocation::m_135820_).filter(Objects::nonNull).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).filter(item -> item != Items.f_41852_).toList();
        if (stealableItems.isEmpty()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart FAILED: No valid stealable items configured or parsed.", (Object)this.hamster.m_19879_());
            return false;
        }
        List nearbyItems = this.world.m_6443_(ItemEntity.class, this.hamster.m_20191_().m_82400_(10.0), itemEntity -> ModItemTags.isStealableItem(itemEntity.m_32055_()) && itemEntity.m_20096_());
        Optional<ItemEntity> closestItem = nearbyItems.stream().filter(item -> this.hamster.m_21573_().m_6570_((Entity)item, 0) != null).min((item1, item2) -> Float.compare(item1.m_20270_((Entity)this.hamster), item2.m_20270_((Entity)this.hamster)));
        if (closestItem.isPresent()) {
            this.targetItem = closestItem.get();
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] canStart SUCCEEDED. Target item: {} at {}. Owner: {}", new Object[]{this.hamster.m_19879_(), this.targetItem.m_32055_().m_41720_(), this.targetItem.m_20183_(), this.owner.m_7755_().getString()});
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.hamster.m_21827_()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Hamster is sitting.", (Object)this.hamster.m_19879_());
            return false;
        }
        if (this.owner == null || !this.owner.m_6084_()) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Owner is null or not alive.", (Object)this.hamster.m_19879_());
            return false;
        }
        if (this.stealDurationTimer <= 0) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Steal duration timer expired.", (Object)this.hamster.m_19879_());
            return false;
        }
        if (this.currentState == State.FLEEING || this.currentState == State.TAUNTING) {
            if (!this.hamster.isStealingDiamond()) {
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Player retrieved diamond (isStealingDiamond is false).", (Object)this.hamster.m_19879_());
                return false;
            }
        } else if (!(this.currentState != State.MOVING_TO_DIAMOND && this.currentState != State.POUNCING || this.targetItem != null && this.targetItem.m_6084_())) {
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] shouldContinue check failed: Target item disappeared before pounce.", (Object)this.hamster.m_19879_());
            return false;
        }
        return true;
    }

    public void m_8056_() {
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        if (this.hamster.isStealingDiamond()) {
            this.stealDurationTimer = this.hamster.getStealDurationTimer();
            this.targetItem = null;
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Resuming steal. Duration left: {} ticks.", (Object)this.hamster.m_19879_(), (Object)this.stealDurationTimer);
            this.currentState = this.hamster.m_20270_((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue() ? State.FLEEING : State.TAUNTING;
        } else {
            this.currentState = State.MOVING_TO_DIAMOND;
            this.hamster.m_21573_().m_5624_((Entity)this.targetItem, 0.75);
            this.stealDurationTimer = this.hamster.m_217043_().m_216332_((Integer)Configs.AHP.minStealDurationSeconds.get() * 20, (Integer)Configs.AHP.maxStealDurationSeconds.get() * 20);
            this.hamster.setStealDurationTimer(this.stealDurationTimer);
            this.repositionTarget = null;
            this.repositionAttempts = 0;
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Goal started fresh. State: MOVING_TO_DIAMOND. Duration: {} ticks.", (Object)this.hamster.m_19879_(), (Object)this.stealDurationTimer);
        }
    }

    public void m_8041_() {
        ItemStack stolenStack;
        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Goal stopped. Final state was: {}.", (Object)this.hamster.m_19879_(), (Object)this.currentState);
        this.hamster.stealCooldownEndTick = this.world.m_46467_() + (long)((Integer)Configs.AHP.stealCooldownTicks.get()).intValue();
        if (this.hamster.isStealingDiamond() && this.stealDurationTimer <= 0 && !(stolenStack = this.hamster.getStolenItemStack()).m_41619_()) {
            this.world.m_7967_((Entity)new ItemEntity(this.world, this.hamster.m_20185_(), this.hamster.m_20186_(), this.hamster.m_20189_(), stolenStack.m_41777_()));
            this.hamster.m_5496_(ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.hamster.m_217043_()), 1.0f, 1.0f);
            SoundEvent pounceSound = ModSounds.getDynamicItemSound(stolenStack);
            float volume = pounceSound == SoundEvents.f_11912_ ? 0.35f : 1.0f;
            this.world.m_5594_(null, this.hamster.m_20183_(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
            AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Dropped stolen item {} because timer expired.", (Object)this.hamster.m_19879_(), (Object)stolenStack.m_41720_());
        }
        this.hamster.setStolenItemStack(ItemStack.f_41583_);
        this.hamster.setStealDurationTimer(0);
        this.hamster.setTaunting(false);
        this.hamster.setStealingDiamond(false);
        this.hamster.m_21573_().m_26573_();
        this.targetItem = null;
        this.owner = null;
        this.currentState = State.SCANNING;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void m_8037_() {
        if (this.stealDurationTimer > 0) {
            --this.stealDurationTimer;
            this.hamster.setStealDurationTimer(this.stealDurationTimer);
        }
        if (this.owner == null) {
            return;
        }
        if (this.bounceSoundDelayTicks > 0) {
            --this.bounceSoundDelayTicks;
            if (this.bounceSoundDelayTicks == 0) {
                this.hamster.m_5496_((SoundEvent)ModSounds.HAMSTER_BOUNCE.get(), 0.6f, this.hamster.m_6100_() * 1.2f);
            }
        }
        --this.stealDurationTimer;
        this.hamster.setStealDurationTimer(this.stealDurationTimer);
        switch (this.currentState) {
            case MOVING_TO_DIAMOND: {
                if (this.targetItem == null) {
                    return;
                }
                this.hamster.m_21563_().m_24960_((Entity)this.targetItem, 25.0f, 25.0f);
                if (this.hamster.m_21573_().m_26571_()) {
                    this.currentState = State.REPOSITIONING;
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Navigator is idle, transitioning to REPOSITIONING.", (Object)this.hamster.m_19879_());
                    return;
                }
                if (!((double)this.hamster.m_20270_((Entity)this.targetItem) < 1.5)) break;
                this.currentState = State.POUNCING;
                this.lungeTicks = 5;
                this.pounceStartPos = this.hamster.m_20182_();
                this.hamster.m_21573_().m_26573_();
                this.hamster.triggerAnimOnServer("mainController", "anim_hamster_diamond_pounce");
                this.bounceSoundDelayTicks = 5;
                SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.hamster.m_217043_());
                if (celebrationSound != null) {
                    this.hamster.m_5496_(celebrationSound, 0.7f, this.hamster.m_6100_());
                }
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed to POUNCING.", (Object)this.hamster.m_19879_());
                break;
            }
            case REPOSITIONING: {
                if (this.targetItem == null) {
                    return;
                }
                if (this.repositionAttempts >= 3) {
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Exceeded max reposition attempts. Stopping goal.", (Object)this.hamster.m_19879_());
                    this.stealDurationTimer = 0;
                    return;
                }
                if (this.repositionTarget == null) {
                    ++this.repositionAttempts;
                    this.repositionTarget = LandRandomPos.m_148492_((PathfinderMob)this.hamster, (int)2, (int)3, (Vec3)Vec3.m_82512_((Vec3i)this.targetItem.m_20183_()));
                    if (this.repositionTarget != null) {
                        this.hamster.m_21573_().m_26519_(this.repositionTarget.f_82479_, this.repositionTarget.f_82480_, this.repositionTarget.f_82481_, 0.75);
                        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Attempt #{}: Found repositioning target at {}. Moving now.", new Object[]{this.hamster.m_19879_(), this.repositionAttempts, this.repositionTarget});
                    } else {
                        AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Could not find a repositioning target. Stopping goal.", (Object)this.hamster.m_19879_());
                        this.stealDurationTimer = 0;
                        return;
                    }
                }
                if (!this.hamster.m_21573_().m_26571_()) break;
                this.repositionTarget = null;
                this.currentState = State.MOVING_TO_DIAMOND;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Repositioning move complete. Transitioning back to MOVING_TO_DIAMOND.", (Object)this.hamster.m_19879_());
                break;
            }
            case POUNCING: {
                if (this.targetItem == null) {
                    return;
                }
                --this.lungeTicks;
                if (this.pounceStartPos != null && this.lungeTicks >= 0) {
                    double progress = (double)(5 - this.lungeTicks) / 5.0;
                    double easedProgress = progress * progress;
                    double newX = this.pounceStartPos.f_82479_ + easedProgress * (this.targetItem.m_20185_() - this.pounceStartPos.f_82479_);
                    double newZ = this.pounceStartPos.f_82481_ + easedProgress * (this.targetItem.m_20189_() - this.pounceStartPos.f_82481_);
                    this.hamster.m_6034_(newX, this.hamster.m_20186_(), newZ);
                }
                if (this.lungeTicks >= 0) break;
                ItemStack stackToSteal = this.targetItem.m_32055_().m_41777_();
                if (stackToSteal.m_41619_()) {
                    this.stealDurationTimer = 0;
                    return;
                }
                this.hamster.setStolenItemStack(stackToSteal);
                this.targetItem.m_146870_();
                this.hamster.setStealingDiamond(true);
                SoundEvent pounceSound = ModSounds.getDynamicItemSound(stackToSteal);
                float volume = pounceSound == SoundEvents.f_11912_ ? 0.35f : 1.0f;
                this.world.m_5594_(null, this.hamster.m_20183_(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                if (!this.world.f_46443_) {
                    ((ServerLevel)this.world).m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.hamster.m_20185_(), this.hamster.m_20186_() + 0.5, this.hamster.m_20189_(), 5, 0.1, 0.1, 0.1, 0.05);
                    ((ServerLevel)this.world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stackToSteal), this.hamster.m_20185_(), this.hamster.m_20186_() + 0.5, this.hamster.m_20189_(), 18, 0.2, 0.2, 0.2, 0.1);
                }
                this.currentState = State.FLEEING;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Pounce finished. Item stolen. State changed to FLEEING.", (Object)this.hamster.m_19879_());
                break;
            }
            case FLEEING: {
                this.hamster.setTaunting(false);
                if (this.hamster.m_20270_((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue()) {
                    Vec3 fleePos = LandRandomPos.m_148521_((PathfinderMob)this.hamster, (int)((Integer)Configs.AHP.maxFleeDistance.get()), (int)7, (Vec3)this.owner.m_20182_());
                    if (fleePos == null) break;
                    this.hamster.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, 1.5);
                    AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] Fleeing: Owner too close, found new flee point at {}.", (Object)this.hamster.m_19879_(), (Object)fleePos);
                    break;
                }
                this.currentState = State.TAUNTING;
                this.hamster.m_21573_().m_26573_();
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed to TAUNTING.", (Object)this.hamster.m_19879_());
                break;
            }
            case TAUNTING: {
                this.hamster.m_21563_().m_24960_((Entity)this.owner, 25.0f, 25.0f);
                if (!this.hamster.isTaunting() && this.tauntSettleTicks == 0) {
                    this.tauntSettleTicks = 5;
                }
                if (this.tauntSettleTicks > 0) {
                    --this.tauntSettleTicks;
                }
                if (this.hamster.m_21573_().m_26571_() && this.tauntSettleTicks == 0) {
                    this.hamster.setTaunting(true);
                }
                if (!(this.hamster.m_20270_((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue())) break;
                this.currentState = State.FLEEING;
                this.hamster.setTaunting(false);
                this.tauntSettleTicks = 0;
                AdorableHamsterPets.LOGGER.trace("[StealGoal-{}] State changed back to FLEEING.", (Object)this.hamster.m_19879_());
            }
        }
    }

    private static enum State {
        SCANNING,
        MOVING_TO_DIAMOND,
        REPOSITIONING,
        POUNCING,
        FLEEING,
        TAUNTING;

    }
}

