/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.block.custom;

import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WildCucumberBushBlock
extends BushBlock {
    public static final BooleanProperty SEEDED = BooleanProperty.m_61465_((String)"seeded");
    private static final VoxelShape SEEDLESS_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SEEDED_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public WildCucumberBushBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SEEDED, (Comparable)Boolean.valueOf(true)));
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.CUCUMBER_SEEDS.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SEEDED) != false ? SEEDED_SHAPE : SEEDLESS_SHAPE;
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)SEEDED) == false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)SEEDED)).booleanValue()) {
            AhpConfig config = AdorableHamsterPets.CONFIG;
            double modifier = (Double)config.wildBushRegrowthModifier.get();
            modifier = Math.max(0.1, modifier);
            int baseRegrowthChanceDenominator = 5;
            int effectiveDenominator = (int)Math.round((double)baseRegrowthChanceDenominator * modifier);
            effectiveDenominator = Math.max(1, effectiveDenominator);
            if (world.m_45524_(pos.m_7494_(), 0) >= 9 && random.m_188503_(effectiveDenominator) == 0) {
                BlockState newState = (BlockState)state.m_61124_((Property)SEEDED, (Comparable)Boolean.valueOf(true));
                world.m_7731_(pos, newState, 2);
                world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)newState));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)SEEDED)).booleanValue()) {
            if (!world.f_46443_) {
                int seedAmount = 1 + world.f_46441_.m_188503_(2);
                WildCucumberBushBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.CUCUMBER_SEEDS.get(), seedAmount));
                world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
                BlockState newState = (BlockState)state.m_61124_((Property)SEEDED, (Comparable)Boolean.valueOf(false));
                world.m_7731_(pos, newState, 2);
                world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)newState));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SEEDED});
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.m_60713_(Blocks.f_50440_) || floor.m_60713_(Blocks.f_50493_) || floor.m_60713_(Blocks.f_50546_) || floor.m_60713_(Blocks.f_50599_) || floor.m_60713_(Blocks.f_50093_);
    }
}

