/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementHudRenderer;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.event.AHPClientScreenEvents;
import net.dawson.adorablehamsterpets.client.gui.widgets.AnnouncementIconAnimator;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.sound.HamsterFlightSoundInstance;
import net.dawson.adorablehamsterpets.client.sound.HamsterThrowSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.HitResult;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;
    private static final AnnouncementHudRenderer announcementHudRenderer = new AnnouncementHudRenderer();
    private static List<AnnouncementManager.PendingNotification> pendingNotifications = Collections.emptyList();
    private static int nextRefreshTicks = 6000;

    public static List<AnnouncementManager.PendingNotification> getPendingNotifications() {
        return pendingNotifications;
    }

    public static void init() {
        RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)ModBlocks.GREEN_BEANS_CROP.get(), (Block)ModBlocks.CUCUMBER_CROP.get(), (Block)ModBlocks.SUNFLOWER_BLOCK.get(), (Block)ModBlocks.WILD_CUCUMBER_BUSH.get(), (Block)ModBlocks.WILD_GREEN_BEAN_BUSH.get()});
        ConfigApiJava.event().onUpdateClient((id, config) -> {
            if (id.equals((Object)ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"main"))) {
                ModItemTags.parseConfig();
                AdorableHamsterPets.LOGGER.info("Reloaded Adorable Hamster Pets item tag config on client following GUI update. *wink wink*");
            }
        });
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.HAMSTER_SPAWN_EGG.get()});
        AHPClientScreenEvents.register();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> AnnouncementManager.INSTANCE.processDeferredReadMarks());
        ClientGuiEvent.RENDER_HUD.register((context, tickDelta) -> announcementHudRenderer.render(context, tickDelta));
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(Minecraft client) {
        boolean isGuiOpen = client.f_91080_ != null;
        AnnouncementIconAnimator.INSTANCE.tick(isGuiOpen);
        if (client.f_91073_ != null) {
            pendingNotifications = AnnouncementManager.INSTANCE.getPendingNotifications();
        }
        if (--nextRefreshTicks <= 0) {
            nextRefreshTicks = 6000;
            AnnouncementManager.INSTANCE.refreshManifest();
            AdorableHamsterPets.LOGGER.debug("[AHP Client Tick] Triggered periodic manifest refresh.");
        }
        if (client.f_91074_ == null || client.f_91073_ == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.m_90859_()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.f_91074_.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean lookingAtReachableBlock = client.f_91077_ != null && client.f_91077_.m_6662_() == HitResult.Type.BLOCK;
                boolean hasShoulderHamsterClient = ((PlayerEntityAccessor)client.f_91074_).hasAnyShoulderHamster();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.ThrowHamsterC2SPacket());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(entityId.intValue());
            buf.writeBoolean(false);
            ModPackets.CHANNEL.sendToServer((Object)new ModPackets.UpdateRenderStateC2SPacket(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
    }

    public static void handleStartFlightSound(int hamsterEntityId) {
        HamsterEntity hamster;
        SoundEvent flightSound;
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        Entity entity = client.f_91073_.m_6815_(hamsterEntityId);
        if (entity instanceof HamsterEntity && (flightSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, (hamster = (HamsterEntity)entity).m_217043_())) != null) {
            client.m_91106_().m_120367_((SoundInstance)new HamsterFlightSoundInstance(flightSound, SoundSource.NEUTRAL, hamster));
        }
    }

    public static void handleStartThrowSound(int hamsterEntityId) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            return;
        }
        Entity entity = client.f_91073_.m_6815_(hamsterEntityId);
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            client.m_91106_().m_120367_((SoundInstance)new HamsterThrowSoundInstance((SoundEvent)ModSounds.HAMSTER_THROW.get(), SoundSource.PLAYERS, hamster));
        }
    }

    private static void handleDismountKeyPress(Minecraft client) {
        long delayMillis;
        long currentTime;
        if (client.f_91074_ == null || client.f_91073_ == null) {
            return;
        }
        boolean hasShoulderHamster = ((PlayerEntityAccessor)client.f_91074_).hasAnyShoulderHamster();
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            KeyMapping vanillaSneak = client.f_91066_.f_92090_;
            KeyMapping customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.m_7249_(false);
                while (vanillaSneak.m_90859_()) {
                }
            }
            if (customDismount != null) {
                customDismount.m_7249_(false);
                while (customDismount.m_90859_()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Mount transition detected -> draining input queues and starting debounce ({} ticks).", (Object)5);
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            if (isWaitingForSecondSneakPress) {
                isWaitingForSecondSneakPress = false;
            }
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        KeyMapping keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.f_91066_.f_92090_;
        boolean wasKeyPressed = keyToListenFor != null && keyToListenFor.m_90859_();
        AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: Listening for '{}'. wasPressed() = {}", (Object)(keyToListenFor != null ? keyToListenFor.m_90860_() : "null-binding"), (Object)wasKeyPressed);
        if (wasKeyPressed) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: SINGLE_PRESS detected. Press type config: {}", config.dismountPressType.get());
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP second press detected. Sending dismount payload.");
                    ModPackets.CHANNEL.sendToServer((Object)new ModPackets.DismountHamsterC2SPacket());
                    isWaitingForSecondSneakPress = false;
                } else {
                    AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP first press detected. Starting timer.");
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            AdorableHamsterPets.LOGGER.trace("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP timed out.");
            isWaitingForSecondSneakPress = false;
        }
    }
}

