/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.sequenced;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import java.util.Collection;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class SequencedRecipe<T extends ProcessingRecipe<?>> {
    private T wrapped;

    public SequencedRecipe(T wrapped) {
        this.wrapped = wrapped;
    }

    public IAssemblyRecipe getAsAssemblyRecipe() {
        return (IAssemblyRecipe)this.wrapped;
    }

    public ProcessingRecipe<?> getRecipe() {
        return this.wrapped;
    }

    public JsonObject toJson() {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).m_7707_();
        JsonObject json = new JsonObject();
        json.addProperty("type", CatnipServices.REGISTRIES.getKeyOrThrow((RecipeSerializer)serializer).toString());
        serializer.write(json, this.wrapped);
        return json;
    }

    public static SequencedRecipe<?> fromJson(JsonObject json, SequencedAssemblyRecipe parent, int index) {
        ResourceLocation parentId = parent.m_6423_();
        Recipe recipe = RecipeManager.fromJson((ResourceLocation)new ResourceLocation(parentId.m_135827_(), parentId.m_135815_() + "_step_" + index), (JsonObject)json, (ICondition.IContext)ICondition.IContext.EMPTY);
        if (recipe instanceof ProcessingRecipe) {
            IAssemblyRecipe assemblyRecipe;
            ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
            if (recipe instanceof IAssemblyRecipe && (assemblyRecipe = (IAssemblyRecipe)recipe).supportsAssembly()) {
                Ingredient transit = Ingredient.m_43927_((ItemStack[])new ItemStack[]{parent.getTransitionalItem()});
                processingRecipe.m_7527_().set(0, (Object)(index == 0 ? Ingredient.merge((Collection)ImmutableList.of((Object)transit, (Object)parent.getIngredient())) : transit));
                SequencedRecipe<ProcessingRecipe> sequencedRecipe = new SequencedRecipe<ProcessingRecipe>(processingRecipe);
                return sequencedRecipe;
            }
        }
        throw new JsonParseException("Not a supported recipe type");
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).m_7707_();
        buffer.m_130085_(CatnipServices.REGISTRIES.getKeyOrThrow((RecipeSerializer)serializer));
        buffer.m_130085_(((ProcessingRecipe)this.wrapped).m_6423_());
        serializer.toNetwork(buffer, this.wrapped);
    }

    public static SequencedRecipe<?> readFromBuffer(FriendlyByteBuf buffer) {
        ResourceLocation resourcelocation = buffer.m_130281_();
        ResourceLocation resourcelocation1 = buffer.m_130281_();
        RecipeSerializer serializer = (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(resourcelocation);
        if (!(serializer instanceof ProcessingRecipeSerializer)) {
            throw new JsonParseException("Not a supported recipe type");
        }
        ProcessingRecipe recipe = (ProcessingRecipe)serializer.m_8005_(resourcelocation1, buffer);
        return new SequencedRecipe<ProcessingRecipe>(recipe);
    }
}

