/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.drill;

import com.simibubi.create.content.kinetics.base.BlockBreakingKineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.drill.CobbleGenOptimisation;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DrillBlockEntity
extends BlockBreakingKineticBlockEntity {
    private CobbleGenOptimisation.CobbleGenBlockConfiguration currentConfig;
    private BlockState currentOutput = Blocks.f_50016_.m_49966_();

    public DrillBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected BlockPos getBreakingPos() {
        return this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)DrillBlock.FACING));
    }

    @Override
    public void onBlockBroken(BlockState stateToBreak) {
        if (!this.optimiseCobbleGen(stateToBreak)) {
            super.onBlockBroken(stateToBreak);
        }
    }

    public boolean optimiseCobbleGen(BlockState stateToBreak) {
        ChuteBlockEntity chute;
        ChuteBlockEntity chute2;
        DirectBeltInputBehaviour inv = BlockEntityBehaviour.get((BlockGetter)this.f_58857_, this.breakingPos.m_7495_(), DirectBeltInputBehaviour.TYPE);
        BlockEntity blockEntityBelow = this.f_58857_.m_7702_(this.breakingPos.m_7495_());
        BlockEntity blockEntityAbove = this.f_58857_.m_7702_(this.breakingPos.m_7494_());
        if (!(inv != null || blockEntityBelow instanceof HopperBlockEntity || blockEntityAbove instanceof ChuteBlockEntity && (chute2 = (ChuteBlockEntity)blockEntityAbove).getItemMotion() > 0.0f)) {
            return false;
        }
        CobbleGenOptimisation.CobbleGenBlockConfiguration config = CobbleGenOptimisation.getConfig((LevelAccessor)this.f_58857_, this.f_58858_, (Direction)this.m_58900_().m_61143_((Property)DrillBlock.FACING));
        if (config == null) {
            return false;
        }
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sl = (ServerLevel)level;
        BlockPos breakingPos = this.getBreakingPos();
        if (!config.equals(this.currentConfig)) {
            this.currentConfig = config;
            this.currentOutput = CobbleGenOptimisation.determineOutput(sl, breakingPos, config);
        }
        if (this.currentOutput.m_60795_() || !this.currentOutput.equals(stateToBreak)) {
            return false;
        }
        if (inv != null) {
            for (ItemStack stack : Block.m_49869_((BlockState)stateToBreak, (ServerLevel)sl, (BlockPos)breakingPos, null)) {
                inv.handleInsertion(stack, Direction.UP, false);
            }
        } else if (blockEntityBelow instanceof HopperBlockEntity) {
            HopperBlockEntity hbe = (HopperBlockEntity)blockEntityBelow;
            IItemHandler handler = (IItemHandler)hbe.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
            if (handler != null) {
                for (ItemStack stack : Block.m_49869_((BlockState)stateToBreak, (ServerLevel)sl, (BlockPos)breakingPos, null)) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                }
            }
        } else if (blockEntityAbove instanceof ChuteBlockEntity && (chute = (ChuteBlockEntity)blockEntityAbove).getItemMotion() > 0.0f) {
            for (ItemStack stack : Block.m_49869_((BlockState)stateToBreak, (ServerLevel)sl, (BlockPos)breakingPos, null)) {
                if (!chute.getItem().m_41619_()) continue;
                chute.setItem(stack, 0.0f);
            }
        }
        this.f_58857_.m_46796_(2001, breakingPos, Block.m_49956_((BlockState)stateToBreak));
        return true;
    }
}

