/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class ToolboxMountedStorage
extends WrapperMountedItemStorage<ToolboxInventory> {
    public static final Codec<ToolboxMountedStorage> CODEC = ToolboxInventory.CODEC.xmap(ToolboxMountedStorage::new, storage -> (ToolboxInventory)storage.wrapped);

    protected ToolboxMountedStorage(MountedItemStorageType<?> type, ToolboxInventory wrapped) {
        super(type, wrapped);
    }

    protected ToolboxMountedStorage(ToolboxInventory wrapped) {
        this((MountedItemStorageType)AllMountedStorageTypes.TOOLBOX.get(), wrapped);
    }

    @Override
    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof ToolboxBlockEntity) {
            ToolboxBlockEntity toolbox = (ToolboxBlockEntity)be;
            ItemHelper.copyContents((IItemHandler)this, (IItemHandlerModifiable)toolbox.inventory);
        }
    }

    @Override
    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        return false;
    }

    public static ToolboxMountedStorage fromToolbox(ToolboxBlockEntity toolbox) {
        ToolboxInventory copy = new ToolboxInventory(null);
        ItemHelper.copyContents((IItemHandler)toolbox.inventory, (IItemHandlerModifiable)copy);
        copy.filters.clear();
        for (ItemStack stack : toolbox.inventory.filters) {
            copy.filters.add(stack.m_41777_());
        }
        return new ToolboxMountedStorage(copy);
    }

    public static ToolboxMountedStorage fromLegacy(CompoundTag nbt) {
        ToolboxInventory inv = new ToolboxInventory(null);
        inv.deserializeNBT(nbt);
        return new ToolboxMountedStorage(inv);
    }
}

