/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public enum AllKeys {
    TOOL_MENU("toolmenu", 342, "Focus Schematic Overlay"),
    ACTIVATE_TOOL(341),
    TOOLBELT("toolbelt", 342, "Access Nearby Toolboxes"),
    ROTATE_MENU("rotate_menu", -1, "Open Block Rotation Menu");

    private KeyMapping keybind;
    private final String description;
    private final String translation;
    private final int key;
    private final boolean modifiable;

    private AllKeys(int defaultKey) {
        this("", defaultKey, "");
    }

    private AllKeys(String description, int defaultKey, String translation) {
        this.description = "create.keyinfo." + description;
        this.key = defaultKey;
        this.modifiable = !description.isEmpty();
        this.translation = translation;
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (AllKeys key : AllKeys.values()) {
            if (!key.modifiable) continue;
            consumer.accept(key.description, key.translation);
        }
    }

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (AllKeys key : AllKeys.values()) {
            key.keybind = new KeyMapping(key.description, key.key, "Create");
            if (!key.modifiable) continue;
            event.register(key.keybind);
        }
    }

    public KeyMapping getKeybind() {
        return this.keybind;
    }

    public boolean isPressed() {
        if (!this.modifiable) {
            return AllKeys.isKeyDown(this.key);
        }
        return this.keybind.m_90857_();
    }

    public String getBoundKey() {
        return this.keybind.m_90863_().getString().toUpperCase();
    }

    public boolean doesModifierAndCodeMatch(int code) {
        boolean codeMatches = code == this.keybind.getKey().m_84873_();
        KeyModifier modifier = this.keybind.getKeyModifier();
        boolean modifierMatches = modifier == KeyModifier.NONE ? true : modifier.equals((Object)KeyModifier.getActiveModifier());
        return codeMatches && modifierMatches;
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key);
    }

    public static boolean isMouseButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)button) == 1;
    }

    public static boolean ctrlDown() {
        return Screen.m_96637_();
    }

    public static boolean shiftDown() {
        return Screen.m_96638_();
    }

    public static boolean altDown() {
        return Screen.m_96639_();
    }
}

