/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource;

import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceSource {
    protected ResourceSourceType sourceType;
    protected String resourceSourceWithoutPrefix;
    protected boolean isDotMinecraftSource = false;

    @NotNull
    public static ResourceSource of(@NotNull String resourceSource, @Nullable ResourceSourceType sourceType) {
        Objects.requireNonNull(resourceSource);
        resourceSource = resourceSource.trim();
        ResourceSource source = new ResourceSource();
        source.resourceSourceWithoutPrefix = ResourceSourceType.getWithoutSourcePrefix(resourceSource);
        String dotMcSourcePath = DotMinecraftUtils.convertToShortenedDotMinecraftPath(source.resourceSourceWithoutPrefix);
        boolean bl = source.isDotMinecraftSource = dotMcSourcePath != null;
        if (source.isDotMinecraftSource) {
            source.sourceType = ResourceSourceType.LOCAL;
            source.resourceSourceWithoutPrefix = new File(DotMinecraftUtils.resolveMinecraftPath(dotMcSourcePath)).getAbsolutePath().replace("\\", "/");
        } else {
            ResourceSourceType resourceSourceType = source.sourceType = sourceType != null ? sourceType : ResourceSourceType.getSourceTypeOf(resourceSource);
            if (source.sourceType == ResourceSourceType.LOCAL) {
                source.resourceSourceWithoutPrefix = GameDirectoryUtils.getAbsoluteGameDirectoryPath(source.resourceSourceWithoutPrefix);
            }
        }
        return source;
    }

    @NotNull
    public static ResourceSource of(@NotNull String resourceSource) {
        return ResourceSource.of(resourceSource, null);
    }

    protected ResourceSource() {
    }

    @NotNull
    public ResourceSourceType getSourceType() {
        return this.sourceType;
    }

    @NotNull
    public String getSerializationSource() {
        String source = this.resourceSourceWithoutPrefix;
        if (this.isDotMinecraftSource) {
            source = DotMinecraftUtils.convertToShortenedDotMinecraftPath(source);
        } else if (this.sourceType == ResourceSourceType.LOCAL) {
            source = GameDirectoryUtils.getPathWithoutGameDirectory(source);
        }
        return this.sourceType.getSourcePrefix() + source;
    }

    @NotNull
    public String getSourceWithPrefix() {
        return this.sourceType.getSourcePrefix() + this.resourceSourceWithoutPrefix;
    }

    @NotNull
    public String getSourceWithoutPrefix() {
        return this.resourceSourceWithoutPrefix;
    }

    public boolean isDotMinecraftSource() {
        return this.isDotMinecraftSource;
    }

    public String toString() {
        return "ResourceSource{sourceType=" + this.sourceType + ", source='" + this.resourceSourceWithoutPrefix + "'}";
    }
}

