/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.networking.packets.placeholders.nbt;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.placeholders.nbt.ServerNbtDataRequestPacket;
import de.keksuccino.fancymenu.networking.packets.placeholders.nbt.ServerNbtDataResponsePacket;
import java.util.List;
import java.util.Locale;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.CommandStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerSideServerNbtDataRequestPacketLogic {
    private static final Logger LOGGER = LogManager.getLogger();

    protected static boolean handle(@NotNull ServerPlayer sender, @NotNull ServerNbtDataRequestPacket packet) {
        if (packet.placeholder == null || packet.placeholder.isEmpty()) {
            LOGGER.warn("[FANCYMENU] Received malformed server NBT placeholder request without placeholder string.");
            return false;
        }
        String result = "";
        ServerNbtDataResponsePacket.ResultType resultType = ServerNbtDataResponsePacket.ResultType.EMPTY;
        try {
            Tag tag;
            CommandContextData context = ServerSideServerNbtDataRequestPacketLogic.buildContext(sender, packet);
            if (context != null && (tag = ServerSideServerNbtDataRequestPacketLogic.resolveTag(context, packet)) != null) {
                result = ServerSideServerNbtDataRequestPacketLogic.convertResult(tag, packet, context);
                resultType = ServerNbtDataResponsePacket.ResultType.SUCCESS;
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to resolve server-side NBT placeholder.", (Throwable)ex);
        }
        PacketHandler.sendToClient(sender, new ServerNbtDataResponsePacket(packet.placeholder, result, resultType));
        return true;
    }

    @Nullable
    private static CommandContextData buildContext(@NotNull ServerPlayer sender, @NotNull ServerNbtDataRequestPacket packet) throws CommandSyntaxException {
        String sourceType;
        if (packet.source_type == null) {
            return null;
        }
        return switch (sourceType = packet.source_type.toLowerCase(Locale.ROOT)) {
            case "entity" -> ServerSideServerNbtDataRequestPacketLogic.resolveEntity(sender, packet.entity_selector);
            case "block" -> ServerSideServerNbtDataRequestPacketLogic.resolveBlock(sender, packet.block_pos);
            case "storage" -> ServerSideServerNbtDataRequestPacketLogic.resolveStorage(sender, packet.storage_id);
            default -> null;
        };
    }

    @Nullable
    private static CommandContextData resolveEntity(@NotNull ServerPlayer sender, @Nullable String selectorString) throws CommandSyntaxException {
        if (selectorString == null || selectorString.isEmpty()) {
            return null;
        }
        EntitySelectorParser parser = new EntitySelectorParser(new StringReader(selectorString), true);
        EntitySelector selector = parser.m_121377_();
        CommandSourceStack source = sender.m_20203_();
        CompoundTag tag = NbtPredicate.m_57485_((Entity)selector.m_121139_(source));
        return new CommandContextData((Tag)tag, source);
    }

    @Nullable
    private static CommandContextData resolveBlock(@NotNull ServerPlayer sender, @Nullable String positionString) throws CommandSyntaxException {
        if (positionString == null || positionString.isEmpty()) {
            return null;
        }
        ServerLevel level = sender.m_284548_();
        CommandSourceStack source = sender.m_20203_();
        Coordinates coordinates = BlockPosArgument.m_118239_().parse(new StringReader(positionString));
        BlockPos pos = coordinates.m_119568_(source);
        if (!level.m_46805_(pos) || !level.m_46739_(pos)) {
            return null;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be == null) {
            return null;
        }
        CompoundTag tag = be.m_187480_();
        return new CommandContextData((Tag)tag, source);
    }

    @Nullable
    private static CommandContextData resolveStorage(@NotNull ServerPlayer sender, @Nullable String storageId) {
        if (storageId == null || storageId.isEmpty()) {
            return null;
        }
        try {
            ResourceLocation id = ResourceLocation.m_135820_((String)storageId);
            if (id == null) {
                return null;
            }
            CommandSourceStack source = sender.m_20203_();
            CommandStorage storage = sender.m_20194_().m_129897_();
            CompoundTag tag = storage.m_78044_(id);
            return new CommandContextData((Tag)tag, source);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to resolve command storage for '{}'.", (Object)storageId, (Object)ex);
            return null;
        }
    }

    @Nullable
    private static Tag resolveTag(@NotNull CommandContextData context, @NotNull ServerNbtDataRequestPacket packet) throws CommandSyntaxException {
        if (context.baseTag() == null) {
            return null;
        }
        if (packet.nbt_path == null || packet.nbt_path.isEmpty()) {
            return context.baseTag();
        }
        NbtPathArgument.NbtPath path = NbtPathArgument.m_99487_().parse(new StringReader(packet.nbt_path));
        List tags = path.m_99638_(context.baseTag());
        if (tags.isEmpty()) {
            return null;
        }
        return (Tag)tags.get(0);
    }

    @NotNull
    private static String convertResult(@NotNull Tag tag, @NotNull ServerNbtDataRequestPacket packet, @NotNull CommandContextData context) throws CommandSyntaxException {
        String returnType = packet.return_type == null ? "value" : packet.return_type.toLowerCase(Locale.ROOT);
        double scale = packet.scale == null ? 1.0 : packet.scale;
        switch (returnType) {
            case "string": {
                return tag.m_7916_();
            }
            case "snbt": {
                return tag.toString();
            }
            case "json": {
                if (tag instanceof CompoundTag) {
                    Component component = NbtUtils.m_178061_((Tag)tag);
                    String json = Component.Serializer.m_130703_((Component)component);
                    if (json.startsWith("\"") && json.endsWith("\"") && json.length() >= 2) {
                        return json.substring(1, json.length() - 1);
                    }
                    return json;
                }
                return tag.toString();
            }
        }
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            return ServerSideServerNbtDataRequestPacketLogic.formatScaledNumeric(numericTag, scale);
        }
        return tag.m_7916_();
    }

    @NotNull
    private static String formatScaledNumeric(@NotNull NumericTag tag, double scale) {
        if (scale != 1.0) {
            return ServerSideServerNbtDataRequestPacketLogic.formatScaled(tag, scale);
        }
        return tag.m_7916_();
    }

    @NotNull
    private static String formatScaled(@NotNull NumericTag tag, double scale) {
        double scaled = tag.m_7061_() * scale;
        if (tag instanceof FloatTag) {
            return Float.toString((float)scaled) + "f";
        }
        if (tag instanceof DoubleTag) {
            return Double.toString(scaled) + "d";
        }
        long rounded = Math.round(scaled);
        if (tag instanceof ByteTag) {
            return Byte.toString((byte)rounded) + "b";
        }
        if (tag instanceof ShortTag) {
            return Short.toString((short)rounded) + "s";
        }
        if (tag instanceof IntTag) {
            return Integer.toString((int)rounded);
        }
        if (tag instanceof LongTag) {
            return Long.toString(rounded) + "L";
        }
        return Long.toString(rounded);
    }

    private record CommandContextData(Tag baseTag, CommandSourceStack source) {
    }
}

