/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import com.mojang.brigadier.StringReader;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtDataGetPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public NbtDataGetPlaceholder() {
        super("nbt_data_get");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String sourceType = dps.values.get("source_type");
        String nbtPath = dps.values.get("nbt_path");
        String scaleStr = dps.values.get("scale");
        String returnType = dps.values.get("return_type");
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return "";
        }
        if (sourceType == null || nbtPath == null) {
            return "";
        }
        if (returnType == null || returnType.isEmpty()) {
            returnType = "value";
        }
        try {
            NbtPathArgument.NbtPath path = new NbtPathArgument().parse(new StringReader(nbtPath));
            CompoundTag sourceData = this.getSourceData(sourceType, dps);
            if (sourceData == null) {
                return "";
            }
            List tags = path.m_99638_((Tag)sourceData);
            if (tags.isEmpty()) {
                return "";
            }
            Tag tag = (Tag)tags.get(0);
            if ("string".equalsIgnoreCase(returnType)) {
                return tag.m_7916_();
            }
            if ("snbt".equalsIgnoreCase(returnType)) {
                return tag.toString();
            }
            if ("json".equalsIgnoreCase(returnType) && tag instanceof CompoundTag) {
                String json = Component.Serializer.m_130703_((Component)NbtUtils.m_178061_((Tag)tag));
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    json = json.substring(1, json.length() - 1);
                }
                return json;
            }
            double scale = 1.0;
            if (scaleStr != null && !scaleStr.isEmpty()) {
                try {
                    scale = Double.parseDouble(scaleStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.getTagValue(tag, scale);
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in nbt_data_get placeholder: " + e.getMessage());
            return "";
        }
    }

    private CompoundTag getSourceData(String sourceType, DeserializedPlaceholderString dps) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        switch (sourceType.toLowerCase()) {
            case "entity": {
                return this.getEntityData(dps);
            }
            case "block": {
                return this.getBlockData(dps);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompoundTag getEntityData(DeserializedPlaceholderString dps) {
        String selector = dps.values.get("entity_selector");
        if (selector == null) {
            return null;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player == null || level == null) {
            return null;
        }
        LocalPlayer targetEntity = null;
        block6 : switch (selector) {
            case "@s": 
            case "@p": {
                targetEntity = player;
                break;
            }
            case "@e": {
                double nearestDist = Double.MAX_VALUE;
                for (Entity entity : level.m_104735_()) {
                    double dist = entity.m_20280_((Entity)player);
                    if (!(dist < nearestDist)) continue;
                    nearestDist = dist;
                    targetEntity = entity;
                }
                break;
            }
            default: {
                try {
                    UUID uuid = UUID.fromString(selector);
                    for (Entity entity : level.m_104735_()) {
                        if (!entity.m_20148_().equals(uuid)) continue;
                        targetEntity = entity;
                    }
                    break;
                }
                catch (IllegalArgumentException e) {
                    for (Entity entity : level.m_104735_()) {
                        if (!entity.m_7755_().getString().equals(selector)) continue;
                        targetEntity = entity;
                        break block6;
                    }
                }
            }
        }
        if (targetEntity == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        targetEntity.m_20240_(tag);
        return tag;
    }

    private CompoundTag getBlockData(DeserializedPlaceholderString dps) {
        String posStr = dps.values.get("block_pos");
        if (posStr == null) {
            return null;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return null;
        }
        try {
            int z;
            int y;
            String[] parts = posStr.trim().split("\\s+");
            if (parts.length != 3) {
                return null;
            }
            int x = Integer.parseInt(parts[0]);
            BlockPos pos = new BlockPos(x, y = Integer.parseInt(parts[1]), z = Integer.parseInt(parts[2]));
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                return blockEntity.m_187482_();
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("[FANCYMENU] Invalid block position: " + posStr);
        }
        return null;
    }

    private String getTagValue(Tag tag, double scale) {
        if (tag instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag;
            if (scale != 1.0) {
                return String.valueOf(Mth.m_14107_((double)(numericTag.m_7061_() * scale)));
            }
            return String.valueOf(Mth.m_14107_((double)numericTag.m_7061_()));
        }
        if (tag instanceof StringTag) {
            return String.valueOf(tag.m_7916_().length());
        }
        if (tag instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)tag;
            return String.valueOf(collectionTag.size());
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return String.valueOf(compoundTag.m_128440_());
        }
        return tag.m_7916_();
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("source_type", "entity_selector", "block_pos", "nbt_path", "scale", "return_type");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.placeholders.nbt_data_get", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.nbt_data_get.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.fancymenu.editor.dynamicvariabletextfield.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source_type", "entity");
        values.put("entity_selector", "@s");
        values.put("block_pos", "");
        values.put("nbt_path", "foodLevel");
        values.put("scale", "1.0");
        values.put("return_type", "value");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

