/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.gui;

import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsAnyElementHoveredRequirement
extends LoadingRequirement {
    private static final Logger LOGGER = LogManager.getLogger();

    public IsAnyElementHoveredRequirement() {
        super("fancymenu_visibility_requirement_is_any_element_hovered");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        ScreenCustomizationLayer handler;
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null && (handler = ScreenCustomizationLayerHandler.getLayerOfScreen(s)) != null) {
            for (AbstractElement e : handler.allElements) {
                int mX = MouseInput.getMouseX();
                int mY = MouseInput.getMouseY();
                int iX = e.getAbsoluteX();
                int iY = e.getAbsoluteY();
                int iW = e.getAbsoluteWidth();
                int iH = e.getAbsoluteHeight();
                if (mX < iX || mX > iX + iW || mY < iY || mY > iY + iH) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.is_any_element_hovered", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_any_element_hovered.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.requirements.categories.gui", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return null;
    }

    @Override
    public String getValuePreset() {
        return null;
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

