/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IsResourcePackEnabledRequirement
extends LoadingRequirement {
    public IsResourcePackEnabledRequirement() {
        super("is_resource_pack_enabled");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value == null) {
            return false;
        }
        String target = value.trim();
        if (target.isEmpty()) {
            return false;
        }
        PackRepository repository = Minecraft.m_91087_().m_91099_();
        for (Pack pack : repository.m_10524_()) {
            String title = pack.m_10429_().getString();
            if (!title.equalsIgnoreCase(target) && !pack.m_10446_().equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.is_resource_pack_enabled", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.requirements.is_resource_pack_enabled.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return null;
    }

    @Override
    public String getValueDisplayName() {
        return I18n.m_118938_((String)"fancymenu.requirements.is_resource_pack_enabled.value_name", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "Programmer Art";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

