/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.video;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.util.file.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VideoElementController {
    public static final File METAS_FILE = new File(FancyMenu.MOD_DIR, "/video_element_controller_metas.json");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, VideoElementMeta> METAS = new HashMap<String, VideoElementMeta>();
    private static boolean initialized = false;

    protected static void read() {
        METAS.clear();
        try {
            METAS_FILE.createNewFile();
            List<String> jsonList = FileUtils.readTextLinesFrom(METAS_FILE);
            StringBuilder json = new StringBuilder();
            jsonList.forEach(json::append);
            if (json.toString().isBlank()) {
                return;
            }
            List metasList = (List)GSON.fromJson(json.toString(), (TypeToken)new TypeToken<List<VideoElementMeta>>(){});
            metasList.forEach(videoElementMeta -> METAS.put(Objects.requireNonNull(videoElementMeta.element_identifier), (VideoElementMeta)videoElementMeta));
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to read Audio element controller metas from file!", (Throwable)ex);
        }
    }

    protected static void write() {
        if (!initialized) {
            VideoElementController.read();
        }
        initialized = true;
        try {
            METAS_FILE.createNewFile();
            ArrayList<VideoElementMeta> metasList = new ArrayList<VideoElementMeta>(METAS.values());
            String json = GSON.toJson(metasList);
            FileUtils.writeTextToFile((File)METAS_FILE, (boolean)false, (String[])new String[]{Objects.requireNonNull(json)});
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to write Video element controller metas to file!", (Throwable)ex);
        }
    }

    public static void syncChanges() {
        if (!initialized) {
            VideoElementController.read();
        }
        initialized = true;
        VideoElementController.write();
    }

    public static boolean hasMetaFor(@NotNull String elementIdentifier) {
        if (!initialized) {
            VideoElementController.read();
        }
        initialized = true;
        return METAS.containsKey(elementIdentifier);
    }

    @Nullable
    public static VideoElementMeta getMeta(@NotNull String elementIdentifier) {
        if (!initialized) {
            VideoElementController.read();
        }
        initialized = true;
        return METAS.get(elementIdentifier);
    }

    public static void putMeta(@NotNull String elementIdentifier, @NotNull VideoElementMeta meta) {
        if (!initialized) {
            VideoElementController.read();
        }
        initialized = true;
        METAS.put(elementIdentifier, meta);
        VideoElementController.syncChanges();
    }

    public static class VideoElementMeta {
        public String element_identifier;
        public float volume;
        public boolean paused;

        public VideoElementMeta(@NotNull String element_identifier, float volume, boolean paused) {
            this.element_identifier = element_identifier;
            this.volume = volume;
            this.paused = paused;
        }
    }
}

