/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGuiBaseScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor DARK_BACKGROUND = DrawableColor.BLACK;
    private static final float BACKGROUND_ALPHA = 0.4f;
    protected final CustomGui gui;
    protected final Screen overrideScreen;
    protected final Screen parentScreen;

    public CustomGuiBaseScreen(@NotNull CustomGui customGui, @Nullable Screen parentScreen, @Nullable Screen overrideScreen) {
        super((Component)Component.m_237119_());
        this.gui = customGui;
        this.overrideScreen = overrideScreen;
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.gui.popupMode) {
            this.resizePopupMenuBackgroundScreen(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
    }

    protected void resizePopupMenuBackgroundScreen(Minecraft minecraft, int width, int height) {
        try {
            if (this.parentScreen != null) {
                Screen current = Minecraft.m_91087_().f_91080_;
                Minecraft.m_91087_().f_91080_ = this.parentScreen;
                this.parentScreen.m_6574_(minecraft, width, height);
                Minecraft.m_91087_().f_91080_ = current;
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to resize popup menu background screen of Custom GUI!", (Throwable)ex);
        }
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    public boolean m_6913_() {
        return this.gui.allowEsc;
    }

    public boolean m_7043_() {
        return this.gui.pauseGame;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this._renderBackground(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
        String title = PlaceholderParser.replacePlaceholders(this.getTitleString());
        MutableComponent titleComp = LocalizationUtils.isLocalizationKey(title) ? Component.m_237115_((String)title) : Component.m_237113_((String)title);
        graphics.m_280653_(this.f_96547_, (Component)titleComp, this.f_96543_ / 2, 8, -1);
    }

    protected void _renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        boolean popupOverlay;
        boolean popup = this.gui.popupMode && this.parentScreen != null;
        boolean bl = popupOverlay = popup && this.gui.popupModeBackgroundOverlay;
        if (popup) {
            this.renderPopupMenuBackgroundScreen(graphics, mouseX, mouseY, partial);
        } else if (Minecraft.m_91087_().f_91073_ == null || !this.gui.worldBackground) {
            this.m_280039_(graphics);
            return;
        }
        if (popupOverlay) {
            this.renderDarkBackgroundOverlay(graphics);
        }
        if (!popup) {
            this.m_280273_(graphics);
        }
    }

    protected void renderDarkBackgroundOverlay(@NotNull GuiGraphics graphics) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, DARK_BACKGROUND.getColorIntWithAlpha(0.4f));
    }

    protected void renderPopupMenuBackgroundScreen(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        RenderingUtils.setTooltipRenderingBlocked(true);
        Screen current = Minecraft.m_91087_().f_91080_;
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = true;
        try {
            Minecraft.m_91087_().f_91080_ = this.parentScreen;
            this.parentScreen.m_280264_(graphics, -500, -500, partial);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render popup menu background screen of Custom GUI!", (Throwable)ex);
        }
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = false;
        Minecraft.m_91087_().f_91080_ = current;
        RenderingUtils.setTooltipRenderingBlocked(false);
    }

    @NotNull
    public String getTitleString() {
        return this.gui.title;
    }

    @NotNull
    public String getIdentifier() {
        return this.gui.identifier;
    }

    @Nullable
    public Screen getOverriddenScreen() {
        return this.overrideScreen;
    }

    @NotNull
    public CustomGui getGuiMetadata() {
        return this.gui;
    }

    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }
}

