/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.ui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionFavoritesManager;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.ActionRegistry;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.ValuePlaceholderHolder;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.FolderExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseIfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.IfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.WhileExecutableBlock;
import de.keksuccino.fancymenu.customization.action.ui.ChooseActionScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.customization.loadingrequirement.ui.ManageRequirementsScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.cursor.CursorHandler;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.theme.UIColorTheme;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.input.MouseInput;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class ActionScriptEditorScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected GenericExecutableBlock executableBlock;
    protected Consumer<GenericExecutableBlock> callback;
    protected ScrollArea scriptEntriesScrollArea = new ScrollArea(0, 0, 0, 0).setAllowScrollWheelSupplier(() -> !this.isUserNavigatingInRightClickContextMenu());
    protected ContextMenu rightClickContextMenu;
    protected float rightClickContextMenuLastOpenX = Float.NaN;
    protected float rightClickContextMenuLastOpenY = Float.NaN;
    @Nullable
    protected Executable contextMenuTargetExecutable = null;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;
    @Nullable
    protected ExecutableEntry renderTickDragHoveredEntry = null;
    @Nullable
    protected ExecutableEntry renderTickDraggedEntry = null;
    private final ExecutableEntry BEFORE_FIRST = new ExecutableEntry(this.scriptEntriesScrollArea, new GenericExecutableBlock(), 1, 0);
    private final ExecutableEntry AFTER_LAST = new ExecutableEntry(this.scriptEntriesScrollArea, new GenericExecutableBlock(), 1, 0);
    @Nullable
    protected Executable pendingSelectionExecutable = null;
    protected boolean pendingSelectionKeepViewAnchor = false;
    protected boolean skipNextContextMenuSelection = false;
    protected boolean contextMenuSelectionOverrideActive = false;
    protected static final int LEFT_MARGIN = 20;
    protected static final int RIGHT_MARGIN = 20;
    protected static final int MINIMAP_WIDTH = 64;
    protected static final int MINIMAP_GAP = 8;
    protected static final int MINIMAP_PADDING = 4;
    protected static final int ACTION_BUTTON_GAP = 5;
    protected static final int MINIMAP_INDENT_STEP = 4;
    protected static final int CHAIN_BAR_WIDTH = 3;
    protected static final int CHAIN_BAR_OFFSET = 2;
    protected static final int INLINE_EDIT_RIGHT_MARGIN = 5;
    protected static final float MINIMAP_TOOLTIP_SCALE = 0.5f;
    protected static final int MINIMAP_TOOLTIP_PADDING = 4;
    protected static final int MINIMAP_TOOLTIP_OFFSET = 12;
    protected static final long VALUE_DOUBLE_CLICK_TIME_MS = 500L;
    protected static final long NAME_DOUBLE_CLICK_TIME_MS = 500L;
    @Nullable
    protected ExecutableEntry hoveredEntry = null;
    @Nullable
    protected ExecutableEntry minimapHoveredEntry = null;
    @Nullable
    protected ExecutableEntry selectedEntry = null;
    @Nullable
    protected ExtendedEditBox inlineValueEditBox = null;
    @Nullable
    protected ExecutableEntry inlineValueEntry = null;
    @Nullable
    protected String inlineValueOriginal = null;
    @Nullable
    protected ExtendedEditBox inlineNameEditBox = null;
    @Nullable
    protected ExecutableEntry inlineNameEntry = null;
    @Nullable
    protected String inlineNameOriginal = null;
    protected List<ExecutableEntry> hoveredStatementChainEntries = Collections.emptyList();
    protected List<ExecutableEntry> hoveredPrimaryChainEntries = Collections.emptyList();
    protected List<ExecutableEntry> minimapHoveredStatementChainEntries = Collections.emptyList();
    protected List<ExecutableEntry> minimapHoveredPrimaryChainEntries = Collections.emptyList();
    protected List<ExecutableEntry> selectedStatementChainEntries = Collections.emptyList();
    protected final List<MinimapEntrySegment> minimapSegments = new ArrayList<MinimapEntrySegment>();
    protected int minimapX = 0;
    protected int minimapY = 0;
    protected int minimapHeight = 0;
    protected int minimapContentX = 0;
    protected int minimapContentY = 0;
    protected int minimapContentWidth = 0;
    protected int minimapContentHeight = 0;
    protected int minimapTotalEntriesHeight = 0;
    @Nullable
    protected ActionInstance clipboardActionInstance = null;
    private static final ResourceLocation ILLEGAL_ACTION_ICON = new ResourceLocation("fancymenu", "textures/not_allowed.png");
    private static final AspectRatio ILLEGAL_ACTION_ICON_RATIO = new AspectRatio(32, 32);
    private static final long ILLEGAL_ACTION_VISIBLE_DURATION_MS = 1500L;
    private static final long ILLEGAL_ACTION_FADE_DURATION_MS = 300L;
    private static final float ILLEGAL_ACTION_MAX_ALPHA = 0.5f;
    protected long illegalActionIndicatorStartTime = -1L;
    private static final int HISTORY_LIMIT = 100;
    private final Deque<ScriptSnapshot> undoHistory = new ArrayDeque<ScriptSnapshot>();
    private final Deque<ScriptSnapshot> redoHistory = new ArrayDeque<ScriptSnapshot>();
    private boolean suppressHistoryCapture = false;
    private boolean actionsMenuRightClickConsumedByEntry = false;

    public ActionScriptEditorScreen(@NotNull GenericExecutableBlock executableBlock, @NotNull Consumer<GenericExecutableBlock> callback) {
        super((Component)Component.m_237115_((String)"fancymenu.actions.screens.manage_screen.manage"));
        this.executableBlock = executableBlock.copy(false);
        this.callback = callback;
        this.updateActionInstanceScrollArea(false);
    }

    protected void m_7856_() {
        this.updateRightClickContextMenu(false, null);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.done"), button -> this.callback.accept(this.executableBlock));
        this.doneButton.setNavigatable(false);
        this.m_7787_((GuiEventListener)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (Component)Component.m_237115_((String)"fancymenu.common_components.cancel"), button -> Minecraft.m_91087_().m_91152_((Screen)ConfirmationScreen.critical(callback -> {
            if (callback.booleanValue()) {
                this.callback.accept(null);
            } else {
                Minecraft.m_91087_().m_91152_((Screen)this);
            }
        }, new Component[]{Component.m_237115_((String)"fancymenu.actions.script_editor.cancel_warning")})));
        this.cancelButton.setNavigatable(false);
        this.m_7787_((GuiEventListener)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.actionsMenuRightClickConsumedByEntry = false;
    }

    public boolean m_6913_() {
        return false;
    }

    public void m_7379_() {
        this.finishInlineNameEditing(true);
        this.finishInlineNameEditing(true);
        this.finishInlineValueEditing(true);
        this.callback.accept(null);
    }

    protected void updateRightClickContextMenu(boolean reopen, @Nullable List<String> entryPath) {
        List<String> currentPath;
        boolean wasOpen = this.rightClickContextMenu != null && this.rightClickContextMenu.isOpen();
        List<String> resolvedEntryPath = null;
        List<String> list = currentPath = wasOpen && this.rightClickContextMenu != null ? this.findOpenContextMenuPath(this.rightClickContextMenu) : null;
        if (currentPath != null) {
            resolvedEntryPath = currentPath;
        } else if (entryPath != null) {
            resolvedEntryPath = new ArrayList<String>(entryPath);
        }
        if (this.rightClickContextMenu != null) {
            this.rightClickContextMenu.closeMenu();
            this.m_169411_(this.rightClickContextMenu);
        }
        this.rightClickContextMenu = new ContextMenu();
        this.m_7787_(this.rightClickContextMenu);
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("edit", (Component)Component.m_237115_((String)"fancymenu.actions.screens.edit_action"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onEdit(target);
        }).addIsActiveSupplier((menu, entry) -> this.canEditEntry(this.getContextMenuTargetEntry()))).setIcon(ContextMenu.IconFactory.getIcon("edit"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_edit");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("delete", (Component)Component.m_237115_((String)"fancymenu.actions.screens.remove_action"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onRemove(target);
        }).addIsActiveSupplier((menu, entry) -> this.getContextMenuTargetEntry() != null)).setShortcutTextSupplier((menu, entry) -> Component.m_237115_((String)"fancymenu.editor.shortcuts.delete"))).setIcon(ContextMenu.IconFactory.getIcon("delete"));
        if (reopen || wasOpen) {
            float reopenX = this.hasStoredRightClickContextMenuPosition() ? this.rightClickContextMenuLastOpenX : (float)MouseInput.getMouseX();
            float reopenY = this.hasStoredRightClickContextMenuPosition() ? this.rightClickContextMenuLastOpenY : (float)MouseInput.getMouseY();
            this.openRightClickContextMenuAt(reopenX, reopenY, resolvedEntryPath);
        }
        this.rightClickContextMenu.addSeparatorEntry("separator_after_remove");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("move_up", (Component)Component.m_237115_((String)"fancymenu.actions.screens.move_action_up"), (menu, contextMenuEntry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            if (target != null) {
                this.handleContextMenuMove(target, true);
            }
        }).addIsActiveSupplier((menu, entry) -> this.getContextMenuTargetEntry() != null)).setTooltipSupplier((menu, entry) -> {
            if (this.getContextMenuTargetEntry() == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.actions.screens.finish.no_action_selected", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.actions.screens.move_action_up.desc", new String[0]));
        })).setShortcutTextSupplier((menu, entry) -> Component.m_237115_((String)"fancymenu.actions.script_editor.shortcuts.shift_arrow_up"))).setIcon(ContextMenu.IconFactory.getIcon("arrow_up"));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("move_down", (Component)Component.m_237115_((String)"fancymenu.actions.screens.move_action_down"), (menu, contextMenuEntry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            if (target != null) {
                this.handleContextMenuMove(target, false);
            }
        }).addIsActiveSupplier((menu, entry) -> this.getContextMenuTargetEntry() != null)).setTooltipSupplier((menu, entry) -> {
            if (this.getContextMenuTargetEntry() == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.actions.screens.finish.no_action_selected", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.actions.screens.move_action_down.desc", new String[0]));
        })).setShortcutTextSupplier((menu, entry) -> Component.m_237115_((String)"fancymenu.actions.script_editor.shortcuts.shift_arrow_down"))).setIcon(ContextMenu.IconFactory.getIcon("arrow_down"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_reorder");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("undo", (Component)Component.m_237115_((String)"fancymenu.editor.edit.undo"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            this.undo();
        }).addIsActiveSupplier((menu, entry) -> this.canUndo())).setShortcutTextSupplier((menu, entry) -> Component.m_237115_((String)"fancymenu.editor.shortcuts.undo"))).setIcon(ContextMenu.IconFactory.getIcon("undo"));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("redo", (Component)Component.m_237115_((String)"fancymenu.editor.edit.redo"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            this.redo();
        }).addIsActiveSupplier((menu, entry) -> this.canRedo())).setShortcutTextSupplier((menu, entry) -> Component.m_237115_((String)"fancymenu.editor.shortcuts.redo"))).setIcon(ContextMenu.IconFactory.getIcon("redo"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_history");
        ContextMenu addActionSubMenu = this.buildAddActionSubMenu(null);
        boolean hasActionEntries = !addActionSubMenu.getEntries().isEmpty();
        ((ContextMenu.SubMenuContextMenuEntry)this.rightClickContextMenu.addSubMenuEntry("add_action", (Component)Component.m_237115_((String)"fancymenu.actions.screens.add_action"), addActionSubMenu).addIsActiveSupplier((menu, entry) -> hasActionEntries)).setIcon(ContextMenu.IconFactory.getIcon("add"));
        this.rightClickContextMenu.addClickableEntry("add_if", (Component)Component.m_237115_((String)"fancymenu.actions.blocks.add.if"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onAddIf(target);
        }).setIcon(ContextMenu.IconFactory.getIcon("add"));
        this.rightClickContextMenu.addClickableEntry("add_while", (Component)Component.m_237115_((String)"fancymenu.actions.blocks.add.while"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onAddWhile(target);
        }).setIcon(ContextMenu.IconFactory.getIcon("add"));
        this.rightClickContextMenu.addClickableEntry("add_folder", (Component)Component.m_237115_((String)"fancymenu.actions.blocks.add.folder"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onAddFolder(target);
        }).setIcon(ContextMenu.IconFactory.getIcon("add"));
        this.rightClickContextMenu.addSeparatorEntry("separator_after_add");
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("append_else_if", (Component)Component.m_237115_((String)"fancymenu.actions.blocks.add.else_if"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onAppendElseIf(target);
        }).addIsActiveSupplier((menu, entry) -> this.canAppendConditionalBlock(this.getContextMenuTargetEntry()))).setIcon(ContextMenu.IconFactory.getIcon("link"));
        ((ContextMenu.ClickableContextMenuEntry)this.rightClickContextMenu.addClickableEntry("append_else", (Component)Component.m_237115_((String)"fancymenu.actions.blocks.add.else"), (menu, entry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry target = this.getContextMenuTargetEntry();
            menu.closeMenu();
            this.onAppendElse(target);
        }).addIsActiveSupplier((menu, entry) -> this.canAppendElseBlock(this.getContextMenuTargetEntry()))).setIcon(ContextMenu.IconFactory.getIcon("link"));
    }

    @NotNull
    protected ContextMenu buildAddActionSubMenu(@Nullable ContextMenu updateContent) {
        LayoutEditorScreen editor = LayoutEditorScreen.getCurrentInstance();
        ContextMenu subMenu = updateContent != null ? updateContent : new ContextMenu(){

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                boolean b = super.m_6375_(mouseX, mouseY, button);
                if (this.isUserNavigatingInMenu() && button == 1) {
                    this.entries.clear();
                    ActionScriptEditorScreen.this.buildAddActionSubMenu(this);
                    return true;
                }
                return b;
            }
        };
        LinkedHashMap<String, Action> availableActions = new LinkedHashMap<String, Action>();
        for (Action action : ActionRegistry.getActions()) {
            if (editor != null && !action.shouldShowUpInEditorActionMenu(editor)) continue;
            availableActions.put(action.getIdentifier(), action);
        }
        ActionFavoritesManager.retainFavorites(new LinkedHashSet<String>(availableActions.keySet()));
        List<String> favoriteIdentifiers = ActionFavoritesManager.getFavorites();
        ArrayList<Action> favoriteActions = new ArrayList<Action>();
        for (String identifier : favoriteIdentifiers) {
            Action action = (Action)availableActions.remove(identifier);
            if (action == null) continue;
            favoriteActions.add(action);
        }
        ArrayList regularActions = new ArrayList(availableActions.values());
        regularActions.sort((left, right) -> {
            String leftName = left.getActionDisplayName().getString();
            String rightName = right.getActionDisplayName().getString();
            return String.CASE_INSENSITIVE_ORDER.compare(leftName, rightName);
        });
        UIColorTheme theme = UIBase.getUIColorTheme();
        MutableComponent openChooserLabel = Component.m_237115_((String)"fancymenu.actions.open_action_chooser").m_6270_(Style.f_131099_.m_178520_(theme.element_label_color_normal.getColorInt()));
        ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)subMenu.addClickableEntry("open_action_chooser", (Component)openChooserLabel, (menu, contextMenuEntry) -> {
            this.markContextMenuActionSelectionSuppressed();
            ExecutableEntry selectionReference = this.getContextMenuTargetEntry();
            this.rightClickContextMenu.closeMenu();
            this.onOpenActionChooser(selectionReference);
        }).setIcon(ContextMenu.IconFactory.getIcon("pick"))).setShortcutTextSupplier((menu, entry) -> Component.m_237115_((String)"fancymenu.actions.script_editor.shortcuts.a"))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.actions.open_action_chooser.desc", new String[0])));
        if (!favoriteActions.isEmpty() || !regularActions.isEmpty()) {
            subMenu.addSeparatorEntry("after_open_action_chooser");
        }
        for (Action action : favoriteActions) {
            subMenu.addEntry(new FavoriteAwareActionEntry(subMenu, action));
        }
        if (!favoriteActions.isEmpty() && !regularActions.isEmpty()) {
            subMenu.addSeparatorEntry("after_favorites");
        }
        for (Action action : regularActions) {
            subMenu.addEntry(new FavoriteAwareActionEntry(subMenu, action));
        }
        return subMenu;
    }

    @NotNull
    protected MutableComponent buildActionMenuLabel(@NotNull Action action) {
        UIColorTheme theme = UIBase.getUIColorTheme();
        MutableComponent label = action.getActionDisplayName().m_6881_().m_6270_(Style.f_131099_.m_178520_(theme.element_label_color_normal.getColorInt()));
        if (action.isDeprecated()) {
            label = label.m_130948_(Style.f_131099_.m_178522_(Boolean.valueOf(true)));
            label = label.m_7220_((Component)Component.m_237113_((String)" ").m_6270_(Style.f_131099_.m_178522_(Boolean.valueOf(false))));
            label = label.m_7220_((Component)Component.m_237115_((String)"fancymenu.actions.deprecated").m_6270_(Style.f_131099_.m_178520_(theme.error_text_color.getColorInt()).m_178522_(Boolean.valueOf(false))));
        }
        return label;
    }

    @Nullable
    protected Tooltip createActionTooltip(@NotNull Action action, boolean isFavorite) {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        Component[] description = action.getActionDescription();
        if (description != null && description.length > 0) {
            Collections.addAll(lines, description);
        }
        UIColorTheme theme = UIBase.getUIColorTheme();
        Style hintStyle = Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()).m_131155_(Boolean.valueOf(true));
        MutableComponent hint = Component.m_237115_((String)(isFavorite ? "fancymenu.actions.favorite.remove" : "fancymenu.actions.favorite.add")).m_6270_(hintStyle);
        if (!lines.isEmpty()) {
            lines.add(Component.m_237119_());
        }
        lines.add(hint);
        return Tooltip.of(lines.toArray(new Component[0]));
    }

    protected void markContextMenuActionSelectionSuppressed() {
        this.skipNextContextMenuSelection = true;
    }

    protected boolean isFavorite(@NotNull Action action) {
        return ActionFavoritesManager.isFavorite(action.getIdentifier());
    }

    protected void toggleFavorite(@NotNull Action action) {
        ActionFavoritesManager.toggleFavorite(action.getIdentifier());
    }

    @Nullable
    protected ExecutableEntry getContextMenuTargetEntry() {
        if (this.contextMenuTargetExecutable == null) {
            return null;
        }
        return this.findEntryForExecutable(this.contextMenuTargetExecutable);
    }

    protected boolean hasStoredRightClickContextMenuPosition() {
        return !Float.isNaN(this.rightClickContextMenuLastOpenX) && !Float.isNaN(this.rightClickContextMenuLastOpenY);
    }

    @Nullable
    protected List<String> findOpenContextMenuPath(@NotNull ContextMenu menu) {
        for (ContextMenu.ContextMenuEntry<?> entry : menu.getEntries()) {
            ContextMenu.SubMenuContextMenuEntry subEntry;
            ContextMenu subMenu;
            if (!(entry instanceof ContextMenu.SubMenuContextMenuEntry) || !(subMenu = (subEntry = (ContextMenu.SubMenuContextMenuEntry)entry).getSubContextMenu()).isOpen()) continue;
            List<String> childPath = this.findOpenContextMenuPath(subMenu);
            ArrayList<String> path = new ArrayList<String>();
            path.add(subEntry.getIdentifier());
            if (childPath != null) {
                path.addAll(childPath);
            }
            return path;
        }
        return null;
    }

    protected void onEdit(@Nullable ExecutableEntry entry) {
        if (!this.canEditEntry(entry)) {
            return;
        }
        if (entry == null) {
            return;
        }
        Executable targetExecutable = entry.executable;
        if (targetExecutable instanceof ActionInstance) {
            ActionInstance instance = (ActionInstance)targetExecutable;
            if (!instance.action.hasValue()) {
                return;
            }
            ChooseActionScreen s = new ChooseActionScreen(instance.copy(false), call -> {
                ExecutableEntry currentEntry;
                if (call != null && (currentEntry = this.findEntryForExecutable(targetExecutable)) != null) {
                    boolean changed;
                    currentEntry.getParentBlock();
                    AbstractExecutableBlock parentBlock = currentEntry.getParentBlock();
                    boolean bl = changed = call.action != instance.action || !Objects.equals(call.value, instance.value);
                    if (changed) {
                        this.createUndoPoint();
                        int index = parentBlock.getExecutables().indexOf(currentEntry.executable);
                        parentBlock.getExecutables().remove(currentEntry.executable);
                        if (index != -1) {
                            parentBlock.getExecutables().add(index, (Executable)call);
                        } else {
                            parentBlock.getExecutables().add((Executable)call);
                        }
                        this.updateActionInstanceScrollArea(false);
                        this.focusEntryForExecutable((Executable)call, true, true);
                    }
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        } else if (targetExecutable instanceof IfExecutableBlock) {
            IfExecutableBlock block = (IfExecutableBlock)targetExecutable;
            ManageRequirementsScreen s = new ManageRequirementsScreen(block.condition.copy(false), container -> {
                Executable patt29169$temp;
                ExecutableEntry currentEntry;
                if (container != null && (currentEntry = this.findEntryForExecutable(block)) != null && (patt29169$temp = currentEntry.executable) instanceof IfExecutableBlock) {
                    IfExecutableBlock currentBlock = (IfExecutableBlock)patt29169$temp;
                    if (!container.equals(currentBlock.condition)) {
                        this.createUndoPoint();
                        currentBlock.condition = container;
                        this.updateActionInstanceScrollArea(true);
                        this.focusEntryForExecutable(currentBlock, true, true);
                    }
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        } else if (targetExecutable instanceof ElseIfExecutableBlock) {
            ElseIfExecutableBlock block = (ElseIfExecutableBlock)targetExecutable;
            ManageRequirementsScreen s = new ManageRequirementsScreen(block.condition.copy(false), container -> {
                Executable patt30159$temp;
                ExecutableEntry currentEntry;
                if (container != null && (currentEntry = this.findEntryForExecutable(block)) != null && (patt30159$temp = currentEntry.executable) instanceof ElseIfExecutableBlock) {
                    ElseIfExecutableBlock currentBlock = (ElseIfExecutableBlock)patt30159$temp;
                    if (!container.equals(currentBlock.condition)) {
                        this.createUndoPoint();
                        currentBlock.condition = container;
                        this.updateActionInstanceScrollArea(true);
                        this.focusEntryForExecutable(currentBlock, true, true);
                    }
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        } else if (targetExecutable instanceof WhileExecutableBlock) {
            WhileExecutableBlock block = (WhileExecutableBlock)targetExecutable;
            ManageRequirementsScreen s = new ManageRequirementsScreen(block.condition.copy(false), container -> {
                Executable patt31152$temp;
                ExecutableEntry currentEntry;
                if (container != null && (currentEntry = this.findEntryForExecutable(block)) != null && (patt31152$temp = currentEntry.executable) instanceof WhileExecutableBlock) {
                    WhileExecutableBlock currentBlock = (WhileExecutableBlock)patt31152$temp;
                    if (!container.equals(currentBlock.condition)) {
                        this.createUndoPoint();
                        currentBlock.condition = container;
                        this.updateActionInstanceScrollArea(true);
                        this.focusEntryForExecutable(currentBlock, true, true);
                    }
                }
                Minecraft.m_91087_().m_91152_((Screen)this);
            });
            Minecraft.m_91087_().m_91152_((Screen)s);
        }
    }

    protected void onOpenActionChooser(@Nullable ExecutableEntry selectionReference) {
        Executable selectionExecutable = selectionReference != null ? selectionReference.executable : null;
        ChooseActionScreen screen = new ChooseActionScreen(null, call -> {
            if (call != null) {
                ExecutableEntry resolvedReference = selectionExecutable != null ? this.findEntryForExecutable(selectionExecutable) : null;
                this.finalizeActionAddition((ActionInstance)call, resolvedReference);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        });
        Minecraft.m_91087_().m_91152_((Screen)screen);
    }

    protected void onAddAction(@NotNull Action action, @Nullable ExecutableEntry selectionReference) {
        ExecutableEntry resolvedReference = selectionReference != null ? this.findEntryForExecutable(selectionReference.executable) : null;
        ActionInstance instance = new ActionInstance(action, action.hasValue() ? action.getValueExample() : null);
        this.finalizeActionAddition(instance, resolvedReference, true);
    }

    protected void finalizeActionAddition(@NotNull ActionInstance instance, @Nullable ExecutableEntry selectionReference) {
        this.finalizeActionAddition(instance, selectionReference, false);
    }

    protected void finalizeActionAddition(@NotNull ActionInstance instance, @Nullable ExecutableEntry selectionReference, boolean preserveViewAnchor) {
        this.finalizeExecutableAddition(instance, selectionReference, preserveViewAnchor);
    }

    protected void finalizeExecutableAddition(@NotNull Executable executable, @Nullable ExecutableEntry selectionReference, boolean preserveViewAnchor) {
        ExecutableEntry previousEntry;
        boolean anchorActive;
        ExecutableEntry previouslySelected;
        this.createUndoPoint();
        Executable previousExecutable = null;
        int previousEntryY = Integer.MIN_VALUE;
        if (preserveViewAnchor && (previouslySelected = this.getSelectedEntry()) != null) {
            previousExecutable = previouslySelected.executable;
            previousEntryY = previouslySelected.getY();
        }
        this.addExecutableRelativeToSelection(executable, selectionReference);
        this.updateActionInstanceScrollArea(false);
        boolean bl = anchorActive = preserveViewAnchor && previousExecutable != null && previousEntryY != Integer.MIN_VALUE;
        if (anchorActive && (previousEntry = this.findEntryForExecutable(previousExecutable)) != null) {
            this.adjustScrollToKeepEntryInPlace(previousEntryY, previousEntry);
        }
        this.focusEntryForExecutable(executable, anchorActive, true);
    }

    protected void onAddFolder(@Nullable ExecutableEntry selectionReference) {
        ExecutableEntry resolvedReference = selectionReference != null ? this.findEntryForExecutable(selectionReference.executable) : null;
        FolderExecutableBlock block = new FolderExecutableBlock();
        this.finalizeExecutableAddition(block, resolvedReference, true);
    }

    protected void onAddIf(@Nullable ExecutableEntry selectionReference) {
        Executable selectionExecutable = selectionReference != null ? selectionReference.executable : null;
        ManageRequirementsScreen s = new ManageRequirementsScreen(new LoadingRequirementContainer(), container -> {
            if (container != null) {
                ExecutableEntry resolvedReference = selectionExecutable != null ? this.findEntryForExecutable(selectionExecutable) : null;
                IfExecutableBlock block = new IfExecutableBlock((LoadingRequirementContainer)container);
                this.finalizeExecutableAddition(block, resolvedReference, true);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    protected void onAddWhile(@Nullable ExecutableEntry selectionReference) {
        Executable selectionExecutable = selectionReference != null ? selectionReference.executable : null;
        ManageRequirementsScreen s = new ManageRequirementsScreen(new LoadingRequirementContainer(), container -> {
            if (container != null) {
                ExecutableEntry resolvedReference = selectionExecutable != null ? this.findEntryForExecutable(selectionExecutable) : null;
                WhileExecutableBlock block = new WhileExecutableBlock((LoadingRequirementContainer)container);
                this.finalizeExecutableAddition(block, resolvedReference, true);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    protected void onAppendElseIf(@Nullable ExecutableEntry targetEntry) {
        if (!this.canAppendConditionalBlock(targetEntry)) {
            return;
        }
        if (targetEntry == null || !(targetEntry.executable instanceof AbstractExecutableBlock)) {
            return;
        }
        Executable targetExecutable = targetEntry.executable;
        ManageRequirementsScreen s = new ManageRequirementsScreen(new LoadingRequirementContainer(), container -> {
            if (container != null) {
                Executable patt37217$temp;
                ExecutableEntry resolvedEntry = this.findEntryForExecutable(targetExecutable);
                if (resolvedEntry == null || !((patt37217$temp = resolvedEntry.executable) instanceof AbstractExecutableBlock)) {
                    Minecraft.m_91087_().m_91152_((Screen)this);
                    return;
                }
                AbstractExecutableBlock resolvedBlock = (AbstractExecutableBlock)patt37217$temp;
                this.createUndoPoint();
                ElseIfExecutableBlock appended = new ElseIfExecutableBlock((LoadingRequirementContainer)container);
                appended.setAppendedBlock(resolvedBlock.getAppendedBlock());
                resolvedBlock.setAppendedBlock(appended);
                this.updateActionInstanceScrollArea(true);
                this.focusEntryForExecutable(appended, true, true);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        });
        Minecraft.m_91087_().m_91152_((Screen)s);
    }

    protected void onAppendElse(@Nullable ExecutableEntry targetEntry) {
        Executable executable;
        if (!this.canAppendElseBlock(targetEntry)) {
            return;
        }
        if (targetEntry == null || !(targetEntry.executable instanceof AbstractExecutableBlock)) {
            return;
        }
        Executable targetExecutable = targetEntry.executable;
        ExecutableEntry resolvedEntry = this.findEntryForExecutable(targetExecutable);
        if (resolvedEntry == null || !((executable = resolvedEntry.executable) instanceof AbstractExecutableBlock)) {
            return;
        }
        AbstractExecutableBlock block = (AbstractExecutableBlock)executable;
        AbstractExecutableBlock appendTarget = this.findAppendElseTarget(block);
        if (appendTarget == null) {
            return;
        }
        ElseExecutableBlock appended = new ElseExecutableBlock();
        this.createUndoPoint();
        appendTarget.setAppendedBlock(appended);
        this.updateActionInstanceScrollArea(true);
        this.focusEntryForExecutable(appended, true, true);
    }

    protected void onRemove(@Nullable ExecutableEntry entry) {
        if (entry == null) {
            return;
        }
        Executable targetExecutable = entry.executable;
        ExecutableEntry currentEntry = this.findEntryForExecutable(targetExecutable);
        if (currentEntry != null) {
            this.createUndoPoint();
            if (currentEntry.appendParent != null) {
                currentEntry.appendParent.setAppendedBlock(null);
            }
            currentEntry.getParentBlock().getExecutables().remove(currentEntry.executable);
            this.updateActionInstanceScrollArea(true);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.renderTickDragHoveredEntry = this.getDragHoveredEntry();
        this.renderTickDraggedEntry = this.getDraggedEntry();
        if (this.renderTickDraggedEntry != null) {
            float scrollOffset = 0.1f * this.scriptEntriesScrollArea.verticalScrollBar.getWheelScrollSpeed();
            if (MouseInput.getMouseY() <= this.scriptEntriesScrollArea.getInnerY()) {
                this.scriptEntriesScrollArea.verticalScrollBar.setScroll(this.scriptEntriesScrollArea.verticalScrollBar.getScroll() - scrollOffset);
            }
            if (MouseInput.getMouseY() >= this.scriptEntriesScrollArea.getInnerY() + this.scriptEntriesScrollArea.getInnerHeight()) {
                this.scriptEntriesScrollArea.verticalScrollBar.setScroll(this.scriptEntriesScrollArea.verticalScrollBar.getScroll() + scrollOffset);
            }
        }
        UIColorTheme theme = UIBase.getUIColorTheme();
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, theme.screen_background_color.getColorInt());
        MutableComponent titleComp = this.f_96539_.m_6881_().m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
        graphics.m_280614_(this.f_96547_, (Component)titleComp, 20, 20, theme.generic_text_base_color.getColorInt(), false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"fancymenu.actions.screens.manage_screen.actions"), 20, 50, theme.generic_text_base_color.getColorInt(), false);
        int scrollAreaWidth = Math.max(120, this.f_96543_ - 20 - 20 - 64 - 8);
        this.scriptEntriesScrollArea.setWidth(scrollAreaWidth, true);
        this.scriptEntriesScrollArea.setHeight(this.f_96544_ - 85, true);
        this.scriptEntriesScrollArea.setX(20, true);
        this.scriptEntriesScrollArea.setY(65, true);
        this.scriptEntriesScrollArea.updateScrollArea();
        this.scriptEntriesScrollArea.updateEntries(null);
        this.processPendingSelection();
        this.minimapX = this.scriptEntriesScrollArea.getXWithBorder() + this.scriptEntriesScrollArea.getWidthWithBorder() + 8;
        this.minimapY = this.scriptEntriesScrollArea.getInnerY() - 1;
        this.minimapHeight = this.scriptEntriesScrollArea.getInnerHeight() + 2;
        this.selectedEntry = this.getSelectedEntry();
        this.selectedStatementChainEntries = this.selectedEntry != null ? this.getStatementChainOf(this.selectedEntry) : Collections.emptyList();
        this.hoveredEntry = this.getScrollAreaHoveredEntry();
        this.hoveredPrimaryChainEntries = this.hoveredEntry != null ? this.getStatementChainOf(this.hoveredEntry) : Collections.emptyList();
        this.hoveredStatementChainEntries = this.hoveredEntry != null ? this.collectChainWithSubChains(this.hoveredEntry) : Collections.emptyList();
        this.rebuildMinimapSegments(mouseX, mouseY);
        int buttonsRightEdge = this.f_96543_ - 20;
        int buttonY = Math.max(20, this.scriptEntriesScrollArea.getYWithBorder() - this.doneButton.m_93694_() - 5);
        this.doneButton.m_252865_(buttonsRightEdge - this.doneButton.m_5711_());
        this.doneButton.m_253211_(buttonY);
        this.cancelButton.m_252865_(Math.max(20, this.doneButton.m_252754_() - 5 - this.cancelButton.m_5711_()));
        this.cancelButton.m_253211_(buttonY);
        this.scriptEntriesScrollArea.render(graphics, mouseX, mouseY, partial);
        this.renderInlineEditors(graphics, mouseX, mouseY, partial);
        this.updateCursor(mouseX, mouseY);
        if (this.renderTickDragHoveredEntry != null) {
            int dY = this.renderTickDragHoveredEntry.getY();
            int dH = this.renderTickDragHoveredEntry.getHeight();
            if (this.renderTickDragHoveredEntry == this.BEFORE_FIRST) {
                dY = this.scriptEntriesScrollArea.getInnerY();
                dH = 1;
            }
            if (this.renderTickDragHoveredEntry == this.AFTER_LAST) {
                dY = this.scriptEntriesScrollArea.getInnerY() + this.scriptEntriesScrollArea.getInnerHeight() - 1;
                dH = 1;
            }
            graphics.m_280509_(this.scriptEntriesScrollArea.getInnerX(), dY + dH - 1, this.scriptEntriesScrollArea.getInnerX() + this.scriptEntriesScrollArea.getInnerWidth(), dY + dH, theme.description_area_text_color.getColorInt());
        }
        this.renderChainMinimap(graphics);
        this.doneButton.m_88315_(graphics, mouseX, mouseY, partial);
        this.cancelButton.m_88315_(graphics, mouseX, mouseY, partial);
        super.m_88315_(graphics, mouseX, mouseY, partial);
        this.renderIllegalActionIndicator(graphics);
        this.renderMinimapEntryTooltip(graphics, mouseX, mouseY);
        this.rightClickContextMenu.m_88315_(graphics, mouseX, mouseY, partial);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    protected void renderInlineEditors(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        if (this.isInlineValueEditing()) {
            if (!this.scriptEntriesScrollArea.getEntries().contains(this.inlineValueEntry)) {
                this.finishInlineValueEditing(false);
            } else {
                this.updateInlineValueEditorBounds();
                if (this.inlineValueEditBox != null) {
                    this.inlineValueEditBox.m_88315_(graphics, mouseX, mouseY, partial);
                }
            }
        }
        if (this.isInlineNameEditing()) {
            if (!this.scriptEntriesScrollArea.getEntries().contains(this.inlineNameEntry)) {
                this.finishInlineNameEditing(false);
            } else {
                this.updateInlineNameEditorBounds();
                if (this.inlineNameEditBox != null) {
                    this.inlineNameEditBox.m_88315_(graphics, mouseX, mouseY, partial);
                }
            }
        }
    }

    protected void renderIllegalActionIndicator(@NotNull GuiGraphics graphics) {
        long totalDuration;
        if (this.illegalActionIndicatorStartTime <= 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - this.illegalActionIndicatorStartTime;
        if (elapsed >= (totalDuration = 1800L)) {
            this.illegalActionIndicatorStartTime = -1L;
            return;
        }
        float alpha = 0.5f;
        if (elapsed > 1500L) {
            long fadeElapsed = elapsed - 1500L;
            float fadeProgress = (float)fadeElapsed / 300.0f;
            alpha = 0.5f * (1.0f - Mth.m_14036_((float)fadeProgress, (float)0.0f, (float)1.0f));
        }
        RenderSystem.enableBlend();
        int targetHeight = Math.max(1, Math.round((float)this.f_96544_ / 3.0f));
        int[] size = ILLEGAL_ACTION_ICON_RATIO.getAspectRatioSizeByMaximumSize(Math.max(1, this.f_96543_), targetHeight);
        int iconWidth = size[0];
        int iconHeight = size[1];
        int iconX = (this.f_96543_ - iconWidth) / 2;
        int iconY = (this.f_96544_ - iconHeight) / 2;
        UIBase.setShaderColor(graphics, UIBase.getUIColorTheme().ui_texture_color, alpha);
        graphics.m_280163_(ILLEGAL_ACTION_ICON, iconX, iconY, 0.0f, 0.0f, iconWidth, iconHeight, iconWidth, iconHeight);
        RenderingUtils.resetShaderColor(graphics);
    }

    protected void showIllegalActionIndicator() {
        this.illegalActionIndicatorStartTime = System.currentTimeMillis();
    }

    protected void renderChainMinimap(@NotNull GuiGraphics graphics) {
        if (this.minimapHeight <= 0) {
            return;
        }
        UIColorTheme theme = UIBase.getUIColorTheme();
        RenderSystem.enableBlend();
        graphics.m_280509_(this.minimapX, this.minimapY, this.minimapX + 64, this.minimapY + this.minimapHeight, theme.actions_minimap_background_color.getColorInt());
        UIBase.renderBorder(graphics, this.minimapX, this.minimapY, this.minimapX + 64, this.minimapY + this.minimapHeight, 1, theme.actions_minimap_border_color, true, true, true, true);
        List<ExecutableEntry> hoverChain = this.getActiveHoveredChain();
        ExecutableEntry activeHoverEntry = this.getActiveHoveredEntry();
        for (MinimapEntrySegment segment : this.minimapSegments) {
            ExecutableEntry entry = segment.entry;
            graphics.m_280509_(segment.x, segment.y, segment.x + segment.width, segment.y + segment.height, this.getMinimapEntryBaseColor(entry).getRGB());
            if (this.selectedEntry == entry) {
                UIBase.renderBorder(graphics, segment.x, segment.y, segment.x + segment.width, segment.y + segment.height, 1, theme.actions_chain_indicator_selected_color, true, true, true, true);
                continue;
            }
            if (activeHoverEntry != entry) continue;
            UIBase.renderBorder(graphics, segment.x, segment.y, segment.x + segment.width, segment.y + segment.height, 1, theme.description_area_text_color, true, true, true, true);
        }
        if (!hoverChain.isEmpty()) {
            this.renderChainMinimapBorder(graphics, hoverChain, theme.actions_chain_indicator_hovered_color.getColorInt());
        }
        this.renderMinimapViewport(graphics, theme);
    }

    protected void renderMinimapEntryTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.minimapHoveredEntry == null) {
            return;
        }
        int entryWidth = this.minimapHoveredEntry.getWidth();
        int entryHeight = this.minimapHoveredEntry.getHeight();
        if (entryWidth <= 0 || entryHeight <= 0) {
            return;
        }
        int scaledWidth = Math.max(1, Math.round((float)entryWidth * 0.5f));
        int scaledHeight = Math.max(1, Math.round((float)entryHeight * 0.5f));
        int tooltipWidth = scaledWidth + 8;
        int tooltipHeight = scaledHeight + 8;
        int tooltipX = mouseX + 12;
        int tooltipY = mouseY + 12;
        if (tooltipX + tooltipWidth > this.f_96543_) {
            tooltipX = Math.max(0, this.f_96543_ - tooltipWidth);
        }
        if (tooltipY + tooltipHeight > this.f_96544_) {
            tooltipY = Math.max(0, this.f_96544_ - tooltipHeight);
        }
        if (tooltipX < 0) {
            tooltipX = 0;
        }
        if (tooltipY < 0) {
            tooltipY = 0;
        }
        UIColorTheme theme = UIBase.getUIColorTheme();
        Color backgroundColor = ActionScriptEditorScreen.withAlpha(theme.screen_background_color.getColor(), 220);
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        RenderSystem.enableBlend();
        graphics.m_280509_(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, backgroundColor.getRGB());
        UIBase.renderBorder(graphics, tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, 1, theme.actions_minimap_tooltip_border_color, true, true, true, true);
        poseStack.m_252880_((float)(tooltipX + 4), (float)(tooltipY + 4), 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        poseStack.m_252880_((float)(-this.minimapHoveredEntry.getX()), (float)(-this.minimapHoveredEntry.getY()), 0.0f);
        this.minimapHoveredEntry.renderThumbnail(graphics);
        poseStack.m_85849_();
    }

    protected void renderChainMinimapBorder(@NotNull GuiGraphics graphics, @NotNull List<ExecutableEntry> chainEntries, int color) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        boolean found = false;
        for (MinimapEntrySegment segment : this.minimapSegments) {
            if (!chainEntries.contains(segment.entry)) continue;
            found = true;
            minX = Math.min(minX, segment.x);
            maxX = Math.max(maxX, segment.x + segment.width);
            minY = Math.min(minY, segment.y);
            maxY = Math.max(maxY, segment.y + segment.height);
        }
        if (!found) {
            return;
        }
        if (maxX <= minX || maxY <= minY) {
            return;
        }
        UIBase.renderBorder(graphics, (float)minX, (float)minY, (float)maxX, (float)maxY, 1.0f, color, true, true, true, true);
    }

    protected void renderMinimapViewport(@NotNull GuiGraphics graphics, @NotNull UIColorTheme theme) {
        int maxViewportBottom;
        int viewportHeight;
        if (this.minimapTotalEntriesHeight <= 0 || this.minimapContentHeight <= 0) {
            return;
        }
        int visibleHeight = this.scriptEntriesScrollArea.getInnerHeight();
        if (this.minimapTotalEntriesHeight <= visibleHeight) {
            return;
        }
        int maxScroll = Math.max(1, this.minimapTotalEntriesHeight - visibleHeight);
        int scrollPixels = Math.round(this.scriptEntriesScrollArea.verticalScrollBar.getScroll() * (float)maxScroll);
        float topRatio = (float)scrollPixels / (float)this.minimapTotalEntriesHeight;
        float heightRatio = (float)visibleHeight / (float)this.minimapTotalEntriesHeight;
        int viewportTop = this.minimapContentY + Math.round(topRatio * (float)this.minimapContentHeight);
        if (viewportTop + (viewportHeight = Math.max(2, Math.round(heightRatio * (float)this.minimapContentHeight))) > (maxViewportBottom = this.minimapContentY + this.minimapContentHeight)) {
            viewportHeight = maxViewportBottom - viewportTop;
        }
        Color viewportBaseColor = theme.actions_minimap_viewport_color.getColor();
        Color viewportColor = ActionScriptEditorScreen.withAlpha(viewportBaseColor, Math.max(0, Math.min(255, viewportBaseColor.getAlpha() / 2)));
        graphics.m_280509_(this.minimapContentX, viewportTop, this.minimapContentX + this.minimapContentWidth, viewportTop + viewportHeight, viewportColor.getRGB());
        UIBase.renderBorder(graphics, this.minimapContentX, viewportTop, this.minimapContentX + this.minimapContentWidth, viewportTop + viewportHeight, 1, theme.actions_minimap_viewport_border_color, true, true, true, true);
    }

    @NotNull
    protected Color getMinimapEntryBaseColor(@NotNull ExecutableEntry entry) {
        UIColorTheme theme = UIBase.getUIColorTheme();
        Color base = entry.executable instanceof IfExecutableBlock ? theme.actions_entry_background_color_if.getColor() : (entry.executable instanceof ElseIfExecutableBlock ? theme.actions_entry_background_color_else_if.getColor() : (entry.executable instanceof ElseExecutableBlock ? theme.actions_entry_background_color_else.getColor() : (entry.executable instanceof WhileExecutableBlock ? theme.actions_entry_background_color_while.getColor() : (entry.executable instanceof FolderExecutableBlock ? theme.actions_entry_background_color_folder.getColor() : (entry.executable instanceof AbstractExecutableBlock ? theme.actions_entry_background_color_generic_block.getColor() : theme.actions_entry_background_color_action.getColor())))));
        return ActionScriptEditorScreen.withAlpha(base, 180);
    }

    protected void rebuildMinimapSegments(int mouseX, int mouseY) {
        this.minimapSegments.clear();
        this.minimapHoveredEntry = null;
        this.minimapHoveredPrimaryChainEntries = Collections.emptyList();
        this.minimapHoveredStatementChainEntries = Collections.emptyList();
        this.minimapContentX = this.minimapX + 4;
        this.minimapContentY = this.minimapY + 4;
        this.minimapContentWidth = Math.max(1, 56);
        this.minimapContentHeight = Math.max(1, this.minimapHeight - 8);
        this.minimapTotalEntriesHeight = 0;
        List<ScrollAreaEntry> scrollEntries = this.scriptEntriesScrollArea.getEntries();
        ArrayList<ExecutableEntry> execEntries = new ArrayList<ExecutableEntry>();
        for (ScrollAreaEntry scrollAreaEntry : scrollEntries) {
            if (!(scrollAreaEntry instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)scrollAreaEntry;
            execEntries.add(ee);
        }
        if (execEntries.isEmpty()) {
            return;
        }
        for (ExecutableEntry executableEntry : execEntries) {
            this.minimapTotalEntriesHeight += executableEntry.getHeight();
        }
        if (this.minimapTotalEntriesHeight <= 0) {
            this.minimapTotalEntriesHeight = 1;
        }
        int offset = 0;
        for (ExecutableEntry entry : execEntries) {
            int entryHeight = entry.getHeight();
            float startRatio = (float)offset / (float)this.minimapTotalEntriesHeight;
            float endRatio = (float)(offset + entryHeight) / (float)this.minimapTotalEntriesHeight;
            int top = this.minimapContentY + Math.round(startRatio * (float)this.minimapContentHeight);
            int bottom = this.minimapContentY + Math.round(endRatio * (float)this.minimapContentHeight);
            if (bottom <= top) {
                bottom = top + 1;
            }
            int height = bottom - top;
            int indentOffset = entry.indentLevel * 4;
            int maxIndent = Math.max(0, this.minimapContentWidth - 1);
            if (indentOffset > maxIndent) {
                indentOffset = maxIndent;
            }
            int segmentX = this.minimapContentX + indentOffset;
            int segmentWidth = Math.max(1, this.minimapContentWidth - indentOffset);
            MinimapEntrySegment segment = new MinimapEntrySegment(entry, segmentX, top, segmentWidth, height);
            this.minimapSegments.add(segment);
            if (UIBase.isXYInArea(mouseX, mouseY, segment.x, segment.y, segment.width, segment.height)) {
                this.minimapHoveredEntry = entry;
            }
            offset += entryHeight;
        }
        if (this.minimapHoveredEntry != null) {
            this.minimapHoveredPrimaryChainEntries = this.getStatementChainOf(this.minimapHoveredEntry);
            this.minimapHoveredStatementChainEntries = this.collectChainWithSubChains(this.minimapHoveredEntry);
        }
    }

    @Nullable
    protected ExecutableEntry getMinimapEntryAt(int mouseX, int mouseY) {
        for (MinimapEntrySegment segment : this.minimapSegments) {
            if (!UIBase.isXYInArea(mouseX, mouseY, segment.x, segment.y, segment.width, segment.height)) continue;
            return segment.entry;
        }
        return null;
    }

    public boolean isMinimapHovered(int mouseX, int mouseY) {
        return this.minimapHeight > 0 && UIBase.isXYInArea(mouseX, mouseY, this.minimapX, this.minimapY, 64, this.minimapHeight);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.isMinimapHovered((int)mouseX, (int)mouseY) && !this.isUserNavigatingInRightClickContextMenu()) {
            if (scrollY != 0.0) {
                float scrollStep = 0.1f * this.scriptEntriesScrollArea.verticalScrollBar.getWheelScrollSpeed();
                float totalOffset = scrollStep * (float)Math.abs(scrollY);
                if (scrollY > 0.0) {
                    totalOffset = -totalOffset;
                }
                this.scriptEntriesScrollArea.verticalScrollBar.setScroll(this.scriptEntriesScrollArea.verticalScrollBar.getScroll() + totalOffset);
                this.scriptEntriesScrollArea.updateEntries(null);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ExecutableEntry ee;
        ExecutableEntry hoveredAfter;
        ExecutableEntry hovered;
        ExecutableEntry entry;
        boolean skipSelection = this.skipNextContextMenuSelection;
        this.skipNextContextMenuSelection = false;
        if (!skipSelection && this.hoveredEntry == null && !this.isMinimapHovered((int)mouseX, (int)mouseY)) {
            if (this.selectedEntry != null) {
                this.selectedEntry.forceSetSelected(false);
            }
            this.selectedEntry = null;
        }
        if (this.isInlineNameEditing()) {
            boolean insideNameEditor = UIBase.isXYInArea((int)mouseX, (int)mouseY, this.inlineNameEditBox.m_252754_(), this.inlineNameEditBox.m_252907_(), this.inlineNameEditBox.m_5711_(), this.inlineNameEditBox.m_93694_());
            if (insideNameEditor && this.inlineNameEditBox.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (!insideNameEditor) {
                this.finishInlineNameEditing(true);
            }
        }
        if (this.isInlineValueEditing()) {
            boolean insideEditor = UIBase.isXYInArea((int)mouseX, (int)mouseY, this.inlineValueEditBox.m_252754_(), this.inlineValueEditBox.m_252907_(), this.inlineValueEditBox.m_5711_(), this.inlineValueEditBox.m_93694_());
            if (insideEditor && this.inlineValueEditBox.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (!insideEditor) {
                this.finishInlineValueEditing(true);
            }
        }
        boolean actionsMenuInteracting = this.isUserNavigatingInRightClickContextMenu();
        if (button == 0 && !actionsMenuInteracting) {
            this.rightClickContextMenu.closeMenu();
            this.contextMenuTargetExecutable = null;
        }
        if (!actionsMenuInteracting && button == 1 && this.isInsideActionsScrollArea((int)mouseX, (int)mouseY)) {
            ExecutableEntry hovered2 = this.getScrollAreaHoveredEntry();
            ExecutableEntry target = null;
            if (hovered2 != null && hovered2 != this.BEFORE_FIRST && hovered2 != this.AFTER_LAST) {
                target = hovered2;
                if (!skipSelection) {
                    hovered2.setSelected(true);
                }
            }
            Executable executable = this.contextMenuTargetExecutable = target != null ? target.executable : null;
            if (this.rightClickContextMenu != null) {
                this.openRightClickContextMenuAt((float)mouseX, (float)mouseY, null);
            }
            return true;
        }
        if (!skipSelection && button == 0 && this.minimapHeight > 0 && UIBase.isXYInArea((int)mouseX, (int)mouseY, this.minimapX, this.minimapY, 64, this.minimapHeight) && (entry = this.getMinimapEntryAt((int)mouseX, (int)mouseY)) != null) {
            entry.setSelected(true);
            this.scrollEntryIntoView(entry);
            return true;
        }
        if (button == 0 && !actionsMenuInteracting && !skipSelection && (hovered = this.getScrollAreaHoveredEntry()) != null) {
            if (hovered.canToggleCollapse() && hovered.isMouseOverCollapseToggle((int)mouseX, (int)mouseY)) {
                this.finishInlineNameEditing(true);
                this.finishInlineValueEditing(true);
                this.toggleCollapseAndPreserveView(hovered);
                return true;
            }
            if (hovered.canInlineEditName() && hovered.isMouseOverName((int)mouseX, (int)mouseY)) {
                if (hovered.registerNameClick((int)mouseX, (int)mouseY)) {
                    this.startInlineNameEditing(hovered);
                    return true;
                }
            } else if (hovered.canInlineEditName()) {
                hovered.resetNameClickTimer();
            }
            if (hovered.canInlineEditValue() && hovered.isMouseOverValue((int)mouseX, (int)mouseY)) {
                if (hovered.registerValueClick((int)mouseX, (int)mouseY)) {
                    this.startInlineValueEditing(hovered);
                    return true;
                }
            } else {
                hovered.resetValueClickTimer();
            }
        }
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        if (!(skipSelection || actionsMenuInteracting || button != 0 || this.isInlineValueEditing() || (hoveredAfter = this.getScrollAreaHoveredEntry()) != null && hoveredAfter.isMouseOverValue((int)mouseX, (int)mouseY))) {
            for (ScrollAreaEntry entry2 : this.scriptEntriesScrollArea.getEntries()) {
                if (!(entry2 instanceof ExecutableEntry)) continue;
                ee = (ExecutableEntry)entry2;
                ee.resetValueClickTimer();
            }
        }
        if (!(skipSelection || actionsMenuInteracting || button != 0 || this.isInlineNameEditing() || (hoveredAfter = this.getScrollAreaHoveredEntry()) != null && hoveredAfter.isMouseOverName((int)mouseX, (int)mouseY))) {
            for (ScrollAreaEntry entry2 : this.scriptEntriesScrollArea.getEntries()) {
                if (!(entry2 instanceof ExecutableEntry) || !(ee = (ExecutableEntry)entry2).canInlineEditName()) continue;
                ee.resetNameClickTimer();
            }
        }
        return handled;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            MainThreadTaskExecutor.executeInMainThread(() -> MainThreadTaskExecutor.executeInMainThread(() -> {
                this.actionsMenuRightClickConsumedByEntry = false;
            }, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK), MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
        }
        if (this.inlineNameEditBox != null && this.inlineNameEditBox.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        if (this.inlineValueEditBox != null && this.inlineValueEditBox.m_6348_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean inlineEditingActive;
        if (this.inlineNameEditBox != null) {
            if (keyCode == 257 || keyCode == 335) {
                this.finishInlineNameEditing(true);
                return true;
            }
            if (keyCode == 256) {
                this.finishInlineNameEditing(false);
                return true;
            }
            if (this.inlineNameEditBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        if (this.inlineValueEditBox != null) {
            if (keyCode == 257 || keyCode == 335) {
                this.finishInlineValueEditing(true);
                return true;
            }
            if (keyCode == 256) {
                this.finishInlineValueEditing(false);
                return true;
            }
            if (this.inlineValueEditBox.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
        }
        boolean contextMenuActive = this.isUserNavigatingInRightClickContextMenu() || this.rightClickContextMenu != null && this.rightClickContextMenu.isOpen();
        boolean bl = inlineEditingActive = this.isInlineNameEditing() || this.isInlineValueEditing();
        if (!contextMenuActive && !inlineEditingActive) {
            ExecutableEntry selected = this.getSelectedEntry();
            boolean ctrlDown = ActionScriptEditorScreen.m_96637_();
            boolean shiftDown = ActionScriptEditorScreen.m_96638_();
            String keyName = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
            String string = keyName = keyName != null ? keyName.toLowerCase(Locale.ROOT) : "";
            if (keyCode == 261 && this.deleteSelectedEntryDirectly()) {
                return true;
            }
            if ("z".equals(keyName) && ctrlDown && shiftDown && this.redo()) {
                return true;
            }
            if ("z".equals(keyName) && ctrlDown && !shiftDown && this.undo()) {
                return true;
            }
            if ("y".equals(keyName) && ctrlDown && this.redo()) {
                return true;
            }
            if ("c".equals(keyName) && ctrlDown) {
                if (this.copySelectedAction()) {
                    return true;
                }
                if (selected != null) {
                    this.showIllegalActionIndicator();
                    return true;
                }
            }
            if ("v".equals(keyName) && ctrlDown && this.pasteCopiedAction(selected)) {
                return true;
            }
            if ("a".equals(keyName)) {
                this.onOpenActionChooser(this.selectedEntry);
                return true;
            }
            if ((keyCode == 265 || keyCode == 264) && (shiftDown ? this.moveSelectedEntry(keyCode == 265) : this.selectAdjacentEntry(keyCode == 264))) {
                return true;
            }
            if ((keyCode == 257 || keyCode == 335) && this.handleEnterShortcut(selected)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean handleEnterShortcut(@Nullable ExecutableEntry selected) {
        if (selected == null) {
            return false;
        }
        Executable executable = selected.executable;
        if (executable instanceof ActionInstance) {
            ActionInstance instance = (ActionInstance)executable;
            if (!instance.action.hasValue()) {
                return false;
            }
            this.startInlineValueEditing(selected);
            return true;
        }
        if (selected.executable instanceof FolderExecutableBlock) {
            this.startInlineNameEditing(selected);
            return true;
        }
        if (selected.executable instanceof IfExecutableBlock || selected.executable instanceof ElseIfExecutableBlock || selected.executable instanceof WhileExecutableBlock) {
            this.onEdit(this.getSelectedEntry());
            return true;
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.inlineNameEditBox != null && this.inlineNameEditBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        if (this.inlineValueEditBox != null && this.inlineValueEditBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private void updateCursor(int mouseX, int mouseY) {
        if (this.inlineNameEditBox != null && UIBase.isXYInArea(mouseX, mouseY, this.inlineNameEditBox.m_252754_(), this.inlineNameEditBox.m_252907_(), this.inlineNameEditBox.m_5711_(), this.inlineNameEditBox.m_93694_())) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_WRITING);
            return;
        }
        if (this.inlineValueEditBox != null && UIBase.isXYInArea(mouseX, mouseY, this.inlineValueEditBox.m_252754_(), this.inlineValueEditBox.m_252907_(), this.inlineValueEditBox.m_5711_(), this.inlineValueEditBox.m_93694_())) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_WRITING);
            return;
        }
        ExecutableEntry hovered = this.hoveredEntry;
        if (hovered != null && hovered.canToggleCollapse() && hovered.isMouseOverCollapseToggle(mouseX, mouseY)) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_POINTING_HAND);
            return;
        }
        if (hovered != null && hovered.canInlineEditName() && hovered.isMouseOverName(mouseX, mouseY)) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_WRITING);
            return;
        }
        if (hovered != null && hovered.canInlineEditValue() && hovered.isMouseOverValue(mouseX, mouseY)) {
            CursorHandler.setClientTickCursor(CursorHandler.CURSOR_WRITING);
        }
    }

    private void toggleCollapseAndPreserveView(@NotNull ExecutableEntry entry) {
        if (!entry.canToggleCollapse()) {
            return;
        }
        this.createUndoPoint();
        ScrollArea scrollArea = this.scriptEntriesScrollArea;
        int desiredOffset = entry.getY() - scrollArea.getInnerY();
        Executable executable = entry.executable;
        entry.toggleCollapsed();
        this.updateActionInstanceScrollArea(true);
        this.restoreEntryTopPosition(executable, desiredOffset);
    }

    private void restoreEntryTopPosition(@NotNull Executable executable, int desiredOffset) {
        int currentOffset;
        int diff;
        ScrollArea scrollArea = this.scriptEntriesScrollArea;
        scrollArea.updateEntries(null);
        ScrollAreaEntry target = null;
        int cumulativeHeight = 0;
        List<ScrollAreaEntry> entries = scrollArea.getEntries();
        for (ScrollAreaEntry scrollEntry : entries) {
            if (scrollEntry instanceof ExecutableEntry) {
                ExecutableEntry ee = (ExecutableEntry)scrollEntry;
                if (ee.executable == executable) {
                    target = ee;
                    break;
                }
                cumulativeHeight += ee.getHeight();
                continue;
            }
            cumulativeHeight += scrollEntry.getHeight();
        }
        if (target == null) {
            return;
        }
        int totalScrollHeight = scrollArea.getTotalScrollHeight();
        if (totalScrollHeight <= 0) {
            scrollArea.verticalScrollBar.setScroll(0.0f);
            scrollArea.updateEntries(null);
            return;
        }
        int innerY = scrollArea.getInnerY();
        int maxOffset = Math.max(0, scrollArea.getInnerHeight() - target.getHeight());
        int minOffset = -target.getHeight();
        int clampedOffset = Mth.m_14045_((int)desiredOffset, (int)minOffset, (int)maxOffset);
        float targetScroll = (float)(cumulativeHeight - clampedOffset) / (float)totalScrollHeight;
        float clampedScroll = Mth.m_14036_((float)targetScroll, (float)0.0f, (float)1.0f);
        scrollArea.verticalScrollBar.setScroll(clampedScroll);
        scrollArea.updateEntries(null);
        for (int attempt = 0; attempt < 2 && Math.abs(diff = (currentOffset = target.getY() - innerY) - clampedOffset) > 1; ++attempt) {
            float adjust = (float)diff / (float)totalScrollHeight;
            float newScroll = Mth.m_14036_((float)(scrollArea.verticalScrollBar.getScroll() + adjust), (float)0.0f, (float)1.0f);
            if (Math.abs(newScroll - scrollArea.verticalScrollBar.getScroll()) < 1.0E-4f) break;
            scrollArea.verticalScrollBar.setScroll(newScroll);
            scrollArea.updateEntries(null);
        }
    }

    protected void startInlineValueEditing(@NotNull ExecutableEntry entry) {
        ActionInstance instance;
        block3: {
            block2: {
                Executable executable = entry.executable;
                if (!(executable instanceof ActionInstance)) break block2;
                instance = (ActionInstance)executable;
                if (instance.action.hasValue()) break block3;
            }
            return;
        }
        this.finishInlineValueEditing(true);
        this.inlineValueEntry = entry;
        this.inlineValueOriginal = instance.value;
        this.inlineValueEditBox = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 10, 10, (Component)Component.m_237119_());
        this.inlineValueEditBox.setHeight(10);
        this.inlineValueEditBox.m_94199_(100000);
        String value = instance.value;
        this.inlineValueEditBox.m_94144_(value != null ? value : "");
        this.inlineValueEditBox.m_94196_(this.inlineValueEditBox.m_94155_().length());
        this.inlineValueEditBox.m_94208_(0);
        UIBase.applyDefaultWidgetSkinTo(this.inlineValueEditBox);
        this.updateInlineValueEditorBounds();
        this.inlineValueEditBox.m_93692_(true);
        this.m_7522_((GuiEventListener)this.inlineValueEditBox);
        entry.setSelected(true);
        entry.leftMouseDownDragging = false;
        entry.dragging = false;
        entry.resetValueClickTimer();
    }

    protected void finishInlineValueEditing(boolean save) {
        if (!this.isInlineValueEditing()) {
            return;
        }
        ExecutableEntry entry = this.inlineValueEntry;
        ExtendedEditBox editBox = this.inlineValueEditBox;
        this.inlineValueEntry = null;
        this.inlineValueEditBox = null;
        this.m_7522_(null);
        Executable executable = entry.executable;
        if (executable instanceof ActionInstance) {
            ActionInstance instance = (ActionInstance)executable;
            String result = Objects.requireNonNullElse(editBox.m_94155_(), "");
            if (!save) {
                instance.value = this.inlineValueOriginal;
            } else {
                String normalized;
                String string = normalized = !result.isEmpty() ? result : null;
                if (!Objects.equals(instance.value, normalized)) {
                    this.createUndoPoint();
                    instance.value = normalized;
                }
            }
            entry.updateValueComponent();
            entry.setWidth(entry.calculateWidth());
            entry.resetValueClickTimer();
        }
        this.inlineValueOriginal = null;
        this.scriptEntriesScrollArea.updateEntries(null);
    }

    private void updateInlineValueEditorBounds() {
        if (!this.isInlineValueEditing()) {
            return;
        }
        ExecutableEntry entry = this.inlineValueEntry;
        int valueX = entry.getValueFieldX();
        int valueY = entry.getValueFieldY();
        int availableWidth = entry.getValueFieldAvailableWidth();
        this.inlineValueEditBox.m_252865_(valueX);
        this.inlineValueEditBox.m_253211_(valueY);
        this.inlineValueEditBox.m_93674_(availableWidth);
        this.inlineValueEditBox.setHeight(10);
    }

    private boolean isInlineValueEditing() {
        return this.inlineValueEditBox != null && this.inlineValueEntry != null;
    }

    protected void startInlineNameEditing(@NotNull ExecutableEntry entry) {
        Executable executable = entry.executable;
        if (!(executable instanceof FolderExecutableBlock)) {
            return;
        }
        FolderExecutableBlock folder = (FolderExecutableBlock)executable;
        this.finishInlineNameEditing(true);
        this.finishInlineValueEditing(true);
        this.inlineNameEntry = entry;
        this.inlineNameOriginal = folder.getName();
        this.inlineNameEditBox = new ExtendedEditBox(Minecraft.m_91087_().f_91062_, 0, 0, 10, 10, (Component)Component.m_237119_());
        this.inlineNameEditBox.setHeight(10);
        this.inlineNameEditBox.m_94199_(256);
        this.inlineNameEditBox.m_94144_(folder.getName());
        this.inlineNameEditBox.m_94196_(this.inlineNameEditBox.m_94155_().length());
        this.inlineNameEditBox.m_94208_(0);
        UIBase.applyDefaultWidgetSkinTo(this.inlineNameEditBox);
        this.updateInlineNameEditorBounds();
        this.inlineNameEditBox.m_93692_(true);
        this.m_7522_((GuiEventListener)this.inlineNameEditBox);
        entry.setSelected(true);
        entry.leftMouseDownDragging = false;
        entry.dragging = false;
        entry.resetNameClickTimer();
    }

    protected void finishInlineNameEditing(boolean save) {
        if (!this.isInlineNameEditing()) {
            return;
        }
        ExecutableEntry entry = this.inlineNameEntry;
        ExtendedEditBox editBox = this.inlineNameEditBox;
        this.inlineNameEntry = null;
        this.inlineNameEditBox = null;
        this.m_7522_(null);
        Executable executable = entry.executable;
        if (executable instanceof FolderExecutableBlock) {
            FolderExecutableBlock folder = (FolderExecutableBlock)executable;
            String result = Objects.requireNonNullElse(editBox.m_94155_(), "");
            if (!save) {
                folder.setName(this.inlineNameOriginal != null ? this.inlineNameOriginal : "New Folder");
            } else {
                String normalized = result.trim();
                if (normalized.isEmpty()) {
                    normalized = "New Folder";
                }
                if (!Objects.equals(folder.getName(), normalized)) {
                    this.createUndoPoint();
                    folder.setName(normalized);
                }
            }
            entry.rebuildComponents();
            entry.setWidth(entry.calculateWidth());
            entry.resetNameClickTimer();
        }
        this.inlineNameOriginal = null;
        this.scriptEntriesScrollArea.updateEntries(null);
    }

    private void updateInlineNameEditorBounds() {
        if (!this.isInlineNameEditing()) {
            return;
        }
        ExecutableEntry entry = this.inlineNameEntry;
        int nameX = entry.getNameFieldX();
        int nameY = entry.getNameFieldY();
        int availableWidth = entry.getNameFieldAvailableWidth();
        this.inlineNameEditBox.m_252865_(nameX);
        this.inlineNameEditBox.m_253211_(nameY);
        this.inlineNameEditBox.m_93674_(availableWidth);
        this.inlineNameEditBox.setHeight(10);
    }

    private boolean isInlineNameEditing() {
        return this.inlineNameEditBox != null && this.inlineNameEntry != null;
    }

    @Nullable
    protected ExecutableEntry getScrollAreaHoveredEntry() {
        if (this.isUserNavigatingInRightClickContextMenu()) {
            return null;
        }
        if (!this.scriptEntriesScrollArea.isMouseInsideArea()) {
            return null;
        }
        int mouseX = MouseInput.getMouseX();
        int mouseY = MouseInput.getMouseY();
        for (ScrollAreaEntry entry : this.scriptEntriesScrollArea.getEntries()) {
            ExecutableEntry ee;
            if (!(entry instanceof ExecutableEntry) || !UIBase.isXYInArea(mouseX, mouseY, (ee = (ExecutableEntry)entry).getX(), ee.getY(), this.scriptEntriesScrollArea.getInnerWidth(), ee.getHeight())) continue;
            return ee;
        }
        return null;
    }

    @NotNull
    protected List<ExecutableEntry> getActiveHoveredChain() {
        if (!this.minimapHoveredStatementChainEntries.isEmpty()) {
            return this.minimapHoveredStatementChainEntries;
        }
        if (!this.hoveredStatementChainEntries.isEmpty()) {
            return this.hoveredStatementChainEntries;
        }
        return Collections.emptyList();
    }

    @NotNull
    protected List<ExecutableEntry> getHoveredChainForIndicator() {
        if (!this.minimapHoveredPrimaryChainEntries.isEmpty()) {
            return this.minimapHoveredPrimaryChainEntries;
        }
        if (!this.hoveredPrimaryChainEntries.isEmpty()) {
            return this.hoveredPrimaryChainEntries;
        }
        ExecutableEntry active = this.getActiveHoveredEntry();
        if (active != null) {
            return this.getStatementChainOf(active);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected ExecutableEntry getActiveHoveredEntry() {
        if (this.minimapHoveredEntry != null) {
            return this.minimapHoveredEntry;
        }
        return this.hoveredEntry;
    }

    protected boolean isEntryPartOfChain(@NotNull ExecutableEntry entry, @NotNull List<ExecutableEntry> chainEntries) {
        if (chainEntries.isEmpty()) {
            return false;
        }
        if (chainEntries.contains(entry)) {
            return true;
        }
        ExecutableEntry anchor = this.getChainAnchor(entry);
        return anchor != null && chainEntries.contains(anchor);
    }

    @NotNull
    protected Color getChainIndicatorColorFor(@NotNull ExecutableEntry entry) {
        UIColorTheme theme = UIBase.getUIColorTheme();
        if (!this.selectedStatementChainEntries.isEmpty() && this.isEntryPartOfChain(entry, this.selectedStatementChainEntries)) {
            return theme.actions_chain_indicator_selected_color.getColor();
        }
        List<ExecutableEntry> hoveredChain = this.getHoveredChainForIndicator();
        if (!hoveredChain.isEmpty() && this.isEntryPartOfChain(entry, hoveredChain)) {
            return theme.actions_chain_indicator_hovered_color.getColor();
        }
        return theme.actions_chain_indicator_color.getColor();
    }

    protected void scrollEntryIntoView(@NotNull ExecutableEntry entry) {
        List<ScrollAreaEntry> scrollEntries = this.scriptEntriesScrollArea.getEntries();
        int totalHeight = 0;
        for (ScrollAreaEntry e : scrollEntries) {
            totalHeight += e.getHeight();
        }
        int visibleHeight = this.scriptEntriesScrollArea.getInnerHeight();
        if (totalHeight <= visibleHeight) {
            return;
        }
        int offset = 0;
        for (ScrollAreaEntry e : scrollEntries) {
            if (e == entry) break;
            offset += e.getHeight();
        }
        int entryCenter = offset + entry.getHeight() / 2;
        int target = Math.max(0, entryCenter - visibleHeight / 2);
        int maxScroll = Math.max(1, totalHeight - visibleHeight);
        float scroll = Math.min(1.0f, (float)target / (float)maxScroll);
        this.scriptEntriesScrollArea.verticalScrollBar.setScroll(scroll);
        this.scriptEntriesScrollArea.updateEntries(null);
    }

    private static Color withAlpha(@NotNull Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.min(255, Math.max(0, alpha)));
    }

    protected boolean isContentOfStatementChain(@NotNull ExecutableEntry entry, @NotNull List<ExecutableEntry> statementChain) {
        List<ExecutableEntry> parentBlockHierarchy = this.getParentBlockHierarchyOf(entry);
        for (ExecutableEntry parentBlock : parentBlockHierarchy) {
            if (!statementChain.contains(parentBlock)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<ExecutableEntry> getParentBlockHierarchyOf(@NotNull ExecutableEntry entry) {
        ArrayList<ExecutableEntry> blocks = new ArrayList<ExecutableEntry>();
        ExecutableEntry e = entry;
        while (e != null) {
            e = e.parentBlock != null ? this.findEntryForExecutable(e.parentBlock) : null;
            if (e == null) continue;
            blocks.add(0, e);
        }
        return blocks;
    }

    @NotNull
    protected List<ExecutableEntry> getStatementChainOf(@NotNull ExecutableEntry entry) {
        ExecutableEntry anchor = this.getChainAnchor(entry);
        if (anchor == null) {
            return Collections.emptyList();
        }
        ArrayList<ExecutableEntry> entries = new ArrayList<ExecutableEntry>();
        ArrayList<ExecutableEntry> beforeEntry = new ArrayList<ExecutableEntry>();
        ExecutableEntry e1 = anchor;
        while (e1 != null) {
            e1 = e1.appendParent != null ? this.findEntryForExecutable(e1.appendParent) : null;
            if (e1 == null) continue;
            beforeEntry.add(0, e1);
        }
        ArrayList<ExecutableEntry> afterEntry = new ArrayList<ExecutableEntry>();
        ExecutableEntry e2 = anchor;
        while (e2 != null) {
            Executable executable = e2.executable;
            if (executable instanceof AbstractExecutableBlock) {
                AbstractExecutableBlock b = (AbstractExecutableBlock)executable;
                AbstractExecutableBlock appendChild = b.getAppendedBlock();
                e2 = appendChild != null ? this.findEntryForExecutable(appendChild) : null;
                if (e2 == null) continue;
                afterEntry.add(e2);
                continue;
            }
            e2 = null;
        }
        entries.addAll(beforeEntry);
        entries.add(anchor);
        entries.addAll(afterEntry);
        if (anchor.executable instanceof WhileExecutableBlock) {
            this.addWhileChainEntries(anchor, entries);
        }
        if (anchor != entry && entry.parentBlock != null && entries.size() > 1) {
            ExecutableEntry lastStatement = (ExecutableEntry)entries.get(entries.size() - 1);
            if (lastStatement.executable == entry.parentBlock) {
                ArrayList<ExecutableEntry> extended = new ArrayList<ExecutableEntry>(entries);
                extended.add(entry);
                entries = extended;
            }
        }
        return entries;
    }

    @Nullable
    protected ExecutableEntry getChainAnchor(@NotNull ExecutableEntry entry) {
        if (entry.executable instanceof AbstractExecutableBlock) {
            return entry;
        }
        if (entry.parentBlock != null) {
            return this.findEntryForExecutable(entry.parentBlock);
        }
        if (entry.appendParent != null) {
            return this.findEntryForExecutable(entry.appendParent);
        }
        return null;
    }

    @NotNull
    protected List<ExecutableEntry> getChainAnchorsFor(@NotNull ExecutableEntry entry) {
        LinkedHashSet<ExecutableEntry> anchors = new LinkedHashSet<ExecutableEntry>();
        ExecutableEntry cursor = entry;
        while (cursor != null) {
            ExecutableEntry anchor = this.getChainAnchor(cursor);
            while (anchor != null) {
                anchors.add(anchor);
                if (anchor.appendParent != null) {
                    anchor = this.findEntryForExecutable(anchor.appendParent);
                    continue;
                }
                anchor = null;
            }
            if (cursor.parentBlock != null && cursor.parentBlock != cursor.executable) {
                cursor = this.findEntryForExecutable(cursor.parentBlock);
                continue;
            }
            cursor = null;
        }
        return new ArrayList<ExecutableEntry>(anchors);
    }

    protected int getChainBarX(@NotNull ExecutableEntry entry) {
        ExecutableEntry anchor = this.getChainAnchor(entry);
        ExecutableEntry reference = anchor != null ? anchor : entry;
        return reference.getX() + 20 * reference.indentLevel + 2;
    }

    protected void addWhileChainEntries(@NotNull ExecutableEntry anchor, @NotNull List<ExecutableEntry> entries) {
        if (!(anchor.executable instanceof WhileExecutableBlock)) {
            return;
        }
        List<ScrollAreaEntry> scrollEntries = this.scriptEntriesScrollArea.getEntries();
        int anchorIndex = scrollEntries.indexOf(anchor);
        if (anchorIndex < 0) {
            return;
        }
        for (int i = anchorIndex + 1; i < scrollEntries.size(); ++i) {
            ScrollAreaEntry raw = scrollEntries.get(i);
            if (!(raw instanceof ExecutableEntry)) continue;
            ExecutableEntry candidate = (ExecutableEntry)raw;
            if (!this.isEntryDescendantOf(candidate, anchor)) break;
            if (candidate.executable instanceof IfExecutableBlock || candidate.executable instanceof ElseIfExecutableBlock || candidate.executable instanceof ElseExecutableBlock || candidate.executable instanceof WhileExecutableBlock || entries.contains(candidate)) continue;
            entries.add(candidate);
        }
    }

    @NotNull
    protected List<ExecutableEntry> collectChainWithSubChains(@NotNull ExecutableEntry entry) {
        LinkedHashSet<ExecutableEntry> expanded = new LinkedHashSet<ExecutableEntry>();
        ArrayDeque<ExecutableEntry> queue = new ArrayDeque<ExecutableEntry>();
        this.enqueueChainEntries(entry, expanded, queue);
        List<ScrollAreaEntry> scrollEntries = this.scriptEntriesScrollArea.getEntries();
        while (!queue.isEmpty()) {
            ExecutableEntry current = queue.poll();
            for (ScrollAreaEntry raw : scrollEntries) {
                ExecutableEntry candidate;
                if (!(raw instanceof ExecutableEntry) || expanded.contains(candidate = (ExecutableEntry)raw) || !this.isEntryDescendantOf(candidate, current)) continue;
                if (candidate.executable instanceof AbstractExecutableBlock) {
                    this.enqueueChainEntries(candidate, expanded, queue);
                    continue;
                }
                expanded.add(candidate);
            }
        }
        return new ArrayList<ExecutableEntry>(expanded);
    }

    protected void enqueueChainEntries(@NotNull ExecutableEntry source, @NotNull LinkedHashSet<ExecutableEntry> expanded, @NotNull ArrayDeque<ExecutableEntry> queue) {
        for (ExecutableEntry chainEntry : this.getStatementChainOf(source)) {
            if (!expanded.add(chainEntry) || !(chainEntry.executable instanceof AbstractExecutableBlock)) continue;
            queue.add(chainEntry);
        }
    }

    protected boolean isEntryDescendantOf(@NotNull ExecutableEntry entry, @NotNull ExecutableEntry potentialAncestor) {
        AbstractExecutableBlock parentBlock = entry.parentBlock;
        while (parentBlock != null) {
            ExecutableEntry parentEntry = this.findEntryForExecutable(parentBlock);
            if (parentEntry == null) {
                return false;
            }
            if (parentEntry == potentialAncestor) {
                return true;
            }
            parentBlock = parentEntry.parentBlock;
        }
        return false;
    }

    @Nullable
    protected ExecutableEntry getDragHoveredEntry() {
        ExecutableEntry draggedEntry = this.getDraggedEntry();
        if (draggedEntry != null) {
            if (MouseInput.getMouseY() <= this.scriptEntriesScrollArea.getInnerY() && this.scriptEntriesScrollArea.verticalScrollBar.getScroll() == 0.0f) {
                return this.BEFORE_FIRST;
            }
            if (MouseInput.getMouseY() >= this.scriptEntriesScrollArea.getInnerY() + this.scriptEntriesScrollArea.getInnerHeight() && this.scriptEntriesScrollArea.verticalScrollBar.getScroll() == 1.0f) {
                return this.AFTER_LAST;
            }
            for (ScrollAreaEntry e : this.scriptEntriesScrollArea.getEntries()) {
                ExecutableEntry pb;
                if (!(e instanceof ExecutableEntry)) continue;
                ExecutableEntry ee = (ExecutableEntry)e;
                if (e.getY() + e.getHeight() > this.scriptEntriesScrollArea.getInnerY() + this.scriptEntriesScrollArea.getInnerHeight() || ee == draggedEntry || !UIBase.isXYInArea(MouseInput.getMouseX(), MouseInput.getMouseY(), ee.getX(), ee.getY(), ee.getWidth(), ee.getHeight()) || !this.scriptEntriesScrollArea.isMouseInsideArea()) continue;
                List<Object> statementChain = new ArrayList();
                if (draggedEntry.executable instanceof AbstractExecutableBlock) {
                    statementChain = this.getStatementChainOf(draggedEntry);
                }
                if (draggedEntry.executable instanceof AbstractExecutableBlock && statementChain.contains(ee)) {
                    return null;
                }
                if (ee.parentBlock != null && ee.parentBlock != this.executableBlock && (pb = this.findEntryForExecutable(ee.parentBlock)) != null && statementChain.contains(pb)) {
                    return null;
                }
                if (draggedEntry.executable instanceof AbstractExecutableBlock && this.isContentOfStatementChain(ee, statementChain)) {
                    return null;
                }
                return ee;
            }
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry getDraggedEntry() {
        for (ScrollAreaEntry e : this.scriptEntriesScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            if (!ee.dragging) continue;
            return ee;
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry findEntryForExecutable(Executable executable) {
        for (ScrollAreaEntry e : this.scriptEntriesScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            if (ee.executable != executable) continue;
            return ee;
        }
        return null;
    }

    protected void focusEntryForExecutable(@NotNull Executable executable, boolean keepViewAnchor) {
        this.focusEntryForExecutable(executable, keepViewAnchor, false);
    }

    protected void focusEntryForExecutable(@NotNull Executable executable, boolean keepViewAnchor, boolean allowSelectionWhileMenuOpen) {
        if (allowSelectionWhileMenuOpen) {
            this.scheduleFocusEntryForExecutable(executable, keepViewAnchor);
            return;
        }
        ExecutableEntry entry = this.findEntryForExecutable(executable);
        if (entry != null) {
            if (!this.isUserNavigatingInRightClickContextMenu()) {
                entry.setSelected(true);
                if (!keepViewAnchor) {
                    this.scrollEntryIntoView(entry);
                }
            } else {
                this.pendingSelectionExecutable = executable;
                this.pendingSelectionKeepViewAnchor = keepViewAnchor;
            }
        }
    }

    protected void scheduleFocusEntryForExecutable(@NotNull Executable executable, boolean keepViewAnchor) {
        MainThreadTaskExecutor.executeInMainThread(() -> {
            if (Minecraft.m_91087_().f_91080_ == this) {
                this.focusEntryForExecutable(executable, keepViewAnchor, false);
            }
        }, MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
    }

    protected void withContextMenuSelectionOverride(@NotNull Runnable action) {
        boolean previous = this.contextMenuSelectionOverrideActive;
        this.contextMenuSelectionOverrideActive = true;
        try {
            action.run();
        }
        finally {
            this.contextMenuSelectionOverrideActive = previous;
        }
    }

    protected void setEntrySelectedRespectingContextMenu(@NotNull ExecutableEntry entry) {
        if (this.isUserNavigatingInRightClickContextMenu()) {
            this.withContextMenuSelectionOverride(() -> entry.setSelected(true));
        } else {
            entry.setSelected(true);
        }
    }

    @Nullable
    protected ExecutableEntry getSelectedEntry() {
        ScrollAreaEntry e = this.scriptEntriesScrollArea.getFocusedEntry();
        if (e instanceof ExecutableEntry) {
            ExecutableEntry ee = (ExecutableEntry)e;
            return ee;
        }
        return null;
    }

    @Nullable
    private MoveTarget calculateMoveTarget(@NotNull ExecutableEntry entry, @NotNull ExecutableEntry moveAfter) {
        int targetIndex;
        AbstractExecutableBlock targetParent;
        AbstractExecutableBlock currentParent = entry.getParentBlock();
        List<Executable> currentList = currentParent.getExecutables();
        int currentIndex = currentList.indexOf(entry.executable);
        if (currentIndex < 0) {
            return null;
        }
        if (moveAfter == this.BEFORE_FIRST) {
            targetParent = this.executableBlock;
            targetIndex = 0;
        } else if (moveAfter == this.AFTER_LAST) {
            targetParent = this.executableBlock;
            targetIndex = this.executableBlock.getExecutables().size();
        } else {
            Executable executable = moveAfter.executable;
            if (executable instanceof AbstractExecutableBlock) {
                AbstractExecutableBlock block = (AbstractExecutableBlock)executable;
                targetParent = block;
                targetIndex = 0;
            } else {
                targetParent = moveAfter.getParentBlock();
                List<Executable> targetList = targetParent.getExecutables();
                int moveAfterIndex = targetList.indexOf(moveAfter.executable);
                int n = targetIndex = moveAfterIndex >= 0 ? moveAfterIndex + 1 : targetList.size();
            }
        }
        if (targetParent == currentParent) {
            if (targetIndex > currentIndex) {
                --targetIndex;
            }
            if (targetIndex == currentIndex) {
                return null;
            }
        }
        return new MoveTarget(targetParent, Math.max(0, targetIndex));
    }

    @Nullable
    protected ExecutableEntry getValidMoveToEntryBefore(@NotNull ExecutableEntry entry, boolean ignoreValidityChecks) {
        if (entry == this.BEFORE_FIRST) {
            return this.BEFORE_FIRST;
        }
        int index = this.scriptEntriesScrollArea.getEntries().size();
        boolean foundEntry = false;
        boolean foundValidMoveTo = false;
        for (ScrollAreaEntry e : Lists.reverse(this.scriptEntriesScrollArea.getEntries())) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            --index;
            if (e == entry) {
                foundEntry = true;
                continue;
            }
            if (!ignoreValidityChecks) {
                ExecutableEntry pb;
                List<Object> statementChain = new ArrayList();
                if (entry.executable instanceof AbstractExecutableBlock) {
                    statementChain = this.getStatementChainOf(entry);
                }
                if (entry.executable instanceof AbstractExecutableBlock && statementChain.contains(ee) || ee.parentBlock != null && ee.parentBlock != this.executableBlock && (pb = this.findEntryForExecutable(ee.parentBlock)) != null && statementChain.contains(pb) || entry.executable instanceof AbstractExecutableBlock && this.isContentOfStatementChain(ee, statementChain)) continue;
            }
            if (!foundEntry) continue;
            foundValidMoveTo = true;
            break;
        }
        if (!foundValidMoveTo) {
            return null;
        }
        ScrollAreaEntry e = this.scriptEntriesScrollArea.getEntry(index);
        if (e instanceof ExecutableEntry) {
            ExecutableEntry ee = (ExecutableEntry)e;
            return ee;
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry getValidMoveToEntryAfter(@NotNull ExecutableEntry entry, boolean ignoreValidityChecks) {
        if (entry == this.AFTER_LAST) {
            return this.AFTER_LAST;
        }
        int index = -1;
        boolean foundEntry = false;
        boolean foundValidMoveTo = false;
        for (ScrollAreaEntry e : this.scriptEntriesScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            ++index;
            if (e == entry) {
                foundEntry = true;
                continue;
            }
            if (!ignoreValidityChecks) {
                ExecutableEntry pb;
                List<Object> statementChain = new ArrayList();
                if (entry.executable instanceof AbstractExecutableBlock) {
                    statementChain = this.getStatementChainOf(entry);
                }
                if (entry.executable instanceof AbstractExecutableBlock && statementChain.contains(ee) || ee.parentBlock != null && ee.parentBlock != this.executableBlock && (pb = this.findEntryForExecutable(ee.parentBlock)) != null && statementChain.contains(pb) || entry.executable instanceof AbstractExecutableBlock && this.isContentOfStatementChain(ee, statementChain)) continue;
            }
            if (!foundEntry) continue;
            foundValidMoveTo = true;
            break;
        }
        if (!foundValidMoveTo) {
            return null;
        }
        ScrollAreaEntry e = this.scriptEntriesScrollArea.getEntry(index);
        if (e instanceof ExecutableEntry) {
            ExecutableEntry ee = (ExecutableEntry)e;
            return ee;
        }
        return null;
    }

    protected boolean moveAfter(@NotNull ExecutableEntry entry, @NotNull ExecutableEntry moveAfter) {
        MoveTarget target = this.calculateMoveTarget(entry, moveAfter);
        if (target == null) {
            return false;
        }
        this.createUndoPoint();
        entry.getParentBlock().getExecutables().remove(entry.executable);
        target.parent().getExecutables().add(target.index(), entry.executable);
        this.updateActionInstanceScrollArea(true);
        ExecutableEntry newEntry = this.findEntryForExecutable(entry.executable);
        if (newEntry != null) {
            this.setEntrySelectedRespectingContextMenu(newEntry);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void moveUp(ExecutableEntry entry) {
        block12: {
            block13: {
                block15: {
                    block17: {
                        block16: {
                            block14: {
                                if (entry == null) break block12;
                                if (!(entry.executable instanceof ActionInstance) && !(entry.executable instanceof IfExecutableBlock) && !(entry.executable instanceof WhileExecutableBlock)) break block13;
                                manualUpdate = false;
                                if (this.scriptEntriesScrollArea.getEntries().indexOf(entry) != 1) break block14;
                                this.moveAfter(entry, this.BEFORE_FIRST);
                                break block15;
                            }
                            if (entry.getParentBlock() == this.executableBlock || !(entry.getParentBlock() instanceof ElseIfExecutableBlock) && !(entry.getParentBlock() instanceof ElseExecutableBlock) || entry.getParentBlock().getExecutables().indexOf(entry.executable) != 0) break block16;
                            parentBlock = this.findEntryForExecutable(entry.getParentBlock());
                            if (parentBlock != null && parentBlock.appendParent != null) {
                                this.createUndoPoint();
                                entry.getParentBlock().getExecutables().remove(entry.executable);
                                parentBlock.appendParent.getExecutables().add(entry.executable);
                                manualUpdate = true;
                            }
                            break block15;
                        }
                        if (entry.getParentBlock() == this.executableBlock || !(entry.getParentBlock() instanceof IfExecutableBlock) || entry.getParentBlock().getExecutables().indexOf(entry.executable) != 0) break block17;
                        parentBlock = this.findEntryForExecutable(entry.getParentBlock());
                        if (parentBlock != null && (parentIndex = Math.max(0, parentBlock.getParentBlock().getExecutables().indexOf(parentBlock.executable))) >= 0) {
                            this.createUndoPoint();
                            entry.getParentBlock().getExecutables().remove(entry.executable);
                            parentBlock.getParentBlock().getExecutables().add(parentIndex, entry.executable);
                            manualUpdate = true;
                        }
                        break block15;
                    }
                    before = this.getValidMoveToEntryBefore(entry, false);
                    if (before == null) break block15;
                    v0 = isMovable = entry.executable instanceof IfExecutableBlock != false || entry.executable instanceof ActionInstance != false;
                    if (!isMovable || !((var6_9 = before.executable) instanceof AbstractExecutableBlock)) ** GOTO lbl-1000
                    b = (AbstractExecutableBlock)var6_9;
                    if (entry.getParentBlock() != b) {
                        this.moveAfter(entry, before);
                    } else if (isMovable && !(before.executable instanceof AbstractExecutableBlock) && before.getParentBlock().getExecutables().indexOf(before.executable) == before.getParentBlock().getExecutables().size() - 1) {
                        this.moveAfter(entry, before);
                    } else {
                        beforeBefore = this.getValidMoveToEntryBefore(before, true);
                        if (beforeBefore != null) {
                            this.moveAfter(entry, beforeBefore);
                        }
                    }
                }
                if (manualUpdate) {
                    this.updateActionInstanceScrollArea(true);
                    newEntry = this.findEntryForExecutable(entry.executable);
                    if (newEntry != null) {
                        this.setEntrySelectedRespectingContextMenu(newEntry);
                    }
                }
                return;
            }
            newEntry = entry.executable;
            if (newEntry instanceof ElseIfExecutableBlock) {
                ei = (ElseIfExecutableBlock)newEntry;
                entryAppendParent = entry.appendParent;
                if (entryAppendParent != null && (appendParentEntry = this.findEntryForExecutable(entryAppendParent)) != null && (parentOfParent = appendParentEntry.appendParent) != null) {
                    this.createUndoPoint();
                    entryAppendParent.setAppendedBlock(ei.getAppendedBlock());
                    ei.setAppendedBlock(entryAppendParent);
                    parentOfParent.setAppendedBlock(ei);
                }
            }
            this.updateActionInstanceScrollArea(true);
            newEntry = this.findEntryForExecutable(entry.executable);
            if (newEntry != null) {
                this.setEntrySelectedRespectingContextMenu(newEntry);
            }
        }
    }

    protected void moveDown(ExecutableEntry entry) {
        if (entry != null) {
            if (entry.executable instanceof ActionInstance || entry.executable instanceof IfExecutableBlock || entry.executable instanceof WhileExecutableBlock) {
                boolean manualUpdate = false;
                if (entry.getParentBlock() != this.executableBlock && entry.getParentBlock().getAppendedBlock() == null && entry.getParentBlock().getExecutables().indexOf(entry.executable) == entry.getParentBlock().getExecutables().size() - 1) {
                    ExecutableEntry parentBlock = this.findEntryForExecutable(entry.getParentBlock());
                    if (parentBlock != null) {
                        int parentIndex = -1;
                        if (parentBlock.executable instanceof IfExecutableBlock) {
                            parentIndex = Math.max(0, parentBlock.getParentBlock().getExecutables().indexOf(parentBlock.executable));
                        } else {
                            List<ExecutableEntry> chain = this.getStatementChainOf(parentBlock);
                            if (!chain.isEmpty()) {
                                parentIndex = chain.get(0).getParentBlock().getExecutables().indexOf(chain.get((int)0).executable);
                            }
                        }
                        if (parentIndex != -1) {
                            this.createUndoPoint();
                            entry.getParentBlock().getExecutables().remove(entry.executable);
                            parentBlock.getParentBlock().getExecutables().add(parentIndex + 1, entry.executable);
                            manualUpdate = true;
                        }
                    }
                } else {
                    ExecutableEntry after = this.getValidMoveToEntryAfter(entry, false);
                    if (after != null) {
                        this.moveAfter(entry, after);
                    }
                }
                if (manualUpdate) {
                    this.updateActionInstanceScrollArea(true);
                    ExecutableEntry newEntry = this.findEntryForExecutable(entry.executable);
                    if (newEntry != null) {
                        this.setEntrySelectedRespectingContextMenu(newEntry);
                    }
                }
                return;
            }
            Executable newEntry = entry.executable;
            if (newEntry instanceof ElseIfExecutableBlock) {
                ElseIfExecutableBlock ei = (ElseIfExecutableBlock)newEntry;
                AbstractExecutableBlock entryAppendChild = ei.getAppendedBlock();
                AbstractExecutableBlock entryAppendParent = entry.appendParent;
                if (entryAppendChild instanceof ElseIfExecutableBlock && entryAppendParent != null) {
                    this.createUndoPoint();
                    ei.setAppendedBlock(entryAppendChild.getAppendedBlock());
                    entryAppendChild.setAppendedBlock(ei);
                    entryAppendParent.setAppendedBlock(entryAppendChild);
                }
            }
            this.updateActionInstanceScrollArea(true);
            ExecutableEntry newEntry2 = this.findEntryForExecutable(entry.executable);
            if (newEntry2 != null) {
                this.setEntrySelectedRespectingContextMenu(newEntry2);
            }
        }
    }

    protected void handleContextMenuMove(@NotNull ExecutableEntry entry, boolean moveUp) {
        this.scriptEntriesScrollArea.updateEntries(null);
        int previousEntryY = entry.getY();
        Executable executable = entry.executable;
        if (moveUp) {
            this.moveUp(entry);
        } else {
            this.moveDown(entry);
        }
        ExecutableEntry newEntry = this.findEntryForExecutable(executable);
        if (newEntry != null) {
            this.adjustScrollToKeepEntryInPlace(previousEntryY, newEntry);
            this.setEntrySelectedRespectingContextMenu(newEntry);
            this.scheduleFocusEntryForExecutable(executable, true);
        }
    }

    protected void processPendingSelection() {
        if (this.pendingSelectionExecutable != null && !this.isUserNavigatingInRightClickContextMenu()) {
            Executable pending = this.pendingSelectionExecutable;
            boolean keep = this.pendingSelectionKeepViewAnchor;
            this.pendingSelectionExecutable = null;
            this.pendingSelectionKeepViewAnchor = false;
            ExecutableEntry entry = this.findEntryForExecutable(pending);
            if (entry != null) {
                entry.setSelected(true);
                if (!keep) {
                    this.scrollEntryIntoView(entry);
                }
            }
        }
    }

    protected void adjustScrollToKeepEntryInPlace(int previousEntryY, @NotNull ExecutableEntry entry) {
        this.scriptEntriesScrollArea.updateEntries(null);
        if (previousEntryY == Integer.MIN_VALUE) {
            return;
        }
        int newEntryY = entry.getY();
        int delta = newEntryY - previousEntryY;
        if (delta == 0) {
            return;
        }
        float totalScrollHeight = this.scriptEntriesScrollArea.getTotalScrollHeight();
        if (totalScrollHeight <= 0.0f) {
            return;
        }
        float currentScroll = this.scriptEntriesScrollArea.verticalScrollBar.getScroll();
        float adjustedScroll = Mth.m_14036_((float)(currentScroll + (float)delta / totalScrollHeight), (float)0.0f, (float)1.0f);
        if (adjustedScroll != currentScroll) {
            this.scriptEntriesScrollArea.verticalScrollBar.setScroll(adjustedScroll);
            this.scriptEntriesScrollArea.updateEntries(null);
        }
    }

    protected void updateActionInstanceScrollArea(boolean keepScroll) {
        this.finishInlineNameEditing(true);
        this.finishInlineValueEditing(true);
        this.minimapSegments.clear();
        this.minimapHoveredEntry = null;
        this.minimapHoveredPrimaryChainEntries = Collections.emptyList();
        this.minimapHoveredStatementChainEntries = Collections.emptyList();
        this.hoveredEntry = null;
        this.hoveredPrimaryChainEntries = Collections.emptyList();
        this.hoveredStatementChainEntries = Collections.emptyList();
        for (ScrollAreaEntry e : this.scriptEntriesScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            ee.leftMouseDownDragging = false;
            ee.dragging = false;
        }
        float oldScrollVertical = this.scriptEntriesScrollArea.verticalScrollBar.getScroll();
        float oldScrollHorizontal = this.scriptEntriesScrollArea.horizontalScrollBar.getScroll();
        this.scriptEntriesScrollArea.clearEntries();
        this.addExecutableToEntries(-1, this.executableBlock, null, null);
        if (keepScroll) {
            this.scriptEntriesScrollArea.verticalScrollBar.setScroll(oldScrollVertical);
            this.scriptEntriesScrollArea.horizontalScrollBar.setScroll(oldScrollHorizontal);
        }
    }

    protected void addExecutableRelativeToSelection(@NotNull Executable executable, @Nullable ExecutableEntry selectionReference) {
        if (selectionReference == this.BEFORE_FIRST) {
            this.executableBlock.addExecutable(executable);
            List<Executable> rootExecutables = this.executableBlock.getExecutables();
            if (rootExecutables.remove(executable)) {
                rootExecutables.add(0, executable);
            }
            return;
        }
        if (selectionReference == this.AFTER_LAST) {
            this.executableBlock.addExecutable(executable);
            return;
        }
        if (selectionReference == null) {
            this.executableBlock.addExecutable(executable);
            return;
        }
        Executable executable2 = selectionReference.executable;
        if (executable2 instanceof AbstractExecutableBlock) {
            AbstractExecutableBlock block = (AbstractExecutableBlock)executable2;
            block.addExecutable(executable);
            return;
        }
        AbstractExecutableBlock parentBlock = selectionReference.getParentBlock();
        List<Executable> executables = parentBlock.getExecutables();
        int selectedIndex = executables.indexOf(selectionReference.executable);
        parentBlock.addExecutable(executable);
        if (selectedIndex >= 0 && executables.remove(executable)) {
            int insertIndex = Math.min(selectedIndex + 1, executables.size());
            executables.add(insertIndex, executable);
        }
    }

    protected void addExecutableToEntries(int level, Executable executable, @Nullable AbstractExecutableBlock appendParent, @Nullable AbstractExecutableBlock parentBlock) {
        if (level >= 0) {
            ExecutableEntry entry = new ExecutableEntry(this.scriptEntriesScrollArea, executable, 14, level);
            entry.appendParent = appendParent;
            entry.parentBlock = parentBlock;
            this.scriptEntriesScrollArea.addEntry(entry);
        }
        if (executable instanceof AbstractExecutableBlock) {
            WhileExecutableBlock whileBlock;
            IfExecutableBlock ifBlock;
            FolderExecutableBlock folder;
            AbstractExecutableBlock b = (AbstractExecutableBlock)executable;
            boolean skipChildren = false;
            if (b instanceof FolderExecutableBlock && (folder = (FolderExecutableBlock)b).isCollapsed()) {
                skipChildren = true;
            } else if (b instanceof IfExecutableBlock && (ifBlock = (IfExecutableBlock)b).isCollapsed()) {
                skipChildren = true;
            } else if (b instanceof WhileExecutableBlock && (whileBlock = (WhileExecutableBlock)b).isCollapsed()) {
                skipChildren = true;
            }
            if (!skipChildren) {
                for (Executable e : b.getExecutables()) {
                    this.addExecutableToEntries(level + 1, e, null, b);
                }
            }
            if (!skipChildren && b.getAppendedBlock() != null) {
                this.addExecutableToEntries(level, b.getAppendedBlock(), b, parentBlock);
            }
        }
    }

    @Nullable
    private Executable findExecutableByIdentifier(@NotNull AbstractExecutableBlock start, @NotNull String identifier) {
        Executable nested;
        if (identifier.equals(start.getIdentifier())) {
            return start;
        }
        for (Executable executable : start.getExecutables()) {
            AbstractExecutableBlock block;
            Executable nested2;
            if (identifier.equals(executable.getIdentifier())) {
                return executable;
            }
            if (!(executable instanceof AbstractExecutableBlock) || (nested2 = this.findExecutableByIdentifier(block = (AbstractExecutableBlock)executable, identifier)) == null) continue;
            return nested2;
        }
        AbstractExecutableBlock appended = start.getAppendedBlock();
        if (appended != null && (nested = this.findExecutableByIdentifier(appended, identifier)) != null) {
            return nested;
        }
        return null;
    }

    protected void openRightClickContextMenuAt(float x, float y, @Nullable List<String> entryPath) {
        if (this.rightClickContextMenu == null) {
            return;
        }
        this.rightClickContextMenuLastOpenX = x;
        this.rightClickContextMenuLastOpenY = y;
        ArrayList<String> path = entryPath != null && !entryPath.isEmpty() ? new ArrayList<String>(entryPath) : null;
        this.rightClickContextMenu.openMenuAt(x, y, path);
    }

    protected boolean isInsideActionsScrollArea(int mouseX, int mouseY) {
        return UIBase.isXYInArea(mouseX, mouseY, this.scriptEntriesScrollArea.getXWithBorder(), this.scriptEntriesScrollArea.getYWithBorder(), this.scriptEntriesScrollArea.getWidthWithBorder(), this.scriptEntriesScrollArea.getHeightWithBorder());
    }

    protected boolean canAppendConditionalBlock(@Nullable ExecutableEntry entry) {
        if (entry == null) {
            return false;
        }
        return entry.executable instanceof IfExecutableBlock || entry.executable instanceof ElseIfExecutableBlock;
    }

    protected boolean canAppendElseBlock(@Nullable ExecutableEntry entry) {
        Executable executable;
        if (entry == null || !((executable = entry.executable) instanceof AbstractExecutableBlock)) {
            return false;
        }
        AbstractExecutableBlock block = (AbstractExecutableBlock)executable;
        if (!(entry.executable instanceof IfExecutableBlock) && !(entry.executable instanceof ElseIfExecutableBlock)) {
            return false;
        }
        return this.findAppendElseTarget(block) != null;
    }

    @Nullable
    protected AbstractExecutableBlock findAppendElseTarget(@NotNull AbstractExecutableBlock block) {
        AbstractExecutableBlock current = block;
        AbstractExecutableBlock appended = current.getAppendedBlock();
        while (appended != null) {
            if (appended instanceof ElseExecutableBlock) {
                return null;
            }
            current = appended;
            appended = current.getAppendedBlock();
        }
        return current;
    }

    protected boolean canEditEntry(@Nullable ExecutableEntry entry) {
        if (entry == null || entry.executable instanceof ElseExecutableBlock) {
            return false;
        }
        if (entry.executable instanceof FolderExecutableBlock) {
            return false;
        }
        Executable executable = entry.executable;
        if (executable instanceof ActionInstance) {
            ActionInstance i = (ActionInstance)executable;
            if (!i.action.hasValue()) {
                return false;
            }
        }
        return true;
    }

    protected boolean deleteSelectedEntryDirectly() {
        ExecutableEntry selected = this.getSelectedEntry();
        if (selected == null) {
            return false;
        }
        Executable nextExecutable = null;
        List<ScrollAreaEntry> currentEntries = this.scriptEntriesScrollArea.getEntries();
        int selectedIndex = currentEntries.indexOf(selected);
        if (selectedIndex != -1) {
            ExecutableEntry ee;
            ScrollAreaEntry entry;
            int i;
            for (i = selectedIndex + 1; i < currentEntries.size(); ++i) {
                entry = currentEntries.get(i);
                if (!(entry instanceof ExecutableEntry) || (ee = (ExecutableEntry)entry) == selected) continue;
                nextExecutable = ee.executable;
                break;
            }
            if (nextExecutable == null) {
                for (i = selectedIndex - 1; i >= 0; --i) {
                    entry = currentEntries.get(i);
                    if (!(entry instanceof ExecutableEntry) || (ee = (ExecutableEntry)entry) == selected) continue;
                    nextExecutable = ee.executable;
                    break;
                }
            }
        }
        this.createUndoPoint();
        if (selected.appendParent != null) {
            selected.appendParent.setAppendedBlock(null);
        }
        selected.getParentBlock().getExecutables().remove(selected.executable);
        this.updateActionInstanceScrollArea(true);
        if (nextExecutable != null) {
            this.focusEntryForExecutable(nextExecutable, true);
        }
        return true;
    }

    protected boolean copySelectedAction() {
        Executable executable;
        ExecutableEntry selected = this.getSelectedEntry();
        if (selected == null || !((executable = selected.executable) instanceof ActionInstance)) {
            return false;
        }
        ActionInstance instance = (ActionInstance)executable;
        this.clipboardActionInstance = instance.copy(true);
        return true;
    }

    protected boolean pasteCopiedAction(@Nullable ExecutableEntry selectionReference) {
        if (this.clipboardActionInstance == null) {
            return false;
        }
        ActionInstance instance = this.clipboardActionInstance.copy(true);
        this.finalizeActionAddition(instance, selectionReference);
        return true;
    }

    protected boolean moveSelectedEntry(boolean moveUp) {
        ExecutableEntry selected = this.getSelectedEntry();
        if (selected == null) {
            return false;
        }
        this.handleContextMenuMove(selected, moveUp);
        return true;
    }

    protected boolean selectAdjacentEntry(boolean moveDown) {
        int targetIndex;
        List<ScrollAreaEntry> entries = this.scriptEntriesScrollArea.getEntries();
        if (entries.isEmpty()) {
            return false;
        }
        ExecutableEntry selected = this.getSelectedEntry();
        if (selected == null) {
            targetIndex = moveDown ? 0 : entries.size() - 1;
        } else {
            int currentIndex = entries.indexOf(selected);
            if (currentIndex == -1) {
                return false;
            }
            int desiredIndex = currentIndex + (moveDown ? 1 : -1);
            if ((desiredIndex = Mth.m_14045_((int)desiredIndex, (int)0, (int)(entries.size() - 1))) == currentIndex) {
                return false;
            }
            targetIndex = desiredIndex;
        }
        ScrollAreaEntry target = entries.get(targetIndex);
        if (target instanceof ExecutableEntry) {
            ExecutableEntry entry = (ExecutableEntry)target;
            entry.setSelected(true);
            this.scrollEntryIntoView(entry);
            return true;
        }
        return false;
    }

    public boolean isUserNavigatingInRightClickContextMenu() {
        return this.rightClickContextMenu != null && this.rightClickContextMenu.isUserNavigatingInMenu();
    }

    private boolean canUndo() {
        return !this.undoHistory.isEmpty();
    }

    private boolean canRedo() {
        return !this.redoHistory.isEmpty();
    }

    private boolean undo() {
        if (!this.canUndo()) {
            return false;
        }
        ScriptSnapshot snapshot = this.undoHistory.pop();
        this.redoHistory.push(this.captureCurrentState());
        this.trimHistory(this.redoHistory);
        this.applySnapshot(snapshot);
        return true;
    }

    private boolean redo() {
        if (!this.canRedo()) {
            return false;
        }
        ScriptSnapshot snapshot = this.redoHistory.pop();
        this.undoHistory.push(this.captureCurrentState());
        this.trimHistory(this.undoHistory);
        this.applySnapshot(snapshot);
        return true;
    }

    private void createUndoPoint() {
        if (this.suppressHistoryCapture) {
            return;
        }
        ScriptSnapshot snapshot = this.captureCurrentState();
        this.undoHistory.push(snapshot);
        this.trimHistory(this.undoHistory);
        this.redoHistory.clear();
    }

    private void trimHistory(@NotNull Deque<ScriptSnapshot> history) {
        while (history.size() > 100) {
            history.removeLast();
        }
    }

    @NotNull
    private ScriptSnapshot captureCurrentState() {
        GenericExecutableBlock snapshotBlock = this.executableBlock.copy(false);
        float verticalScroll = this.scriptEntriesScrollArea.verticalScrollBar.getScroll();
        float horizontalScroll = this.scriptEntriesScrollArea.horizontalScrollBar.getScroll();
        ExecutableEntry selected = this.getSelectedEntry();
        String selectedId = selected != null ? selected.executable.getIdentifier() : null;
        String targetId = this.contextMenuTargetExecutable != null ? this.contextMenuTargetExecutable.getIdentifier() : null;
        return new ScriptSnapshot(snapshotBlock, verticalScroll, horizontalScroll, selectedId, targetId);
    }

    private void applySnapshot(@NotNull ScriptSnapshot snapshot) {
        this.suppressHistoryCapture = true;
        try {
            Executable executable;
            this.executableBlock = snapshot.block.copy(false);
            this.updateActionInstanceScrollArea(false);
            this.scriptEntriesScrollArea.verticalScrollBar.setScroll(Mth.m_14036_((float)snapshot.verticalScroll, (float)0.0f, (float)1.0f));
            this.scriptEntriesScrollArea.horizontalScrollBar.setScroll(Mth.m_14036_((float)snapshot.horizontalScroll, (float)0.0f, (float)1.0f));
            this.scriptEntriesScrollArea.updateEntries(null);
            if (snapshot.selectedExecutableId != null && (executable = this.findExecutableByIdentifier(this.executableBlock, snapshot.selectedExecutableId)) != null) {
                this.focusEntryForExecutable(executable, true, false);
            }
            this.contextMenuTargetExecutable = snapshot.contextMenuTargetExecutableId != null ? this.findExecutableByIdentifier(this.executableBlock, snapshot.contextMenuTargetExecutableId) : null;
        }
        finally {
            this.suppressHistoryCapture = false;
        }
    }

    public class ExecutableEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public static final int INDENT_X_OFFSET = 20;
        public static final int STATEMENT_CONTENT_OFFSET = 4;
        private static final int COLLAPSE_TOGGLE_SIZE = 8;
        @NotNull
        public Executable executable;
        @Nullable
        public AbstractExecutableBlock parentBlock;
        @Nullable
        public AbstractExecutableBlock appendParent;
        public final int lineHeight;
        public Font font;
        public int indentLevel;
        public boolean leftMouseDownDragging;
        public double leftMouseDownDraggingPosX;
        public double leftMouseDownDraggingPosY;
        public boolean dragging;
        private String cachedThemeIdentifier;
        private MutableComponent displayNameComponent;
        private MutableComponent valueComponent;
        @Nullable
        private MutableComponent folderLabelComponent;
        @Nullable
        private MutableComponent folderNameComponent;
        @Nullable
        private MutableComponent folderCollapsedSuffixComponent;
        @Nullable
        private MutableComponent valueLabelComponent;
        @Nullable
        private MutableComponent valueOnlyComponent;
        private long lastValueClickTime;
        private long lastNameClickTime;

        public ExecutableEntry(@NotNull ScrollArea parentScrollArea, Executable executable, int lineHeight, int indentLevel) {
            super(parentScrollArea, 100, 30);
            this.font = Minecraft.m_91087_().f_91062_;
            this.leftMouseDownDragging = false;
            this.leftMouseDownDraggingPosX = 0.0;
            this.leftMouseDownDraggingPosY = 0.0;
            this.dragging = false;
            this.cachedThemeIdentifier = "";
            this.lastValueClickTime = 0L;
            this.lastNameClickTime = 0L;
            this.setPlayClickSound(false);
            this.executable = executable;
            this.lineHeight = lineHeight;
            this.indentLevel = indentLevel;
            this.rebuildComponents();
            this.applyThemeBackground(true);
            this.setWidth(this.calculateWidth());
            if (this.executable instanceof AbstractExecutableBlock) {
                this.setHeight(lineHeight + 6);
            } else {
                this.setHeight(lineHeight * 2 + 6);
            }
        }

        private void applyThemeBackground(boolean force) {
            UIColorTheme theme = UIBase.getUIColorTheme();
            String themeIdentifier = theme.getIdentifier();
            if (!force && themeIdentifier.equals(this.cachedThemeIdentifier)) {
                return;
            }
            this.cachedThemeIdentifier = themeIdentifier;
            this.rebuildComponents();
            Color idle = theme.actions_entry_background_color_action.getColor();
            Color hover = theme.actions_entry_background_color_action_hover.getColor();
            if (this.executable instanceof IfExecutableBlock) {
                idle = theme.actions_entry_background_color_if.getColor();
                hover = theme.actions_entry_background_color_if_hover.getColor();
            } else if (this.executable instanceof ElseIfExecutableBlock) {
                idle = theme.actions_entry_background_color_else_if.getColor();
                hover = theme.actions_entry_background_color_else_if_hover.getColor();
            } else if (this.executable instanceof ElseExecutableBlock) {
                idle = theme.actions_entry_background_color_else.getColor();
                hover = theme.actions_entry_background_color_else_hover.getColor();
            } else if (this.executable instanceof WhileExecutableBlock) {
                idle = theme.actions_entry_background_color_while.getColor();
                hover = theme.actions_entry_background_color_while_hover.getColor();
            } else if (this.executable instanceof FolderExecutableBlock) {
                idle = theme.actions_entry_background_color_folder.getColor();
                hover = theme.actions_entry_background_color_folder_hover.getColor();
            } else if (this.executable instanceof AbstractExecutableBlock) {
                idle = theme.actions_entry_background_color_generic_block.getColor();
                hover = theme.actions_entry_background_color_generic_block_hover.getColor();
            }
            this.setBackgroundColorIdle(idle);
            this.setBackgroundColorHover(hover);
        }

        private void rebuildComponents() {
            UIColorTheme theme = UIBase.getUIColorTheme();
            this.folderLabelComponent = null;
            this.folderNameComponent = null;
            this.folderCollapsedSuffixComponent = null;
            this.valueLabelComponent = null;
            this.valueOnlyComponent = null;
            Executable executable = this.executable;
            if (executable instanceof ActionInstance) {
                ActionInstance i = (ActionInstance)executable;
                this.displayNameComponent = i.action.getActionDisplayName().m_6881_().m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                this.updateValueComponent();
            } else {
                executable = this.executable;
                if (executable instanceof IfExecutableBlock) {
                    IfExecutableBlock b = (IfExecutableBlock)executable;
                    requirements = "";
                    for (LoadingRequirementGroup g : b.condition.getGroups()) {
                        if (!((String)requirements).isEmpty()) {
                            requirements = (String)requirements + ", ";
                        }
                        requirements = (String)requirements + g.identifier;
                    }
                    for (LoadingRequirementInstance i : b.condition.getInstances()) {
                        if (!((String)requirements).isEmpty()) {
                            requirements = (String)requirements + ", ";
                        }
                        requirements = (String)requirements + i.requirement.getDisplayName();
                    }
                    MutableComponent display = Component.m_237110_((String)"fancymenu.actions.blocks.if", (Object[])new Object[]{Component.m_237113_((String)requirements)}).m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                    if (b.isCollapsed()) {
                        display = display.m_7220_((Component)this.createCollapsedSuffixComponent(theme));
                    }
                    this.displayNameComponent = display;
                    this.valueComponent = Component.m_237119_();
                } else {
                    requirements = this.executable;
                    if (requirements instanceof ElseIfExecutableBlock) {
                        ElseIfExecutableBlock b = (ElseIfExecutableBlock)requirements;
                        requirements = "";
                        for (LoadingRequirementGroup g : b.condition.getGroups()) {
                            if (!((String)requirements).isEmpty()) {
                                requirements = (String)requirements + ", ";
                            }
                            requirements = (String)requirements + g.identifier;
                        }
                        for (LoadingRequirementInstance i : b.condition.getInstances()) {
                            if (!((String)requirements).isEmpty()) {
                                requirements = (String)requirements + ", ";
                            }
                            requirements = (String)requirements + i.requirement.getDisplayName();
                        }
                        this.displayNameComponent = Component.m_237110_((String)"fancymenu.actions.blocks.else_if", (Object[])new Object[]{Component.m_237113_((String)requirements)}).m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                        this.valueComponent = Component.m_237119_();
                    } else if (this.executable instanceof ElseExecutableBlock) {
                        this.displayNameComponent = Component.m_237115_((String)"fancymenu.actions.blocks.else").m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                        this.valueComponent = Component.m_237119_();
                    } else {
                        requirements = this.executable;
                        if (requirements instanceof WhileExecutableBlock) {
                            WhileExecutableBlock b = (WhileExecutableBlock)requirements;
                            requirements = "";
                            for (LoadingRequirementGroup g : b.condition.getGroups()) {
                                if (!((String)requirements).isEmpty()) {
                                    requirements = (String)requirements + ", ";
                                }
                                requirements = (String)requirements + g.identifier;
                            }
                            for (LoadingRequirementInstance i : b.condition.getInstances()) {
                                if (!((String)requirements).isEmpty()) {
                                    requirements = (String)requirements + ", ";
                                }
                                requirements = (String)requirements + i.requirement.getDisplayName();
                            }
                            Iterator<ValuePlaceholderHolder> display = Component.m_237110_((String)"fancymenu.actions.blocks.while", (Object[])new Object[]{Component.m_237113_((String)requirements)}).m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                            if (b.isCollapsed()) {
                                display = display.m_7220_((Component)this.createCollapsedSuffixComponent(theme));
                            }
                            this.displayNameComponent = display;
                            this.valueComponent = Component.m_237119_();
                        } else {
                            requirements = this.executable;
                            if (requirements instanceof FolderExecutableBlock) {
                                FolderExecutableBlock folder = (FolderExecutableBlock)requirements;
                                MutableComponent labelComponent = Component.m_237113_((String)I18n.m_118938_((String)"fancymenu.actions.blocks.folder.display", (Object[])new Object[]{""})).m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                                MutableComponent nameComponent = Component.m_237113_((String)folder.getName()).m_6270_(Style.f_131099_.m_178520_(theme.element_label_color_normal.getColorInt()));
                                this.folderLabelComponent = labelComponent;
                                this.folderNameComponent = nameComponent;
                                MutableComponent display = labelComponent.m_6881_().m_7220_((Component)nameComponent.m_6881_());
                                if (folder.isCollapsed()) {
                                    MutableComponent collapsedComponent;
                                    this.folderCollapsedSuffixComponent = collapsedComponent = this.createCollapsedSuffixComponent(theme);
                                    display = display.m_7220_((Component)collapsedComponent.m_6881_());
                                }
                                this.displayNameComponent = display;
                                this.valueComponent = Component.m_237119_();
                            } else {
                                this.displayNameComponent = Component.m_237113_((String)"[UNKNOWN EXECUTABLE]").m_130940_(ChatFormatting.RED);
                                this.valueComponent = Component.m_237119_();
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void setSelected(boolean selected) {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu() && !ActionScriptEditorScreen.this.contextMenuSelectionOverrideActive) {
                return;
            }
            super.setSelected(selected);
        }

        public void forceSetSelected(boolean selected) {
            super.setSelected(selected);
        }

        @Override
        public boolean isHovered() {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                return false;
            }
            return super.isHovered();
        }

        @Override
        public void updateEntry() {
            super.updateEntry();
            if (!this.isSelected() && ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorIdle, this.backgroundColorIdle, this.backgroundColorIdle, 1);
            }
        }

        @Override
        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
            this.renderInternal(graphics, mouseX, mouseY, partial, true);
        }

        public void renderThumbnail(@NotNull GuiGraphics graphics) {
            this.renderInternal(graphics, Integer.MIN_VALUE, Integer.MIN_VALUE, 0.0f, false);
        }

        private void renderInternal(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial, boolean interactive) {
            this.applyThemeBackground(false);
            if (interactive) {
                this.handleDragging();
            }
            super.m_88315_(graphics, mouseX, mouseY, partial);
            this.renderEntryDecorations(graphics);
        }

        private void renderEntryDecorations(@NotNull GuiGraphics graphics) {
            RenderSystem.enableBlend();
            List<ExecutableEntry> chainAnchors = ActionScriptEditorScreen.this.getChainAnchorsFor(this);
            for (ExecutableEntry anchorEntry : chainAnchors) {
                List<ExecutableEntry> chainEntries = ActionScriptEditorScreen.this.getStatementChainOf(anchorEntry);
                if (chainEntries.size() <= 1) continue;
                Color chainColor = ActionScriptEditorScreen.this.getChainIndicatorColorFor(anchorEntry);
                this.renderChainColumn(graphics, chainColor, anchorEntry);
            }
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            int renderX = this.getX() + 20 * this.indentLevel + this.getContentOffset();
            UIColorTheme theme = UIBase.getUIColorTheme();
            Executable executable = this.executable;
            if (executable instanceof FolderExecutableBlock) {
                FolderExecutableBlock folder = (FolderExecutableBlock)executable;
                int toggleX = renderX + 5;
                int toggleY = centerYLine1 - 4;
                this.renderCollapseToggle(graphics, toggleX, toggleY, folder.isCollapsed());
                int textX = toggleX + 8 + 3;
                Objects.requireNonNull(this.font);
                int textY = centerYLine1 - 9 / 2;
                if (ActionScriptEditorScreen.this.inlineNameEntry != this) {
                    graphics.m_280614_(this.font, (Component)this.displayNameComponent, textX, textY, -1, false);
                } else {
                    if (this.folderLabelComponent != null) {
                        graphics.m_280614_(this.font, (Component)this.folderLabelComponent, textX, textY, -1, false);
                    }
                    if (ActionScriptEditorScreen.this.inlineNameEditBox != null && this.folderCollapsedSuffixComponent != null) {
                        int suffixX = ActionScriptEditorScreen.this.inlineNameEditBox.m_252754_() + ActionScriptEditorScreen.this.inlineNameEditBox.m_5711_() + 2;
                        graphics.m_280614_(this.font, (Component)this.folderCollapsedSuffixComponent, suffixX, textY, -1, false);
                    }
                }
            } else {
                Executable toggleX = this.executable;
                if (toggleX instanceof IfExecutableBlock) {
                    IfExecutableBlock ifBlock = (IfExecutableBlock)toggleX;
                    int toggleX2 = renderX + 5;
                    int toggleY = centerYLine1 - 4;
                    this.renderCollapseToggle(graphics, toggleX2, toggleY, ifBlock.isCollapsed());
                    int textX = toggleX2 + 8 + 3;
                    Objects.requireNonNull(this.font);
                    int textY = centerYLine1 - 9 / 2;
                    graphics.m_280614_(this.font, (Component)this.displayNameComponent, textX, textY, -1, false);
                } else {
                    toggleX = this.executable;
                    if (toggleX instanceof WhileExecutableBlock) {
                        WhileExecutableBlock whileBlock = (WhileExecutableBlock)toggleX;
                        int toggleX3 = renderX + 5;
                        int toggleY = centerYLine1 - 4;
                        this.renderCollapseToggle(graphics, toggleX3, toggleY, whileBlock.isCollapsed());
                        int textX = toggleX3 + 8 + 3;
                        Objects.requireNonNull(this.font);
                        int textY = centerYLine1 - 9 / 2;
                        graphics.m_280614_(this.font, (Component)this.displayNameComponent, textX, textY, -1, false);
                    } else if (this.executable instanceof ElseIfExecutableBlock) {
                        int indicatorX = renderX + 5;
                        int indicatorY = centerYLine1 - 4;
                        this.renderStatementBadge(graphics, indicatorX, indicatorY, theme.listing_dot_color_2.getColor());
                        int textX = indicatorX + 8 + 3;
                        Objects.requireNonNull(this.font);
                        int textY = centerYLine1 - 9 / 2;
                        graphics.m_280614_(this.font, (Component)this.displayNameComponent, textX, textY, -1, false);
                    } else if (this.executable instanceof ElseExecutableBlock) {
                        int indicatorX = renderX + 5;
                        int indicatorY = centerYLine1 - 4;
                        this.renderStatementBadge(graphics, indicatorX, indicatorY, theme.listing_dot_color_2.getColor());
                        int textX = indicatorX + 8 + 3;
                        Objects.requireNonNull(this.font);
                        int textY = centerYLine1 - 9 / 2;
                        graphics.m_280614_(this.font, (Component)this.displayNameComponent, textX, textY, -1, false);
                    } else if (this.executable instanceof ActionInstance) {
                        UIBase.renderListingDot(graphics, renderX + 5, centerYLine1 - 2, theme.listing_dot_color_2.getColor());
                        Objects.requireNonNull(this.font);
                        graphics.m_280614_(this.font, (Component)this.displayNameComponent, renderX + 5 + 4 + 3, centerYLine1 - 9 / 2, -1, false);
                        UIBase.renderListingDot(graphics, renderX + 5 + 4 + 3, centerYLine2 - 2, theme.listing_dot_color_1.getColor());
                        int valueTextX = renderX + 5 + 4 + 3 + 4 + 3;
                        Objects.requireNonNull(this.font);
                        int valueTextY = centerYLine2 - 9 / 2;
                        if (ActionScriptEditorScreen.this.inlineValueEntry != this) {
                            graphics.m_280614_(this.font, (Component)this.valueComponent, valueTextX, valueTextY, -1, false);
                        } else if (this.valueLabelComponent != null) {
                            graphics.m_280614_(this.font, (Component)this.valueLabelComponent, valueTextX, valueTextY, -1, false);
                        }
                    } else {
                        UIBase.renderListingDot(graphics, renderX + 5, centerYLine1 - 2, theme.warning_text_color.getColor());
                        Objects.requireNonNull(this.font);
                        graphics.m_280614_(this.font, (Component)this.displayNameComponent, renderX + 5 + 4 + 3, centerYLine1 - 9 / 2, -1, false);
                    }
                }
            }
        }

        private void renderChainColumn(@NotNull GuiGraphics graphics, @NotNull Color color, @NotNull ExecutableEntry anchorEntry) {
            int barX = ActionScriptEditorScreen.this.getChainBarX(anchorEntry);
            int barTop = this.getY() + 1;
            int barBottom = this.getY() + this.getHeight() - 1;
            if (barBottom <= barTop) {
                barBottom = barTop + 1;
            }
            graphics.m_280509_(barX, barTop, barX + 3, barBottom, color.getRGB());
        }

        protected void handleDragging() {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                return;
            }
            if (!MouseInput.isLeftMouseDown()) {
                ExecutableEntry hover;
                if (this.dragging && (hover = ActionScriptEditorScreen.this.renderTickDragHoveredEntry) != null && ActionScriptEditorScreen.this.renderTickDraggedEntry == this) {
                    ActionScriptEditorScreen.this.moveAfter(this, hover);
                }
                this.leftMouseDownDragging = false;
                this.dragging = false;
            }
            if (this.leftMouseDownDragging && (this.leftMouseDownDraggingPosX != (double)MouseInput.getMouseX() || this.leftMouseDownDraggingPosY != (double)MouseInput.getMouseY()) && (!(this.executable instanceof AbstractExecutableBlock) || this.executable instanceof IfExecutableBlock || this.executable instanceof WhileExecutableBlock || this.executable instanceof FolderExecutableBlock)) {
                this.dragging = true;
            }
        }

        private int getContentOffset() {
            if (this.executable instanceof AbstractExecutableBlock) {
                return 4;
            }
            return 0;
        }

        @NotNull
        public AbstractExecutableBlock getParentBlock() {
            if (this.parentBlock == null) {
                return ActionScriptEditorScreen.this.executableBlock;
            }
            return this.parentBlock;
        }

        private int calculateWidth() {
            if (this.executable instanceof FolderExecutableBlock || this.executable instanceof IfExecutableBlock || this.executable instanceof WhileExecutableBlock || this.executable instanceof ElseIfExecutableBlock || this.executable instanceof ElseExecutableBlock) {
                int textWidth = this.font.m_92852_((FormattedText)this.displayNameComponent);
                w = 16 + textWidth + 5;
            } else {
                int w1 = 12 + this.font.m_92852_((FormattedText)this.displayNameComponent) + 5;
                int w2 = 19 + this.font.m_92852_((FormattedText)this.valueComponent) + 5;
                w = Math.max(w1, w2);
            }
            w += 20 * this.indentLevel;
            return w += this.getContentOffset();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean canInlineEditValue() {
            Executable executable = this.executable;
            if (!(executable instanceof ActionInstance)) return false;
            ActionInstance i = (ActionInstance)executable;
            if (!i.action.hasValue()) return false;
            return true;
        }

        protected boolean isMouseOverValue(int mouseX, int mouseY) {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                return false;
            }
            if (!this.canInlineEditValue()) {
                return false;
            }
            int valueX = this.getValueFieldX();
            int valueY = this.getValueFieldY();
            Objects.requireNonNull(this.font);
            int height = 9;
            int width = this.valueOnlyComponent != null ? this.font.m_92852_((FormattedText)this.valueOnlyComponent) : 0;
            return UIBase.isXYInArea(mouseX, mouseY, valueX, valueY, Math.max(width, 6), height);
        }

        protected boolean registerValueClick(int mouseX, int mouseY) {
            if (!this.isMouseOverValue(mouseX, mouseY)) {
                this.lastValueClickTime = 0L;
                return false;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastValueClickTime <= 500L) {
                this.lastValueClickTime = 0L;
                return true;
            }
            this.lastValueClickTime = now;
            return false;
        }

        protected void resetValueClickTimer() {
            this.lastValueClickTime = 0L;
        }

        protected boolean canInlineEditName() {
            return this.executable instanceof FolderExecutableBlock;
        }

        protected boolean isMouseOverName(int mouseX, int mouseY) {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                return false;
            }
            if (!this.canInlineEditName()) {
                return false;
            }
            int nameX = this.getNameFieldX();
            int nameY = this.getNameFieldY();
            Objects.requireNonNull(this.font);
            int height = 9;
            int width = this.folderNameComponent != null ? this.font.m_92852_((FormattedText)this.folderNameComponent) : 0;
            return UIBase.isXYInArea(mouseX, mouseY, nameX, nameY, Math.max(width, 6), height);
        }

        protected boolean registerNameClick(int mouseX, int mouseY) {
            if (!this.isMouseOverName(mouseX, mouseY)) {
                this.lastNameClickTime = 0L;
                return false;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastNameClickTime <= 500L) {
                this.lastNameClickTime = 0L;
                return true;
            }
            this.lastNameClickTime = now;
            return false;
        }

        protected void resetNameClickTimer() {
            this.lastNameClickTime = 0L;
        }

        protected int getNameFieldX() {
            int baseX = this.getX() + 20 * this.indentLevel + this.getContentOffset();
            int nameX = baseX + 5 + 8 + 3;
            if (this.folderLabelComponent != null) {
                nameX += this.font.m_92852_((FormattedText)this.folderLabelComponent);
            }
            return nameX;
        }

        protected int getNameFieldY() {
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            Objects.requireNonNull(this.font);
            return centerYLine1 - 9 / 2;
        }

        protected int getNameFieldAvailableWidth() {
            ScrollArea scrollArea = ActionScriptEditorScreen.this.scriptEntriesScrollArea;
            int visibleRight = scrollArea.getInnerX() + scrollArea.getInnerWidth() - 5;
            return Math.max(1, visibleRight - this.getNameFieldX());
        }

        protected int getValueFieldX() {
            int baseX = this.getX() + 20 * this.indentLevel + this.getContentOffset();
            int valueX = baseX + 5 + 4 + 3 + 4 + 3;
            if (this.valueLabelComponent != null) {
                valueX += this.font.m_92852_((FormattedText)this.valueLabelComponent);
            }
            return valueX;
        }

        protected int getValueFieldY() {
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            Objects.requireNonNull(this.font);
            return centerYLine2 - 9 / 2;
        }

        protected int getValueFieldAvailableWidth() {
            int valueX = this.getValueFieldX();
            ScrollArea scrollArea = ActionScriptEditorScreen.this.scriptEntriesScrollArea;
            int visibleRight = scrollArea.getInnerX() + scrollArea.getInnerWidth() - 5;
            int available = visibleRight - valueX;
            return Math.max(1, available);
        }

        protected boolean canToggleCollapse() {
            return this.executable instanceof FolderExecutableBlock || this.executable instanceof IfExecutableBlock || this.executable instanceof WhileExecutableBlock;
        }

        protected boolean isMouseOverCollapseToggle(int mouseX, int mouseY) {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                return false;
            }
            if (!this.canToggleCollapse()) {
                return false;
            }
            int toggleX = this.getCollapseToggleX();
            int toggleY = this.getCollapseToggleY();
            return UIBase.isXYInArea(mouseX, mouseY, toggleX, toggleY, 8, 8);
        }

        private int getCollapseToggleX() {
            int baseX = this.getX() + 20 * this.indentLevel + this.getContentOffset();
            return baseX + 5;
        }

        private int getCollapseToggleY() {
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            return centerYLine1 - 4;
        }

        protected void toggleCollapsed() {
            boolean toggled = false;
            Executable executable = this.executable;
            if (executable instanceof FolderExecutableBlock) {
                FolderExecutableBlock folder;
                folder.setCollapsed(!(folder = (FolderExecutableBlock)executable).isCollapsed());
                toggled = true;
            } else {
                executable = this.executable;
                if (executable instanceof IfExecutableBlock) {
                    IfExecutableBlock ifBlock;
                    ifBlock.setCollapsed(!(ifBlock = (IfExecutableBlock)executable).isCollapsed());
                    toggled = true;
                } else {
                    executable = this.executable;
                    if (executable instanceof WhileExecutableBlock) {
                        WhileExecutableBlock whileBlock;
                        whileBlock.setCollapsed(!(whileBlock = (WhileExecutableBlock)executable).isCollapsed());
                        toggled = true;
                    }
                }
            }
            if (toggled) {
                this.rebuildComponents();
                this.setWidth(this.calculateWidth());
            }
        }

        private void renderCollapseToggle(@NotNull GuiGraphics graphics, int x, int y, boolean collapsed) {
            UIColorTheme theme = UIBase.getUIColorTheme();
            int size = 8;
            Color background = theme.actions_entry_background_color_generic_block.getColor();
            graphics.m_280509_(x, y, x + size, y + size, background.getRGB());
            UIBase.renderBorder(graphics, x, y, x + size, y + size, 1, theme.actions_chain_indicator_color, true, true, true, true);
            int midY = y + size / 2;
            graphics.m_280509_(x + 2, midY - 1, x + size - 2, midY + 1, theme.description_area_text_color.getColorInt());
            if (collapsed) {
                int midX = x + size / 2;
                graphics.m_280509_(midX - 1, y + 2, midX + 1, y + size - 2, theme.description_area_text_color.getColorInt());
            }
        }

        private void renderStatementBadge(@NotNull GuiGraphics graphics, int x, int y, @NotNull Color fillColor) {
            UIColorTheme theme = UIBase.getUIColorTheme();
            int size = 8;
            Color background = theme.actions_entry_background_color_generic_block.getColor();
            graphics.m_280509_(x, y, x + size, y + size, background.getRGB());
            UIBase.renderBorder(graphics, x, y, x + size, y + size, 1, theme.actions_chain_indicator_color, true, true, true, true);
            int inset = 3;
            graphics.m_280509_(x + inset, y + inset, x + size - inset, y + size - inset, fillColor.getRGB());
        }

        private MutableComponent createCollapsedSuffixComponent(@NotNull UIColorTheme theme) {
            return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"fancymenu.actions.blocks.folder.collapsed").m_6270_(Style.f_131099_.m_178520_(theme.warning_text_color.getColorInt())));
        }

        protected void updateValueComponent() {
            this.valueLabelComponent = null;
            this.valueOnlyComponent = null;
            Executable executable = this.executable;
            if (executable instanceof ActionInstance) {
                ActionInstance i = (ActionInstance)executable;
                UIColorTheme theme = UIBase.getUIColorTheme();
                String cachedValue = i.value;
                boolean hasValue = i.action.hasValue();
                String valueString = cachedValue != null && hasValue ? cachedValue : I18n.m_118938_((String)"fancymenu.actions.screens.manage_screen.info.value.none", (Object[])new Object[0]);
                MutableComponent label = Component.m_237113_((String)(I18n.m_118938_((String)"fancymenu.actions.screens.manage_screen.info.value", (Object[])new Object[0]) + " ")).m_6270_(Style.f_131099_.m_178520_(theme.description_area_text_color.getColorInt()));
                MutableComponent value = Component.m_237113_((String)valueString).m_6270_(Style.f_131099_.m_178520_(theme.element_label_color_normal.getColorInt()));
                this.valueLabelComponent = label;
                this.valueOnlyComponent = value;
                this.valueComponent = label.m_6881_().m_7220_((Component)value.m_6881_());
            } else {
                this.valueComponent = Component.m_237119_();
            }
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
            if (ActionScriptEditorScreen.this.isUserNavigatingInRightClickContextMenu()) {
                return;
            }
            if (this.parent.getEntries().contains(this)) {
                this.leftMouseDownDragging = true;
                this.leftMouseDownDraggingPosX = MouseInput.getMouseX();
                this.leftMouseDownDraggingPosY = MouseInput.getMouseY();
            }
        }
    }

    protected class FavoriteAwareActionEntry
    extends ContextMenu.ClickableContextMenuEntry<FavoriteAwareActionEntry> {
        @NotNull
        private final Action action;

        protected FavoriteAwareActionEntry(@NotNull ContextMenu parent, Action action) {
            super("action_" + action.getIdentifier(), parent, (Component)ActionScriptEditorScreen.this.buildActionMenuLabel(action), (menu, entry) -> {
                ActionScriptEditorScreen.this.markContextMenuActionSelectionSuppressed();
                ExecutableEntry selectionReference = ActionScriptEditorScreen.this.getContextMenuTargetEntry();
                menu.closeMenu();
                ActionScriptEditorScreen.this.onAddAction(action, selectionReference);
            });
            this.action = action;
            this.setLabelSupplier((menu, entry) -> ActionScriptEditorScreen.this.buildActionMenuLabel(action));
            this.setTooltipSupplier((menu, entry) -> ActionScriptEditorScreen.this.createActionTooltip(action, ActionScriptEditorScreen.this.isFavorite(action)));
            this.updateFavoriteIcon();
        }

        private void updateFavoriteIcon() {
            if (ActionScriptEditorScreen.this.isFavorite(this.action)) {
                this.setIcon(ContextMenu.IconFactory.getIcon("favorite"));
            } else {
                this.setIcon(null);
            }
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button == 1 && this.isHovered() && this.isActive() && !this.parent.isSubMenuHovered() && !this.tooltipIconHovered && !ActionScriptEditorScreen.this.actionsMenuRightClickConsumedByEntry) {
                ActionScriptEditorScreen.this.toggleFavorite(this.action);
                ActionScriptEditorScreen.this.actionsMenuRightClickConsumedByEntry = true;
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    protected static final class MinimapEntrySegment {
        protected final ExecutableEntry entry;
        protected final int x;
        protected final int y;
        protected final int width;
        protected final int height;

        protected MinimapEntrySegment(@NotNull ExecutableEntry entry, int x, int y, int width, int height) {
            this.entry = entry;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    private record MoveTarget(AbstractExecutableBlock parent, int index) {
    }

    private static final class ScriptSnapshot {
        private final GenericExecutableBlock block;
        private final float verticalScroll;
        private final float horizontalScroll;
        @Nullable
        private final String selectedExecutableId;
        @Nullable
        private final String contextMenuTargetExecutableId;

        private ScriptSnapshot(@NotNull GenericExecutableBlock block, float verticalScroll, float horizontalScroll, @Nullable String selectedExecutableId, @Nullable String contextMenuTargetExecutableId) {
            this.block = block;
            this.verticalScroll = verticalScroll;
            this.horizontalScroll = horizontalScroll;
            this.selectedExecutableId = selectedExecutableId;
            this.contextMenuTargetExecutableId = contextMenuTargetExecutableId;
        }
    }
}

