/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization;

import de.keksuccino.fancymenu.Compat;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomizationEvents;
import de.keksuccino.fancymenu.customization.action.actions.Actions;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.MenuBackgrounds;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementMemories;
import de.keksuccino.fancymenu.customization.element.elements.Elements;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerHandler;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.editor.widget.widgets.LayoutEditorWidgets;
import de.keksuccino.fancymenu.customization.listener.ListenerHandler;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.customization.loadingrequirement.requirements.LoadingRequirements;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.customization.panorama.PanoramaHandler;
import de.keksuccino.fancymenu.customization.placeholder.placeholders.Placeholders;
import de.keksuccino.fancymenu.customization.screen.dummyscreen.DummyScreens;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.customization.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.customization.variables.VariableHandler;
import de.keksuccino.fancymenu.customization.widget.identification.identificationcontext.contexts.WidgetIdentificationContexts;
import de.keksuccino.fancymenu.customization.world.LastWorldHandler;
import de.keksuccino.fancymenu.events.ModReloadEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenCompletedEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenStartingEvent;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinPauseScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.properties.PropertiesParser;
import de.keksuccino.fancymenu.util.properties.PropertyContainer;
import de.keksuccino.fancymenu.util.properties.PropertyContainerSet;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.theme.themes.UIColorThemes;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenCustomization {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final File CUSTOMIZABLE_MENUS_FILE = new File("config/fancymenu/customizablemenus.txt");
    private static final List<ScreenBlacklistRule> SCREEN_BLACKLIST_RULES = new ArrayList<ScreenBlacklistRule>();
    private static PropertyContainerSet customizableScreens;
    protected static boolean isCurrentScrollable;
    protected static boolean isNewMenu;
    protected static ScreenCustomizationEvents eventsInstance;
    protected static boolean screenCustomizationEnabled;
    private static boolean initialized;

    public static void init() {
        if (initialized) {
            return;
        }
        LOGGER.info("[FANCYMENU] Initializing screen customization engine! Addons should NOT REGISTER TO REGISTRIES anymore now!");
        EventHandler.INSTANCE.registerListenersOf(eventsInstance);
        ScreenCustomization.addDefaultScreenBlacklistRules();
        ElementMemories.init();
        ScreenCustomizationLayerHandler.init();
        Actions.registerAll();
        LoadingRequirements.registerAll();
        Placeholders.registerAll();
        MenuBackgrounds.registerAll();
        Elements.registerAll();
        VariableHandler.init();
        WidgetIdentificationContexts.registerAll();
        DummyScreens.registerAll();
        PanoramaHandler.init();
        SlideshowHandler.init();
        CustomGuiHandler.init();
        CustomizationOverlay.init();
        LayoutHandler.init();
        ScreenCustomization.readCustomizableScreensFromFile();
        LastWorldHandler.init();
        LayoutEditorWidgets.registerAll();
        Listeners.registerAll();
        ListenerHandler.init();
        initialized = true;
    }

    public static boolean isScreenCustomizationEnabled() {
        return screenCustomizationEnabled;
    }

    public static void setScreenCustomizationEnabled(boolean enabled) {
        screenCustomizationEnabled = enabled;
    }

    public static void setCustomizationForScreenEnabled(Screen screen, boolean enabled) {
        if (enabled) {
            ScreenCustomization.enableCustomizationForScreen(screen);
        } else {
            ScreenCustomizationLayer layer;
            ScreenCustomization.disableCustomizationForScreen(screen);
            if (screen != null && (layer = ScreenCustomizationLayerHandler.getLayerOfScreen(screen)) != null) {
                layer.layoutBase.menuBackgrounds.forEach(MenuBackground::onDisableOrRemove);
                layer.allElements.forEach(AbstractElement::onDestroyElement);
            }
        }
    }

    private static void enableCustomizationForScreen(Screen screen) {
        if (screen == null) {
            return;
        }
        if (ScreenCustomization.isScreenBlacklisted(screen)) {
            return;
        }
        if (customizableScreens == null) {
            ScreenCustomization.readCustomizableScreensFromFile();
        }
        if (screen instanceof CustomGuiBaseScreen) {
            return;
        }
        if (!ScreenCustomization.isCustomizationEnabledForScreen(screen, true)) {
            String screenClassPath = screen.getClass().getName();
            PropertyContainer sec = new PropertyContainer(screenClassPath);
            customizableScreens.putContainer(sec);
            ScreenCustomization.writeCustomizableScreensToFile();
        }
    }

    private static void disableCustomizationForScreen(Screen screen) {
        if (customizableScreens == null) {
            ScreenCustomization.readCustomizableScreensFromFile();
        }
        if (screen instanceof CustomGuiBaseScreen) {
            return;
        }
        if (screen != null) {
            String screenClassPath = screen.getClass().getName();
            ArrayList<PropertyContainer> l = new ArrayList<PropertyContainer>();
            for (PropertyContainer sec : customizableScreens.getContainers()) {
                if (sec.getType().equals(screenClassPath)) continue;
                l.add(sec);
            }
            customizableScreens = new PropertyContainerSet("customizablemenus");
            for (PropertyContainer sec : l) {
                customizableScreens.putContainer(sec);
            }
            ScreenCustomization.writeCustomizableScreensToFile();
        }
    }

    public static boolean isCustomizationEnabledForScreen(Screen screen) {
        return ScreenCustomization.isCustomizationEnabledForScreen(screen, false);
    }

    public static boolean isCustomizationEnabledForScreen(Screen screen, boolean ignoreAllowScreenCustomization) {
        PauseScreen p;
        if (screen == null) {
            return false;
        }
        if (ScreenCustomization.isScreenBlacklisted(screen)) {
            return false;
        }
        if (!screenCustomizationEnabled && !ignoreAllowScreenCustomization) {
            return false;
        }
        if (customizableScreens == null) {
            ScreenCustomization.readCustomizableScreensFromFile();
        }
        if (screen instanceof CustomGuiBaseScreen) {
            return true;
        }
        if (screen instanceof PauseScreen && !((IMixinPauseScreen)(p = (PauseScreen)screen)).get_showPauseMenu_FancyMenu()) {
            return false;
        }
        List<PropertyContainer> s = customizableScreens.getContainersOfType(screen.getClass().getName());
        return !s.isEmpty();
    }

    public static void disableCustomizationForAllScreens() {
        if (customizableScreens == null) {
            ScreenCustomization.readCustomizableScreensFromFile();
        }
        customizableScreens.getContainers().clear();
        ScreenCustomization.writeCustomizableScreensToFile();
    }

    private static void writeCustomizableScreensToFile() {
        PropertiesParser.serializeSetToFile(customizableScreens, CUSTOMIZABLE_MENUS_FILE.getPath());
    }

    public static void readCustomizableScreensFromFile() {
        try {
            PropertyContainerSet s;
            if (!CUSTOMIZABLE_MENUS_FILE.exists()) {
                CUSTOMIZABLE_MENUS_FILE.createNewFile();
                PropertiesParser.serializeSetToFile(new PropertyContainerSet("customizablemenus"), CUSTOMIZABLE_MENUS_FILE.getPath());
            }
            if ((s = PropertiesParser.deserializeSetFromFile(CUSTOMIZABLE_MENUS_FILE.getPath())) == null) {
                PropertiesParser.serializeSetToFile(new PropertyContainerSet("customizablemenus"), CUSTOMIZABLE_MENUS_FILE.getPath());
                s = PropertiesParser.deserializeSetFromFile(CUSTOMIZABLE_MENUS_FILE.getPath());
            }
            Objects.requireNonNull(s, "[FANCYMENU] Unable to read customizable menus file! PropertyContainer was NULL!");
            PropertyContainerSet s2 = new PropertyContainerSet("customizablemenus");
            for (PropertyContainer sec : s.getContainers()) {
                String identifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(sec.getType());
                if (UniversalScreenIdentifierRegistry.universalIdentifierExists(identifier)) {
                    LOGGER.error("[FANCYMENU] Found illegal universal identifier '" + identifier + "' in customizable menus file! Skipping..");
                    continue;
                }
                if (!ScreenIdentifierHandler.isValidIdentifier(identifier)) continue;
                s2.putContainer(new PropertyContainer(identifier));
            }
            customizableScreens = s2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isNewMenu() {
        return isNewMenu;
    }

    public static void setIsNewMenu(boolean b) {
        isNewMenu = b;
        ScreenCustomization.eventsInstance.lastScreen = null;
    }

    public static boolean isCurrentMenuScrollable() {
        return isCurrentScrollable;
    }

    public static void reloadCurrentScreen() {
        Screen s = Minecraft.m_91087_().f_91080_;
        if (s != null && ScreenCustomization.isCustomizationEnabledForScreen(s)) {
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(s);
            if (layer != null) {
                layer.resetLayer();
            }
            ScreenCustomization.reInitCurrentScreen();
        }
    }

    public static void reloadFancyMenu() {
        FancyMenu.reloadOptions();
        ResourceHandlers.reloadAll();
        UIColorThemes.reloadThemes();
        LayoutHandler.reloadLayouts();
        AnimationControllerHandler.stopAllAnimations();
        AnimationControllerHandler.clearMemory();
        TextEditorScreen.clearCompiledSingleLineCache();
        EventHandler.INSTANCE.postEvent(new ModReloadEvent(Minecraft.m_91087_().f_91080_));
        ScreenCustomization.reInitCurrentScreen();
    }

    public static void reInitCurrentScreen() {
        ScreenCustomization.reInitCurrentScreen(true, true);
    }

    public static void reInitCurrentScreen(boolean resetScale, boolean setScreenOnFirstInit) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            if (resetScale) {
                RenderingUtils.resetGuiScale();
            }
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenStartingEvent(Minecraft.m_91087_().f_91080_, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Pre(Minecraft.m_91087_().f_91080_, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            if (!((IMixinScreen)Minecraft.m_91087_().f_91080_).get_initialized_FancyMenu()) {
                if (setScreenOnFirstInit) {
                    Minecraft.m_91087_().m_91152_(Minecraft.m_91087_().f_91080_);
                } else {
                    Minecraft.m_91087_().f_91080_.m_6575_(Minecraft.m_91087_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
                }
            } else {
                Minecraft.m_91087_().f_91080_.m_6574_(Minecraft.m_91087_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
            }
            ScrollScreenNormalizer.normalizeScrollableScreen(Minecraft.m_91087_().f_91080_);
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenEvent.Post(Minecraft.m_91087_().f_91080_, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
            EventHandler.INSTANCE.postEvent(new InitOrResizeScreenCompletedEvent(Minecraft.m_91087_().f_91080_, InitOrResizeScreenEvent.InitializationPhase.RESIZE));
        }
    }

    public static void onSwitchingToNewScreenType(@Nullable Screen newScreen, @Nullable Screen lastScreen) {
        ScreenCustomizationLayer lastLayer;
        AnimationControllerHandler.stopAllAnimations();
        AnimationControllerHandler.clearMemory();
        if (lastScreen != null && (lastLayer = ScreenCustomizationLayerHandler.getLayerOfScreen(lastScreen)) != null) {
            lastLayer.allElements.forEach(element -> {
                if (element.loadOncePerSession) {
                    element.setHideOncePerSessionElement();
                }
            });
        }
    }

    public static void onPreGameRenderTick() {
        AnimationControllerHandler.tick();
    }

    public static void addScreenBlacklistRule(ScreenBlacklistRule rule) {
        SCREEN_BLACKLIST_RULES.add(rule);
    }

    public static List<ScreenBlacklistRule> getScreenBlacklistRules() {
        return new ArrayList<ScreenBlacklistRule>(SCREEN_BLACKLIST_RULES);
    }

    public static boolean isScreenBlacklisted(@NotNull Screen screen) {
        return ScreenCustomization.isScreenBlacklisted(screen.getClass().getName());
    }

    public static boolean isScreenBlacklisted(@NotNull String screenClassPath) {
        for (ScreenBlacklistRule rule : SCREEN_BLACKLIST_RULES) {
            if (!rule.isScreenBlacklisted(screenClassPath)) continue;
            return true;
        }
        return false;
    }

    private static void addDefaultScreenBlacklistRules() {
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("com.simibubi.create."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("de.keksuccino.panoramica."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("com.github.alexthe666.alexsmobs."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("io.github.lgatodu47.screenshot_viewer."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("twilightforest."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("net.mehvahdjukaar.supplementaries."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("net.optifine"));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("slimeknights."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("eu.midnightdust."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("net.cobrasrock.skinswapper."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.equals(VideoSettingsScreen.class.getName()) && Compat.isOptiFineLoaded());
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("de.keksuccino.fancymenu.") && !screen.equals(CustomGuiBaseScreen.class.getName()));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("blusunrize.immersiveengineering."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("net.dungeonz."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("net.spellcraftgaming.rpghud."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.contains(".cobblemon."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.contains(".mari_023."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("appeng."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.startsWith("xaero."));
        ScreenCustomization.addScreenBlacklistRule(screen -> screen.contains(".xaero."));
    }

    @Deprecated
    public static boolean isExistingGameDirectoryPath(@NotNull String path) {
        return GameDirectoryUtils.isExistingGameDirectoryPath(path);
    }

    @Deprecated
    public static String getAbsoluteGameDirectoryPath(@NotNull String path) {
        return GameDirectoryUtils.getAbsoluteGameDirectoryPath(path);
    }

    @Deprecated
    public static String getPathWithoutGameDirectory(@NotNull String path) {
        return GameDirectoryUtils.getPathWithoutGameDirectory(path);
    }

    public static String generateUniqueIdentifier() {
        return UUID.randomUUID() + "-" + System.currentTimeMillis();
    }

    static {
        isCurrentScrollable = false;
        isNewMenu = true;
        eventsInstance = new ScreenCustomizationEvents();
        screenCustomizationEnabled = true;
        initialized = false;
    }

    @FunctionalInterface
    public static interface ScreenBlacklistRule {
        public boolean isScreenBlacklisted(String var1);
    }
}

