/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.world.gen.structure;

import com.mojang.serialization.Codec;
import com.ninni.species.registry.SpeciesStructureTypes;
import com.ninni.species.server.structure.WraptorCoopGenerator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WraptorCoopStructure
extends Structure {
    public static final Codec<WraptorCoopStructure> CODEC = WraptorCoopStructure.m_226607_(WraptorCoopStructure::new);

    public WraptorCoopStructure(Structure.StructureSettings config) {
        super(config);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!WraptorCoopStructure.canGenerate(context, context.f_226628_().m_151394_(0))) {
            return Optional.empty();
        }
        return WraptorCoopStructure.m_226585_((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, collector -> this.addPieces((StructurePiecesBuilder)collector, context));
    }

    public static boolean canGenerate(Structure.GenerationContext context, BlockPos blockPos) {
        boolean flag = false;
        NoiseColumn verticalBlockSample = context.f_226622_().m_214184_(blockPos.m_123341_(), blockPos.m_123343_(), context.f_226629_(), context.f_226624_());
        for (int y = 127; y > context.f_226622_().m_6337_(); --y) {
            if (!verticalBlockSample.m_183556_(y - 1).m_60815_() || !verticalBlockSample.m_183556_(y).m_60795_() || !verticalBlockSample.m_183556_(y + 4).m_60795_()) continue;
            flag = true;
        }
        return flag;
    }

    public void addPieces(StructurePiecesBuilder collector, Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        BlockPos pos = new BlockPos(chunkPos.m_45604_(), this.getHeight(random), chunkPos.m_45605_());
        WraptorCoopGenerator.addPieces(context.f_226625_(), pos, 0, Rotation.m_221990_((RandomSource)random), (StructurePieceAccessor)collector, (RandomSource)random);
    }

    private int getHeight(WorldgenRandom random) {
        return random.m_188503_(60) + 40;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)SpeciesStructureTypes.WRAPTOR_COOP.get();
    }
}

