/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.ninni.species.registry.SpeciesBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class AlphaceneMushroomFeature
extends Feature<NoneFeatureConfiguration> {
    public AlphaceneMushroomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        BlockPos blockPos = featurePlaceContext.m_159777_();
        RandomSource random = featurePlaceContext.m_225041_();
        BlockState stemBlock = Blocks.f_50182_.m_49966_();
        BlockState mushroomBlock = ((Block)SpeciesBlocks.ALPHACENE_MUSHROOM_BLOCK.get()).m_49966_();
        ArrayList conkPoses = Lists.newArrayList();
        boolean initialFlag = world.m_8055_(blockPos.m_7495_()).m_204336_(BlockTags.f_144274_);
        if (!initialFlag) {
            return false;
        }
        Direction initialDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
        BlockPos initialSprialPos = blockPos.m_6630_(2).m_121945_(initialDirection);
        int secondLayerCount = UniformInt.m_146622_((int)6, (int)16).m_214085_(random);
        int rotatingIndex = 3;
        int baseSize = 2;
        int elevateIndex = 2;
        int primaryStemLength = 8;
        this.placeStem(primaryStemLength, secondLayerCount, world, blockPos, stemBlock, mushroomBlock);
        this.placeBaseRoof(baseSize, blockPos, world, mushroomBlock, conkPoses);
        this.placeSpiral(initialSprialPos, primaryStemLength, initialDirection, world, mushroomBlock, elevateIndex, secondLayerCount, rotatingIndex, conkPoses);
        this.placeConks(world, random, conkPoses);
        return true;
    }

    private void placeConks(WorldGenLevel worldGenLevel, RandomSource randomSource, List<BlockPos> conkPoses) {
        for (BlockPos pos : conkPoses) {
            if (!worldGenLevel.m_46859_(pos) || !worldGenLevel.m_8055_(pos.m_7494_()).m_60713_((Block)SpeciesBlocks.ALPHACENE_MUSHROOM_BLOCK.get()) || randomSource.m_188503_(10) == 0) continue;
            worldGenLevel.m_7731_(pos, ((Block)SpeciesBlocks.ALPHACENE_MUSHROOM_GROWTH.get()).m_49966_(), 2);
        }
    }

    private void placeSpiral(BlockPos initialSprialPos, int primaryStemLength, Direction initialDirection, WorldGenLevel world, BlockState mushroomBlock, int elevateIndex, int secondLayerCount, int rotatingIndex, List<BlockPos> conkPoses) {
        int i;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)initialSprialPos);
        for (i = 0; i < primaryStemLength; ++i) {
            if (i % 2 != 0) {
                initialDirection = initialDirection.m_122427_();
            }
            if (world.m_7433_((BlockPos)mutableBlockPos, DripstoneUtils::m_159664_)) {
                world.m_7731_((BlockPos)mutableBlockPos, mushroomBlock, 2);
                conkPoses.add((BlockPos)mutableBlockPos);
            }
            if (i == 7 && world.m_7433_(mutableBlockPos.m_7494_(), DripstoneUtils::m_159664_)) {
                world.m_7731_(mutableBlockPos.m_7494_(), mushroomBlock, 2);
                conkPoses.add((BlockPos)mutableBlockPos);
            }
            mutableBlockPos.m_122173_(initialDirection.m_122427_());
            if (++elevateIndex % 4 != 0) continue;
            if (world.m_7433_((BlockPos)mutableBlockPos, DripstoneUtils::m_159664_)) {
                world.m_7731_((BlockPos)mutableBlockPos, mushroomBlock, 2);
                conkPoses.add(mutableBlockPos.m_7495_());
            }
            mutableBlockPos.m_122173_(Direction.UP);
        }
        mutableBlockPos.m_122173_(Direction.UP);
        for (i = 0; i <= secondLayerCount; ++i) {
            if (rotatingIndex % 4 == 0) {
                initialDirection = initialDirection.m_122427_();
                rotatingIndex = 2;
            }
            if (i % 2 == 0 && i >= 2) {
                if (world.m_7433_((BlockPos)mutableBlockPos, DripstoneUtils::m_159664_)) {
                    world.m_7731_((BlockPos)mutableBlockPos, mushroomBlock, 2);
                    conkPoses.add(mutableBlockPos.m_7495_());
                }
                mutableBlockPos.m_122173_(Direction.UP);
            }
            if (world.m_7433_((BlockPos)mutableBlockPos, DripstoneUtils::m_159664_)) {
                world.m_7731_((BlockPos)mutableBlockPos, mushroomBlock, 2);
                conkPoses.add(mutableBlockPos.m_7495_());
            }
            mutableBlockPos.m_122173_(initialDirection.m_122427_());
            ++rotatingIndex;
        }
    }

    private void placeBaseRoof(int baseSize, BlockPos blockPos, WorldGenLevel world, BlockState mushroomBlock, List<BlockPos> conkPoses) {
        for (int x = -baseSize; x <= baseSize; ++x) {
            for (int z = -baseSize; z <= baseSize; ++z) {
                boolean invalid;
                BlockPos basePos = blockPos.m_7494_().m_7918_(x, 0, z);
                boolean xCorner = x == -baseSize || x == baseSize;
                boolean zCorner = z == -baseSize || z == baseSize;
                boolean bl = invalid = xCorner && zCorner || !world.m_7433_(basePos, DripstoneUtils::m_159664_);
                if (invalid) continue;
                world.m_7731_(basePos, mushroomBlock, 2);
                conkPoses.add(basePos.m_7495_());
            }
        }
    }

    private void placeStem(int primaryStemLength, int secondLayerCount, WorldGenLevel world, BlockPos blockPos, BlockState stemBlock, BlockState mushroomBlock) {
        BlockState placeState = stemBlock;
        int length = primaryStemLength / 2 + secondLayerCount / 2;
        for (int i = 0; i < length; ++i) {
            boolean placeable;
            if (i == length - 1) {
                placeState = mushroomBlock;
            }
            boolean bl = placeable = world.m_7433_(blockPos.m_6630_(i), DripstoneUtils::m_159664_) || world.m_8055_(blockPos).m_60713_((Block)SpeciesBlocks.ALPHACENE_MUSHROOM.get());
            if (!placeable) continue;
            world.m_7731_(blockPos.m_6630_(i), placeState, 2);
        }
    }
}

