/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.packet;

import com.ninni.species.server.entity.mob.update_3.Harpoon;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class HarpoonInputPacket {
    private final int harpoonId;
    private final float xInput;
    private final float yInput;
    private final float zInput;

    public HarpoonInputPacket(int harpoonId, float xInput, float yInput, float zInput) {
        this.harpoonId = harpoonId;
        this.xInput = xInput;
        this.yInput = yInput;
        this.zInput = zInput;
    }

    public static void write(HarpoonInputPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.harpoonId);
        buf.writeFloat(msg.xInput);
        buf.writeFloat(msg.yInput);
        buf.writeFloat(msg.zInput);
    }

    public static HarpoonInputPacket read(FriendlyByteBuf buf) {
        return new HarpoonInputPacket(buf.readInt(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(HarpoonInputPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Harpoon harpoon;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Entity harpoonEntity = player.m_9236_().m_6815_(msg.harpoonId);
            if (harpoonEntity instanceof Harpoon && (harpoon = (Harpoon)harpoonEntity).m_19749_() == player && harpoon.isAnchored()) {
                harpoon.setSwingInput(msg.xInput, msg.yInput, msg.zInput);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

