/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesStatusEffects;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_3.WickedFireball;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Wicked
extends Monster
implements RangedAttackMob {
    private boolean isHaunting = false;
    protected static final EntityDataAccessor<Optional<UUID>> HAUNTED_TARGET_UUID = SynchedEntityData.m_135353_(Wicked.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    @Nullable
    private Mob hauntedTarget;
    public static final EntityDataAccessor<Integer> MANA_AMOUNT = SynchedEntityData.m_135353_(Wicked.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState spotAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    private int spotTimer = 0;
    private int attackTimer = 0;
    private int spotCooldown = 0;
    private int fallCooldown = 0;

    public Wicked(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_6842_(false);
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new HauntMobGoal(this));
        this.f_21345_.m_25352_(1, new RunAwayGoal(this, LivingEntity.class, this::isSuitableForRunningAway, 4.0f, 1.25, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new ShootGoal(this, 1.25, 30, 30, 30.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.22f);
    }

    public void haunt(Mob target, boolean addEffects) {
        Level level;
        if (addEffects && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 20, (double)(this.m_20205_() / 8.0f), 0.0, (double)(this.m_20205_() / 8.0f), (double)0.2f);
            for (int i = 0; i < 20; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(2.0), this.m_20187_(), this.m_20262_(2.0), 0, (double)(this.m_20205_() / 8.0f), 0.0, (double)(this.m_20205_() / 8.0f), (double)0.1f);
            }
        }
        this.isHaunting = true;
        this.hauntedTarget = target;
        this.setHauntedTargetUUID(target.m_20148_());
        this.hauntedTarget.m_6710_(this.m_5448_());
        this.m_6842_(true);
        this.m_20124_(SpeciesPose.HAUNTING.get());
        if (addEffects) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.WICKED_HAUNT.get(), 2.0f, 1.0f);
            this.addWickedEffects(target);
        }
    }

    public void stopHaunting() {
        this.spotCooldown += 10;
        this.fallCooldown += 60;
        if (this.hauntedTarget != null) {
            this.removeWickedEffect(this.hauntedTarget);
            this.m_6034_(this.hauntedTarget.m_20185_(), this.hauntedTarget.m_20186_() + 1.0, this.hauntedTarget.m_20189_());
            this.hauntedTarget.m_6710_(null);
        }
        this.isHaunting = false;
        this.hauntedTarget = null;
        this.setHauntedTargetUUID(null);
        this.m_6842_(false);
        this.m_20124_(Pose.STANDING);
        this.m_216990_((SoundEvent)SpeciesSoundEvents.WICKED_STOP_HAUNTING.get());
        this.setMana(Math.max(0, this.getMana() - 1));
        this.m_20256_(new Vec3((double)(this.f_19796_.m_188501_() * 0.25f), 1.0, (double)(this.f_19796_.m_188501_() * 0.25f)));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.POOF.get()), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.01, this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
        }
        List list = this.m_9236_().m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(10.0), player -> true);
        for (ServerPlayer serverPlayer : list) {
            SpeciesCriterion.WICKED_STOP_HAUNTING.trigger(serverPlayer);
        }
    }

    public boolean m_6785_(double d) {
        return !this.isHaunting;
    }

    public void addWickedEffects(Mob target) {
        int i = this.f_19796_.m_188503_(4);
        int amplifier = 0;
        MobEffect effect = switch (i) {
            default -> (MobEffect)SpeciesStatusEffects.COMBUSTION.get();
            case 1 -> (MobEffect)SpeciesStatusEffects.IRON_WILL.get();
            case 2 -> (MobEffect)SpeciesStatusEffects.TANKED.get();
            case 3 -> (MobEffect)SpeciesStatusEffects.SNATCHED.get();
        };
        if (target.m_21023_(effect)) {
            amplifier = target.m_21124_(effect).m_19564_() + 1;
        }
        if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            ++amplifier;
        }
        target.m_7292_(new MobEffectInstance(effect, -1, amplifier));
    }

    public void removeWickedEffect(Mob target) {
        target.m_21195_((MobEffect)SpeciesStatusEffects.COMBUSTION.get());
        target.m_21195_((MobEffect)SpeciesStatusEffects.IRON_WILL.get());
        target.m_21195_((MobEffect)SpeciesStatusEffects.TANKED.get());
        target.m_21195_((MobEffect)SpeciesStatusEffects.SNATCHED.get());
    }

    public void m_8119_() {
        Creeper creeper;
        Level level;
        super.m_8119_();
        if (this.getHauntedTargetUUID() != null && this.hauntedTarget == null) {
            this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(20.0), mob -> this.isSuitableForHaunting((LivingEntity)mob) && mob.m_20148_().equals(this.getHauntedTargetUUID())).forEach(mob -> this.haunt((Mob)mob, false));
        }
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.attackTimer == 0 && this.m_20089_() == SpeciesPose.ATTACK.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.spotTimer > 0) {
            --this.spotTimer;
        }
        if (this.spotTimer == 0 && this.m_20089_() == SpeciesPose.SPOT.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.attackTimer == 0 && this.attackAnimationState.m_216984_()) {
            this.attackAnimationState.m_216973_();
        }
        if (this.spotTimer == 0 && this.spotAnimationState.m_216984_()) {
            this.spotAnimationState.m_216973_();
        }
        if (this.spotCooldown > 0) {
            --this.spotCooldown;
        }
        if (this.fallCooldown > 0) {
            --this.fallCooldown;
        }
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0 && this.fallCooldown == 0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ % 2 == 0) {
                if (this.isHaunting && this.hauntedTarget != null && this.f_19796_.m_188501_() < (float)this.getMana() / 10.0f) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.WICKED_FLAME.get()), this.hauntedTarget.m_20208_((double)this.hauntedTarget.m_20205_()), this.hauntedTarget.m_20187_(), this.hauntedTarget.m_20262_((double)this.hauntedTarget.m_20205_()), 1, (double)(this.hauntedTarget.m_20205_() / 8.0f), 0.1, (double)(this.hauntedTarget.m_20205_() / 8.0f), 0.02);
                }
                if (this.getMana() > 0) {
                    int particleAmount = switch (this.getMana()) {
                        case 2 -> 15;
                        case 3 -> 10;
                        case 4 -> 8;
                        case 5 -> 3;
                        default -> 30;
                    };
                    if (this.isHaunting && this.hauntedTarget != null) {
                        particleAmount = 2;
                    }
                    if (this.f_19797_ % particleAmount == 0) {
                        if (this.isHaunting && this.hauntedTarget != null) {
                            this.spawnParticles(serverLevel, this.hauntedTarget);
                        } else {
                            this.spawnParticles(serverLevel, (Mob)this);
                        }
                    }
                }
            }
        }
        if (!(!this.isHaunting || this.hauntedTarget.m_6084_() && this.isSuitableForHaunting((LivingEntity)this.hauntedTarget) && this.hauntedTarget != null)) {
            this.stopHaunting();
        }
        if (this.hauntedTarget != null && (level = this.hauntedTarget) instanceof Creeper && (creeper = (Creeper)level).m_32310_() == 1) {
            this.spotCooldown = 120;
            this.stopHaunting();
        }
    }

    private void spawnParticles(ServerLevel serverLevel, Mob mob) {
        float heightAdjustment = mob.m_21023_((MobEffect)SpeciesStatusEffects.SNATCHED.get()) || mob.m_21023_((MobEffect)SpeciesStatusEffects.TANKED.get()) ? 0.5f : 0.0f;
        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.WICKED_EMBER.get()), mob.m_20208_((double)0.2f), mob.m_20186_() + (double)mob.m_20206_() + (double)0.35f + (double)heightAdjustment, mob.m_20262_((double)0.2f), 1, (double)(mob.m_20205_() / 8.0f), 0.0, (double)(mob.m_20205_() / 8.0f), 0.5);
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20208_((double)0.2f), mob.m_20186_() + (double)mob.m_20206_() + (double)0.35f + (double)heightAdjustment, mob.m_20262_((double)0.2f), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void m_6504_(LivingEntity livingEntity, float v) {
        double d0 = livingEntity.m_20185_() - this.m_20185_();
        double d1 = livingEntity.m_20227_((double)(livingEntity.m_20206_() * 0.4f)) - this.m_20227_(this.m_20206_() * 0.4f);
        double d2 = livingEntity.m_20189_() - this.m_20189_();
        WickedFireball fireball = new WickedFireball((LivingEntity)this, d0, d1, d2, this.m_9236_(), 5.0f);
        this.m_20124_(SpeciesPose.ATTACK.get());
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.WICKED_SHOOT.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        fireball.m_6034_(fireball.m_20185_(), this.m_20227_(this.m_20206_() * 0.5f), fireball.m_20189_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123755_, fireball.m_20208_(0.6f), fireball.m_20187_(), fireball.m_20262_(0.6f), 2, 0.0, 0.0, 0.0, 0.0);
        }
        this.m_9236_().m_7967_((Entity)fireball);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42409_) && this.getMana() < 5) {
            this.setMana(Math.min(5, this.getMana() + 1));
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(hand));
            this.m_216990_(SoundEvents.f_11942_);
            this.m_21530_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean isSuitableForHaunting(LivingEntity livingEntity) {
        return !(livingEntity instanceof Wicked) && (livingEntity instanceof Enemy || livingEntity instanceof NeutralMob) && !livingEntity.m_6095_().m_204039_(SpeciesTags.CANT_BE_HAUNTED) && !livingEntity.m_8077_() && livingEntity.m_6336_() != MobType.f_21644_ || livingEntity.m_6095_().m_204039_(SpeciesTags.CAN_BE_HAUNTED_EXTRAS);
    }

    public boolean isSuitableForRunningAway(LivingEntity livingEntity) {
        Creeper creeper;
        if (this.m_5448_() != null) {
            return livingEntity.m_7306_((Entity)this.m_5448_());
        }
        return livingEntity instanceof Creeper && (creeper = (Creeper)livingEntity).m_32310_() == 1 || livingEntity.m_6336_() == MobType.f_21644_;
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.STANDING) {
                this.attackAnimationState.m_216973_();
                this.spotAnimationState.m_216973_();
                this.m_6210_();
            } else if (this.m_20089_() == SpeciesPose.ATTACK.get()) {
                this.attackTimer = 15;
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.SPOT.get()) {
                this.spotTimer = 20;
                this.spotAnimationState.m_216977_(this.f_19797_);
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MANA_AMOUNT, (Object)5);
        this.f_19804_.m_135372_(HAUNTED_TARGET_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Mana", this.getMana());
        if (this.getHauntedTargetUUID() != null) {
            compoundTag.m_128362_("HauntedTarget", this.getHauntedTargetUUID());
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setMana(compoundTag.m_128451_("Mana"));
        if (compoundTag.m_128403_("HauntedTarget")) {
            this.setHauntedTargetUUID(compoundTag.m_128342_("HauntedTarget"));
        }
    }

    @Nullable
    public UUID getHauntedTargetUUID() {
        return ((Optional)this.f_19804_.m_135370_(HAUNTED_TARGET_UUID)).orElse(null);
    }

    public void setHauntedTargetUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(HAUNTED_TARGET_UUID, Optional.ofNullable(uuid));
    }

    public int getMana() {
        return (Integer)this.f_19804_.m_135370_(MANA_AMOUNT);
    }

    public void setMana(int cooldown) {
        this.f_19804_.m_135381_(MANA_AMOUNT, (Object)cooldown);
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == SpeciesPose.HAUNTING.get() ? EntityDimensions.m_20395_((float)0.0f, (float)0.0f) : super.m_6972_(pose);
    }

    public void m_20124_(Pose p_20125_) {
        super.m_20124_(p_20125_);
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.isHaunting) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_142065_() {
        if (this.isHaunting) {
            return false;
        }
        return super.m_142065_();
    }

    public boolean m_6097_() {
        return !this.isHaunting;
    }

    public boolean m_20229_(double p_20230_, double p_20231_, double p_20232_) {
        if (this.isHaunting) {
            return true;
        }
        return super.m_20229_(p_20230_, p_20231_, p_20232_);
    }

    public boolean m_6094_() {
        return !this.isHaunting && super.m_6094_();
    }

    protected void m_6138_() {
    }

    public boolean m_213854_() {
        return !this.isHaunting;
    }

    public boolean m_20329_(Entity p_20330_) {
        if (this.isHaunting) {
            return false;
        }
        return super.m_20329_(p_20330_);
    }

    public void m_7023_(Vec3 p_250068_) {
        if (this.spotTimer > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            p_250068_ = p_250068_.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(p_250068_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isHaunting ? (SoundEvent)SpeciesSoundEvents.WICKED_IDLE_HAUNTING.get() : (SoundEvent)SpeciesSoundEvents.WICKED_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SpeciesSoundEvents.WICKED_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.WICKED_DEATH.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    protected void m_7472_(DamageSource p_34697_, int p_34698_, boolean p_34699_) {
        Creeper creeper;
        super.m_7472_(p_34697_, p_34698_, p_34699_);
        Entity entity = p_34697_.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            ItemStack itemstack = new ItemStack((ItemLike)SpeciesItems.WICKED_CANDLE.get());
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    public int m_213860_() {
        return super.m_213860_() + (switch (this.getMana()) {
            case 0 -> 5;
            case 1 -> 4;
            case 2 -> 3;
            case 3 -> 2;
            case 4 -> 1;
            default -> 0;
        });
    }

    public static boolean m_219013_(EntityType<? extends Monster> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, RandomSource p_219018_) {
        return !p_219015_.m_6018_().m_46471_() && p_219015_.m_46791_() != Difficulty.PEACEFUL && Wicked.m_219009_((ServerLevelAccessor)p_219015_, (BlockPos)p_219017_, (RandomSource)p_219018_) && Wicked.m_217057_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (RandomSource)p_219018_);
    }

    static class HauntMobGoal
    extends Goal {
        private final Wicked wicked;
        private Mob target;
        private boolean sound = false;

        public HauntMobGoal(Wicked wicked) {
            this.wicked = wicked;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.wicked.m_5448_() == null || this.wicked.getMana() == 0 || !this.wicked.m_20096_() || this.wicked.spotCooldown > 0) {
                return false;
            }
            this.target = (Mob)this.wicked.m_9236_().m_45963_(Mob.class, TargetingConditions.m_148353_().m_26883_(30.0).m_26888_(this.wicked::isSuitableForHaunting), (LivingEntity)this.wicked, this.wicked.m_20185_(), this.wicked.m_20186_(), this.wicked.m_20189_(), this.wicked.m_20191_().m_82400_(30.0));
            return this.target != this.wicked.m_5448_() && this.target != null && !this.wicked.isHaunting && this.target != this.wicked;
        }

        public void m_8056_() {
            if (this.target != this.wicked.m_5448_() && this.target != null) {
                if (!this.sound && this.wicked.m_20096_() && this.wicked.spotCooldown == 0) {
                    this.wicked.m_216990_((SoundEvent)SpeciesSoundEvents.WICKED_SPOT.get());
                    this.wicked.m_20124_(SpeciesPose.SPOT.get());
                    this.sound = true;
                }
                this.wicked.m_21573_().m_5624_((Entity)this.target, 2.0);
            }
        }

        public void m_8037_() {
            if (this.target != this.wicked.m_5448_() && this.target != null) {
                double distanceToTarget = this.wicked.m_20270_((Entity)this.target);
                if (this.wicked.isHaunting) {
                    this.wicked.m_21573_().m_5624_((Entity)this.target, 1.0);
                } else if (distanceToTarget <= 1.5) {
                    this.wicked.haunt(this.target, true);
                    this.sound = false;
                } else {
                    this.wicked.m_21573_().m_5624_((Entity)this.target, 2.0);
                }
            }
        }

        public boolean m_8045_() {
            return this.target != this.wicked.m_5448_() && this.wicked.isHaunting && this.wicked.hauntedTarget != null && this.wicked.hauntedTarget.m_6084_();
        }
    }

    static class RunAwayGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Wicked wicked;

        public RunAwayGoal(Wicked mob, Class aClass, Predicate<LivingEntity> predicate, float v, double v1, double v2) {
            super((PathfinderMob)mob, aClass, predicate, v, v1, v2, EntitySelector.f_20406_::test);
            this.wicked = mob;
        }

        public boolean m_8036_() {
            if (this.wicked.isHaunting) {
                return false;
            }
            if (this.wicked.getMana() > 0) {
                LivingEntity target = this.wicked.m_9236_().m_45963_(Mob.class, TargetingConditions.m_148353_().m_26883_(20.0).m_26888_(this.wicked::isSuitableForHaunting), (LivingEntity)this.wicked, this.wicked.m_20185_(), this.wicked.m_20186_(), this.wicked.m_20189_(), this.wicked.m_20191_().m_82400_(10.0));
                return target == null && super.m_8036_();
            }
            return super.m_8036_();
        }
    }

    class ShootGoal
    extends RangedAttackGoal {
        private final Wicked wicked;

        public ShootGoal(RangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
            super(p_25773_, p_25774_, p_25775_, p_25776_, p_25777_);
            this.wicked = Wicked.this;
        }

        public boolean m_8036_() {
            if (this.wicked.isHaunting) {
                return false;
            }
            if (this.wicked.getMana() > 0) {
                LivingEntity target = this.wicked.m_9236_().m_45963_(Mob.class, TargetingConditions.m_148353_().m_26883_(20.0).m_26888_(this.wicked::isSuitableForHaunting), (LivingEntity)this.wicked, this.wicked.m_20185_(), this.wicked.m_20186_(), this.wicked.m_20189_(), this.wicked.m_20191_().m_82400_(10.0));
                return target == null && super.m_8036_();
            }
            return super.m_8036_();
        }
    }
}

