/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.Species;
import com.ninni.species.client.screen.ScreenShakeEvent;
import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Quake
extends Monster {
    public static final EntityDataAccessor<Float> STORED_DAMAGE = SynchedEntityData.m_135353_(Quake.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> ATTACK_TIMER = SynchedEntityData.m_135353_(Quake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> RECHARGE_TIMER = SynchedEntityData.m_135353_(Quake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_COOLDOWN = SynchedEntityData.m_135353_(Quake.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState attackAnimationState = new AnimationState();

    public Quake(EntityType<? extends Monster> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
        this.m_274367_(1.0f);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAttackTimer() > 0 || this.getRechargeTimer() > 0) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(0.8), this.m_20187_(), this.m_20262_(0.8), 0.0, 0.0, 0.0);
        }
        if (this.getAttackTimer() > 0) {
            this.setAttackTimer(this.getAttackTimer() - 1);
        }
        if (this.getRechargeTimer() > 0) {
            this.setRechargeTimer(this.getRechargeTimer() - 1);
        }
        if (this.getAttackCooldown() > 0) {
            this.setAttackCooldown(this.getAttackCooldown() - 1);
        }
        if (this.getAttackTimer() == 10) {
            this.damage(this.getStoredDamage());
        }
        if (this.getAttackTimer() == 1) {
            this.setRechargeTimer(121);
        }
        if (this.getRechargeTimer() == 1) {
            this.setAttackCooldown(201);
        }
        if (this.getAttackTimer() == 0 && this.m_20089_() == SpeciesPose.ATTACK.get()) {
            this.m_20124_(SpeciesPose.RECHARGE.get());
            this.setRechargeTimer(120);
        }
        if (this.getAttackTimer() == 0 && this.getRechargeTimer() == 0 && (this.m_20089_() == SpeciesPose.ATTACK.get() || this.m_20089_() == SpeciesPose.RECHARGE.get())) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.m_9236_().m_5776_() && this.getAttackTimer() == 0 && this.getRechargeTimer() == 0 && this.attackAnimationState.m_216984_()) {
            this.attackAnimationState.m_216973_();
        }
        if (this.getAttackCooldown() == 20) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_RECHARGE.get(), 1.0f, 1.0f);
        }
        if (this.getAttackTimer() == 20) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_ATTACK.get(), 3.0f, 1.0f);
        }
        if (this.getRechargeTimer() == 90) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_UNSCREWS.get(), 2.0f, 1.0f);
        }
        if (this.getRechargeTimer() == 40) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_FINISHES_UNSCREWING.get(), 1.0f, 1.0f);
        }
    }

    private void damage(float amount) {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(11.0), EntitySelector.f_20406_);
        List advancementList = this.m_9236_().m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(25.0), player -> true);
        HashSet<Mob> killedMobs = new HashSet<Mob>();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.KINETIC_ENERGY.get()), this.m_20182_().f_82479_, this.m_20182_().f_82480_ + 0.01, this.m_20182_().f_82481_, 1, 0.0, 0.0, 0.0, 0.5);
        }
        this.m_246865_(new Vec3(0.0, 0.35, 0.0));
        for (LivingEntity target : list) {
            if (target == this) continue;
            Vec3 enemyPos = target.m_20182_().m_82546_(this.m_20182_());
            Vec3 normalizedDirection = enemyPos.m_82541_();
            double knockbackXZ = 2.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
            double knockbackY = 0.5 * (1.0 - target.m_21133_(Attributes.f_22278_));
            target.m_5997_(normalizedDirection.m_7096_() * knockbackXZ, normalizedDirection.m_7098_() * knockbackY, normalizedDirection.m_7094_() * knockbackXZ);
            double distanceFromEnemy = target.m_20182_().m_82554_(this.m_20182_());
            float scalingFactor = distanceFromEnemy <= 4.0 ? 1.0f : (distanceFromEnemy <= 7.0 ? 0.75f : (distanceFromEnemy <= 10.0 ? 0.5f : 0.25f));
            amount *= scalingFactor;
            if (target.m_20148_().equals(UUID.fromString("3e11a940-8aff-449c-80d1-fc0f427f4876")) || target.m_20148_().equals(UUID.fromString("053de6af-392b-4385-90c5-34395b7e8757"))) {
                target.m_6469_(this.m_269291_().m_269298_(DamageTypes.f_268650_, (Entity)this), 1.0E9f);
            } else {
                Creeper creeper;
                if (target instanceof Creeper && (creeper = (Creeper)target).m_7090_() && amount > creeper.m_21223_()) {
                    creeper.m_19998_((ItemLike)SpeciesItems.MUSIC_DISK_SPAWNER.get());
                }
                target.m_6469_(this.kinetic((LivingEntity)this), amount);
            }
            this.m_7327_((Entity)target);
            if (target.m_6084_() || !(target instanceof Mob)) continue;
            Mob mob = (Mob)target;
            killedMobs.add(mob);
        }
        if (!advancementList.isEmpty()) {
            for (ServerPlayer serverPlayer : advancementList) {
                if (killedMobs.size() >= 10) {
                    SpeciesCriterion.KILL_TEN_MOBS_WITH_QUAKE.trigger(serverPlayer);
                }
                HashSet killedMobTypes = killedMobs.stream().map(Entity::m_6095_).collect(Collectors.toCollection(HashSet::new));
                Set requiredMobTypes = BuiltInRegistries.f_256780_.m_123024_().filter(type -> type.m_204039_(SpeciesTags.PREHISTORIC)).collect(Collectors.toSet());
                System.out.println(requiredMobTypes);
                if (!killedMobTypes.containsAll(requiredMobTypes)) continue;
                SpeciesCriterion.KILL_ALL_PREHISTORIC_MOBS_WITH_QUAKE.trigger(serverPlayer);
            }
        }
        Species.PROXY.screenShake(new ScreenShakeEvent(this.m_20182_(), Math.min(80, (int)this.getStoredDamage()), 0.75f, 40.0f, true));
        this.setStoredDamage(0.0f);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_269533_(DamageTypeTags.f_268738_) || damageSource.m_7639_() == null) {
            return super.m_6469_(damageSource, amount);
        }
        if (this.m_20089_() != SpeciesPose.ATTACK.get() && this.m_20089_() != SpeciesPose.RECHARGE.get()) {
            if (this.getAttackCooldown() == 0) {
                this.m_20124_(SpeciesPose.ATTACK.get());
                this.addStoredDamage(amount);
                return false;
            }
            this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_SHIELD.get(), 1.0f, 1.0f);
            return true;
        }
        if (this.m_20089_() == SpeciesPose.ATTACK.get() && this.getAttackTimer() > 0) {
            this.addStoredDamage(amount);
            this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_ABSORB.get(), 4.0f, this.getStoredDamage() * 0.015f);
            return true;
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.STANDING) {
                this.attackAnimationState.m_216973_();
            } else if (this.m_20089_() == SpeciesPose.ATTACK.get()) {
                this.setStoredDamage(0.0f);
                this.setAttackTimer(190);
                this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_CHARGE.get(), 3.0f, 1.0f);
                this.attackAnimationState.m_216977_(this.f_19797_);
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STORED_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACK_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(RECHARGE_TIMER, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TIMER, (Object)0);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("StoredDamage", this.getStoredDamage());
        compoundTag.m_128405_("AttackCooldown", this.getAttackCooldown());
        compoundTag.m_128405_("RechargeTimer", this.getRechargeTimer());
        compoundTag.m_128405_("AttackTimer", this.getAttackTimer());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setStoredDamage(compoundTag.m_128457_("StoredDamage"));
        this.setAttackCooldown(compoundTag.m_128451_("AttackCooldown"));
        this.setRechargeTimer(compoundTag.m_128451_("RechargeTimer"));
        this.setAttackTimer(compoundTag.m_128451_("AttackTimer"));
    }

    public float getStoredDamage() {
        return ((Float)this.f_19804_.m_135370_(STORED_DAMAGE)).floatValue();
    }

    public void setStoredDamage(float amount) {
        this.f_19804_.m_135381_(STORED_DAMAGE, (Object)Float.valueOf(amount));
    }

    public void addStoredDamage(float amount) {
        this.setStoredDamage(this.getStoredDamage() + amount);
    }

    public int getAttackCooldown() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_COOLDOWN);
    }

    public void setAttackCooldown(int cooldown) {
        this.f_19804_.m_135381_(ATTACK_COOLDOWN, (Object)cooldown);
    }

    public int getRechargeTimer() {
        return (Integer)this.f_19804_.m_135370_(RECHARGE_TIMER);
    }

    public void setRechargeTimer(int timer) {
        this.f_19804_.m_135381_(RECHARGE_TIMER, (Object)timer);
    }

    public int getAttackTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TIMER);
    }

    public void setAttackTimer(int timer) {
        this.f_19804_.m_135381_(ATTACK_TIMER, (Object)timer);
    }

    public DamageSource kinetic(LivingEntity livingEntity) {
        return this.m_269291_().m_269298_(SpeciesDamageTypes.KINETIC, (Entity)livingEntity);
    }

    public float m_5610_(BlockPos p_33013_, LevelReader p_33014_) {
        return 0.0f;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.QUAKE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)SpeciesSoundEvents.QUAKE_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.QUAKE_STEP.get(), 1.0f, this.m_6100_());
    }

    protected void m_7472_(DamageSource p_34697_, int p_34698_, boolean p_34699_) {
        Creeper creeper;
        super.m_7472_(p_34697_, p_34698_, p_34699_);
        Entity entity = p_34697_.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            ItemStack itemstack = new ItemStack((ItemLike)SpeciesItems.QUAKE_HEAD.get());
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.getAttackTimer() > 0 || this.getRechargeTimer() > 0;
    }
}

