/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_2;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_2.SpringlingHead;
import com.ninni.species.server.packet.SendSpringlingPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class Springling
extends TamableAnimal
implements PlayerRideable {
    public static final EntityDataAccessor<Integer> MAX_EXTENDED_AMOUNT = SynchedEntityData.m_135353_(Springling.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> EXTENDED_AMOUNT = SynchedEntityData.m_135353_(Springling.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> RETRACTING = SynchedEntityData.m_135353_(Springling.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static int messageCooldown;
    public int previousQuantizedStep;
    public int currentQuantizedStep;
    private final SpringlingHead[] subEntities;
    public final SpringlingHead head;

    public Springling(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_6210_();
        this.head = new SpringlingHead(this, "head", 1.0f, 0.1f);
        this.subEntities = new SpringlingHead[]{this.head};
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public void m_20234_(int i1) {
        super.m_20234_(i1);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(i1 + i + 1);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new SpringlingFollowOwnerGoal(this, 1.25, 5.0f, 2.0f, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(SpeciesTags.SPRINGLING_BREED_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setMaxExtendedAmount(this.f_19796_.m_188503_(10000) == 0 ? 24 : this.f_19796_.m_216339_(8, 16));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        super.m_8119_();
        this.previousQuantizedStep = this.currentQuantizedStep;
        this.currentQuantizedStep = Mth.m_14143_((float)(this.getExtendedAmount() * 10.0f));
        if (this.previousQuantizedStep != this.currentQuantizedStep) {
            this.m_6210_();
        }
        this.head.m_6027_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_());
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (this.getExtendedAmount() == (float)this.getMaxExtendedAmount()) {
                    SpeciesCriterion.EXTEND_SPRINGLING_FULLY.trigger(serverPlayer);
                }
            }
            this.m_20225_(true);
        } else {
            this.m_20225_(false);
        }
        if (this.getExtendedAmount() > (float)this.getMaxExtendedAmount()) {
            this.setExtendedAmount(this.getMaxExtendedAmount());
        }
        if (this.isRetracting() && !this.m_9236_().f_46443_) {
            if (this.getExtendedAmount() > 0.0f) {
                this.setExtendedAmount(this.getExtendedAmount() - 0.25f);
                this.playExtendingSound((Entity)this);
            }
            if (this.getExtendedAmount() < 0.5f) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.SPRINGLING_EXTEND_FINISH.get(), 2.0f, 1.0f);
            }
            if (this.getExtendedAmount() == 0.0f) {
                this.setRetracting(false);
            }
        }
        if (messageCooldown > 0 && !this.m_9236_().f_46443_) {
            --messageCooldown;
        }
        if (messageCooldown < 10 && messageCooldown > 0 && this.m_20160_() && (livingEntity = this.m_146895_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            SpeciesNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SendSpringlingPacket());
        }
        if (this.getExtendedAmount() < 0.0f) {
            this.setExtendedAmount(0.0f);
        }
    }

    public void playExtendingSound(Entity entity) {
        if (this.getExtendedAmount() >= (float)this.getMaxExtendedAmount() - 0.1f) {
            entity.m_5496_((SoundEvent)SpeciesSoundEvents.SPRINGLING_EXTEND_FINISH.get(), 2.0f, 1.0f);
        }
        entity.m_5496_((SoundEvent)SpeciesSoundEvents.SPRINGLING_EXTEND.get(), 0.5f, this.getExtendedAmount() / 10.0f + 0.5f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (this.m_20160_()) {
            return super.m_6071_(player, interactionHand);
        }
        if (!this.m_21824_() && itemStack.m_204117_(SpeciesTags.SPRINGLING_TAMING_ITEMS) && !this.m_6162_()) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SpeciesSoundEvents.SPRINGLING_EAT.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6898_(itemStack)) {
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, interactionHand, itemStack);
                this.m_27595_(player);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpeciesSoundEvents.SPRINGLING_EAT.get(), SoundSource.NEUTRAL, 1.0f, this.m_6162_() ? Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f) * 1.5f : Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, interactionHand, itemStack);
                this.m_146740_(Animal.m_216967_((int)(-i)), true);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)SpeciesSoundEvents.SPRINGLING_EAT.get(), SoundSource.NEUTRAL, 1.0f, this.m_6162_() ? Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f) * 1.5f : Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        if (!this.m_6162_() && !this.m_6898_(itemStack) && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (!player.m_6144_() && player.m_20188_() > this.m_20188_() - (double)2.2f) {
                messageCooldown = 260;
                this.doPlayerRide(player);
                return InteractionResult.SUCCESS;
            }
            if (!this.m_9236_().f_46443_ && !this.isRetracting() && this.getExtendedAmount() > 0.0f) {
                this.setRetracting(true);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, interactionHand);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (f > 0.0f && this.getExtendedAmount() > 0.0f) {
            this.setRetracting(true);
        }
        return super.m_6469_(damageSource, f);
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.playExtendingSound(this.m_146895_());
        } else {
            super.m_7822_(b);
        }
    }

    public void m_27563_(ServerLevel serverLevel, Animal animal) {
        ItemStack itemStack = new ItemStack((ItemLike)SpeciesItems.SPRINGLING_EGG.get());
        ItemEntity itemEntity = new ItemEntity((Level)serverLevel, this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), itemStack);
        itemEntity.m_32060_();
        this.m_277117_(serverLevel, animal, null);
        this.m_5496_((SoundEvent)SpeciesSoundEvents.SPRINGLING_EGG_PLOP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.5f);
        serverLevel.m_7967_((Entity)itemEntity);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(SpeciesTags.SPRINGLING_BREED_ITEMS);
    }

    public EntityDimensions m_6972_(Pose pose) {
        float extensionScale = (float)this.currentQuantizedStep / 10.0f;
        return EntityDimensions.m_20395_((float)0.99f, (float)2.2f).m_20390_(this.m_6134_(), this.m_6134_() + extensionScale / 1.5f - 0.1f * this.m_6134_());
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.25f : 1.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAX_EXTENDED_AMOUNT, (Object)9);
        this.f_19804_.m_135372_(EXTENDED_AMOUNT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RETRACTING, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Retracting", this.isRetracting());
        compoundTag.m_128405_("MaxExtendedAmount", this.getMaxExtendedAmount());
        compoundTag.m_128350_("ExtendedAmount", this.getExtendedAmount());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setRetracting(compoundTag.m_128471_("Retracting"));
        this.setMaxExtendedAmount(compoundTag.m_128451_("MaxExtendedAmount"));
        this.setExtendedAmount(compoundTag.m_128457_("ExtendedAmount"));
    }

    public int getMaxExtendedAmount() {
        return (Integer)this.f_19804_.m_135370_(MAX_EXTENDED_AMOUNT);
    }

    public void setMaxExtendedAmount(int amount) {
        this.f_19804_.m_135381_(MAX_EXTENDED_AMOUNT, (Object)amount);
    }

    public float getExtendedAmount() {
        return ((Float)this.f_19804_.m_135370_(EXTENDED_AMOUNT)).floatValue();
    }

    public void setExtendedAmount(float amount) {
        this.f_19804_.m_135381_(EXTENDED_AMOUNT, (Object)Float.valueOf(amount));
    }

    public boolean isRetracting() {
        return (Boolean)this.f_19804_.m_135370_(RETRACTING);
    }

    public void setRetracting(boolean bl) {
        this.f_19804_.m_135381_(RETRACTING, (Object)bl);
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        int i = this.m_5639_(f, g);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(damageSource, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(damageSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    public boolean m_6107_() {
        return super.m_6107_() && this.m_20160_() || this.getExtendedAmount() > 0.0f && !this.m_20160_();
    }

    public int m_8100_() {
        return 240;
    }

    protected int m_5639_(float f, float g) {
        return Mth.m_14167_((float)((f * 0.5f - 3.0f) * g));
    }

    protected void doPlayerRide(Player player) {
        if (!this.m_9236_().f_46443_) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        Level level;
        super.m_274498_(player, vec3);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_20096_() && vec3.m_165925_() > 0.01 && this.f_19797_ % 8 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_5594_(null, this.m_20183_(), (SoundEvent)SpeciesSoundEvents.SPRINGLING_STEP.get(), this.m_5720_(), 0.15f, 1.0f);
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity livingEntity) {
        return new Vec2(livingEntity.m_146909_() * 0.5f, livingEntity.m_146908_());
    }

    protected Vec3 m_274312_(Player player, Vec3 vec3) {
        float f = player.f_20900_ * 0.5f;
        float g = player.f_20902_;
        if (g <= 0.0f) {
            g *= 0.25f;
        }
        return new Vec3((double)f, 0.0, (double)g);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SpeciesSoundEvents.SPRINGLING_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpeciesSoundEvents.SPRINGLING_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.SPRINGLING_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.SPRINGLING_STEP.get(), 0.15f, 1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)SpeciesEntities.SPRINGLING.get()).m_20615_((Level)serverLevel);
    }

    protected float m_245547_(Player player) {
        return (float)(this.m_21133_(Attributes.f_22279_) * (double)0.8f);
    }

    public boolean m_6147_() {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ - 0.05f;
    }

    public double m_6048_() {
        return this.m_6972_((Pose)Pose.STANDING).f_20378_ - 0.05f;
    }

    public boolean m_6094_() {
        return !this.m_20160_() && this.getExtendedAmount() == 0.0f;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob;
        }
        if (entity instanceof Player) {
            Player mob = (Player)entity;
            return mob;
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        return new Vec3(this.m_20185_(), this.m_20191_().f_82292_ + (double)0.15f, this.m_20189_());
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public static boolean canSpawn(EntityType<Springling> entity, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return false;
    }

    public class SpringlingFollowOwnerGoal
    extends FollowOwnerGoal {
        public SpringlingFollowOwnerGoal(TamableAnimal tamableAnimal, double d, float f, float g, boolean bl) {
            super(tamableAnimal, d, f, g, bl);
        }

        public boolean m_8045_() {
            return super.m_8045_() && Springling.this.getExtendedAmount() == 0.0f;
        }

        public boolean m_8036_() {
            return super.m_8036_() && Springling.this.getExtendedAmount() == 0.0f;
        }
    }
}

