/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_1;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.data.LimpetOreManager;
import com.ninni.species.server.entity.ai.LimpetAi;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Limpet
extends PathfinderMob {
    protected static final ImmutableList<SensorType<? extends Sensor<? super Limpet>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_26383_);
    private static final EntityDataAccessor<Integer> SCARED_TICKS = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_SHELL = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CRACKED_STAGE = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> ORE = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> MAX_COUNT = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> ORE_ITEM_STACK = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<BlockState> ORE_BLOCK_STATE = SynchedEntityData.m_135353_(Limpet.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final UniformInt RETREAT_DURATION = TimeUtil.m_145020_((int)5, (int)20);
    private static final EntityDimensions SCARED_DIMENSIONS = EntityDimensions.m_20395_((float)0.75f, (float)0.75f);

    public Limpet(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public float m_274421_() {
        return 1.0f;
    }

    protected Brain.Provider<Limpet> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public Brain<Limpet> m_6274_() {
        return super.m_6274_();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return LimpetAi.makeBrain((Brain<Limpet>)this.m_5490_().m_22073_(dynamic));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        LimpetOreManager.setOre(this);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("limpetBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("limpetActivityUpdate");
        LimpetAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createLimpetAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCARED_TICKS, (Object)0);
        this.f_19804_.m_135372_(HAS_SHELL, (Object)true);
        this.f_19804_.m_135372_(CRACKED_STAGE, (Object)0);
        this.f_19804_.m_135372_(ORE, (Object)"species:shell");
        this.f_19804_.m_135372_(MAX_COUNT, (Object)0);
        this.f_19804_.m_135372_(ORE_ITEM_STACK, (Object)Items.f_42499_.m_7968_());
        this.f_19804_.m_135372_(ORE_BLOCK_STATE, (Object)Blocks.f_50069_.m_49966_());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("ScaredTicks", this.getScaredTicks());
        nbt.m_128379_("HasShell", this.hasShell());
        nbt.m_128405_("CrackedStage", this.getCrackedStage());
        nbt.m_128359_("Ore", this.getOre());
        nbt.m_128405_("MaxCount", this.getMaxCount());
        nbt.m_128365_("OreItemStack", (Tag)this.getOreItemStack().m_41739_(new CompoundTag()));
        nbt.m_128365_("OreBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.getOreBlockState()));
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setScaredTicks(nbt.m_128451_("ScaredTicks"));
        this.setHasShell(nbt.m_128471_("HasShell"));
        this.setCrackedStage(nbt.m_128451_("CrackedStage"));
        if (nbt.m_128441_("Ore")) {
            this.setOre(nbt.m_128461_("Ore"));
        }
        if (nbt.m_128441_("MaxCount")) {
            this.setMaxCount(nbt.m_128451_("MaxCount"));
        }
        if (nbt.m_128441_("OreItemStack")) {
            this.setOreItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("OreItemStack")));
        }
        if (nbt.m_128441_("OreBlockState")) {
            this.setOreBlockState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("OreBlockState")));
        }
    }

    public ItemStack getOreItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(ORE_ITEM_STACK);
    }

    public void setOreItemStack(ItemStack stack) {
        this.f_19804_.m_135381_(ORE_ITEM_STACK, (Object)stack);
    }

    public BlockState getOreBlockState() {
        return (BlockState)this.f_19804_.m_135370_(ORE_BLOCK_STATE);
    }

    public void setOreBlockState(BlockState state) {
        this.f_19804_.m_135381_(ORE_BLOCK_STATE, (Object)state);
    }

    public int getMaxCount() {
        return (Integer)this.f_19804_.m_135370_(MAX_COUNT);
    }

    public void setMaxCount(int maxCount) {
        this.f_19804_.m_135381_(MAX_COUNT, (Object)maxCount);
    }

    public boolean hasShell() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SHELL);
    }

    public void setHasShell(boolean hasShell) {
        this.f_19804_.m_135381_(HAS_SHELL, (Object)hasShell);
    }

    public int getCrackedStage() {
        return (Integer)this.f_19804_.m_135370_(CRACKED_STAGE);
    }

    public void setCrackedStage(int crackedStage) {
        this.f_19804_.m_135381_(CRACKED_STAGE, (Object)crackedStage);
    }

    public String getOre() {
        return (String)this.f_19804_.m_135370_(ORE);
    }

    public void setOre(String id) {
        this.f_19804_.m_135381_(ORE, (Object)id);
    }

    public int getScaredTicks() {
        return (Integer)this.f_19804_.m_135370_(SCARED_TICKS);
    }

    public void setScaredTicks(int scaredTicks) {
        this.f_19804_.m_135381_(SCARED_TICKS, (Object)scaredTicks);
    }

    public boolean isScared() {
        return this.getScaredTicks() > 0;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isScared()) {
            this.m_20124_(SpeciesPose.SCARED.get());
        } else {
            this.m_20124_(Pose.STANDING);
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.m_6274_().m_21874_(MemoryModuleType.f_26383_)) {
                this.m_9236_().m_6443_(Player.class, this.m_20191_().m_82400_(4.0), this::isValidEntity).forEach(player -> this.setScaredTicks(100));
            }
            if (this.isScared()) {
                int scaredTicks = this.m_6274_().m_21874_(MemoryModuleType.f_26383_) ? 0 : this.getScaredTicks() - 1;
                this.m_21573_().m_26573_();
                this.setScaredTicks(scaredTicks);
            }
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == SpeciesPose.SCARED.get() ? SCARED_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public boolean m_5829_() {
        return this.isScared();
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (this.getCrackedStage() > 0 && this.hasShell() && stack.m_41720_() == this.getOreItemStack().m_41720_() && !this.m_6274_().m_21874_(MemoryModuleType.f_26383_)) {
            this.setCrackedStage(this.getCrackedStage() - 1);
            this.m_5496_(this.getOreBlockState().m_60827_().m_56777_(), 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_21530_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public boolean m_6094_() {
        return !this.isScared();
    }

    public boolean isValidEntity(Player player) {
        Optional<ItemStack> stack = this.getStackInHand(player);
        return this.hasShell() && !player.m_5833_() && player.m_6084_() && !player.m_150110_().f_35937_ && !player.m_6144_() || this.hasShell() && stack.isPresent();
    }

    public boolean isValidEntityHoldingPickaxe(Player player) {
        return this.hasShell() && this.getStackInHand(player).isPresent();
    }

    public Optional<ItemStack> getStackInHand(Player player) {
        return player.m_21205_().m_41735_(this.getOreBlockState()) ? Optional.of(player.m_21205_()) : Optional.empty();
    }

    /*
     * Unable to fully structure code
     */
    public boolean m_6469_(DamageSource source, float amount) {
        var4_3 = source.m_7639_();
        if (!(var4_3 instanceof Player)) ** GOTO lbl-1000
        player = (Player)var4_3;
        if (this.hasShell() && this.getStackInHand(player).isPresent() && !player.m_36335_().m_41519_(player.m_21205_().m_41720_())) {
            v0 = hasOre = Objects.equals(this.getOre(), "species:shell") == false;
            if (hasOre) {
                this.spawnBreakingParticles();
            }
            stack = player.m_21205_();
            if (this.getCrackedStage() < 3) {
                this.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)player, (long)Limpet.RETREAT_DURATION.m_214085_(this.m_9236_().f_46441_));
                this.setCrackedStage(this.getCrackedStage() + 1);
                this.m_5496_(this.getOreBlockState().m_60827_().m_56775_(), 1.0f, (float)this.getCrackedStage() * 0.3f + 0.5f);
                this.m_5496_((SoundEvent)SpeciesSoundEvents.LIMPET_BREAK.get(), 0.6f, this.getCrackedStage() + 1);
                this.setScaredTicks(0);
                for (ItemStack itemStack : player.m_150109_().f_35974_) {
                    player.m_36335_().m_41524_(itemStack.m_41720_(), player.m_150110_().f_35937_ != false ? 0 : 80);
                }
                return false;
            }
            if (this.getMaxCount() > 0) {
                count = (int)((float)(this.getMaxCount() / 2 + this.f_19796_.m_188503_(this.getMaxCount() / 2)) * (1.0f + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack) * 0.15f));
                if (hasOre) {
                    for (i = 0; i < count; ++i) {
                        this.m_20000_((ItemLike)this.getOreItemStack().m_41720_(), 1);
                    }
                }
            }
            this.m_5496_(this.getOreBlockState().m_60827_().m_56775_(), 1.0f, (float)this.getCrackedStage() * 0.3f + 1.0f);
            this.m_5496_((SoundEvent)SpeciesSoundEvents.LIMPET_BREAK.get(), 0.6f, (float)this.getCrackedStage() + 1.5f);
            this.setCrackedStage(0);
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) != 0) {
                if (hasOre) {
                    LimpetOreManager.setNoOre(this);
                } else {
                    this.setHasShell(false);
                }
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    SpeciesCriterion.SILK_TOUCH_BREAK_LIMPET.trigger(serverPlayer);
                }
                return false;
            }
            this.setHasShell(false);
            this.setScaredTicks(0);
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                SpeciesCriterion.BREAK_LIMPET.trigger(serverPlayer);
            }
        } else if (source.m_7639_() instanceof LivingEntity && amount < 12.0f && !this.m_9236_().f_46443_ && this.hasShell()) {
            var5_7 = source.m_7640_();
            if (var5_7 instanceof Projectile) {
                projectile = (Projectile)var5_7;
                projectile.m_20256_(new Vec3(1.0, 1.0, 0.0));
            }
            this.m_5496_((SoundEvent)SpeciesSoundEvents.LIMPET_DEFLECT.get(), 1.0f, 1.0f);
            if (!this.m_6274_().m_21874_(MemoryModuleType.f_26383_)) {
                this.setScaredTicks(300);
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    private void spawnBreakingParticles() {
        for (int i = 0; i < 40; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getOreItemStack()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_(), this.m_20189_(), ((double)this.f_19796_.m_188501_() - 0.5) * 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 0.8, ((double)this.f_19796_.m_188501_() - 0.5) * 0.5);
        }
    }

    public void m_7023_(Vec3 vec3) {
        if (!this.m_6274_().m_21874_(MemoryModuleType.f_26383_) && this.isScared()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SpeciesSoundEvents.LIMPET_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.LIMPET_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SpeciesSoundEvents.LIMPET_HURT.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.LIMPET_STEP.get(), 0.15f, 1.0f);
    }

    public float m_5610_(BlockPos p_33013_, LevelReader p_33014_) {
        return -p_33014_.m_220419_(p_33013_);
    }

    public static boolean canSpawn(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return levelAccessor.m_45517_(LightLayer.BLOCK, blockPos) == 0 && levelAccessor.m_45517_(LightLayer.SKY, blockPos) == 0 && levelAccessor.m_8055_(blockPos.m_7495_()).m_204336_(SpeciesTags.LIMPET_SPAWNABLE_ON) && levelAccessor.m_8055_(blockPos.m_7495_()).m_60643_((BlockGetter)levelAccessor, blockPos, entityType);
    }
}

