/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.ai.tasks;

import com.google.common.collect.ImmutableMap;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.registry.SpeciesMemoryModuleTypes;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.mob.update_2.Cruncher;
import com.ninni.species.server.entity.mob.update_2.CruncherPellet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SpitPellet
extends Behavior<Cruncher> {
    private static final int DURATION = 30;

    public SpitPellet() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26368_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)SpeciesMemoryModuleTypes.SPIT_CHARGING.get()), (Object)MemoryStatus.VALUE_ABSENT), 30);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Cruncher livingEntity) {
        Optional nearestPlayer = livingEntity.m_6274_().m_21952_(MemoryModuleType.f_26368_);
        long day = serverLevel.m_46468_() / 24000L;
        long cruncherDay = livingEntity.getDay();
        if (cruncherDay == -1L || day != cruncherDay && day == 0L) {
            livingEntity.setDay(day);
        }
        if (cruncherDay < day) {
            livingEntity.setDay(cruncherDay + 1L);
            return livingEntity.getPelletData() != null && nearestPlayer.isPresent();
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Cruncher livingEntity, long l) {
        return livingEntity.getSpits() <= 10;
    }

    protected void start(ServerLevel serverLevel, Cruncher livingEntity, long l) {
        serverLevel.m_7605_((Entity)livingEntity, (byte)4);
        livingEntity.m_5496_((SoundEvent)SpeciesSoundEvents.CRUNCHER_SPIT.get(), 2.0f, 1.0f);
        livingEntity.m_6274_().m_21882_((MemoryModuleType)SpeciesMemoryModuleTypes.SPIT_CHARGING.get(), (Object)Unit.INSTANCE, 12L);
    }

    protected void tick(ServerLevel serverLevel, Cruncher livingEntity, long l) {
        Brain<Cruncher> brain = livingEntity.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26370_);
        if (brain.m_21952_((MemoryModuleType)SpeciesMemoryModuleTypes.SPIT_CHARGING.get()).isPresent()) {
            return;
        }
        BlockPos blockPos = livingEntity.m_20183_();
        BlockState blockState = ((Block)SpeciesBlocks.CRUNCHER_PELLET.get()).m_49966_();
        float angle = (float)Math.PI / 180 * livingEntity.f_20883_;
        double headX = 3.0f * livingEntity.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
        double headZ = 3.0f * livingEntity.m_6134_() * Mth.m_14089_((float)angle);
        CruncherPellet pellet = new CruncherPellet((Level)serverLevel, (double)blockPos.m_123341_() + headX, (float)blockPos.m_123342_() + livingEntity.m_20192_(), (double)blockPos.m_123343_() + headZ, blockState, livingEntity.getPelletData());
        pellet.m_20256_(livingEntity.m_20154_().m_82490_(2.0).m_82542_(0.25, 1.0, 0.25));
        serverLevel.m_7967_((Entity)pellet);
        livingEntity.setSpits(livingEntity.getSpits() + 1);
        brain.m_21882_((MemoryModuleType)SpeciesMemoryModuleTypes.SPIT_CHARGING.get(), (Object)Unit.INSTANCE, 96L);
    }

    protected void stop(ServerLevel serverLevel, Cruncher livingEntity, long time) {
        if (livingEntity.getSpits() > 10) {
            long day = serverLevel.m_46468_() / 24000L;
            livingEntity.setSpits(0);
            livingEntity.setDay(day);
        }
    }
}

