/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.ninni.species.registry.SpeciesMemoryModuleTypes;
import com.ninni.species.registry.SpeciesSensorTypes;
import com.ninni.species.server.entity.ai.tasks.RoarAttack;
import com.ninni.species.server.entity.ai.tasks.SpitPellet;
import com.ninni.species.server.entity.ai.tasks.StompAttack;
import com.ninni.species.server.entity.mob.update_2.Cruncher;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class CruncherAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super Cruncher>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)((SensorType)SpeciesSensorTypes.CRUNCHER_ATTACK_ENTITY_SENSOR.get()));
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_217768_, (Object)MemoryModuleType.f_26383_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26367_, (Object)MemoryModuleType.f_26368_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148206_, (MemoryModuleType)SpeciesMemoryModuleTypes.ROAR_CHARGING.get(), (MemoryModuleType)SpeciesMemoryModuleTypes.STOMP_CHARGING.get(), (MemoryModuleType)SpeciesMemoryModuleTypes.SPIT_CHARGING.get(), (MemoryModuleType)SpeciesMemoryModuleTypes.ROAR_COOLDOWN.get()});

    public static Brain<Cruncher> makeBrain(Brain<Cruncher> brain) {
        CruncherAi.initCoreActivity(brain);
        CruncherAi.initIdleActivity(brain);
        CruncherAi.initFightActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<Cruncher> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90){

            protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mob mob) {
                Cruncher cruncher;
                if (mob instanceof Cruncher && (cruncher = (Cruncher)mob).getStunnedTicks() > 0) {
                    return false;
                }
                return super.m_6114_(serverLevel, (LivingEntity)mob);
            }
        }, (Object)new MoveToTargetSink(){

            protected boolean m_6114_(ServerLevel serverLevel, Mob mob) {
                Cruncher cruncher;
                if (mob instanceof Cruncher && (cruncher = (Cruncher)mob).cannotWalk()) {
                    return false;
                }
                return super.m_6114_(serverLevel, mob);
            }
        }));
    }

    private static void initIdleActivity(Brain<Cruncher> brain) {
        brain.m_21900_(Activity.f_37979_, ImmutableList.of((Object)Pair.of((Object)0, (Object)StartAttacking.m_257741_(Predicate.not(CruncherAi::isPassive), cruncher -> cruncher.m_6274_().m_21952_(MemoryModuleType.f_148194_))), (Object)Pair.of((Object)1, (Object)((Object)new SpitPellet())), (Object)Pair.of((Object)2, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)1.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1))))));
    }

    private static void initFightActivity(Brain<Cruncher> brain) {
        brain.m_21903_(Activity.f_37988_, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.5f)), (Object)Pair.of((Object)1, (Object)((Object)new RoarAttack())), (Object)Pair.of((Object)2, (Object)((Object)new StompAttack()))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static boolean isPassive(LivingEntity livingEntity) {
        Cruncher cruncher;
        return livingEntity instanceof Cruncher && (cruncher = (Cruncher)livingEntity).getHunger() <= 0;
    }

    public static void updateActivity(Cruncher cruncher) {
        cruncher.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
    }
}

