/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ninni.species.Species;
import com.ninni.species.registry.SpeciesNetwork;
import com.ninni.species.server.packet.GooberGooSyncPacket;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.PacketDistributor;

public class GooberGooManager
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_INSTANCE = new GsonBuilder().create();
    public static final List<GooberGooData> DATA = Lists.newArrayList();

    public GooberGooManager() {
        super(GSON_INSTANCE, "gameplay/goober_goo");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        DATA.clear();
        object.forEach((resourceLocation, jsonElement) -> {
            GooberGooData data = GooberGooData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).result().orElseGet(() -> {
                Species.LOGGER.error("Failed to read Goober goo recipe for resource {}", resourceLocation);
                return null;
            });
            if (data != null && data.input != Blocks.f_50016_ && data.output != Blocks.f_50016_) {
                DATA.add(data);
            }
        });
        Species.LOGGER.info("Loaded {} Goober goo recipes", (Object)DATA.size());
    }

    public void onDatapackSync(@Nullable ServerPlayer player) {
        if (DATA.isEmpty()) {
            return;
        }
        HashBiMap registryMap = HashBiMap.create();
        for (GooberGooData data : DATA) {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)data.input());
            if (id == null) continue;
            registryMap.put((Object)id, (Object)data);
        }
        if (player == null) {
            SpeciesNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new GooberGooSyncPacket((BiMap<ResourceLocation, GooberGooData>)registryMap));
        } else {
            SpeciesNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GooberGooSyncPacket((BiMap<ResourceLocation, GooberGooData>)registryMap));
        }
    }

    public void synchronizeRegistryForClient(BiMap<ResourceLocation, GooberGooData> newData) {
        DATA.clear();
        DATA.addAll(newData.values());
    }

    public record GooberGooData(Block input, Block output) {
        public static final Codec<GooberGooData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("input").forGetter(GooberGooData::input), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("output").forGetter(GooberGooData::output)).apply((Applicative)instance, GooberGooData::new));

        public static GooberGooData fromNetwork(FriendlyByteBuf buf) {
            Block input = (Block)buf.m_236816_((IdMap)BuiltInRegistries.f_256975_);
            Block output = (Block)buf.m_236816_((IdMap)BuiltInRegistries.f_256975_);
            return new GooberGooData(input, output);
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)this.input);
            buf.m_236818_((IdMap)BuiltInRegistries.f_256975_, (Object)this.output);
        }
    }
}

