/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesDamageTypes;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesStatusEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CranktrapBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    protected static final VoxelShape SHAPE_NS_CLOSED = Block.m_49796_((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)6.0, (double)11.0);
    protected static final VoxelShape SHAPE_WE_CLOSED = Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)6.0, (double)15.0);
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public CranktrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, POWERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return SHAPE;
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP -> SHAPE_NS_CLOSED;
            case Direction.WEST, Direction.EAST -> SHAPE_WE_CLOSED;
        };
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if ((entity instanceof Mob || entity instanceof Player) && !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)SpeciesStatusEffects.STUCK.get(), 2, 0, false, false, false));
        }
        super.m_7892_(state, level, pos, entity);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.m_5776_()) {
            boolean isPowered = level.m_276867_(pos);
            boolean wasPowered = (Boolean)state.m_61143_((Property)POWERED);
            if (isPowered && !wasPowered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
                level.m_186460_(pos, (Block)this, 10);
            } else if (!isPowered && wasPowered) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean hasMob;
        List list = level.m_45976_(LivingEntity.class, new AABB(pos).m_165897_(0.0, 0.5, 0.0));
        boolean bl = hasMob = !list.isEmpty();
        if (hasMob) {
            if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
                this.open((Level)level, pos, state);
                for (LivingEntity entity : list) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)SpeciesStatusEffects.STUCK.get(), 8, 0, false, false, false));
                }
                level.m_186460_(pos, (Block)this, 4);
                return;
            }
            this.close((Level)level, pos, state);
            for (LivingEntity entity : list) {
                float amount = 2.0f + entity.m_21233_() / 8.0f * (1.0f - (entity.m_21233_() - entity.m_21223_()) / entity.m_21233_());
                int i = 0;
                while ((float)i < amount) {
                    level.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.BEWEREAGER_SLOW.get()), (double)pos.m_123341_() + 0.5 + random.m_188583_() * 0.5, (double)((float)pos.m_123342_() + random.m_188501_()), (double)pos.m_123343_() + 0.5 + random.m_188583_() * 0.5, 1, 0.3, 0.3, 0.3, 1.0);
                    ++i;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)SpeciesStatusEffects.STUCK.get(), 4, 0, false, false, false));
                entity.m_6469_(level.m_269111_().m_269298_(SpeciesDamageTypes.CRANKTRAP, (Entity)entity), amount);
            }
        } else if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            this.resetTrap(level, pos, state);
        }
    }

    private void resetTrap(ServerLevel level, BlockPos pos, BlockState state) {
        List list = level.m_45976_(LivingEntity.class, new AABB(pos).m_165897_(0.0, 0.5, 0.0));
        if (list.isEmpty()) {
            this.open((Level)level, pos, state);
        } else {
            level.m_186460_(pos, (Block)this, 10);
        }
    }

    public void open(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            level.m_5594_(null, pos, (SoundEvent)SpeciesSoundEvents.CRANKTRAP_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void close(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            level.m_5594_(null, pos, (SoundEvent)SpeciesSoundEvents.CRANKTRAP_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return (Boolean)p_60475_.m_61143_((Property)OPEN);
    }
}

