/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.model.mob_heads.MobHeadModelBase;
import com.ninni.species.client.renderer.block.MobHeadBlockEntityRenderer;
import com.ninni.species.server.block.MobHeadBlock;
import com.ninni.species.server.block.WallMobHeadBlock;
import com.ninni.species.server.item.RicoshieldItem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="species", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SpeciesItemRenderers
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation RICOSHIELD_TEXTURE = new ResourceLocation("species", "textures/entity/quake/ricoshield/ricoshield.png");
    private static final ResourceLocation RICOSHIELD_TEXTURE_CHARGING = new ResourceLocation("species", "textures/entity/quake/ricoshield/ricoshield_charging.png");
    private static final ResourceLocation RICOSHIELD_TEXTURE_CHARGED = new ResourceLocation("species", "textures/entity/quake/ricoshield/ricoshield_charged.png");
    public static SpeciesItemRenderers instance;
    private Map<MobHeadBlock.Type, MobHeadModelBase> headModelBaseMap;

    public SpeciesItemRenderers(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    @SubscribeEvent
    public static void onRegisterReloadListener(RegisterClientReloadListenersEvent event) {
        instance = new SpeciesItemRenderers(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        event.registerReloadListener((PreparableReloadListener)instance);
    }

    public void m_6213_(ResourceManager resourceManager) {
        super.m_6213_(resourceManager);
        this.headModelBaseMap = MobHeadBlockEntityRenderer.createMobHeadRenderers(this.f_172548_);
    }

    public void m_108829_(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource bufferSource, int p_108834_, int p_108835_) {
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).m_40614_();
            if (block instanceof MobHeadBlock || block instanceof WallMobHeadBlock) {
                MobHeadBlock.Type type = block instanceof MobHeadBlock ? ((MobHeadBlock)block).getType() : ((WallMobHeadBlock)block).getType();
                MobHeadModelBase modelBase = this.headModelBaseMap.get(type);
                if (modelBase == null) {
                    return;
                }
                RenderType rendertype = MobHeadBlockEntityRenderer.getRenderType(type);
                MobHeadBlockEntityRenderer.renderMobHead(null, 180.0f, 0.0f, poseStack, bufferSource, p_108834_, modelBase, rendertype, itemDisplayContext, type, false);
            }
        } else if (item instanceof RicoshieldItem) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.0f, -1.0f, -1.0f);
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)RICOSHIELD_TEXTURE), (boolean)false, (boolean)itemStack.m_41790_());
            this.f_108823_.m_103711_().m_104306_(poseStack, vertexconsumer, p_108834_, p_108835_, 1.0f, 1.0f, 1.0f, 1.0f);
            this.f_108823_.m_103701_().m_104306_(poseStack, vertexconsumer, p_108834_, p_108835_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (itemStack.m_41783_().m_128441_("StoredDamage") && itemStack.m_41783_().m_128457_("StoredDamage") > 0.0f) {
                float storedDamage = itemStack.m_41783_().m_128457_("StoredDamage");
                float opacityCharging = storedDamage >= 25.0f ? 1.0f : 0.0f;
                float opacityCharged = storedDamage >= 35.0f ? 1.0f : 0.0f;
                VertexConsumer vertexconsumerCharging = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)RICOSHIELD_TEXTURE_CHARGING), (boolean)false, (boolean)false);
                this.f_108823_.m_103701_().m_104306_(poseStack, vertexconsumerCharging, p_108834_, p_108835_, 1.0f, 1.0f, 1.0f, opacityCharging);
                VertexConsumer vertexconsumerCharged = ItemRenderer.m_115184_((MultiBufferSource)bufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)RICOSHIELD_TEXTURE_CHARGED), (boolean)false, (boolean)false);
                this.f_108823_.m_103701_().m_104306_(poseStack, vertexconsumerCharged, p_108834_, p_108835_, 1.0f, 1.0f, 1.0f, opacityCharged);
            }
            poseStack.m_85849_();
        }
    }
}

