/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.model.mob.update_2;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.animation.GooberAnimations;
import com.ninni.species.server.entity.mob.update_2.Goober;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GooberModel<E extends Goober>
extends HierarchicalModel<E> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart tail;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public GooberModel(ModelPart root) {
        this.root = root;
        this.body = this.root.m_171324_("body");
        this.leftArm = this.root.m_171324_("left_arm");
        this.rightArm = this.root.m_171324_("right_arm");
        this.rightLeg = this.root.m_171324_("right_leg");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.neck = this.body.m_171324_("neck");
        this.tail = this.body.m_171324_("tail");
        this.head = this.neck.m_171324_("head");
        this.jaw = this.head.m_171324_("jaw");
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_267799_(GooberAnimations.WALK, limbAngle, limbDistance, 4.5f, 8.0f);
        this.m_233381_(((Goober)((Object)entity)).idleAnimationState, GooberAnimations.IDLE, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).layDownIdleAnimationState, GooberAnimations.LAY_DOWN_IDLE, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).layDownAnimationState, GooberAnimations.LAY_DOWN, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).standUpAnimationState, GooberAnimations.STAND_UP, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).yawnAnimationState, GooberAnimations.YAWN, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).layDownYawnAnimationState, GooberAnimations.LAY_DOWN_YAWN, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).rearUpAnimationState, GooberAnimations.REAR_UP, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).sneezeAnimationState, GooberAnimations.SNEEZE, animationProgress);
        this.m_233381_(((Goober)((Object)entity)).layDownSneezeAnimationState, GooberAnimations.LAY_DOWN_SNEEZE, animationProgress);
        this.head.f_104203_ = this.head.f_104203_ + (((Goober)((Object)entity)).isGooberLayingDown() ? 0.0f : headPitch * ((float)Math.PI / 180) - headPitch * ((float)Math.PI / 180) / 2.0f);
        this.head.f_104204_ += headYaw * ((float)Math.PI / 180) - headYaw * ((float)Math.PI / 180) / 2.0f;
        this.neck.f_104203_ = this.neck.f_104203_ + (((Goober)((Object)entity)).isGooberLayingDown() ? 0.0f : headPitch * ((float)Math.PI / 180) / 2.0f);
        this.neck.f_104204_ += headYaw * ((float)Math.PI / 180) / 2.0f;
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-11.0f, -18.0f, -16.0f, 22.0f, 22.0f, 26.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)3.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(12, 57).m_171481_(-5.0f, -1.5f, 0.0f, 10.0f, 3.0f, 32.0f), PartPose.m_171423_((float)0.0f, (float)2.5f, (float)10.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(64, 56).m_171481_(-7.0f, -8.0f, -23.0f, 14.0f, 10.0f, 23.0f), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-16.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-6.0f, -2.0f, -10.0f, 12.0f, 7.0f, 10.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)-23.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 65).m_171481_(-6.0f, -4.0f, -10.0f, 12.0f, 9.0f, 10.0f).m_171514_(93, 45).m_171481_(-6.0f, -3.0f, -5.0f, 12.0f, 8.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(70, 1).m_171481_(-4.5f, -1.0f, -4.5f, 9.0f, 16.0f, 9.0f), PartPose.m_171419_((float)8.5f, (float)9.0f, (float)-6.5f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(70, 1).m_171481_(-4.5f, -1.0f, -4.5f, 9.0f, 16.0f, 9.0f), PartPose.m_171419_((float)-8.5f, (float)9.0f, (float)-6.5f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(70, 1).m_171481_(-4.5f, -1.0f, -4.5f, 9.0f, 16.0f, 9.0f), PartPose.m_171419_((float)-9.5f, (float)9.0f, (float)7.5f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(70, 1).m_171481_(-4.5f, -1.0f, -4.5f, 9.0f, 16.0f, 9.0f), PartPose.m_171419_((float)9.5f, (float)9.0f, (float)7.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)144, (int)96);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        if (this.f_102610_) {
            float babyScale = 0.5f;
            float bodyYOffset = 24.0f;
            poseStack.m_85836_();
            poseStack.m_85841_(babyScale, babyScale, babyScale);
            poseStack.m_252880_(0.0f, bodyYOffset / 16.0f, 0.0f);
            this.m_142109_().m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
            poseStack.m_85849_();
        } else {
            this.m_142109_().m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

